/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.mmc.fmm.common.util.RouteOldVsersionInitUtils;

public class RouteVersionInitFormPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(RouteVersionInitFormPlugin.class);
    public static final String APPNUM = "mmc-fmm-formplugin";

    public void createJob(Set<Long> orgIdSet, String ruleid, String opKey) {
        try {
            String formNum = "";
            formNum = this.getView() instanceof ListView ? ((ListView)this.getView()).getBillFormId() : this.getView().getEntityId();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? appIdByFormNum : this.getView().getFormShowParameter().getAppId();
            appId = StringUtils.isEmpty((String)appId) ? "fmm" : appId;
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("fmm");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName("fmm-routeversioninit-task-job");
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            jobInfo.setTaskClassname("kd.mmc.fmm.formplugin.processroute.versiontask.ExecOldVersionInitTask");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("pageId", this.getPageCache().getPageId());
            params.put("orgids", orgIdSet);
            params.put("ruleid", ruleid);
            params.put("opKey", opKey);
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, opKey);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7248\u672c\u521d\u59cb\u5316\u6267\u884c", (String)"RouteVersionInitFormPlugin_02", (String)APPNUM, (Object[])new Object[0]));
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.mmc.fmm.formplugin.processroute.versiontask.ExecOldVersionInitClickTask");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception e1) {
            throw new KDBizException(new ErrorCode("0", e1.getMessage()), new Object[0]);
        }
    }

    public void handleTaskCallBack(Object returnData) {
        try {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && !StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "showMess": {
                        view.showMessage(msg);
                        break;
                    }
                    case "successNotice": {
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.showSuccessNotification(msg, showTime);
                        break;
                    }
                }
            }
        }
        catch (Exception e1) {
            logger.warn("RouteVersionInitFormPlugin.handleTaskCallBack error", (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJobAndLock(Set<Long> orgIdSet, String ruleid, String opKey) {
        if (!RouteOldVsersionInitUtils.isFromSysParamOpen((String)opKey)) {
            String lockMsg = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7248\u672c\u521d\u59cb\u5316\u64cd\u4f5c\u9501", (String)"RouteVersionInitFormPlugin_01", (String)APPNUM, (Object[])new Object[0]);
            for (Long bizOrgId : orgIdSet) {
                String lockKey = bizOrgId + "_rtversion_init";
                DLock lock = DLock.create((String)lockKey, (String)lockMsg);
                lock.lock();
                try {
                    RouteOldVsersionInitUtils.setInitRunning((Long)bizOrgId);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        this.createJob(orgIdSet, ruleid, opKey);
    }
}

