/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.processroute.versiontask;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.mmc.fmm.business.route.RouteOldVersionInitBusiness;
import kd.mmc.fmm.common.util.RouteOldVsersionInitUtils;

public class ExecOldVersionInitTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(ExecOldVersionInitTask.class);
    private static final String APPPARAM = "mmc-fmm-formplugin";
    private static final BigDecimal ALLSTEP = new BigDecimal("80");

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        String desc = ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u65b0\u65e7\u7248\u672c\u521d\u59cb\u5316\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"ExecOldVersionInitTask_01", (String)APPPARAM, (Object[])new Object[0]);
        this.feedbackProgress(10, desc, null);
        try {
            if (this.loopExecData(rc, params)) {
                this.feedbackProgress(98, ResManager.loadKDString((String)"\u7248\u672c\u521d\u59cb\u5316\u6267\u884c\u5b8c\u6bd5\uff0c\u8bf7\u7b49\u5f85\u9875\u9762\u52a0\u8f7d...", (String)"ExecOldVersionInitTask_02", (String)APPPARAM, (Object[])new Object[0]), null);
            }
        }
        catch (Exception e) {
            log.warn("ExecResourceCheckTask.execute error", (Throwable)e);
            this.wrapFeedBack(false, "errorNotice", ResManager.loadKDString((String)"\u7248\u672c\u521d\u59cb\u5316\u53d1\u751f\u5931\u8d25\u6216\u7ec8\u6b62\u64cd\u4f5c:", (String)"ExecOldVersionInitTask_03", (String)APPPARAM, (Object[])new Object[0]) + e.getMessage(), null);
        }
    }

    public Set<Long> getOrgIdSet(Map<String, Object> params) throws KDException {
        String orgids = params.get("orgids").toString();
        return RouteOldVsersionInitUtils.ParseStringToLongSet((String)orgids);
    }

    public int getOneStepCount(int allSize) {
        if (allSize <= 0) {
            return ALLSTEP.intValue();
        }
        int oneStep = ALLSTEP.divide(new BigDecimal(allSize + ""), new MathContext(10)).intValue();
        return oneStep == 0 ? 1 : oneStep;
    }

    public int getCurrentSetp(int currentSeq, int oneStepCount) {
        BigDecimal step = new BigDecimal(currentSeq + "").multiply(new BigDecimal(oneStepCount + ""));
        return step.compareTo(ALLSTEP) > 0 ? ALLSTEP.intValue() : step.intValue();
    }

    public boolean loopExecData(RequestContext rc, Map<String, Object> params) throws KDException {
        Set<Long> orgIds = this.getOrgIdSet(params);
        String opKey = params.get("opKey").toString();
        String ruleid = params.get("ruleid").toString();
        int size = 0;
        int oneStepCount = this.getOneStepCount(orgIds.size());
        StringBuilder allErrorMsg = new StringBuilder();
        for (Long orgId : orgIds) {
            int currentSetp = this.getCurrentSetp(++size, oneStepCount);
            String currentDesc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7ec4\u7ec7\uff1a%1$s\u3002", (String)"ExecOldVersionInitTask_05", (String)APPPARAM, (Object[])new Object[0]), RouteOldVsersionInitUtils.getOrgName((Long)orgId));
            this.feedbackProgress(currentSetp, currentDesc, null);
            RouteOldVersionInitBusiness imp = new RouteOldVersionInitBusiness();
            String errorMsg = imp.exec(orgId, ruleid, opKey);
            if (errorMsg == null || "".equals(errorMsg)) continue;
            allErrorMsg.append(errorMsg);
        }
        if (allErrorMsg.length() > 1) {
            throw new KDBizException(allErrorMsg.toString());
        }
        this.wrapFeedBack(true, "successNotice", ResManager.loadKDString((String)"\u6267\u884c\u5b8c\u6bd5", (String)"ExecOldVersionInitTask_04", (String)APPPARAM, (Object[])new Object[0]), 3000);
        return true;
    }

    private void wrapFeedBack(boolean success, String msgType, String msg, Integer showTime) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", success);
        result.put("msgType", msgType);
        result.put("msg", msg);
        if (null != showTime) {
            result.put("showTime", showTime);
        }
        this.feedbackCustomdata(result);
    }
}

