/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.programe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.mmc.fmm.business.programe.ProgramAssignBusiness;

public class ProgramAssignEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    public void registerListener(EventObject event) {
        EntryGrid groupGrid = (EntryGrid)this.getView().getControl("groupentity");
        groupGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid stageGrid = (EntryGrid)this.getView().getControl("stageentity");
        stageGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid preStageGrid = (EntryGrid)this.getView().getControl("prestageentity");
        preStageGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid assignGrid = (EntryGrid)this.getView().getControl("assignentry");
        assignGrid.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        Tab tabap1 = (Tab)this.getView().getControl("tabap1");
        tabap1.addTabSelectListener((TabSelectListener)this);
    }

    public void entryRowClick(RowClickEvent e) {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryName = entryGrid.getEntryKey();
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        int index = e.getRow();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        if ("groupentity".equals(entryName)) {
            DynamicObject entryObj = dm.getEntryRowEntity("groupentity", index);
            business.setChildGroupChecked(entryGrid, userId, index, fv, dm);
        } else if ("stageentity".equals(entryName)) {
            this.setStageEntryDataToCatch("groupentity", "stageentity", "checkedData");
        } else if (!"assignentry".equals(entryName) && "prestageentity".equals(entryName)) {
            this.setStageEntryDataToCatch("assignentry", "prestageentity", "preCheckedData");
        }
    }

    private void setStageEntryDataToCatch(String parentEntityNane, String entityName, String keyName) {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        EntryGrid stageEntryGrid = (EntryGrid)fv.getControl(entityName);
        int[] indexArray = stageEntryGrid.getSelectRows();
        int groupIndex = dm.getEntryCurrentRowIndex(parentEntityNane);
        DynamicObject groupObj = dm.getEntryRowEntity(parentEntityNane, groupIndex);
        String groupId = groupObj.getString("id");
        String indexArrayStr = business.intArrayToString(indexArray);
        IPageCache pageCatch = fv.getPageCache();
        String checkData = pageCatch.get(keyName);
        JSONObject cheeckObj = null;
        if (checkData == null || "".equals(checkData)) {
            cheeckObj = new JSONObject();
            cheeckObj.put(groupId, (Object)indexArrayStr);
        } else {
            cheeckObj = JSONObject.parseObject((String)checkData);
            cheeckObj.put(groupId, (Object)indexArrayStr);
        }
        pageCatch.put(keyName, cheeckObj.toJSONString());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel dm = this.getModel();
        DynamicObjectCollection assignEntryCol = dm.getEntryEntity("assignentry");
        HashSet<Integer> deleteSet = new HashSet<Integer>(assignEntryCol.size());
        for (int i = 0; i < assignEntryCol.size(); ++i) {
            DynamicObject assignObj = (DynamicObject)assignEntryCol.get(i);
            boolean hasStage = this.hasStageDataToAssign(assignObj);
            BigDecimal assignQtty = assignObj.getBigDecimal("preassinqtynum");
            if (assignQtty.compareTo(BigDecimal.ZERO) > 0 || hasStage) continue;
            deleteSet.add(i);
        }
        Integer[] retArray = deleteSet.toArray(new Integer[deleteSet.size()]);
        int[] retIntArray = Arrays.stream(retArray).mapToInt(Integer::valueOf).toArray();
        dm.deleteEntryRows("assignentry", retIntArray);
        Tab groupTab = (Tab)this.getControl("tabap");
        groupTab.activeTab("grouptabpageap");
    }

    private boolean hasStageDataToAssign(DynamicObject assignGroupObj) {
        boolean retFlag = false;
        if (assignGroupObj == null) {
            return retFlag;
        }
        DynamicObjectCollection stageCol = assignGroupObj.getDynamicObjectCollection("prestageentity");
        for (DynamicObject stageObj : stageCol) {
            BigDecimal assignQty = stageObj.getBigDecimal("preassignqtynum");
            if (assignQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            retFlag = true;
        }
        return retFlag;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject dataObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("data");
        if (dataObj == null) {
            return;
        }
        JSONArray proArray = dataObj.getJSONArray("proArray");
        JSONArray groupArray = dataObj.getJSONArray("groupArray");
        this.loadProEntry(proArray);
        this.loadGroupEntry(groupArray);
        this.getView().updateView();
    }

    private void loadProEntry(JSONArray proArray) {
        if (proArray == null || proArray.isEmpty()) {
            return;
        }
        IDataModel dm = this.getModel();
        int index = 0;
        for (int i = 0; i < proArray.size(); ++i) {
            JSONObject data = (JSONObject)proArray.get(i);
            int[] row = dm.appendEntryRow("entryentity", index += i, 1);
            int currentIndex = row[0];
            DynamicObject entryObj = dm.getEntryRowEntity("entryentity", currentIndex);
            entryObj.set("id", data.get((Object)"id"));
            dm.setValue("processno", data.get((Object)"processno"), currentIndex);
            dm.setValue("prostatge", data.get((Object)"prostatge"), currentIndex);
            dm.setValue("prostatgedesc", data.get((Object)"prostatgedesc"), currentIndex);
            dm.setValue("isstage", data.get((Object)"isstage"), currentIndex);
        }
        dm.updateCache();
    }

    private void loadGroupEntry(JSONArray groupArray) {
        if (groupArray == null || groupArray.isEmpty()) {
            return;
        }
        IDataModel dm = this.getModel();
        int index = 0;
        ORM orm = ORM.create();
        long[] pks = orm.genLongIds("fmm_programassign", groupArray.size());
        for (int i = 0; i < groupArray.size(); ++i) {
            JSONObject data = (JSONObject)groupArray.get(i);
            int[] row = dm.appendEntryRow("groupentity", index += i, 1);
            int currentIndex = row[0];
            dm.setValue("groupseq", data.get((Object)"seq"), currentIndex);
            dm.setValue("id", data.get((Object)"id"), currentIndex);
            dm.setValue("prodtype", data.get((Object)"prodtype"), currentIndex);
            dm.setValue("entrymaterial", data.get((Object)"entrymaterial"), currentIndex);
            dm.setValue("entrydesc", data.get((Object)"entrydesc"), currentIndex);
            dm.setValue("entryunit", data.get((Object)"entryunit"), currentIndex);
            dm.setValue("entryversion", data.get((Object)"entryversion"), currentIndex);
            dm.setValue("entryauxproperty", data.get((Object)"entryauxproperty"), currentIndex);
            dm.setValue("entryqtytype", data.get((Object)"entryqtytype"), currentIndex);
            dm.setValue("assignnumerator", data.get((Object)"assignnumerator"), currentIndex);
            dm.setValue("assigndenominator", data.get((Object)"assigndenominator"), currentIndex);
            dm.setValue("qtynumerator", data.get((Object)"assignnumerator"), currentIndex);
            dm.setValue("entryisjumplevel", data.get((Object)"entryisjumplevel"), currentIndex);
            dm.setValue("tobeassignrate", data.get((Object)"tobeassignrate"), currentIndex);
            dm.setValue("assignfixscrap", data.get((Object)"tobeassignrate"), currentIndex);
            String groupId = data.getString("groupid");
            if (groupId == null || "".equals(groupId)) {
                groupId = String.valueOf(pks[i]);
            }
            dm.setValue("groupid", (Object)groupId, currentIndex);
            dm.setValue("sourceid", data.get((Object)"sourceid"), currentIndex);
            dm.setValue("pgroupid", data.get((Object)"pgroupid"), currentIndex);
            dm.setValue("cgroupid", data.get((Object)"cgroupid"), currentIndex);
            Object stageObj = data.get((Object)"stageentity");
            if (stageObj == null) continue;
            JSONArray stageArray = (JSONArray)data.get((Object)"stageentity");
            DynamicObject groupEntryObj = dm.getEntryRowEntity("groupentity", currentIndex);
            this.loadStageEntry(groupEntryObj, stageArray);
        }
    }

    private void loadStageEntry(DynamicObject groupEntryObj, JSONArray stageArray) {
        if (groupEntryObj == null || stageArray == null || stageArray.isEmpty()) {
            return;
        }
        DynamicObjectCollection stageEntryCol = groupEntryObj.getDynamicObjectCollection("stageentity");
        for (int i = 0; i < stageArray.size(); ++i) {
            JSONObject data = (JSONObject)stageArray.get(i);
            DynamicObject stageEntryObj = stageEntryCol.addNew();
            stageEntryObj.set("batchstartqty", data.get((Object)"batchstartqty"));
            stageEntryObj.set("batchendqty", data.get((Object)"batchendqty"));
            stageEntryObj.set("isstagefix", data.get((Object)"isstagefix"));
            stageEntryObj.set("assignstagenumerator", data.get((Object)"assignstagenumerator"));
            stageEntryObj.set("assginstagedenominator", data.get((Object)"assginstagedenominator"));
            stageEntryObj.set("assignqty", data.get((Object)"assignstagenumerator"));
            stageEntryObj.set("assginstagefixscrap", data.get((Object)"assginstagefixscrap"));
            stageEntryObj.set("assginfixscrap", data.get((Object)"assginstagefixscrap"));
            stageEntryObj.set("id", data.get((Object)"id"));
        }
        this.getModel().updateCache();
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        IDataModel dm = this.getView().getModel();
        if ("ok".equals(opKey) || "input".equals(opKey)) {
            // empty if block
        }
    }

    private String inputQtyValdate() {
        String retMsg = "";
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        EntryGrid groupGrid = (EntryGrid)fv.getControl("groupentity");
        int[] groupIndexArray = groupGrid.getSelectRows();
        Set checkedRowSet = business.arrayToSet(groupIndexArray);
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("checkedData");
        JSONObject dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        for (int i = 0; i < groupCol.size(); ++i) {
            String selectStageSeq;
            DynamicObject groupObj = (DynamicObject)groupCol.get(i);
            int entrySeq = groupObj.getInt("seq");
            String indexStr = String.valueOf(entrySeq - 1);
            String entryId = groupObj.getString("id");
            String string = selectStageSeq = dataObj == null ? null : dataObj.getString(entryId);
            if (!checkedRowSet.contains(indexStr) && (selectStageSeq == null || "".equals(selectStageSeq))) continue;
            BigDecimal groupAssignQty = groupObj.getBigDecimal("qtynumerator");
            BigDecimal toBeAssignQty = groupObj.getBigDecimal("assignnumerator");
            BigDecimal tobeassignrate = groupObj.getBigDecimal("tobeassignrate");
            BigDecimal assignfixscrap = groupObj.getBigDecimal("assignfixscrap");
            if (groupAssignQty.compareTo(BigDecimal.ZERO) <= 0 && (selectStageSeq == null || "".equals(selectStageSeq))) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u6ca1\u6709\u9700\u8981\u52a0\u5165\u7269\u6599\u6e05\u5355\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1);
                break;
            }
            if (groupAssignQty.compareTo(toBeAssignQty) == 0 && tobeassignrate.compareTo(assignfixscrap) != 0) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c,\u201c\u5206\u914d\u6570\u91cf\u201d=\u201c\u5f85\u5206\u914d\u7528\u91cf\uff1a\u5206\u5b50\u201d\u65f6\u8981\u6c42\u201c\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d=\u201c\u5f85\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d\u3002", (String)"ProgramAssignEditPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1);
                break;
            }
            retMsg = this.inputStageVal(groupObj, selectStageSeq, checkedRowSet, indexStr, i + 1);
            if (retMsg != null && !"".equals(retMsg)) break;
        }
        return retMsg;
    }

    private String inputStageVal(DynamicObject groupObj, String selectStageSeq, Set<String> checkedRowSet, String groupIndexStr, int groupIndex) {
        String retMsg = "";
        if (groupObj == null || selectStageSeq == null || "".equals(selectStageSeq)) {
            return retMsg;
        }
        BigDecimal groupAssignQty = groupObj.getBigDecimal("qtynumerator");
        if (!checkedRowSet.contains(groupIndexStr)) {
            groupAssignQty = BigDecimal.ZERO;
        }
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        int[] stageIndexArray = business.stringToArray(selectStageSeq);
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        for (int index : stageIndexArray) {
            DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(index);
            BigDecimal stageAssignQty = stageEntry.getBigDecimal("assignqty");
            BigDecimal toBeAssignQty = stageEntry.getBigDecimal("assignstagenumerator");
            BigDecimal stageAssignRate = stageEntry.getBigDecimal("assginfixscrap");
            BigDecimal toBeAssignRate = stageEntry.getBigDecimal("assginstagefixscrap");
            if (stageAssignQty.compareTo(BigDecimal.ZERO) <= 0 && groupAssignQty.compareTo(BigDecimal.ZERO) <= 0) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\u6ca1\u6709\u9700\u8981\u52a0\u5165\u7269\u6599\u6e05\u5355\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex, index + 1);
                break;
            }
            if (stageAssignQty.compareTo(toBeAssignQty) != 0 || stageAssignRate.compareTo(toBeAssignRate) >= 0) continue;
            retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u9636\u68af\u4fe1\u606f\uff0c\u201c\u5206\u914d\u7528\u91cf\u201d=\u201c\u5f85\u5206\u914d\u7528\u91cf\uff1a\u5206\u5b50\u201d\u65f6\uff0c\u8981\u6c42\u201c\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d=\u201c\u5f85\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d\u3002", (String)"ProgramAssignEditPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex, index + 1);
            break;
        }
        return retMsg;
    }

    private String outputQtyValdate() {
        String retMsg = "";
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        DynamicObjectCollection assignCol = dm.getEntryEntity("assignentry");
        EntryGrid assignGrid = (EntryGrid)fv.getControl("assignentry");
        int[] assignIndexArray = assignGrid.getSelectRows();
        Set checkedRowSet = business.arrayToSet(assignIndexArray);
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("preCheckedData");
        JSONObject dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        for (int i = 0; i < assignCol.size(); ++i) {
            String selectStageSeq;
            DynamicObject assignObj = (DynamicObject)assignCol.get(i);
            int entrySeq = assignObj.getInt("seq");
            String indexStr = String.valueOf(entrySeq - 1);
            String entryId = assignObj.getString("id");
            String string = selectStageSeq = dataObj == null ? null : dataObj.getString(entryId);
            if (!checkedRowSet.contains(indexStr) && (selectStageSeq == null || "".equals(selectStageSeq))) continue;
            BigDecimal outputQty = assignObj.getBigDecimal("outputqty");
            BigDecimal toBeAssignQty = assignObj.getBigDecimal("preassinqtynum");
            BigDecimal outputRate = assignObj.getBigDecimal("outputfixscrap");
            BigDecimal toBeAssignRate = assignObj.getBigDecimal("preassignfixscrap");
            if (outputQty.compareTo(BigDecimal.ZERO) <= 0 && (selectStageSeq == null || "".equals(selectStageSeq))) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u7269\u6599\u6e05\u5355\u6ca1\u6709\u9700\u8981\u79fb\u51fa\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_20", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1);
                break;
            }
            if (outputQty.compareTo(toBeAssignQty) == 0 && outputRate.compareTo(toBeAssignRate) != 0) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c,\u201c\u79fb\u51fa\u6570\u91cf\u201d=\u201c\u5206\u914d\u7528\u91cf\uff1a\u5206\u5b50\u201d\u65f6\u8981\u6c42\u201c\u79fb\u51fa\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d=\u201c\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d\u3002", (String)"ProgramAssignEditPlugin_21", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1);
                break;
            }
            retMsg = this.outputStageVal(assignObj, selectStageSeq, checkedRowSet, indexStr, i + 1);
            if (retMsg != null && !"".equals(retMsg)) break;
        }
        return retMsg;
    }

    private String outputStageVal(DynamicObject assignObj, String selectStageSeq, Set<String> checkedRowSet, String assignIndexStr, int assignIndex) {
        String retMsg = "";
        if (assignObj == null || selectStageSeq == null || "".equals(selectStageSeq)) {
            return retMsg;
        }
        BigDecimal outputQty = assignObj.getBigDecimal("outputqty");
        if (!checkedRowSet.contains(assignIndexStr)) {
            outputQty = BigDecimal.ZERO;
        }
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        int[] stageIndexArray = business.stringToArray(selectStageSeq);
        DynamicObjectCollection stageEntryCol = assignObj.getDynamicObjectCollection("prestageentity");
        for (int index : stageIndexArray) {
            DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(index);
            BigDecimal stageAssignQty = stageEntry.getBigDecimal("unassignstageqty");
            BigDecimal toBeAssignQty = stageEntry.getBigDecimal("preassignqtynum");
            BigDecimal stageAssignRate = stageEntry.getBigDecimal("unassignstagefixscrap");
            BigDecimal toBeAssignRate = stageEntry.getBigDecimal("preassginstagefixscrap");
            if (stageAssignQty.compareTo(BigDecimal.ZERO) <= 0 && outputQty.compareTo(BigDecimal.ZERO) <= 0) {
                retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\u6ca1\u6709\u9700\u8981\u79fb\u51fa\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_22", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), assignIndex, index + 1);
                break;
            }
            if (stageAssignQty.compareTo(toBeAssignQty) != 0 || stageAssignRate.compareTo(toBeAssignRate) >= 0) continue;
            retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u9636\u68af\u4fe1\u606f\uff0c\u201c\u79fb\u51fa\u7528\u91cf\u201d=\u201c\u5206\u914d\u7528\u91cf\uff1a\u5206\u5b50\u201d\u65f6\uff0c\u8981\u6c42\u201c\u79fb\u51fa\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d=\u201c\u5206\u914d\u56fa\u5b9a\u635f\u8017\u201d\u3002", (String)"ProgramAssignEditPlugin_23", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), assignIndex, index + 1);
            break;
        }
        return retMsg;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        if ("ok".equals(opKey)) {
            DynamicObjectCollection assigenCol = dm.getEntryEntity("assignentry");
            if (assigenCol == null || assigenCol.isEmpty()) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u6e05\u5355\u4e3a\u7a7a\uff0c\u6ca1\u6709\u9700\u8981\u5206\u914d\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONArray dataArray = new JSONArray();
            for (int i = 0; i < assigenCol.size(); ++i) {
                JSONObject dataObj = new JSONObject();
                DynamicObject assignObj = (DynamicObject)assigenCol.get(i);
                DynamicObject prostatge = assignObj.getDynamicObject("preprostatge");
                long prostatgeId = prostatge == null ? 0L : prostatge.getLong("id");
                String proNum = assignObj.getString("preprocessno");
                boolean isStage = assignObj.getBoolean("preisstage");
                String proEntryIdStr = assignObj.getString("preproentryid");
                long proEntryId = proEntryIdStr == null || "".equals(proEntryIdStr) ? 0L : Long.parseLong(proEntryIdStr);
                String stageDesc = assignObj.getString("preprostatgedesc");
                int groupSeq = assignObj.getInt("pregroupseq");
                BigDecimal assignQty = assignObj.getBigDecimal("preassinqtynum");
                BigDecimal assignRate = assignObj.getBigDecimal("preassignfixscrap");
                boolean isJump = assignObj.getBoolean("preentryisjumplevel");
                String groupId = assignObj.getString("pregroupid");
                DynamicObjectCollection stageEntryCol = assignObj.getDynamicObjectCollection("prestageentity");
                JSONArray stageArray = business.getAssignStageEntry(stageEntryCol);
                dataObj.put("prostatgeId", (Object)prostatgeId);
                dataObj.put("processno", (Object)proNum);
                dataObj.put("isstage", (Object)isStage);
                dataObj.put("id", (Object)proEntryId);
                dataObj.put("prostatgedesc", (Object)stageDesc);
                dataObj.put("groupseq", (Object)groupSeq);
                dataObj.put("qtynumerator", (Object)assignQty);
                dataObj.put("entryisjumplevel", (Object)isJump);
                dataObj.put("assignfixscrap", (Object)assignRate);
                dataObj.put("groupId", (Object)groupId);
                dataObj.put("stageEntry", (Object)stageArray);
                dataArray.add((Object)dataObj);
            }
            fv.returnDataToParent((Object)dataArray);
            this.getView().close();
        } else if ("input".equals(opKey)) {
            String errorMsg;
            EntryGrid groupGrid = (EntryGrid)fv.getControl("groupentity");
            int[] groupIndexArray = groupGrid.getSelectRows();
            boolean isEnbaleAssign = true;
            DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
            for (int i = 0; i < groupIndexArray.length; ++i) {
                int groupIndex = groupIndexArray[i];
                DynamicObject groupObj = (DynamicObject)groupCol.get(groupIndex);
                BigDecimal groupAssignQty = groupObj.getBigDecimal("qtynumerator");
                BigDecimal toBeAssignQty = groupObj.getBigDecimal("assignnumerator");
                BigDecimal groupAssignRate = groupObj.getBigDecimal("assignfixscrap");
                BigDecimal toBeAssignRate = groupObj.getBigDecimal("tobeassignrate");
                if (groupAssignQty.compareTo(toBeAssignQty) > 0 || groupAssignRate.compareTo(toBeAssignRate) > 0) {
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\uff0c\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f85\u5206\u914d\u6570\u91cf\u4e14\u5206\u914d\u56fa\u5b9a\u635f\u8017\u4e0d\u80fd\u5927\u4e8e\u5f85\u5206\u914d\u56fa\u5b9a\u635f\u8017\u3002", (String)"ProgramAssignEditPlugin_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex + 1));
                    isEnbaleAssign = false;
                    break;
                }
                String retMsg = this.isStageEntryEnableInput(groupObj, groupIndex);
                if (retMsg == null || "".equals(retMsg)) continue;
                fv.showTipNotification(retMsg);
                isEnbaleAssign = false;
                break;
            }
            if ((errorMsg = this.inputQtyValdate()) != null && !"".equals(errorMsg)) {
                this.getView().showTipNotification(errorMsg);
                isEnbaleAssign = false;
            }
            if (isEnbaleAssign) {
                this.inputAssignData();
            }
        } else if ("output".equals(opKey)) {
            String errorMsg;
            EntryGrid assignGrid = (EntryGrid)fv.getControl("assignentry");
            int[] assignIndexArray = assignGrid.getSelectRows();
            boolean isEnbaleAssign = true;
            DynamicObjectCollection assignCol = dm.getEntryEntity("assignentry");
            for (int i = 0; i < assignIndexArray.length; ++i) {
                int groupIndex = assignIndexArray[i];
                DynamicObject assignObj = (DynamicObject)assignCol.get(groupIndex);
                BigDecimal outputQty = assignObj.getBigDecimal("outputqty");
                BigDecimal AssignQty = assignObj.getBigDecimal("preassinqtynum");
                BigDecimal outputRate = assignObj.getBigDecimal("outputfixscrap");
                BigDecimal AssignRate = assignObj.getBigDecimal("preassignfixscrap");
                if (outputQty.compareTo(AssignQty) > 0 || outputRate.compareTo(AssignRate) > 0) {
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u6e05\u5355\uff0c\u79fb\u51fa\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u6570\u91cf\u3002", (String)"ProgramAssignEditPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex + 1));
                    isEnbaleAssign = false;
                    break;
                }
                String retMsg = this.isStageEntryEnableOutput(assignObj, groupIndex);
                if (retMsg == null || "".equals(retMsg)) continue;
                fv.showTipNotification(retMsg);
                isEnbaleAssign = false;
                break;
            }
            if ((errorMsg = this.outputQtyValdate()) != null && !"".equals(errorMsg)) {
                this.getView().showTipNotification(errorMsg);
                isEnbaleAssign = false;
            }
            if (isEnbaleAssign) {
                this.outputAssignData();
                fv.updateView();
            }
        }
    }

    private String isStageEntryEnableInput(DynamicObject groupObj, int groupIndex) {
        int[] stageIndex;
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        IFormView fv = this.getView();
        String retMsg = "";
        if (groupObj == null) {
            return retMsg;
        }
        String groupEntryId = groupObj.getString("id");
        DynamicObjectCollection stageCol = groupObj.getDynamicObjectCollection("stageentity");
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("checkedData");
        JSONObject dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        String selectStageSeq = dataObj == null ? "" : dataObj.getString(groupEntryId);
        for (int index : stageIndex = business.stringToArray(selectStageSeq)) {
            DynamicObject stageObj = (DynamicObject)stageCol.get(index);
            BigDecimal stageAssignQty = stageObj.getBigDecimal("assignqty");
            BigDecimal toBeAssignQty = stageObj.getBigDecimal("assignstagenumerator");
            BigDecimal stageAssignRate = stageObj.getBigDecimal("assginfixscrap");
            BigDecimal toBeAssignRate = stageObj.getBigDecimal("assginstagefixscrap");
            if (stageAssignQty.compareTo(toBeAssignQty) <= 0 && stageAssignRate.compareTo(toBeAssignRate) <= 0) continue;
            retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\uff0c\u5206\u914d\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5f85\u5206\u914d\u6570\u91cf\u4e14\u5206\u914d\u56fa\u5b9a\u635f\u8017\u4e0d\u80fd\u5927\u4e8e\u5f85\u5206\u914d\u56fa\u5b9a\u635f\u8017\u3002", (String)"ProgramAssignEditPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex + 1, index + 1);
            break;
        }
        return retMsg;
    }

    private String isStageEntryEnableOutput(DynamicObject assignObj, int assignIndex) {
        int[] stageIndex;
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        IFormView fv = this.getView();
        String retMsg = "";
        if (assignObj == null) {
            return retMsg;
        }
        String assignEntryId = assignObj.getString("id");
        DynamicObjectCollection stageCol = assignObj.getDynamicObjectCollection("prestageentity");
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("preCheckedData");
        JSONObject dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        String selectStageSeq = dataObj == null ? "" : dataObj.getString(assignEntryId);
        for (int index : stageIndex = business.stringToArray(selectStageSeq)) {
            DynamicObject stageObj = (DynamicObject)stageCol.get(index);
            BigDecimal outputQty = stageObj.getBigDecimal("unassignstageqty");
            BigDecimal assignQty = stageObj.getBigDecimal("preassignqtynum");
            BigDecimal outputRate = stageObj.getBigDecimal("unassignstagefixscrap");
            BigDecimal assignRate = stageObj.getBigDecimal("preassginstagefixscrap");
            if (outputQty.compareTo(assignQty) <= 0 && outputRate.compareTo(assignRate) <= 0) continue;
            retMsg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u884c\u9636\u68af\uff0c\u79fb\u51fa\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u6570\u91cf\u4e14\u79fb\u51fa\u5206\u914d\u56fa\u5b9a\u635f\u8017\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u56fa\u5b9a\u635f\u8017\u3002", (String)"ProgramAssignEditPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), assignIndex + 1, index + 1);
            break;
        }
        return retMsg;
    }

    private void inputAssignData() {
        JSONObject dataObj;
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid proGrid = (EntryGrid)fv.getControl("entryentity");
        EntryGrid groupGrid = (EntryGrid)fv.getControl("groupentity");
        int[] proIndexArray = proGrid.getSelectRows();
        int[] groupIndexArray = groupGrid.getSelectRows();
        DynamicObject proEntryObj = null;
        if (proIndexArray.length > 0) {
            proEntryObj = dm.getEntryRowEntity("entryentity", proIndexArray[0]);
        }
        if (proEntryObj == null) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de5\u5e8f\u3002", (String)"ProgramAssignEditPlugin_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        DynamicObjectCollection assignCol = dm.getEntryEntity("assignentry");
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        Set checkedRowSet = business.arrayToSet(groupIndexArray);
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("checkedData");
        JSONObject jSONObject = dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        if (groupIndexArray.length <= 0 && dataObj == null) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7269\u6599\u4fe1\u606f\u548c\u9636\u68af\u4fe1\u606f\u3002", (String)"ProgramAssignEditPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < groupCol.size(); ++i) {
            String selectStageSeq;
            DynamicObject groupObj = (DynamicObject)groupCol.get(i);
            int entrySeq = groupObj.getInt("seq");
            String indexStr = String.valueOf(entrySeq - 1);
            String entryId = groupObj.getString("id");
            String string = selectStageSeq = dataObj == null ? null : dataObj.getString(entryId);
            if (!checkedRowSet.contains(indexStr) && (selectStageSeq == null || "".equals(selectStageSeq))) continue;
            this.addAssignGroup(assignCol, groupObj, proEntryObj, checkedRowSet, indexStr, selectStageSeq);
        }
        pageCatch.put("checkedData", null);
        fv.updateView();
    }

    private void addAssignGroup(DynamicObjectCollection assignCol, DynamicObject groupObj, DynamicObject proEntryObj, Set<String> checkedRowSet, String groupIndexStr, String selectStageSeq) {
        if (assignCol == null || groupObj == null || proEntryObj == null) {
            return;
        }
        BigDecimal groupAssignQty = groupObj.getBigDecimal("qtynumerator");
        BigDecimal toBeAssignQty = groupObj.getBigDecimal("assignnumerator");
        BigDecimal groupAssignRate = groupObj.getBigDecimal("assignfixscrap");
        BigDecimal toBeAssignRate = groupObj.getBigDecimal("tobeassignrate");
        if (!checkedRowSet.contains(groupIndexStr)) {
            groupAssignQty = BigDecimal.ZERO;
            groupAssignRate = BigDecimal.ZERO;
        }
        String groupId = groupObj.getString("groupid");
        String proEntryId = proEntryObj.getString("id");
        DynamicObject assignObj = this.getTheSameAssignObj(proEntryId, groupId);
        if (assignObj != null) {
            BigDecimal assinQty = assignObj.getBigDecimal("preassinqtynum");
            assinQty = assinQty.add(groupAssignQty);
            assignObj.set("preassinqtynum", (Object)assinQty);
            BigDecimal assinRate = assignObj.getBigDecimal("preassignfixscrap");
            assinRate = assinRate.add(groupAssignRate);
            assignObj.set("preassignfixscrap", (Object)assinRate);
        } else {
            ORM orm = ORM.create();
            long assignEntryId = orm.genLongId((IDataEntityType)assignCol.getDynamicObjectType());
            assignObj = assignCol.addNew();
            assignObj.set("id", (Object)assignEntryId);
            assignObj.set("matentryid", groupObj.get("id"));
            assignObj.set("preprodtype", groupObj.get("prodtype"));
            assignObj.set("preentrymaterial", groupObj.get("entrymaterial"));
            assignObj.set("preentrydesc", groupObj.get("entrydesc"));
            assignObj.set("preentryauxproperty", groupObj.get("entryauxproperty"));
            assignObj.set("preentryqtytype", groupObj.get("entryqtytype"));
            assignObj.set("preentryversion", groupObj.get("entryversion"));
            assignObj.set("preprocessno", proEntryObj.get("processno"));
            assignObj.set("preprostatge", proEntryObj.get("prostatge"));
            assignObj.set("preprostatgedesc", proEntryObj.get("prostatgedesc"));
            assignObj.set("preisstage", proEntryObj.get("isstage"));
            assignObj.set("preentryunit", groupObj.get("entryunit"));
            assignObj.set("preassinqtynum", (Object)groupAssignQty);
            assignObj.set("preassignqtydemo", groupObj.get("assigndenominator"));
            assignObj.set("preassignfixscrap", (Object)groupAssignRate);
            assignObj.set("prescraprate", (Object)BigDecimal.ZERO);
            assignObj.set("pregroupid", groupObj.get("groupid"));
            assignObj.set("preproentryid", (Object)proEntryObj.getString("id"));
            assignObj.set("pregroupseq", (Object)groupObj.getString("groupseq"));
            assignObj.set("preentryisjumplevel", groupObj.get("entryisjumplevel"));
            assignObj.set("presourceid", groupObj.get("sourceid"));
            assignObj.set("prepgroupid", groupObj.get("pgroupid"));
            assignObj.set("precgroupid", groupObj.get("cgroupid"));
            assignObj.set("outputqty", (Object)groupAssignQty);
            assignObj.set("outputfixscrap", (Object)groupAssignRate);
        }
        toBeAssignQty = toBeAssignQty.subtract(groupAssignQty);
        groupObj.set("qtynumerator", (Object)toBeAssignQty);
        groupObj.set("assignnumerator", (Object)toBeAssignQty);
        toBeAssignRate = toBeAssignRate.subtract(groupAssignRate);
        groupObj.set("assignfixscrap", (Object)toBeAssignRate);
        groupObj.set("tobeassignrate", (Object)toBeAssignRate);
        this.addAssignStageEntry(assignObj, groupObj, selectStageSeq);
    }

    private void addAssignStageEntry(DynamicObject assignGroupObj, DynamicObject groupObj, String selectStageSeq) {
        if (selectStageSeq == null || "".equals(selectStageSeq)) {
            return;
        }
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        int[] stageIndexArray = business.stringToArray(selectStageSeq);
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        DynamicObjectCollection assignStageEntryCol = assignGroupObj.getDynamicObjectCollection("prestageentity");
        for (int index : stageIndexArray) {
            DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(index);
            long stageEntryId = stageEntry.getLong("id");
            BigDecimal stageAssignQty = stageEntry.getBigDecimal("assignqty");
            BigDecimal toBeAssignQty = stageEntry.getBigDecimal("assignstagenumerator");
            BigDecimal stageAssignRate = stageEntry.getBigDecimal("assginfixscrap");
            BigDecimal toBeAssignRate = stageEntry.getBigDecimal("assginstagefixscrap");
            DynamicObject assignStageObj = this.getTheSameStageObj(assignStageEntryCol, stageEntryId);
            if (assignStageObj != null) {
                BigDecimal assignQty = assignStageObj.getBigDecimal("preassignqtynum");
                assignQty = assignQty.add(stageAssignQty);
                assignStageObj.set("preassignqtynum", (Object)assignQty);
                assignStageObj.set("unassignstageqty", (Object)assignQty);
                BigDecimal assignRate = assignStageObj.getBigDecimal("preassginstagefixscrap");
                assignRate = assignRate.add(stageAssignRate);
                assignStageObj.set("preassginstagefixscrap", (Object)assignRate);
                assignStageObj.set("unassignstagefixscrap", (Object)assignRate);
            } else {
                assignStageObj = assignStageEntryCol.addNew();
                assignStageObj.set("id", stageEntry.get("id"));
                assignStageObj.set("prebatchstartqty", stageEntry.get("batchstartqty"));
                assignStageObj.set("prebatchendqty", stageEntry.get("batchendqty"));
                assignStageObj.set("preisstagefix", stageEntry.get("isstagefix"));
                assignStageObj.set("preassignqtynum", (Object)stageAssignQty);
                assignStageObj.set("preassignqtydome", stageEntry.get("assginstagedenominator"));
                assignStageObj.set("preassginstagefixscrap", (Object)stageAssignRate);
                assignStageObj.set("prestagescraprate", (Object)BigDecimal.ZERO);
                assignStageObj.set("unassignstageqty", (Object)stageAssignQty);
                assignStageObj.set("unassignstagefixscrap", (Object)stageAssignRate);
            }
            toBeAssignQty = toBeAssignQty.subtract(stageAssignQty);
            stageEntry.set("assignstagenumerator", (Object)toBeAssignQty);
            stageEntry.set("assignqty", (Object)toBeAssignQty);
            toBeAssignRate = toBeAssignRate.subtract(stageAssignRate);
            stageEntry.set("assginstagefixscrap", (Object)toBeAssignRate);
            stageEntry.set("assginfixscrap", (Object)toBeAssignRate);
        }
    }

    private DynamicObject getTheSameStageObj(DynamicObjectCollection assignStageEntryCol, long stageEntryId) {
        DynamicObject retObj = null;
        if (assignStageEntryCol == null || assignStageEntryCol.isEmpty()) {
            return retObj;
        }
        for (int i = 0; i < assignStageEntryCol.size(); ++i) {
            DynamicObject assignStage = (DynamicObject)assignStageEntryCol.get(i);
            long entryId = assignStage.getLong("id");
            if (entryId == 0L || entryId != stageEntryId) continue;
            retObj = assignStage;
            break;
        }
        return retObj;
    }

    private void outputAssignData() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid assignGrid = (EntryGrid)fv.getControl("assignentry");
        int[] assignIndexArray = assignGrid.getSelectRows();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        Set checkedRowSet = business.arrayToSet(assignIndexArray);
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        DynamicObjectCollection assignCol = dm.getEntryEntity("assignentry");
        IPageCache pageCatch = fv.getPageCache();
        String checkedData = pageCatch.get("preCheckedData");
        JSONObject dataObj = checkedData == null ? null : JSONObject.parseObject((String)checkedData);
        boolean hasDataOutPut = false;
        for (int i = 0; i < assignCol.size(); ++i) {
            String selectStageSeq;
            DynamicObject aasignObj = (DynamicObject)assignCol.get(i);
            int entrySeq = aasignObj.getInt("seq");
            String indexStr = String.valueOf(entrySeq - 1);
            String entryId = aasignObj.getString("id");
            String string = selectStageSeq = dataObj == null ? null : dataObj.getString(entryId);
            if (!checkedRowSet.contains(indexStr) && (selectStageSeq == null || "".equals(selectStageSeq))) continue;
            hasDataOutPut = true;
            this.addGroup(groupCol, aasignObj, checkedRowSet, indexStr, selectStageSeq);
        }
        if (assignIndexArray.length <= 0 && !hasDataOutPut) {
            fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u51fa\u7684\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void addGroup(DynamicObjectCollection groupCol, DynamicObject assignObj, Set<String> checkedRowSet, String groupIndexStr, String selectStageSeq) {
        DynamicObject groupObj;
        if (groupCol == null || assignObj == null) {
            return;
        }
        String assignEntryId = assignObj.getString("matentryid");
        BigDecimal assignQty = assignObj.getBigDecimal("preassinqtynum");
        BigDecimal assignRate = assignObj.getBigDecimal("preassignfixscrap");
        BigDecimal outputQty = assignObj.getBigDecimal("outputqty");
        BigDecimal outputfixRate = assignObj.getBigDecimal("outputfixscrap");
        if (!checkedRowSet.contains(groupIndexStr)) {
            outputQty = BigDecimal.ZERO;
            outputfixRate = BigDecimal.ZERO;
        }
        if ((groupObj = this.getGroupObj(assignEntryId)) != null) {
            BigDecimal toBeAssignQty = groupObj.getBigDecimal("assignnumerator");
            toBeAssignQty = toBeAssignQty.add(outputQty);
            groupObj.set("assignnumerator", (Object)toBeAssignQty);
            groupObj.set("qtynumerator", (Object)toBeAssignQty);
            BigDecimal toBeAssignRate = groupObj.getBigDecimal("tobeassignrate");
            toBeAssignRate = toBeAssignRate.add(outputfixRate);
            groupObj.set("tobeassignrate", (Object)toBeAssignRate);
            groupObj.set("assignfixscrap", (Object)toBeAssignRate);
        } else {
            groupObj = groupCol.addNew();
            String groupEntryId = assignObj.getString("matentryid");
            groupObj.set("id", (Object)(groupEntryId == null || "".equals(groupEntryId) ? 0L : Long.parseLong(groupEntryId)));
            groupObj.set("prodtype", assignObj.get("preprodtype"));
            groupObj.set("groupseq", assignObj.get("groupseq"));
            groupObj.set("entrymaterial", assignObj.get("preentrymaterial"));
            groupObj.set("entrydesc", assignObj.get("preentrydesc"));
            groupObj.set("entryauxproperty", assignObj.get("preentryauxproperty"));
            groupObj.set("entryqtytype", assignObj.get("preentryqtytype"));
            groupObj.set("entryversion", assignObj.get("preentryversion"));
            groupObj.set("entryunit", assignObj.get("preentryunit"));
            groupObj.set("assignnumerator", assignObj.get("outputqty"));
            groupObj.set("assigndenominator", assignObj.get("preassignqtydemo"));
            groupObj.set("qtynumerator", assignObj.get("outputqty"));
            groupObj.set("tobeassignrate", assignObj.get("outputfixscrap"));
            groupObj.set("assignfixscrap", assignObj.get("outputfixscrap"));
            groupObj.set("groupid", assignObj.get("pregroupid"));
            groupObj.set("entryisjumplevel", assignObj.get("preentryisjumplevel"));
            groupObj.set("sourceid", assignObj.get("presourceid"));
            groupObj.set("pgroupid", assignObj.get("prepgroupid"));
            groupObj.set("cgroupid", assignObj.get("precgroupid"));
        }
        assignQty = assignQty.subtract(outputQty);
        assignObj.set("preassinqtynum", (Object)assignQty);
        assignRate = assignRate.subtract(outputfixRate);
        assignObj.set("preassignfixscrap", (Object)assignRate);
        assignObj.set("outputqty", (Object)assignQty);
        assignObj.set("outputfixscrap", (Object)assignRate);
        this.addStageEntry(groupObj, assignObj, selectStageSeq);
    }

    private void addStageEntry(DynamicObject groupObj, DynamicObject assignObj, String selectStageSeq) {
        if (selectStageSeq == null || "".equals(selectStageSeq)) {
            return;
        }
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        int[] stageIndexArray = business.stringToArray(selectStageSeq);
        DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
        DynamicObjectCollection assignStageEntryCol = assignObj.getDynamicObjectCollection("prestageentity");
        for (int index : stageIndexArray) {
            DynamicObject stageEntry = (DynamicObject)assignStageEntryCol.get(index);
            long stageEntryId = stageEntry.getLong("id");
            BigDecimal outAssignQty = stageEntry.getBigDecimal("unassignstageqty");
            BigDecimal assignQty = stageEntry.getBigDecimal("preassignqtynum");
            BigDecimal outAssignRate = stageEntry.getBigDecimal("unassignstagefixscrap");
            BigDecimal assignRate = stageEntry.getBigDecimal("preassginstagefixscrap");
            DynamicObject groupStageObj = this.getTheSameStageObj(stageEntryCol, stageEntryId);
            if (groupStageObj != null) {
                BigDecimal toBeAssignQty = groupStageObj.getBigDecimal("assignstagenumerator");
                toBeAssignQty = toBeAssignQty.add(outAssignQty);
                groupStageObj.set("assignstagenumerator", (Object)toBeAssignQty);
                groupStageObj.set("assignqty", (Object)toBeAssignQty);
                BigDecimal toBeAssignRate = groupStageObj.getBigDecimal("assginstagefixscrap");
                toBeAssignRate = toBeAssignRate.add(outAssignRate);
                groupStageObj.set("assginstagefixscrap", (Object)toBeAssignRate);
                groupStageObj.set("assginfixscrap", (Object)toBeAssignRate);
            } else {
                groupStageObj = stageEntryCol.addNew();
                groupStageObj.set("id", stageEntry.get("id"));
                groupStageObj.set("batchstartqty", stageEntry.get("prebatchstartqty"));
                groupStageObj.set("batchendqty", stageEntry.get("prebatchendqty"));
                groupStageObj.set("isstagefix", stageEntry.get("preisstagefix"));
                groupStageObj.set("assignstagenumerator", (Object)outAssignQty);
                groupStageObj.set("assginstagedenominator", stageEntry.get("preassignqtydome"));
                groupStageObj.set("assignqty", (Object)outAssignQty);
                groupStageObj.set("assginstagefixscrap", (Object)outAssignRate);
                groupStageObj.set("assginfixscrap", (Object)outAssignRate);
            }
            assignQty = assignQty.subtract(outAssignQty);
            stageEntry.set("preassignqtynum", (Object)assignQty);
            stageEntry.set("unassignstageqty", (Object)assignQty);
            assignRate = assignRate.subtract(outAssignRate);
            stageEntry.set("preassginstagefixscrap", (Object)assignRate);
            stageEntry.set("unassignstagefixscrap", (Object)assignRate);
        }
    }

    private DynamicObject getGroupObj(String groupEntryId) {
        DynamicObject retObj = null;
        if (groupEntryId == null || "".equals(groupEntryId)) {
            return retObj;
        }
        IDataModel dm = this.getModel();
        DynamicObjectCollection groupCol = dm.getEntryEntity("groupentity");
        for (int i = 0; i < groupCol.size(); ++i) {
            DynamicObject groupObj = (DynamicObject)groupCol.get(i);
            String enrtyId = groupObj.getString("id");
            if (enrtyId == null || !enrtyId.equals(groupEntryId)) continue;
            retObj = groupObj;
            break;
        }
        return retObj;
    }

    private DynamicObject getTheSameAssignObj(String proEntryId, String groupId) {
        DynamicObject retObj = null;
        if (proEntryId == null || "".equals(proEntryId) || groupId == null || "".equals(groupId)) {
            return retObj;
        }
        IDataModel dm = this.getModel();
        DynamicObjectCollection assignCol = dm.getEntryEntity("assignentry");
        for (DynamicObject assignObj : assignCol) {
            String assignProEntryId = assignObj.getString("preproentryid");
            String assignGroupId = assignObj.getString("pregroupid");
            if (!proEntryId.equals(assignProEntryId) || !groupId.equals(assignGroupId)) continue;
            retObj = assignObj;
            break;
        }
        return retObj;
    }

    public void tabSelected(TabSelectEvent e) {
        String tabPageKey = e.getTabKey();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid stageEntryGrid = (EntryGrid)fv.getControl("stageentity");
        EntryGrid groupEntryGrid = (EntryGrid)fv.getControl("groupentity");
        if (!"grouptabpageap".equals(tabPageKey)) {
            if ("stagetabpageap".equals(tabPageKey)) {
                String groupId;
                String qtyType;
                Tab matTab = (Tab)fv.getControl("tabap");
                int[] groupIndexArray = groupEntryGrid.getSelectRows();
                if (groupIndexArray.length <= 0) {
                    matTab.activeTab("grouptabpageap");
                    fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_18", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int groupIndex = dm.getEntryCurrentRowIndex("groupentity");
                if (groupIndex == -1) {
                    fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_18", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject groupObj = dm.getEntryRowEntity("groupentity", groupIndex);
                if (groupObj == null) {
                    return;
                }
                String string = qtyType = groupObj == null ? "" : groupObj.getString("entryqtytype");
                if (!"C".equals(qtyType)) {
                    matTab.activeTab("grouptabpageap");
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u7269\u6599\uff0c\u7528\u91cf\u7c7b\u578b\u4e0d\u4e3a\u201c\u9636\u68af\u201d\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9636\u68af\u7528\u91cf\u3002", (String)"ProgramAssignEditPlugin_19", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex + 1));
                    return;
                }
                IPageCache pageCatch = fv.getPageCache();
                String checkedData = pageCatch.get("checkedData");
                if (checkedData == null || "".equals(checkedData) || groupIndex == -1) {
                    return;
                }
                JSONObject dataObj = JSONObject.parseObject((String)checkedData);
                String indexArrayStr = dataObj.getString(groupId = groupObj.getString("id"));
                int[] stageIndexArray = business.stringToArray(indexArrayStr);
                if (stageIndexArray == null || stageIndexArray.length <= 0) {
                    return;
                }
                stageEntryGrid.selectRows(stageIndexArray, stageIndexArray[0]);
            } else if ("stagetabpage".equals(tabPageKey)) {
                String assignId;
                String qtyType;
                EntryGrid assignEntryGrid = (EntryGrid)fv.getControl("prestageentity");
                int assignIndex = dm.getEntryCurrentRowIndex("assignentry");
                if (assignIndex == -1) {
                    fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u6e05\u5355\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject assignObj = dm.getEntryRowEntity("assignentry", assignIndex);
                if (assignObj == null) {
                    fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u6e05\u5355\u6570\u636e\u3002", (String)"ProgramAssignEditPlugin_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
                String string = qtyType = assignObj == null ? "" : assignObj.getString("preentryqtytype");
                if (!"C".equals(qtyType)) {
                    Tab assignTab = (Tab)fv.getControl("tabap1");
                    assignTab.activeTab("mattabpage");
                    fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u7269\u6599\u6e05\u5355\uff0c\u7528\u91cf\u7c7b\u578b\u4e0d\u4e3a\u201c\u9636\u68af\u201d\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9636\u68af\u7528\u91cf\u3002", (String)"ProgramAssignEditPlugin_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), assignIndex + 1));
                    return;
                }
                IPageCache pageCatch = fv.getPageCache();
                String checkedData = pageCatch.get("preCheckedData");
                if (checkedData == null || "".equals(checkedData)) {
                    return;
                }
                JSONObject dataObj = JSONObject.parseObject((String)checkedData);
                String indexArrayStr = dataObj.getString(assignId = assignObj.getString("id"));
                int[] assignIndexArray = business.stringToArray(indexArrayStr);
                if (assignIndexArray == null || assignIndexArray.length <= 0) {
                    return;
                }
                assignEntryGrid.selectRows(assignIndexArray, assignIndexArray[0]);
            }
        }
    }
}

