/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.programe;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mmc.fmm.business.programe.ProgramAssignBusiness;

public class ProgramUnAssignEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TabSelectListener {
    public void registerListener(EventObject event) {
        EntryGrid groupGrid = (EntryGrid)this.getView().getControl("groupentity");
        groupGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid stageGrid = (EntryGrid)this.getView().getControl("stageentity");
        stageGrid.addRowClickListener((RowClickEventListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        JSONObject dataObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("data");
        if (dataObj == null) {
            return;
        }
        JSONArray groupArray = dataObj.getJSONArray("groupArray");
        this.loadGroupEntry(groupArray);
        this.getView().updateView();
    }

    private void loadGroupEntry(JSONArray groupArray) {
        IDataModel dm = this.getModel();
        if (groupArray == null || groupArray.isEmpty()) {
            return;
        }
        int index = 0;
        for (int i = 0; i < groupArray.size(); ++i) {
            JSONObject data = (JSONObject)groupArray.get(i);
            int[] row = dm.appendEntryRow("groupentity", index += i, 1);
            int currentIndex = row[0];
            dm.setValue("groupseq", data.get((Object)"seq"), currentIndex);
            dm.setValue("groupentity.id", data.get((Object)"id"), currentIndex);
            dm.setValue("prodtype", data.get((Object)"prodtype"), currentIndex);
            dm.setValue("entrymaterial", data.get((Object)"entrymaterial"), currentIndex);
            dm.setValue("entryunit", data.get((Object)"entryunit"), currentIndex);
            dm.setValue("entrydesc", data.get((Object)"entrydesc"), currentIndex);
            dm.setValue("entryversion", data.get((Object)"entryversion"), currentIndex);
            dm.setValue("entryauxproperty", data.get((Object)"entryauxproperty"), currentIndex);
            dm.setValue("entryqtytype", data.get((Object)"entryqtytype"), currentIndex);
            dm.setValue("qtynumerator", data.get((Object)"qtynumerator"), currentIndex);
            dm.setValue("qtydenominator", data.get((Object)"qtydenominator"), currentIndex);
            dm.setValue("entryisjumplevel", data.get((Object)"entryisjumplevel"), currentIndex);
            dm.setValue("groupid", data.get((Object)"groupid"), currentIndex);
            dm.setValue("assignrate", data.get((Object)"assignrate"), currentIndex);
            dm.setValue("cancernum", data.get((Object)"qtynumerator"), currentIndex);
            dm.setValue("assignfixscrap", data.get((Object)"assignrate"), currentIndex);
            dm.setValue("groupstatgedesc", data.get((Object)"groupstatgedesc"), currentIndex);
            dm.setValue("pgroupid", data.get((Object)"pgroupid"), currentIndex);
            dm.setValue("id", data.get((Object)"id"), currentIndex);
            dm.setValue("cgroupid", data.get((Object)"cgroupid"), currentIndex);
            dm.setValue("entryprono", data.get((Object)"entryprono"), currentIndex);
            dm.setValue("prodstage", data.get((Object)"prodstage"), currentIndex);
            dm.setValue("groupstatgedesc", data.get((Object)"groupstatgedesc"), currentIndex);
            dm.setValue("stage", data.get((Object)"stage"), currentIndex);
            Object stageObj = data.get((Object)"stageentity");
            if (stageObj == null) continue;
            JSONArray stageArray = (JSONArray)data.get((Object)"stageentity");
            DynamicObject groupEntryObj = dm.getEntryRowEntity("groupentity", currentIndex);
            this.loadStageEntry(groupEntryObj, stageArray);
        }
    }

    private void loadStageEntry(DynamicObject groupEntryObj, JSONArray stageArray) {
        if (groupEntryObj == null || stageArray == null || stageArray.isEmpty()) {
            return;
        }
        DynamicObjectCollection stageEntryCol = groupEntryObj.getDynamicObjectCollection("stageentity");
        for (int i = 0; i < stageArray.size(); ++i) {
            JSONObject data = (JSONObject)stageArray.get(i);
            DynamicObject stageEntryObj = stageEntryCol.addNew();
            stageEntryObj.set("batchstartqty", data.get((Object)"batchstartqty"));
            stageEntryObj.set("batchendqty", data.get((Object)"batchendqty"));
            stageEntryObj.set("isstagefix", data.get((Object)"isstagefix"));
            stageEntryObj.set("assignedstagenumerator", data.get((Object)"assignedstagenumerator"));
            stageEntryObj.set("assginedstagedenominator", data.get((Object)"assginedstagedenominator"));
            stageEntryObj.set("unassignqty", data.get((Object)"assignedstagenumerator"));
            stageEntryObj.set("assginedstagefixscrap", data.get((Object)"assginedstagefixscrap"));
            stageEntryObj.set("unassginfixscrap", data.get((Object)"assginedstagefixscrap"));
            stageEntryObj.set("id", data.get((Object)"id"));
            stageEntryObj.set("stagesourceid", data.get((Object)"stagesourceid"));
        }
        this.getModel().updateCache();
        this.getView().updateView();
    }

    public void entryRowClick(RowClickEvent e) {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryName = entryGrid.getEntryKey();
        RequestContext rc = RequestContext.get();
        long userId = rc.getCurrUserId();
        int index = e.getRow();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        if ("groupentity".equals(entryName)) {
            int[] indexArray = entryGrid.getSelectRows();
            if (index == 0 && indexArray.length == 0) {
                return;
            }
            business.setChildGroupChecked(entryGrid, userId, index, fv, dm);
        } else if ("stageentity".equals(entryName)) {
            this.setStageEntryDataToCatch();
        }
    }

    private void setStageEntryDataToCatch() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        EntryGrid stageEntryGrid = (EntryGrid)fv.getControl("stageentity");
        int[] indexArray = stageEntryGrid.getSelectRows();
        int groupIndex = dm.getEntryCurrentRowIndex("groupentity");
        DynamicObject groupObj = dm.getEntryRowEntity("groupentity", groupIndex);
        String groupId = groupObj.getString("id");
        IPageCache pageCatch = fv.getPageCache();
        HashMap<String, String> stageSelectedData = pageCatch.getAll();
        if (stageSelectedData == null) {
            stageSelectedData = new HashMap<String, String>(64);
        }
        String indexArrayStr = business.intArrayToString(indexArray);
        stageSelectedData.put(groupId, indexArrayStr);
        pageCatch.put(stageSelectedData);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        ProgramAssignBusiness business;
        boolean isSelectedRow;
        super.afterDoOperation(e);
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        if ("ok".equals(opKey) && (isSelectedRow = (business = new ProgramAssignBusiness()).getSelectEntry(fv, dm, "pro_unassign"))) {
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String opKey = operate.getOperateKey();
        IDataModel dm = this.getView().getModel();
        if ("ok".equals(opKey)) {
            String stageErrorMsg;
            String errorMsg = this.qtyValidator();
            if (errorMsg != null && !"".equals(errorMsg)) {
                e.setCancel(true);
                this.getView().showTipNotification(errorMsg);
            }
            if ((stageErrorMsg = this.stageQtyVal()) != null && !"".equals(stageErrorMsg)) {
                e.setCancel(true);
                this.getView().showTipNotification(stageErrorMsg);
            }
        }
    }

    private String qtyValidator() {
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid groupGrid = (EntryGrid)this.getView().getControl("groupentity");
        int[] groupRows = groupGrid.getSelectRows();
        StringBuilder errorMsg = new StringBuilder();
        DynamicObjectCollection entryCol = dm.getEntryEntity("groupentity");
        for (int index : groupRows) {
            String msg;
            DynamicObject entryObj = (DynamicObject)entryCol.get(index);
            BigDecimal qtynumerator = entryObj.getBigDecimal("qtynumerator");
            BigDecimal cancernum = entryObj.getBigDecimal("cancernum");
            BigDecimal assignrate = entryObj.getBigDecimal("assignrate");
            BigDecimal assignfixscrap = entryObj.getBigDecimal("assignfixscrap");
            if (qtynumerator.compareTo(cancernum) < 0) {
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                msg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u53d6\u6d88\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u6570\u91cf\u3002", (String)"ProgramUnAssignEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), index + 1);
                errorMsg.append(msg);
            }
            if (assignrate.compareTo(assignfixscrap) < 0) {
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                msg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u53d6\u6d88\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u4e0d\u80fd\u5927\u4e8e\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u3002", (String)"ProgramUnAssignEditPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), index + 1);
                errorMsg.append(msg);
            }
            if (qtynumerator.compareTo(cancernum) != 0 || assignfixscrap.compareTo(assignrate) >= 0) continue;
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            msg = String.format(ResManager.loadKDString((String)"\u7b2c\"%1$s\"\u884c\u7528\u91cf\u5df2\u5168\u90e8\u53d6\u6d88\uff0c \u5df2\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u4e5f\u9700\u5168\u90e8\u53d6\u6d88\u3002", (String)"ProgramUnAssignEditPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), index + 1);
            errorMsg.append(msg);
        }
        return errorMsg.toString();
    }

    public String stageQtyVal() {
        int[] selectIndex;
        StringBuilder errorMsg = new StringBuilder();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        Map catchMap = this.getView().getPageCache().getAll();
        DynamicObjectCollection groupCol = this.getModel().getEntryEntity("groupentity");
        EntryGrid grid = (EntryGrid)this.getView().getControl("groupentity");
        for (int i : selectIndex = grid.getSelectRows()) {
            int[] stageIndexArray;
            DynamicObject groupObj = (DynamicObject)groupCol.get(i);
            BigDecimal cancernum = groupObj.getBigDecimal("cancernum");
            String stageEntryId = groupObj.getString("id");
            String seqStr = (String)catchMap.get(stageEntryId);
            if (cancernum.compareTo(BigDecimal.ZERO) <= 0 && (seqStr == null || "".equals(seqStr))) {
                String msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u4e0d\u5b58\u5728\u9700\u8981\u53d6\u6d88\u5206\u914d\u7684\u7269\u6599\u6570\u636e\u6216\u9636\u68af\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProgramUnAssignEditPlugin_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1);
                errorMsg.append(msg);
            }
            if (seqStr == null || "".equals(seqStr)) continue;
            DynamicObjectCollection stageEntryCol = groupObj.getDynamicObjectCollection("stageentity");
            for (int index : stageIndexArray = business.stringToArray(seqStr)) {
                String msg;
                DynamicObject stageEntry = (DynamicObject)stageEntryCol.get(index);
                BigDecimal assignQty = stageEntry.getBigDecimal("unassignqty");
                BigDecimal assignFixRate = stageEntry.getBigDecimal("unassginfixscrap");
                BigDecimal toBeAssignQty = stageEntry.getBigDecimal("assignedstagenumerator");
                BigDecimal ToBeAssignFixRate = stageEntry.getBigDecimal("assginedstagefixscrap");
                if (assignQty.compareTo(BigDecimal.ZERO) <= 0 || assignQty.compareTo(toBeAssignQty) > 0) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u9636\u68af\u4fe1\u606f\uff0c\u53d6\u6d88\u5206\u914d\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c11\u4e8e\u5206\u914d\u6570\u91cf\u3002", (String)"ProgramUnAssignEditPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1, index + 1);
                    errorMsg.append(msg);
                }
                if (assignFixRate.compareTo(BigDecimal.ZERO) < 0 || assignFixRate.compareTo(ToBeAssignFixRate) > 0) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u9636\u68af\u4fe1\u606f\uff0c\u53d6\u6d88\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u5fc5\u987b\u5c11\u4e8e\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u3002", (String)"ProgramUnAssignEditPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1, index + 1);
                    errorMsg.append(msg);
                }
                if (assignQty.compareTo(toBeAssignQty) != 0 || assignFixRate.compareTo(ToBeAssignFixRate) >= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7269\u6599\u5bf9\u5e94\u7b2c\u201c%2$s\u201d\u9636\u68af\u4fe1\u606f\uff0c\u5206\u914d\u7528\u91cf\u5df2\u7ecf\u5168\u90e8\u53d6\u6d88\uff0c\u5206\u914d\u56fa\u5b9a\u635f\u8017\u7387\u4e5f\u9700\u5168\u90e8\u53d6\u6d88\u3002", (String)"ProgramUnAssignEditPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1, index + 1);
                errorMsg.append(msg);
            }
        }
        return errorMsg.toString();
    }

    public void tabSelected(TabSelectEvent e) {
        String tabPageKey = e.getTabKey();
        ProgramAssignBusiness business = new ProgramAssignBusiness();
        IFormView fv = this.getView();
        IDataModel dm = this.getModel();
        EntryGrid stageEntryGrid = (EntryGrid)fv.getControl("stageentity");
        if (!"grouptabpageap".equals(tabPageKey) && "stagetabpageap".equals(tabPageKey)) {
            String qtyType;
            IPageCache pageCatch = fv.getPageCache();
            Map stageSelectedData = pageCatch.getAll();
            int groupIndex = dm.getEntryCurrentRowIndex("groupentity");
            if (groupIndex == -1) {
                fv.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u6570\u636e\u3002", (String)"ProgramUnAssignEditPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject groupObj = dm.getEntryRowEntity("groupentity", groupIndex);
            if (groupObj == null) {
                return;
            }
            String string = qtyType = groupObj == null ? "" : groupObj.getString("entryqtytype");
            if (!"C".equals(qtyType)) {
                Tab matTab = (Tab)fv.getControl("tabap");
                matTab.activeTab("grouptabpageap");
                fv.showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%s\u201d\u884c\u7269\u6599\uff0c\u7528\u91cf\u7c7b\u578b\u4e0d\u4e3a\u201c\u9636\u68af\u201d\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9636\u68af\u7528\u91cf\u3002", (String)"ProgramUnAssignEditPlugin_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), groupIndex + 1));
                return;
            }
            if (stageSelectedData == null || groupIndex == -1) {
                return;
            }
            String groupId = groupObj.getString("id");
            String indexArrayStr = (String)stageSelectedData.get(groupId);
            int[] stageIndexArray = business.stringToArray(indexArrayStr);
            if (stageIndexArray == null || stageIndexArray.length <= 0) {
                return;
            }
            stageEntryGrid.selectRows(stageIndexArray, stageIndexArray[0]);
        }
    }
}

