/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.fmm.formplugin.resourceready;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ResourceReadyPlanEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String MRP_BILLFILED_TRANSFER = "mrp_billfieldtransfer";
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String RES_REGISTER_DEMAND = "resregisterdemand";
    private static final String RES_REGISTER_SUPPLY = "resregistersupply";
    private static final String ENTRY_PLAN_RESBILL = "entryplanresbill";
    private static final String ENTRY_PLAN_FIELDTRANSFER = "entryplanfieldtransfer";
    private static final String ENTRY_PLAN_READYRULE = "entryplanreadyrule";
    private static final String ENTRY_EXE_RESBILL = "entryexeresbill";
    private static final String ENTRY_EXE_FIELDTRANSFER = "entryexefieldtransfer";
    private static final String ENTRY_EXE_READYRULE = "entryexereadyrule";

    public void registerListener(EventObject e) {
        BasedataEdit entryExeReadyRule;
        BasedataEdit entryExeFieldTransfer;
        BasedataEdit entryExeResBill;
        BasedataEdit entryPlanReadyRule;
        BasedataEdit entryPlanFieldTransfer;
        super.registerListener(e);
        BasedataEdit entryPlanResBill = (BasedataEdit)this.getControl(ENTRY_PLAN_RESBILL);
        if (entryPlanResBill != null) {
            entryPlanResBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryPlanFieldTransfer = (BasedataEdit)this.getControl(ENTRY_PLAN_FIELDTRANSFER)) != null) {
            entryPlanFieldTransfer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryPlanReadyRule = (BasedataEdit)this.getControl(ENTRY_PLAN_READYRULE)) != null) {
            entryPlanReadyRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryExeResBill = (BasedataEdit)this.getControl(ENTRY_EXE_RESBILL)) != null) {
            entryExeResBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryExeFieldTransfer = (BasedataEdit)this.getControl(ENTRY_EXE_FIELDTRANSFER)) != null) {
            entryExeFieldTransfer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryExeReadyRule = (BasedataEdit)this.getControl(ENTRY_EXE_READYRULE)) != null) {
            entryExeReadyRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        int row = e.getRow();
        switch (fieldName) {
            case "entryplanresbill": 
            case "entryexeresbill": {
                DynamicObject resRegisterDO = (DynamicObject)model.getValue(RES_REGISTER_DEMAND);
                if (resRegisterDO != null) {
                    List<Object> filterList = this.getDemandModelPKIDList(resRegisterDO);
                    QFilter qFilter = new QFilter("id", "in", filterList);
                    listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90\u9700\u6c42\u6a21\u578b\u3002", (String)"ResourceReadyPlanEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "entryplanfieldtransfer": 
            case "entryexefieldtransfer": {
                DynamicObject planResbillDO = null;
                String resBillFieldName = ENTRY_PLAN_RESBILL;
                if (StringUtils.equals((CharSequence)ENTRY_EXE_FIELDTRANSFER, (CharSequence)fieldName)) {
                    resBillFieldName = ENTRY_EXE_RESBILL;
                }
                if (row > -1) {
                    planResbillDO = (DynamicObject)model.getValue(resBillFieldName, row);
                }
                if (planResbillDO != null) {
                    List<QFilter> filterList = this.getFTransferPKIDList(planResbillDO);
                    listShowParameter.getListFilterParameter().getQFilters().addAll(filterList);
                    break;
                }
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90\u5bf9\u8c61\u3002", (String)"ResourceReadyPlanEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "entryplanreadyrule": 
            case "entryexereadyrule": {
                DynamicObject fieldTransferDO = null;
                String fieldTranFieldName = ENTRY_PLAN_FIELDTRANSFER;
                if (StringUtils.equals((CharSequence)ENTRY_EXE_READYRULE, (CharSequence)fieldName)) {
                    fieldTranFieldName = ENTRY_EXE_FIELDTRANSFER;
                }
                if (row > -1) {
                    fieldTransferDO = (DynamicObject)model.getValue(fieldTranFieldName, row);
                }
                if (fieldTransferDO != null) {
                    List<QFilter> filterList = this.getReadyRulePKIDList(fieldTransferDO);
                    listShowParameter.getListFilterParameter().getQFilters().addAll(filterList);
                    break;
                }
                view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d44\u6e90\u5c31\u7eea\u5339\u914d\u89c4\u5219\u3002", (String)"ResourceReadyPlanEditPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private List<QFilter> getReadyRulePKIDList(DynamicObject fieldTransferDO) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        if (fieldTransferDO == null) {
            return filterList;
        }
        DynamicObject srcBillDO = fieldTransferDO.getDynamicObject("srcbill");
        Object srcBillPK = null;
        if (srcBillDO != null) {
            srcBillPK = srcBillDO.getPkValue();
        }
        QFilter srcBillQFilter = new QFilter("billfieldtransfer.srcbill", "=", srcBillPK);
        filterList.add(srcBillQFilter);
        DynamicObject destBillDO = fieldTransferDO.getDynamicObject("destbill");
        Object destBillPK = null;
        if (srcBillDO != null) {
            destBillPK = destBillDO.getPkValue();
        }
        QFilter destBillQFilter = new QFilter("billfieldtransfer.destbill", "=", destBillPK);
        filterList.add(destBillQFilter);
        return filterList;
    }

    private List<QFilter> getFTransferPKIDList(DynamicObject planResbillDO) {
        Object resRSupplyPK;
        QFilter dataConfigFilter;
        DynamicObjectCollection dataConfigDOC;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        if (planResbillDO == null) {
            return filterList;
        }
        IDataModel model = this.getModel();
        Object planResbillPK = planResbillDO.getPkValue();
        QFilter resBillQFilter = new QFilter("srcbill.id", "=", planResbillPK);
        filterList.add(resBillQFilter);
        QFilter destBillEQFilter = new QFilter("destbill.id", "=", planResbillPK);
        QFilter destBillNOTEQFilter = new QFilter("destbill.id", "!=", planResbillPK);
        DynamicObject resRegisterSupplyDO = (DynamicObject)model.getValue(RES_REGISTER_SUPPLY);
        ArrayList<Object> billFieldList = new ArrayList<Object>(2);
        if (resRegisterSupplyDO != null && (dataConfigDOC = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"billfieldtransfer.id,billfieldtransfer.srcbill", (QFilter[])new QFilter[]{dataConfigFilter = new QFilter("cgnumber", "in", resRSupplyPK = resRegisterSupplyDO.getPkValue())})) != null && !dataConfigDOC.isEmpty()) {
            for (DynamicObject dataConfigDO : dataConfigDOC) {
                billFieldList.add(dataConfigDO.get("billfieldtransfer.srcbill"));
            }
        }
        QFilter supplyFieldTranFilter = new QFilter("destbill", "in", billFieldList);
        QFilter supplyMergeFilter = destBillNOTEQFilter.and(supplyFieldTranFilter);
        QFilter finalQfilter = destBillEQFilter.or(supplyMergeFilter);
        filterList.add(finalQfilter);
        return filterList;
    }

    private List<Object> getDemandModelPKIDList(DynamicObject resRegisterDO) {
        Object resRSupplyPK;
        QFilter dataConfigFilter;
        DynamicObjectCollection dataConfigDOC;
        ArrayList<Object> filterPKID = new ArrayList<Object>(2);
        Object pkValue = null;
        DynamicObject resourceRegister = null;
        if (resRegisterDO != null) {
            pkValue = resRegisterDO.getPkValue();
            resourceRegister = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"mrp_resourceregister_cf");
        }
        Object businessEntity = null;
        if (resourceRegister != null && (dataConfigDOC = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"billfieldtransfer.srcbill", (QFilter[])new QFilter[]{dataConfigFilter = new QFilter("cgnumber", "in", resRSupplyPK = resourceRegister.getPkValue())})) != null && !dataConfigDOC.isEmpty()) {
            for (DynamicObject dataConfigDO : dataConfigDOC) {
                filterPKID.add(dataConfigDO.get("billfieldtransfer.srcbill"));
            }
        }
        return filterPKID;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            this.propertyChangeds(changeData, propertyName);
        }
    }

    public void propertyChangeds(ChangeData changeData, String propertyName) {
        if (changeData == null) {
            return;
        }
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        switch (propertyName) {
            case "resregisterdemand": {
                if (newValue != null || oldValue == null) break;
                this.clearDetailInfo(rowIndex);
                break;
            }
            case "resregistersupply": {
                if (newValue != null || oldValue == null) break;
                this.clearDoubleRule(ENTRY_PLAN_RESBILL, rowIndex);
                this.clearDoubleRule(ENTRY_EXE_RESBILL, rowIndex);
                break;
            }
            case "entryplanresbill": {
                if (newValue != null || oldValue == null) break;
                this.clearDoubleRule(ENTRY_PLAN_RESBILL, rowIndex);
                break;
            }
            case "entryplanfieldtransfer": {
                if (newValue != null || oldValue == null) break;
                this.clearCheckRule(ENTRY_PLAN_FIELDTRANSFER, rowIndex);
                break;
            }
            case "entryexeresbill": {
                if (newValue != null || oldValue == null) break;
                this.clearDoubleRule(ENTRY_EXE_RESBILL, rowIndex);
                break;
            }
            case "entryexefieldtransfer": {
                if (newValue != null || oldValue == null) break;
                this.clearCheckRule(ENTRY_EXE_FIELDTRANSFER, rowIndex);
            }
        }
    }

    public void clearDoubleRule(String prop, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)prop, (CharSequence)ENTRY_PLAN_RESBILL)) {
            model.setValue(ENTRY_PLAN_FIELDTRANSFER, null, rowIndex);
            this.clearCheckRule(ENTRY_PLAN_FIELDTRANSFER, rowIndex);
        } else if (StringUtils.equals((CharSequence)prop, (CharSequence)ENTRY_EXE_RESBILL)) {
            model.setValue(ENTRY_EXE_FIELDTRANSFER, null, rowIndex);
            this.clearCheckRule(ENTRY_EXE_FIELDTRANSFER, rowIndex);
        }
    }

    public void clearCheckRule(String prop, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)prop, (CharSequence)ENTRY_PLAN_FIELDTRANSFER)) {
            model.setValue(ENTRY_PLAN_READYRULE, null, rowIndex);
        } else if (StringUtils.equals((CharSequence)prop, (CharSequence)ENTRY_EXE_FIELDTRANSFER)) {
            model.setValue(ENTRY_EXE_READYRULE, null, rowIndex);
        }
    }

    private void clearDetailInfo(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(ENTRY_PLAN_RESBILL, null, rowIndex);
        this.clearDoubleRule(ENTRY_PLAN_RESBILL, rowIndex);
        model.setValue(ENTRY_EXE_RESBILL, null, rowIndex);
        this.clearDoubleRule(ENTRY_EXE_RESBILL, rowIndex);
    }
}

