/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.formplugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgListPlugin
extends AbstractListPlugin {
    private static final String ID_SUFFIX = ".id";
    private static final String NAME_SUFFIX = ".name";
    private static final String NUMBER_SUFFIX = ".number";
    private static final String CACHEKEY_ORG = "bill_ctrlorgids";
    private static final String CACHEKEY_ORG_CAPTION = "org_caption";

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String mainOrg = this.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            return;
        }
        String fieldName = args.getFieldName();
        if ((mainOrg + NAME_SUFFIX).equals(fieldName) || (mainOrg + NUMBER_SUFFIX).equals(fieldName) || (mainOrg + ID_SUFFIX).equals(fieldName)) {
            args.addCustomQFilter(new QFilter("id", "in", this.getCtrlUnitOrgIds()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String mainOrg = this.getMainOrg();
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            return;
        }
        String mainOrgId = mainOrg + ID_SUFFIX;
        String mainOrgName = mainOrg + NAME_SUFFIX;
        String mainOrgNumber = mainOrg + NUMBER_SUFFIX;
        args.getCommonFilterColumns().stream().filter(filterColumn -> {
            String fieldName = filterColumn.getFieldName();
            return mainOrgNumber.equals(fieldName) || mainOrgName.equals(fieldName) || mainOrgId.equals(fieldName);
        }).findFirst().ifPresent(filterColumn -> {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setMulti(false);
            commonFilterColumn.setMustInput(true);
            List comboItems = commonFilterColumn.getComboItems();
            if (comboItems.isEmpty()) {
                this.getPageCache().put(CACHEKEY_ORG_CAPTION, commonFilterColumn.getCaption().getLocaleValue());
            }
        });
        List schemeFilterColumns = args.getSchemeFilterColumns();
        schemeFilterColumns.removeIf(schemeFilterColumn -> schemeFilterColumn.getFieldName().equals(mainOrgName) || schemeFilterColumn.getFieldName().equals(mainOrgNumber));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)(this.getMainOrg() + ID_SUFFIX))) {
            args.addCustomQFilter(new QFilter("id", "in", this.getCtrlUnitOrgIds()));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String caption;
        super.beforeItemClick(evt);
        if ("tblnew".equals(evt.getItemKey()) && (caption = this.getPageCache().get(CACHEKEY_ORG_CAPTION)) != null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u56e0\u4e3a\u7a7a\u503c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"OrgListPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), caption));
            evt.setCancel(true);
        }
    }

    private Set<Object> getCtrlUnitOrgIds() {
        String cacheJson = this.getPageCache().get(CACHEKEY_ORG);
        if (cacheJson != null) {
            return (Set)SerializationUtils.fromJsonString((String)cacheJson, Set.class);
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (structureMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Object> ids = new HashSet<Object>(structureMap.size());
        for (Map.Entry entry : structureMap.entrySet()) {
            ids.add(((DynamicObject)entry.getValue()).get("org_id"));
        }
        this.getPageCache().put(CACHEKEY_ORG, SerializationUtils.toJsonString(ids));
        return ids;
    }

    private String getMainOrg() {
        IListView listView = (IListView)this.getView();
        return ((BillEntityType)listView.getListModel().getDataEntityType()).getMainOrg();
    }
}

