/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.formplugin.base;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmbd.helper.ProjectCalendarHelper;

public class ProjectCalenderSaveDateInfoPlugin
extends AbstractListPlugin {
    public static final String BILLLISTTAP = "billlistap";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String CACHE_USERID = "userid";

    public void registerListener(EventObject e) {
        Toolbar advcontoolbarap;
        Button btn = (Button)this.getControl("savedateinfo");
        btn.addClickListener((ClickListener)this);
        Toolbar advcontoolbarap1 = (Toolbar)this.getControl("advcontoolbarap1");
        if (null != advcontoolbarap1) {
            advcontoolbarap1.addItemClickListener((ItemClickListener)this);
        }
        if (null != (advcontoolbarap = (Toolbar)this.getControl("advcontoolbarap"))) {
            advcontoolbarap.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        System.out.println();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String oprKey = evt.getItemKey();
        EntryGrid halfworktimeentry = (EntryGrid)this.getControl("halfworktimeentry");
        EntryGrid worktimeentry = (EntryGrid)this.getControl("worktimeentry");
        switch (oprKey) {
            case "newentryhalftime": {
                int newHalfRowKey = this.getModel().createNewEntryRow("halfworktimeentry");
                halfworktimeentry.selectRows(newHalfRowKey, true);
                break;
            }
            case "deleteentryhalftime": {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("halfworktimeentry");
                this.getModel().deleteEntryRow("halfworktimeentry", entryCurrentRowIndex);
                break;
            }
            case "newentry": {
                int newRowKey = this.getModel().createNewEntryRow("worktimeentry");
                worktimeentry.selectRows(newRowKey, true);
                break;
            }
            case "deleteentry": {
                int timeEntryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("worktimeentry");
                this.getModel().deleteEntryRow("worktimeentry", timeEntryCurrentRowIndex);
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String oprKey;
        super.beforeClick(evt);
        Control ctl = (Control)evt.getSource();
        switch (oprKey = ctl.getKey().toLowerCase()) {
            case "savedateinfo": {
                this.saveDateInfo(evt);
                break;
            }
        }
    }

    private void saveDateInfo(BeforeClickEvent evt) {
        String dateType;
        DynamicObjectCollection halfworktimeentrymodels;
        String billstatus;
        String caleID = this.getPageCache().get("cur_cale");
        long parseLong = StringUtils.isNotBlank((CharSequence)caleID) ? Long.parseLong(caleID) : 0L;
        DynamicObject caleObj = ProjectCalendarHelper.getCalendar((Long)parseLong);
        if (null != caleObj && !StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)(billstatus = caleObj.getString("status")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e5\u5386\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"ProjectCalenderSaveDateInfoPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Boolean restdate = dataEntity.getBoolean("restdate");
        Boolean holiday = dataEntity.getBoolean("holiday");
        Boolean halfworkdate = dataEntity.getBoolean("halfworkdate");
        Boolean workdate = dataEntity.getBoolean("workdate");
        DynamicObjectCollection worktimeentrymodels = dataEntity.getDynamicObjectCollection("worktimeentry");
        boolean validateTimes = this.validateTimes(worktimeentrymodels, halfworktimeentrymodels = dataEntity.getDynamicObjectCollection("halfworktimeentry"), dateType = this.getDateType(restdate, holiday, halfworkdate));
        if (!validateTimes) {
            evt.setCancel(true);
            return;
        }
        String calendarExprids = dataEntity.getString("calendarexprid");
        String[] split = calendarExprids.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (String calendarexprid : split) {
            if (null == calendarexprid || StringUtils.equals((CharSequence)"fcalendarexprid", (CharSequence)calendarexprid)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"ProjectCalenderSaveDateInfoPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            ids.add(Long.parseLong(calendarexprid));
        }
        QFilter filters = new QFilter("id", "in", ids);
        DynamicObject[] calendarExprs = BusinessDataServiceHelper.load((String)"pmbd_calendarexpr", (String)"worktimeentry,datetype,workdate,worktimeentry.workstarttime,worktimeentry.workfinshtime,worktimeentry.halfworkstarttime,worktimeentry.halfworkfinshtime", (QFilter[])new QFilter[]{filters});
        ArrayList<String> dateList = new ArrayList<String>(16);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        for (DynamicObject dynamicObject : calendarExprs) {
            DynamicObject addNew;
            Date date = dynamicObject.getDate("workdate");
            String dateStr = simpleDateFormat.format(date);
            dateList.add(dateStr);
            DynamicObjectCollection worktimeentrys = dynamicObject.getDynamicObjectCollection("worktimeentry");
            worktimeentrys.clear();
            if (halfworkdate.booleanValue()) {
                for (DynamicObject worktimeentrymodel : halfworktimeentrymodels) {
                    addNew = worktimeentrys.addNew();
                    addNew.set("halfworkstarttime", worktimeentrymodel.get("halfworkstarttime"));
                    addNew.set("halfworkfinshtime", worktimeentrymodel.get("halfworkfinshtime"));
                }
            } else if (workdate.booleanValue()) {
                for (DynamicObject worktimeentrymodel : worktimeentrymodels) {
                    addNew = worktimeentrys.addNew();
                    addNew.set("workstarttime", worktimeentrymodel.get("workstarttime"));
                    addNew.set("workfinshtime", worktimeentrymodel.get("workfinshtime"));
                }
            }
            dynamicObject.set("datetype", (Object)dateType);
            dynamicObject.set("worktimeentry", (Object)worktimeentrys);
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        workCalendar.setDateTypeCallBack(dateList, dateType);
        SaveServiceHelper.save((DynamicObject[])calendarExprs);
        this.getView().updateView("workcalendarap");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ProjectCalenderSaveDateInfoPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
    }

    private boolean validateTimes(DynamicObjectCollection worktimeentrymodels, DynamicObjectCollection halfworktimeentrymodels, String dateType) {
        String errHalfWorkTimeStr = ResManager.loadKDString((String)"\u5de5\u4f5c\u65f6\u95f4\u6bb5\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u534a\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"ProjectCalenderSaveDateInfoPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        String errWorkTimeStr = ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u6bb5\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5de5\u4f5c\u65e5\u5de5\u4f5c\u65f6\u95f4\u3002", (String)"ProjectCalenderSaveDateInfoPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        switch (dateType) {
            case "1": {
                boolean validateWorkTimes = this.validateWorkTimes(worktimeentrymodels, "entryentitytime", "workstarttime", "workfinshtime");
                if (validateWorkTimes) break;
                this.getView().showTipNotification(errWorkTimeStr);
                return false;
            }
            case "2": {
                boolean validateHalfWorkTimes = this.validateWorkTimes(halfworktimeentrymodels, "entryentity", "halfworkstarttime", "halfworkfinshtime");
                if (validateHalfWorkTimes) break;
                this.getView().showTipNotification(errHalfWorkTimeStr);
                return false;
            }
        }
        return true;
    }

    private boolean validateWorkTimes(DynamicObjectCollection worktimes, String entryEntityName, String startTimeName, String endTimeName) {
        for (int index = 0; index < worktimes.size(); ++index) {
            DynamicObject worktime = (DynamicObject)worktimes.get(index);
            Integer halfworkstarttime = worktime.getInt(startTimeName);
            Integer halfworkfinshtime = worktime.getInt(endTimeName);
            for (int indexTwo = index + 1; indexTwo < worktimes.size(); ++indexTwo) {
                boolean fourth;
                DynamicObject worktimeTwo = (DynamicObject)worktimes.get(indexTwo);
                Integer halfworkstarttimeTwo = worktimeTwo.getInt(startTimeName);
                Integer halfworkfinshtimeTwo = worktimeTwo.getInt(endTimeName);
                boolean first = halfworkstarttime.compareTo(halfworkstarttimeTwo) > 0 && halfworkstarttime.compareTo(halfworkfinshtimeTwo) < 0;
                boolean sencond = halfworkfinshtime.compareTo(halfworkstarttimeTwo) > 0 && halfworkfinshtime.compareTo(halfworkfinshtimeTwo) < 0;
                boolean third = halfworkfinshtimeTwo.compareTo(halfworkstarttime) > 0 && halfworkfinshtimeTwo.compareTo(halfworkfinshtime) < 0;
                boolean bl = fourth = halfworkstarttimeTwo.compareTo(halfworkstarttime) > 0 && halfworkstarttimeTwo.compareTo(halfworkfinshtime) < 0;
                if (!first && !sencond && !third && !fourth && halfworkstarttime.compareTo(halfworkstarttimeTwo) != 0 && halfworkstarttime.compareTo(halfworkfinshtimeTwo) != 0 && halfworkfinshtime.compareTo(halfworkstarttimeTwo) != 0 && halfworkfinshtime.compareTo(halfworkfinshtimeTwo) != 0) continue;
                return false;
            }
        }
        return true;
    }

    private String getDateType(Boolean restdate, Boolean holiday, Boolean halfworkdate) {
        String dateType = "1";
        if (restdate.booleanValue()) {
            dateType = "4";
        } else if (holiday.booleanValue()) {
            dateType = "3";
        } else if (halfworkdate.booleanValue()) {
            dateType = "2";
        }
        return dateType;
    }
}

