/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmbd.formplugin.base;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmbd.common.util.TimeUtils;
import kd.pmc.pmbd.helper.ProjectCalendarHelper;
import org.apache.log4j.Logger;

public class ProjectCalenderTreeListPlugin
extends AbstractListPlugin
implements IConfirmCallBack,
SelectRowsEventListener,
PagerClickListener {
    private static Logger logger = Logger.getLogger(ProjectCalenderTreeListPlugin.class);
    public static final String CUR_ORG = "cur_org";
    public static final String CUR_CALE = "cur_cale";
    public static final String BILLLISTTAP = "billlistap";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String CACHE_USERID = "userid";
    public static final String CACHE_ISCALELIST = "isCaleList";
    private static final String OPT_COVER_DEFCALE = "opt_cover_defcale";
    private static final String CACHE_TURNPAGER = "turnPage";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (e.getSource() instanceof BillList) {
            String turnPage = this.getPageCache().get(CACHE_TURNPAGER);
            BillList list = (BillList)this.getControl(BILLLISTTAP);
            ListSelectedRow selectDefRow = null;
            ListSelectedRowCollection selRows = list.getSelectedRows();
            if (selRows.size() <= 0) {
                selectDefRow = this.getDefListRow();
            }
            if (StringUtils.isNotBlank(selectDefRow) && selectDefRow != null) {
                list.selectRows(selectDefRow.getRowKey(), true);
                this.drawCale(String.valueOf(selectDefRow));
            } else if (selRows.size() > 0 && StringUtils.isNotBlank((CharSequence)turnPage) && Boolean.parseBoolean(turnPage)) {
                ListSelectedRow selRow = this.getLastSelectListRow();
                if (StringUtils.isNotBlank((Object)selRow)) {
                    this.drawCale(String.valueOf(selRow));
                } else {
                    this.setCaleVisible(Boolean.FALSE, "");
                }
            }
            this.setCaleVisible(Boolean.FALSE, "");
        }
    }

    public void initialize() {
        if (this.getCaleListCache().booleanValue()) {
            String[] ctls = new String[]{"nextyear", "preyear"};
            this.addClickListeners(ctls);
            WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
            workCalendar.addClickListener((ClickListener)this);
            workCalendar.setPassDayLocked(false);
            BillList list = (BillList)this.getControl(BILLLISTTAP);
            list.addListRowDoubleClickListener((ListRowClickListener)this);
            list.addPagerClickListener((PagerClickListener)this);
            list.addSelectRowsListener((SelectRowsEventListener)this);
            list.addClickListener((ClickListener)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put(CACHE_ISCALELIST, this.getCaleList().toString());
        if (!this.getCaleListCache().booleanValue()) {
            return;
        }
        String year = this.getPageCache().get("year");
        if (StringUtils.isBlank((CharSequence)year)) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
        Long userId = RequestContext.get().getCurrUserId();
        this.getPageCache().put(CACHE_USERID, userId.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String actionID = evt.getCallBackId();
        Boolean cfmRes = evt.getResult() == MessageBoxResult.Yes;
        switch (actionID) {
            case "setdefcale": {
                if (!cfmRes.booleanValue()) break;
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPT_COVER_DEFCALE, String.valueOf(cfmRes));
                this.getView().invokeOperation("setdefcale", operateOption);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        String oprKey;
        super.itemClick(evt);
        switch (oprKey = evt.getOperationKey()) {
            case "new_new": {
                this.showCaleForm(OperationStatus.ADDNEW, 0L, null);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String oprKey = ctl.getKey().toLowerCase();
        int year = Integer.parseInt(this.getPageCache().get("year"));
        switch (oprKey) {
            case "preyear": {
                this.loadCaleData(--year, Boolean.TRUE);
                break;
            }
            case "nextyear": {
                this.loadCaleData(++year, Boolean.TRUE);
                break;
            }
            case "workcalendarap": {
                this.markWorkCalendar();
                long currentTimeMillis = System.currentTimeMillis();
                this.getPageCache().put("time", String.valueOf(currentTimeMillis));
                break;
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String oprKey;
        super.beforeClick(evt);
        Control ctl = (Control)evt.getSource();
        switch (oprKey = ctl.getKey().toLowerCase()) {
            case "workcalendarap": {
                String time = this.getPageCache().get("time");
                if (!StringUtils.isNotBlank((CharSequence)time)) break;
                long frontTimeMillis = Long.parseLong(time);
                long currentTimeMillis = System.currentTimeMillis();
                long compare = currentTimeMillis - frontTimeMillis;
                if (compare > 200L) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u671f\u70b9\u51fb\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProjectCalenderTreeListPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String oprKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (oprKey = operate.getOperateKey()) {
            case "setdefcale": {
                this.setDefCale(args, operate);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String oprKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        switch (oprKey = operate.getOperateKey()) {
            case "delete": {
                this.DeleteCalendarexpr(afterDoOperationEventArgs, operate);
                break;
            }
        }
    }

    private void DeleteCalendarexpr(AfterDoOperationEventArgs args, FormOperate operate) {
        BillList list = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRowCollection selRows = list.getSelectedRows();
        Object[] pks = selRows.getPrimaryKeyValues();
        if (null != pks && pks.length > 0) {
            QFilter calendarexprFilter = new QFilter("pjcalendar", "in", (Object)pks);
            DeleteServiceHelper.delete((String)"pmbd_calendarexpr", (QFilter[])calendarexprFilter.toArray());
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        Boolean isSelect = Boolean.FALSE;
        BillList list = (BillList)evt.getSource();
        List newRows = evt.getNewRows();
        List oldNews = evt.getOldRows();
        int selectRows = newRows.size() - oldNews.size();
        if (StringUtils.isNotBlank((Object)list.getFocusRowPkId())) {
            isSelect = Boolean.TRUE;
        }
        String curCalId = "";
        if (!isSelect.booleanValue()) {
            this.setCaleVisible(Boolean.FALSE, curCalId);
            return;
        }
        int pageRow = list.getPageRow();
        ListSelectedRowCollection colls = list.getCurrentListAllRowCollection();
        if (selectRows == 1) {
            curCalId = String.valueOf(list.getFocusRowPkId());
        } else if (selectRows < 0) {
            Integer index = (Integer)newRows.get(newRows.size() - 1);
            int floorMod = Math.floorMod(index, pageRow);
            curCalId = String.valueOf(colls.get(floorMod));
        } else if (selectRows > 1) {
            curCalId = String.valueOf(colls.get(colls.size() - 1));
        }
        if (StringUtils.isBlank((CharSequence)curCalId) || StringUtils.equals((CharSequence)"0", (CharSequence)curCalId)) {
            return;
        }
        this.drawCale(curCalId);
    }

    private void aloneSelected() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"dateinfoap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"savedateinfo"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"advcontoolbarap1"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
    }

    private void mulitSelected() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"dateinfoap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"savedateinfo"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
    }

    private void drawCale(String curCalId) {
        String preCalId = this.getPageCache().get(CUR_CALE);
        if (!StringUtils.equalsIgnoreCase((CharSequence)preCalId, (CharSequence)curCalId) || StringUtils.isBlank((CharSequence)preCalId)) {
            DynamicObject calendarObj = ProjectCalendarHelper.getCalendar((Long)Long.valueOf(curCalId));
            Date expirstartdate = calendarObj.getDate("expirstartdate");
            Calendar cale = Calendar.getInstance();
            cale.setTime(expirstartdate);
            Integer year = cale.get(1);
            this.getPageCache().put(CUR_CALE, curCalId);
            this.loadCaleData(year, false);
            Label calendarno = (Label)this.getControl("calendarno");
            if (calendarno != null) {
                calendarno.setText(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a%s\u3002", (String)"ProjectCalenderTreeListPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), calendarObj.getString("number")));
                Label calendarname = (Label)this.getControl("calendarname");
                calendarname.setText(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u540d\u79f0\uff1a%s\u3002", (String)"ProjectCalenderTreeListPlugin_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), calendarObj.getString("name")));
                this.setNotInValidate();
                Label datelabel = (Label)this.getControl("datelabel");
                datelabel.setText(ResManager.loadKDString((String)"\u65e5\u671f", (String)"ProjectCalenderTreeListPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setCaleVisible(Boolean isvisible, String caleid) {
        this.getView().setVisible(isvisible, new String[]{"flexcaletoolbar"});
        this.getView().setVisible(isvisible, new String[]{"workcalendarap"});
        this.getView().setVisible(isvisible, new String[]{"dateinfoap"});
        this.getPageCache().put(CUR_CALE, caleid);
    }

    private Boolean getCaleList() {
        FormShowParameter form = this.getView().getFormShowParameter();
        Boolean isCaleList = "pmbd_calendar_list".equals(form.getFormId());
        return isCaleList;
    }

    private Boolean getCaleListCache() {
        String isCaleListStr = this.getPageCache().get(CACHE_ISCALELIST);
        Boolean isCaleList = StringUtils.isNotBlank((CharSequence)isCaleListStr) && Boolean.parseBoolean(isCaleListStr);
        return isCaleList;
    }

    private void showCaleForm(OperationStatus status, Long pkId, Map<String, String> mapCustParas) {
        Long userId = Long.parseLong(this.getPageCache().get(CACHE_USERID));
        String errMsg = "";
        if (mapCustParas == null) {
            mapCustParas = new HashMap<String, String>();
        }
        if (status.equals((Object)OperationStatus.ADDNEW) && !PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"pmbd_calendar", (String)"47156aff000000ac")) {
            errMsg = ResManager.loadKDString((String)"\u65e0\u9879\u76ee\u65e5\u5386\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectCalenderTreeListPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        } else if (status.equals((Object)OperationStatus.EDIT) && !PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"pmbd_calendar", (String)"4715a0df000000ac")) {
            errMsg = ResManager.loadKDString((String)"\u65e0\u9879\u76ee\u65e5\u5386\u7f16\u8f91\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectCalenderTreeListPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        if (errMsg.length() > 0) {
            this.getView().showTipNotification(errMsg);
            return;
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("formId", "pmbd_calendar");
        if (pkId > 0L) {
            para.put("pkId", pkId);
        }
        para.put("status", status);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setFormId("pmbd_calendar");
        showParameter.setStatus(OperationStatus.ADDNEW);
        for (Map.Entry<String, String> custPara : mapCustParas.entrySet()) {
            showParameter.setCustomParam(custPara.getKey(), (Object)custPara.getValue());
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "refresh");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        super.billClosedCallBack(e);
        String actionID = e.getCloseCallBack().getActionId();
        Object pkID = e.getPkId();
        if (StringUtils.isBlank((Object)pkID) || Long.parseLong(pkID.toString()) == 0L) {
            return;
        }
        switch (actionID) {
            case "refresh": {
                if (!StringUtils.isNotBlank((Object)pkID)) break;
                this.getView().invokeOperation("refresh");
                break;
            }
            case "listoperation": {
                this.getPageCache().put(CUR_CALE, "");
                this.drawCale(String.valueOf(pkID));
                break;
            }
        }
    }

    private void loadCaleData(int year, Boolean validFlag) {
        String errMsg = "";
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put("pjcalendar", this.getPageCache().get(CUR_CALE));
        orgMap.put("year", String.valueOf(year));
        if (validFlag.booleanValue()) {
            errMsg = this.validCale(orgMap);
        }
        if (errMsg.length() > 0) {
            this.getView().showTipNotification(errMsg);
            return;
        }
        if (StringUtils.isBlank((CharSequence)errMsg)) {
            this.loadCalendar(orgMap);
        }
    }

    private void loadCalendar(Map<String, String> orgMap) {
        DynamicObject orgObj;
        String tempObj = orgMap.get("pjcalendar");
        Long pjID = 0L;
        String orgId = "";
        DynamicObject caleObj = null;
        if (StringUtils.isNotBlank((Object)tempObj)) {
            pjID = Long.parseLong(tempObj.toString());
        }
        if (pjID > 0L && Objects.nonNull(orgObj = (caleObj = BusinessDataServiceHelper.loadSingle((Object)pjID, (String)"pmbd_calendar")).getDynamicObject("createorg"))) {
            orgId = String.valueOf(orgObj.get("id"));
        }
        String yearObj = orgMap.get("year");
        int year = 0;
        if (StringUtils.isNotBlank((Object)yearObj)) {
            year = Integer.parseInt(yearObj.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            orgMap.put("org", orgId);
        }
        List workDataList = ProjectCalendarHelper.loadWorkCalendar(orgMap, (int)year);
        this.setCaleDataList(pjID, year, workDataList);
    }

    private void setCaleDataList(Long pjId, int year, List<Map<String, String>> workDataList) {
        if (workDataList == null || workDataList.size() == 0) {
            return;
        }
        Map<String, String> workdataFirst = workDataList.get(0);
        Map<String, String> workdataLast = workDataList.get(workDataList.size() - 1);
        this.getPageCache().put("id", pjId.toString());
        this.getPageCache().put("startvaliddate", workdataFirst.get("workDate"));
        this.getPageCache().put("endvaliddate", workdataLast.get("workDate"));
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        if (workCalendar != null) {
            workCalendar.setYear(year);
            workCalendar.setWorkDataList(workDataList);
            workCalendar.setData();
            this.setCaleVisible(workDataList.size() > 0, pjId.toString());
            this.setCurYear(year);
        }
    }

    private void setCurYear(int year) {
        this.getPageCache().put("year", String.valueOf(year));
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void markWorkCalendar() {
        BillList list;
        ListSelectedRow selectRow;
        Long userId = Long.parseLong(this.getPageCache().get(CACHE_USERID));
        if (!PermissionServiceHelper.hasSpecificPerm((long)userId, (String)"pmbd_calendar", (String)"4715a0df000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u9879\u76ee\u65e5\u5386\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectCalenderTreeListPlugin_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        }
        if (null == (selectRow = (list = (BillList)this.getControl(BILLLISTTAP)).getCurrentSelectedRowInfo()) || null != selectRow && StringUtils.isBlank((Object)selectRow.getPrimaryKeyValue())) {
            return;
        }
        Long caleID = (Long)selectRow.getPrimaryKeyValue();
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        ArrayList dateList = workCalendar.getDateList();
        if (dateList == null || dateList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u65e5\u671f\u3002", (String)"ProjectCalenderTreeListPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        String startDateStr = (String)dateList.get(0);
        String endDateStr = (String)dateList.get(dateList.size() - 1);
        Label datelabel = (Label)this.getControl("datelabel");
        if (dateList.size() == 1) {
            datelabel.setText(startDateStr);
        } else if (dateList.size() > 1) {
            datelabel.setText(startDateStr + "-" + endDateStr);
        }
        this.aloneSelected();
        Date startDate = TimeUtils.getDate((String)startDateStr, (String)DATE_FORMAT);
        Date endDate = TimeUtils.getDate((String)endDateStr, (String)DATE_FORMAT);
        String startvaliddateStr = this.getPageCache().get("startvaliddate");
        String endvaliddateStr = this.getPageCache().get("endvaliddate");
        Date startvaliddate = TimeUtils.getDate((String)startvaliddateStr, (String)DATE_FORMAT);
        Date endvaliddate = TimeUtils.getDate((String)endvaliddateStr, (String)DATE_FORMAT);
        if (startDate.compareTo(startvaliddate) < 0 || startDate.compareTo(endvaliddate) > 0) {
            this.setNotInValidate();
            return;
        }
        if (dateList.size() > 1 && endDate.compareTo(endvaliddate) > 0) {
            this.setNewDateList(workCalendar, caleID, dateList, startDate, endvaliddate);
        } else {
            this.showDateInfo(caleID, dateList, workCalendar);
        }
    }

    private void setNewDateList(WorkCalendar workCalendar, Long caleID, List<String> dateList, Date startDate, Date endvaliddate) {
        List<String> realDateList = new ArrayList<String>(Arrays.asList(new String[dateList.size()]));
        Collections.copy(realDateList, dateList);
        long time = endvaliddate.getTime() - startDate.getTime();
        long floorDiv = Math.floorDiv(time, 86400000L);
        if (floorDiv <= Integer.MAX_VALUE) {
            int last = (int)Math.floorDiv(time, 86400000L);
            realDateList = realDateList.subList(0, last + 1);
            this.showDateInfo(caleID, realDateList, workCalendar);
        }
    }

    private void setNotInValidate() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"dateinfoap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"savedateinfo"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        this.getModel().deleteEntryData("halfworktimeentry");
        this.getModel().deleteEntryData("worktimeentry");
        this.getModel().setValue("workdate", (Object)Boolean.FALSE);
        this.getModel().setValue("halfworkdate", (Object)Boolean.FALSE);
        this.getModel().setValue("holiday", (Object)Boolean.FALSE);
        this.getModel().setValue("restdate", (Object)Boolean.FALSE);
    }

    private void showDateInfo(Long caleID, List<String> dateList, WorkCalendar workCalendar) {
        StringBuilder calendarExprids = new StringBuilder();
        DynamicObject[] query = this.getCanlendarExpr(caleID, dateList);
        DynamicObjectCollection worktimeentry = (DynamicObjectCollection)this.getModel().getValue("worktimeentry");
        DynamicObjectCollection halfworktimeentry = (DynamicObjectCollection)this.getModel().getValue("halfworktimeentry");
        if (query.length >= 1) {
            DynamicObject dynamicObject = query[0];
            String dateType = dynamicObject.getString("datetype");
            this.getModel().deleteEntryData("halfworktimeentry");
            this.getModel().deleteEntryData("worktimeentry");
            DynamicObjectCollection worktimes = dynamicObject.getDynamicObjectCollection("worktimeentry");
            switch (dateType) {
                case "1": {
                    this.getModel().setValue("workdate", (Object)Boolean.TRUE);
                    this.addNewWorkDate(worktimeentry.getDynamicObjectType(), worktimes, "worktimeentry", "workstarttime", "workfinshtime");
                    break;
                }
                case "2": {
                    this.getModel().setValue("halfworkdate", (Object)Boolean.TRUE);
                    this.addNewWorkDate(halfworktimeentry.getDynamicObjectType(), worktimes, "halfworktimeentry", "halfworkstarttime", "halfworkfinshtime");
                    break;
                }
                case "3": {
                    this.getModel().setValue("holiday", (Object)Boolean.TRUE);
                    break;
                }
                case "4": {
                    this.getModel().setValue("restdate", (Object)Boolean.TRUE);
                }
            }
            Object pkValue = dynamicObject.getPkValue();
            calendarExprids.append(pkValue);
            calendarExprids.append(',');
        }
        this.getModel().setValue("calendarexprid", (Object)calendarExprids.toString());
        DynamicObject caleObj = ProjectCalendarHelper.getCalendar((Long)caleID);
        String billstatus = caleObj.getString("status");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)billstatus)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"dateinfoap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"savedateinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
        }
    }

    private DynamicObject[] getCanlendarExpr(Long caleID, List<String> dateList) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        ArrayList<Timestamp> timestamps = new ArrayList<Timestamp>();
        ArrayList<ParseException> errorException = new ArrayList<ParseException>(1);
        for (String string : dateList) {
            try {
                Date parse = dateFormat.parse(string);
                Timestamp timestamp = new Timestamp(parse.getTime());
                timestamps.add(timestamp);
            }
            catch (ParseException e) {
                errorException.add(e);
            }
        }
        if (!errorException.isEmpty()) {
            logger.warn((Object)("ProjectCalenderTreeListPlugin.getCanlendarExpr is date error,size:" + errorException.size() + "\u3002"), (Throwable)errorException.get(0));
        }
        QFilter workdateFilter = new QFilter("workdate", "in", timestamps);
        QFilter calendarexprFilter = new QFilter("pjcalendar", "=", (Object)caleID);
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"pmbd_calendarexpr", (String)"datetype,worktimeentry,worktimeentry.halfworkstarttime,worktimeentry.halfworkfinshtime,worktimeentry.workfinshtime,worktimeentry.workstarttime", (QFilter[])new QFilter[]{calendarexprFilter, workdateFilter});
        return query;
    }

    private void addNewWorkDate(DynamicObjectType dynamicObjectType, DynamicObjectCollection worktimes, String timeEntry, String startTime, String finshTime) {
        for (int index = worktimes.size() - 1; index >= 0; --index) {
            DynamicObject worktime = (DynamicObject)worktimes.get(index);
            DynamicObject addNew = new DynamicObject(dynamicObjectType);
            this.getModel().createNewEntryRow(timeEntry, addNew);
            addNew.set(startTime, (Object)worktime.getInt(startTime));
            addNew.set(finshTime, (Object)worktime.getInt(finshTime));
            this.getView().updateView("dateinfoap");
        }
    }

    private String validCale(Map<String, String> paras) {
        String errMsg = "";
        BillList list = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRow selRow = list.getCurrentSelectedRowInfo();
        String curYear = "";
        if (StringUtils.isNotBlank((CharSequence)paras.get("year"))) {
            curYear = paras.get("year");
        }
        if (StringUtils.isBlank((Object)selRow)) {
            errMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u65e5\u5386\u3002", (String)"ProjectCalenderTreeListPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        } else if (!ProjectCalendarHelper.isCalendarAtYear((Long)((Long)selRow.getPrimaryKeyValue()), (Long)Long.valueOf(curYear)).booleanValue()) {
            errMsg = String.format(ResManager.loadKDString((String)"%s\u5e74\u9879\u76ee\u65e5\u5386\u672a\u8bbe\u7f6e\u3002", (String)"ProjectCalenderTreeListPlugin_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), curYear);
        }
        return errMsg;
    }

    public void pagerClick(PagerClickEvent evt) {
        int pageRows = evt.getPageRows();
        this.getPageCache().put(CACHE_TURNPAGER, "true");
        System.out.println();
    }

    private ListSelectedRow getLastSelectListRow() {
        BillList list = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRowCollection colls = list.getCurrentListAllRowCollection();
        ListSelectedRow lastSelRow = null;
        ListSelectedRowCollection selRows = list.getSelectedRows();
        int rowKeyPre = -1;
        for (int i = selRows.size() - 1; i >= 0; --i) {
            ListSelectedRow selRow = selRows.get(i);
            int rowKey = selRow.getRowKey();
            if (rowKey <= rowKeyPre || !colls.contains((Object)selRow)) continue;
            lastSelRow = selRow;
            rowKeyPre = rowKey;
            break;
        }
        return lastSelRow;
    }

    private ListSelectedRow getDefListRow() {
        BillList list = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRowCollection colls = list.getCurrentListAllRowCollection();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow coll : colls) {
            String cid = String.valueOf(coll);
            ids.add(Long.valueOf(cid));
        }
        ListSelectedRow selectRow = null;
        if (colls.size() > 0) {
            QFilter qfilter = new QFilter("isfault", "=", (Object)Boolean.TRUE);
            qfilter.and("id", "in", ids);
            DynamicObject dyncCale = QueryServiceHelper.queryOne((String)"pmbd_calendar", (String)"id", (QFilter[])qfilter.toArray());
            if (StringUtils.isBlank((Object)dyncCale)) {
                selectRow = colls.get(0);
            } else {
                String id = dyncCale.getString("id");
                for (int i = 0; i < colls.size(); ++i) {
                    ListSelectedRow coll = colls.get(i);
                    String cid = String.valueOf(coll);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)cid, (CharSequence)id)) continue;
                    selectRow = colls.get(i);
                    break;
                }
            }
        }
        return selectRow;
    }

    private void setDefCale(BeforeDoOperationEventArgs args, FormOperate operate) {
        BillList list = (BillList)this.getControl(BILLLISTTAP);
        ListSelectedRow selRow = list.getCurrentSelectedRowInfo();
        ListSelectedRowCollection selRows = list.getSelectedRows();
        String errStr = "";
        if (StringUtils.isBlank((Object)selRow)) {
            errStr = ResManager.loadKDString((String)"\u5f53\u524d\u672a\u9009\u4e2d\u9879\u76ee\u65e5\u5386\u4fe1\u606f", (String)"ProjectCalenderTreeListPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        } else if (selRows.size() > 1) {
            errStr = ResManager.loadKDString((String)"\u8bbe\u7f6e\u9879\u76ee\u65e5\u5386\u65f6\uff0c\u53ea\u80fd\u9009\u4e2d\u4e00\u884c\u6570\u636e\u3002", (String)"ProjectCalenderTreeListPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        if (errStr.length() > 0) {
            this.getView().showTipNotification(errStr);
            args.setCancel(true);
            return;
        }
        DynamicObject caleObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(String.valueOf(selRow)), (String)"pmbd_calendar");
        boolean defset = caleObj.getBoolean("isfault");
        if (defset) {
            errStr = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u65e5\u5386:%s\u5df2\u662f\u9ed8\u8ba4\u65e5\u5386,\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ProjectCalenderTreeListPlugin_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), caleObj.getString("number"));
            this.getView().showTipNotification(errStr);
            args.setCancel(true);
            return;
        }
        DynamicObject userorg = caleObj.getDynamicObject("createorg");
        if (ProjectCalendarHelper.existDefaultCalendar((Long)((Long)userorg.getPkValue()), (Long)((Long)caleObj.getPkValue())).booleanValue()) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPT_COVER_DEFCALE, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("setdefcale", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u9879\u76ee\u65e5\u5386\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"ProjectCalenderTreeListPlugin_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        } else {
            caleObj.set("isfault", (Object)Boolean.TRUE);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{caleObj});
            this.getView().invokeOperation("refresh");
        }
    }
}

