/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class SyncLogPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected static final String TOOLBARAP = "toolbarap";
    protected static final String BTN_RETRY = "btn_retry";
    protected static final String BILLLIST = "billlistap";
    protected static final String BTN_REFRESH = "btn_refresh";

    public void afterCreateNewData(EventObject e) {
        this.refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl(TOOLBARAP);
        toolbar.addItemClickListener((ItemClickListener)this);
        BillList billList = this.getBillList();
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)BTN_RETRY, (CharSequence)itemKey)) {
            this.retryEvent();
        } else if (StringUtils.equals((CharSequence)BTN_REFRESH, (CharSequence)itemKey)) {
            this.refresh();
        }
    }

    private void refresh() {
        String businesskey = (String)this.getView().getFormShowParameter().getCustomParam("businesskey");
        QFilter qFilter = new QFilter("businesskey", "=", (Object)businesskey);
        BillList billList = this.getBillList();
        billList.setFilterParameter(new FilterParameter(qFilter, null));
        billList.refresh();
    }

    private void retryEvent() {
        ListSelectedRowCollection rows = this.getSelectRows();
        StringBuilder errorMSG = new StringBuilder();
        StringBuilder deadLetterJobIds = new StringBuilder();
        if (rows != null && !rows.isEmpty()) {
            try {
                Object[] jobIds = rows.getPrimaryKeyValues();
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                for (Object jobId : jobIds) {
                    deadLetterJobIds.append(jobId).append(',');
                    try {
                        wfService.getManagementService().revokDeadLetterEventJob(Long.valueOf(Long.parseLong(jobId.toString())));
                    }
                    catch (Exception e1) {
                        errorMSG.append(String.format(ResManager.loadKDString((String)"\u4efb\u52a1Id\u4e3a\uff1a%1$s\u91cd\u8bd5\u5931\u8d25\uff0c%2$s \n", (String)"SyncLogPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), jobId, e1.getMessage()));
                    }
                }
            }
            catch (Exception e) {
                errorMSG.append(String.format(ResManager.loadKDString((String)"\u5f15\u64ce\u5f02\u5e38\uff1a%s", (String)"SyncLogPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (errorMSG.length() > 0) {
                this.getView().showErrorNotification(errorMSG.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f", (String)"SyncLogPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            WfUtils.addLog((String)"wf_deadletterjob", (String)ResManager.loadKDString((String)"\u6fc0\u6d3b", (String)"SyncLogPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5c06\u5f02\u5e38Id[%s]\u6fc0\u6d3b", (String)"SyncLogPlugin_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), deadLetterJobIds.substring(0, deadLetterJobIds.length() - 1)));
            BillList billList = this.getBillList();
            billList.refresh();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SyncLogPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        }
    }

    private BillList getBillList() {
        return (BillList)this.getControl(BILLLIST);
    }

    private ListSelectedRowCollection getSelectRows() {
        BillList billList = this.getBillList();
        return billList.getSelectedRows();
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        BillList billList = this.getBillList();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f", (String)"SyncLogPlugin_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        parameter.setFormId("evt_deadletterjob");
        parameter.setPkId(billList.getFocusRowPkId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

