/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.report.ReportShowParameter;
import kd.pmc.pmpd.common.util.ProjectMonitorUtils;
import kd.pmc.pmpd.formplugin.base.ProjectCardPlugin;

public class DynamicBoardPlugin
extends ProjectCardPlugin {
    public static final String PAGEIDS = "pageIds";

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)"inittab", (CharSequence)operateKey)) {
            String param = this.getView().getPageCache().get("param");
            FormShowParameter formShowParameter = FormShowParameter.fromJsonString((String)param);
            String publish = (String)formShowParameter.getCustomParam("publish");
            String entity = (String)formShowParameter.getCustomParam("entity");
            if (formShowParameter instanceof ListShowParameter) {
                formShowParameter.addCustPlugin("kd.pmc.pmpd.formplugin.base.HideToolBarPlugin");
                if (StringUtils.isEmpty((CharSequence)entity)) {
                    entity = ((ListShowParameter)formShowParameter).getBillFormId();
                }
                ((ListShowParameter)formShowParameter).getListFilterParameter().getQFilters().addAll(ProjectMonitorUtils.getQFilters((Object[])this.getProjectIds().toArray(), (String)"pmpd_project", (String)entity));
            } else if (formShowParameter instanceof ReportShowParameter) {
                List qFilters;
                ReportQueryParam reportQueryParam = ((ReportShowParameter)formShowParameter).getReportQueryParam();
                if (reportQueryParam == null) {
                    reportQueryParam = new ReportQueryParam();
                }
                if (!(qFilters = ProjectMonitorUtils.getQFilters((Object[])this.getProjectIds().toArray(), (String)"pmpd_project", (String)formShowParameter.getFormId())).isEmpty()) {
                    reportQueryParam.getFilter().getQFilters().addAll(qFilters);
                }
            }
            if (StringUtils.equals((CharSequence)"0", (CharSequence)publish)) {
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setAppId("pmts");
                this.getView().showForm(formShowParameter);
            } else {
                String refresh = (String)formShowParameter.getCustomParam("refresh");
                String pageId = formShowParameter.getPageId();
                String pageName = formShowParameter.getCaption();
                Map<String, String> pageIds = this.getPageIds();
                if (pageIds.containsKey(pageId)) {
                    if (StringUtils.isNotEmpty((CharSequence)refresh)) {
                        this.removePageId(pageId);
                        formShowParameter.setPageId(pageId + System.currentTimeMillis());
                        this.handleTab(pageId, pageName);
                        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                        formShowParameter.getOpenStyle().setTargetKey(pageId);
                        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, pageId));
                        this.getView().showForm(formShowParameter);
                    } else {
                        Tab tabap = (Tab)this.getControl("tabap");
                        tabap.activeTab(pageId);
                    }
                } else {
                    this.handleTab(pageId, pageName);
                    formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                    formShowParameter.getOpenStyle().setTargetKey(pageId);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, pageId));
                    this.getView().showForm(formShowParameter);
                }
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String name = e.getEventName();
        String key = e.getEventArgs();
        if ("closeTab".equals(name)) {
            this.closeTab(key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Map<String, String> pageIds = this.getPageIds();
        String pageId = e.getActionId();
        if (pageIds.containsKey(pageId)) {
            this.closeTab(pageId);
        }
    }

    protected void closeTab(String pageId) {
        TabAp tabap = new TabAp();
        tabap.setKey("tabap");
        tabap.setName(new LocaleString("tabap"));
        tabap.setGrow(0);
        this.removePageId(pageId);
        Map<String, String> pageIds = this.getPageIds();
        String lastTab = "";
        int index = pageIds.size();
        for (Map.Entry<String, String> entry : pageIds.entrySet()) {
            --index;
            TabPageAp page = new TabPageAp();
            page.setKey(entry.getKey());
            page.setName(new LocaleString(entry.getValue()));
            tabap.getItems().add(page);
            if (index != 0) continue;
            lastTab = entry.getKey();
        }
        if (pageIds.size() > 0) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.selectTab(lastTab);
        }
        Map features = tabap.createControl();
        this.getView().updateControlMetadata("tabap", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(16);
        closeMap.put("closable", true);
        for (Map.Entry<String, String> entry : pageIds.entrySet()) {
            this.getView().updateControlMetadata(entry.getKey(), closeMap);
        }
    }

    protected void handleTab(String pageId, String pageName) {
        TabAp tabap = new TabAp();
        tabap.setKey("tabap");
        tabap.setName(new LocaleString("tabap"));
        tabap.setGrow(0);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab(pageId);
        this.cachePageId(pageId, pageName);
        Map<String, String> pageIds = this.getPageIds();
        for (Map.Entry<String, String> entry : pageIds.entrySet()) {
            TabPageAp page = new TabPageAp();
            page.setKey(entry.getKey());
            page.setName(new LocaleString(entry.getValue()));
            tabap.getItems().add(page);
        }
        Map features = tabap.createControl();
        this.getView().updateControlMetadata("tabap", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>(16);
        closeMap.put("closable", true);
        for (Map.Entry<String, String> entry : pageIds.entrySet()) {
            this.getView().updateControlMetadata(entry.getKey(), closeMap);
        }
    }

    protected void cachePageId(String pageId, String name) {
        Map<String, String> pageIds = this.getPageIds();
        pageIds.put(pageId, name);
        this.getPageCache().put(PAGEIDS, SerializationUtils.toJsonString(pageIds));
    }

    protected void removePageId(String pageId) {
        Map<String, String> pageIds = this.getPageIds();
        pageIds.remove(pageId);
        this.getPageCache().put(PAGEIDS, SerializationUtils.toJsonString(pageIds));
    }

    protected Map<String, String> getPageIds() {
        String pageIds = this.getPageCache().get(PAGEIDS);
        if (StringUtils.isNotEmpty((CharSequence)pageIds)) {
            return (Map)SerializationUtils.fromJsonString((String)pageIds, LinkedHashMap.class);
        }
        return new LinkedHashMap<String, String>();
    }
}

