/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EntitySelectPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btn_ok";
    private static final String ENTITY = "entity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_ok = (Button)this.getControl(BTN_OK);
        btn_ok.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initComboItems();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)key)) {
            this.showQueryDesignForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)actionId)) {
            this.getView().close();
        }
    }

    private void initComboItems() {
        ComboEdit entity = (ComboEdit)this.getControl(ENTITY);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String defaultValue = "";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fmm_quercard_setting", (String)"id,entryentity.labelkey,entryentity.entitykey,entryentity.showkey,entryentity.caption", (QFilter[])new QFilter("number", "=", (Object)"DEFAULT").toArray());
        for (DynamicObject obj : query) {
            String entityKey = obj.getString("entryentity.entitykey");
            String caption = obj.getString("entryentity.caption");
            ComboItem comboItem = new ComboItem();
            comboItem.setId(entityKey);
            comboItem.setValue(entityKey);
            comboItem.setCaption(new LocaleString(caption));
            items.add(comboItem);
            if (!StringUtils.isEmpty((CharSequence)defaultValue)) continue;
            defaultValue = entityKey;
        }
        entity.setComboItems(items);
        this.getModel().setValue(ENTITY, (Object)defaultValue);
    }

    private void showQueryDesignForm() {
        String entity = (String)this.getModel().getValue(ENTITY);
        if (StringUtils.isEmpty((CharSequence)entity)) {
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("fmm_querydesign");
        baseShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCustomParam(ENTITY, (Object)entity);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_OK));
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        qFilter = qFilter.and(new QFilter("number", "=", (Object)entity));
        DynamicObject queryDesign = QueryServiceHelper.queryOne((String)"fmm_querydesign", (String)"id", (QFilter[])qFilter.toArray());
        if (queryDesign != null) {
            baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
            baseShowParameter.setPkId(queryDesign.get("id"));
        }
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }
}

