/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ProjectCardPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        this.cachePageId();
    }

    protected void cachePageId() {
        IFormView view = this.getView();
        String parentFormId = view.getFormShowParameter().getParentPageId();
        if (parentFormId == null) {
            return;
        }
        IFormView parentView = view.getView(parentFormId);
        if (parentView == null) {
            return;
        }
        parentView.getPageCache().put(view.getEntityId(), view.getPageId());
    }

    protected void sendOperate(String param, String entityName, String operateName) {
        IFormView view = this.getView();
        String parentFormId = view.getFormShowParameter().getParentPageId();
        if (parentFormId == null) {
            return;
        }
        IFormView parentView = view.getView(parentFormId);
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        String pageId = pageCache.get(entityName);
        IFormView actionView = view.getView(pageId);
        if (actionView == null) {
            return;
        }
        IPageCache actionPageCache = actionView.getPageCache();
        actionPageCache.put("param", param);
        actionView.invokeOperation(operateName);
        view.sendFormAction(actionView);
    }

    protected List<Long> getProjectIds() {
        List<Long> projectIds = new ArrayList<Long>(8);
        String projectValue = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("projectid");
        if (projectValue != null) {
            String[] ids = projectValue.split(";");
            projectIds = Stream.of(ids).map(i -> Long.parseLong(i)).collect(Collectors.toList());
        }
        return projectIds;
    }
}

