/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class ProjectCardSettingPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cardformname", "btn_ok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("cardformname")) {
            this.showFormList();
        } else if (key.equals("btn_ok") && this.validateValue()) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("cardType", "bos_card_custom");
            returnMap.put("cardformname", (String)this.getModel().getValue("cardformname"));
            returnMap.put("cardformnum", (String)this.getModel().getValue("cardformnum"));
            returnMap.put("cardtitle", ((OrmLocaleValue)this.getModel().getValue("cardtitle")).entrySet().toString());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private boolean validateValue() {
        OrmLocaleValue cardTitle = (OrmLocaleValue)this.getModel().getValue("cardtitle");
        String cardFormName = (String)this.getModel().getValue("cardformname");
        if (cardTitle != null && !StringUtils.isEmpty((String)cardTitle.toString())) {
            if (StringUtils.isEmpty((String)cardFormName)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u8868\u5355\u4e0d\u80fd\u7a7a\u3002", (String)"ProjectCardSettingPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898\u4e0d\u80fd\u7a7a\u3002", (String)"ProjectCardSettingPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        return false;
    }

    private void showFormList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_formmeta", (boolean)false);
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", this.getProjectMonitorCards()));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cardformlist"));
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u76d1\u63a7\u5361\u7247", (String)"ProjectCardSettingPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cardformlist"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("cardformlist".equals(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            if (selectedRows.isEmpty()) {
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            this.getModel().setValue("cardformnum", (Object)selectedRow.getNumber());
            this.getModel().setValue("cardformname", (Object)selectedRow.getName());
        }
    }

    protected List<String> getProjectMonitorCards() {
        ArrayList<String> cardList = new ArrayList<String>(8);
        cardList.add("fmm_dynamicboard_card");
        cardList.add("fmm_projectlist_card");
        cardList.add("fmm_promonit_msgcard");
        cardList.add("fmm_promonit_rptlist");
        cardList.add("fmm_queryarea_card");
        return cardList;
    }
}

