/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterBindDataEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.formplugin.base.ProjectCardPlugin;

public class ProjectMonitorCardListPlugin
extends ProjectCardPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldsetting"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addAfterBindDataListener(this::afterBindDataListener);
        this.setProjectFilter();
    }

    protected void afterBindDataListener(AfterBindDataEvent afterBindDataEvent) {
        BillList billList = (BillList)this.getControl("billlistap");
        List list = billList.getListFieldsControlColumns();
        this.showAndHideCardField(list);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setProjectFilter();
    }

    protected void setProjectFilter() {
        IFormView formView = this.getView().getParentView();
        if (formView == null) {
            return;
        }
        String projectValue = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("projectid");
        if (projectValue != null) {
            BillList billlistap = (BillList)this.getView().getControl("billlistap");
            String[] ids = projectValue.split(";");
            List projectPks = Stream.of(ids).map(i -> Long.parseLong(i)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", projectPks);
            billlistap.getFilterParameter().setFilter(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showAndHideCardField(this.getListField());
    }

    protected void showAndHideCardField(List<Map<String, Object>> fields) {
        HashMap<String, Boolean> styleShow = new HashMap<String, Boolean>(2);
        styleShow.put("vi", Boolean.TRUE);
        HashMap<String, Boolean> styleHide = new HashMap<String, Boolean>(2);
        styleHide.put("vi", Boolean.FALSE);
        for (Map<String, Object> field : fields) {
            String fieldName = field.get("listFieldKey") + "c";
            fieldName = fieldName.replace(".", "");
            Integer visible = (Integer)field.get("visible");
            if (visible == 0) {
                this.getView().updateControlMetadata(fieldName, styleHide);
                continue;
            }
            this.getView().updateControlMetadata(fieldName, styleShow);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("fieldsetting".equals(key)) {
            this.showListFieldsControl();
        }
    }

    public void showListFieldsControl() {
        BillList billList = (BillList)this.getControl("billlistap");
        List<Map<String, Object>> fields = this.getListField();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fmm_listfieldscontrol");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey("billlistap");
        closeCallBack.setActionId("listFieldsControl");
        closeCallBack.setClassName(this.getPluginName());
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("entityId", (Object)billList.getEntityId());
        parameter.setCustomParam("listColumns", fields);
        parameter.setCustomParam("factorySetColumns", fields);
        parameter.setCustomParam("isLookup", (Object)Boolean.FALSE);
        parameter.setCustomParam("ListFieldsControlKey", (Object)"fmm_projectlist_card.pmpd_project.billlistap");
        parameter.setCustomParam("UserSummaryFieldsKey", (Object)"fmm_projectlist_card.pmpd_project.billlistap.userSummaryFields");
        parameter.setCustomParam("SummaryFieldId", (Object)billList.getSummaryFieldId());
        parameter.setCustomParam("isList", (Object)Boolean.FALSE);
        this.getView().showForm(parameter);
    }

    public List<Map<String, Object>> getListField() {
        BillList billList = (BillList)this.getControl("billlistap");
        Class<BillList> billListClass = BillList.class;
        List fields = null;
        try {
            Method method = billListClass.getDeclaredMethod("getBackListColumns", List.class);
            Method method1 = billListClass.getDeclaredMethod("fireListFieldsControlEvent", List.class);
            AccessibleObject[] colorAcce = new AccessibleObject[]{method, method1};
            AccessibleObject.setAccessible(colorAcce, true);
            ArrayList data = new ArrayList();
            method1.invoke((Object)billList, data);
            fields = (List)method.invoke((Object)billList, data);
        }
        catch (Exception e) {
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
        return fields;
    }
}

