/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.QuickLaunchConfigPlugin;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.formplugin.base.ProjectCardPlugin;

public class ProjectMonitorRptListPlugin
extends ProjectCardPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btladd", "btlpublish", "btlunpublish"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("menus");
        entryGrid.addHyperClickListener(this::hyperClick);
    }

    private void hyperClick(HyperLinkClickEvent event) {
        List qingMenus;
        int row = event.getRowIndex();
        DynamicObject menu = this.getModel().getEntryRowEntity("menus", row);
        String publish = menu.getString("publish");
        String appId = menu.getString("appid");
        String menuId = menu.getString("menuid");
        AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
        boolean isQingMenu = false;
        if (appMenuInfo == null && (qingMenus = new QuickLaunchConfigPlugin().getQingMenuArray(appId)) != null) {
            for (AppMenuInfo qingMenu : qingMenus) {
                if (!menuId.equals(qingMenu.getId())) continue;
                appMenuInfo = qingMenu;
                isQingMenu = true;
                if (!"0".equals(publish)) break;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("view", this.getView());
                map.put("formnumber", qingMenu.getFormId());
                map.put("parameter", qingMenu.getParams());
                map.put("menuname", qingMenu.getName().getLocaleValue());
                map.put("parametertype", null);
                map.put("openType", null);
                map.put("permItem", null);
                OpenPageUtils.openApp((String)qingMenu.getAppId(), (String)menuId, map, (IFormView)this.getView());
                return;
            }
        }
        if (appMenuInfo == null) {
            return;
        }
        String parameterStr = appMenuInfo.getParams();
        String paramType = appMenuInfo.getParamType();
        Map parameter = new HashMap(0);
        if (StringUtils.isNotBlank((CharSequence)parameterStr)) {
            parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr, Map.class);
        }
        HashMap<String, String> openParameter = new HashMap<String, String>(parameter);
        if (!isQingMenu && StringUtils.isNotBlank((CharSequence)paramType) && "ListShowParameter".equalsIgnoreCase(paramType)) {
            openParameter.put("type", "list");
            openParameter.put("billFormId", appMenuInfo.getFormId());
        } else {
            if (!isQingMenu) {
                openParameter.put("type", paramType);
            }
            openParameter.put("formId", appMenuInfo.getFormId());
        }
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        formShowParameter.setPageId(this.getView().getPageId() + appMenuInfo.getFormId());
        formShowParameter.setCaption(appMenuInfo.getName().getLocaleValue());
        formShowParameter.setCustomParam("publish", (Object)publish);
        this.sendOperate(FormShowParameter.toJsonString((FormShowParameter)formShowParameter), "fmm_dynamicboard_card", "inittab");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initListEntry();
    }

    private void initListEntry() {
        DynamicObjectCollection conf = this.querySysConf();
        if (conf == null || conf.isEmpty()) {
            conf = this.queryCurrentUserConf();
        }
        if (conf == null || conf.isEmpty()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"menuname", "appid", "menuid", "launchtype", "publish"});
        for (DynamicObject menu : conf) {
            List qingMenus;
            String appId = menu.getString("appid");
            String menuId = menu.getString("menuid");
            if (appId == null || menuId == null) continue;
            AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            if (appMenuInfo == null && (qingMenus = new QuickLaunchConfigPlugin().getQingMenuArray(appId)) != null) {
                for (AppMenuInfo qingMenu : qingMenus) {
                    if (!menuId.equals(qingMenu.getId())) continue;
                    appMenuInfo = qingMenu;
                    break;
                }
            }
            if (appMenuInfo == null) continue;
            String menuName = appMenuInfo.getName() == null ? "" : appMenuInfo.getName().getLocaleValue();
            tableValueSetter.addRow(new Object[]{menuName, appId, menuId, menu.get("launchtype"), menu.get("publish")});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("menus", tableValueSetter);
        model.endInit();
        this.getView().updateView("menus");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btlpublish".equals(key) && !this.hasSelectRow()) {
            evt.setCancel(true);
        } else if ("btlunpublish".equals(key) && !this.hasSelectRow()) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btladd".equals(key)) {
            this.showAddMenuForm();
        }
    }

    private void showAddMenuForm() {
        Map<String, String> menuMap = this.getSelectMenuMap();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fmm_selectmenus");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCustomParam("menuMap", (Object)SerializationUtils.toJsonString(menuMap));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addmenus"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("addmenus".equals(actionId)) {
            List retDatas = (List)event.getReturnData();
            if (retDatas == null) {
                return;
            }
            DynamicObjectCollection menus = this.getModel().getEntryEntity("menus");
            Set menuIds = menus.stream().map(i -> i.getString("menuid")).collect(Collectors.toSet());
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"menuname", "appid", "menuid", "launchtype"});
            for (Map menu : retDatas) {
                List qingMenus;
                String menuId = (String)menu.get("cache_sel_menuId");
                if (menuIds.contains(menuId)) continue;
                String launchType = (String)menu.get("launchType");
                String appId = (String)menu.get("cache_sel_appId");
                AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
                if (appMenuInfo == null) {
                    appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId.toUpperCase());
                }
                if (appMenuInfo == null && (qingMenus = new QuickLaunchConfigPlugin().getQingMenuArray(appId)) != null) {
                    for (AppMenuInfo qingMenu : qingMenus) {
                        if (!menuId.equals(qingMenu.getId())) continue;
                        appMenuInfo = qingMenu;
                        break;
                    }
                }
                if (appMenuInfo == null) continue;
                tableValueSetter.addRow(new Object[]{appMenuInfo.getName().getLocaleValue(), appId, menuId, launchType});
            }
            model.beginInit();
            model.batchCreateNewEntryRow("menus", tableValueSetter);
            model.endInit();
            this.getView().updateView("menus");
            this.saveAndUpdateMenusConf();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("deleteentry".equals(key)) {
            this.saveAndUpdateMenusConf();
        } else if ("publish".equals(key) && this.setPublishStatus("1")) {
            this.saveAndUpdateMenusConf();
        } else if ("unpublish".equals(key) && this.setPublishStatus("0")) {
            this.saveAndUpdateMenusConf();
        }
    }

    private boolean setPublishStatus(String publish) {
        int[] selects;
        EntryGrid entryGrid = (EntryGrid)this.getControl("menus");
        for (int select : selects = entryGrid.getSelectRows()) {
            this.getModel().setValue("publish", (Object)publish, select);
        }
        return true;
    }

    public boolean hasSelectRow() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("menus");
        int[] selects = entryGrid.getSelectRows();
        if (selects == null || selects.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProjectMonitorRptListPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void saveAndUpdateMenusConf() {
        DynamicObjectCollection menus = this.getModel().getEntryEntity("menus");
        DynamicObject menusConf = this.queryCurrentUserConfInfo();
        if (menusConf == null) {
            menusConf = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fmm_promonit_menuconf"));
            menusConf.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            menusConf.set("sysconf", (Object)Boolean.FALSE);
        }
        DynamicObjectCollection menusConfEntry = menusConf.getDynamicObjectCollection("menus");
        menusConfEntry.clear();
        for (DynamicObject menu : menus) {
            DynamicObject menuInfo = menusConfEntry.addNew();
            menuInfo.set("menuid", menu.get("menuid"));
            menuInfo.set("appid", menu.get("appid"));
            menuInfo.set("launchtype", menu.get("launchtype"));
            menuInfo.set("publish", menu.get("publish"));
            menuInfo.set("seq", menu.get("seq"));
        }
        SaveServiceHelper.saveOperate((String)"fmm_promonit_menuconf", (DynamicObject[])new DynamicObject[]{menusConf}, (OperateOption)OperateOption.create());
    }

    private Map<String, String> getSelectMenuMap() {
        DynamicObjectCollection menus = this.getModel().getEntryEntity("menus");
        return menus.stream().collect(Collectors.toMap(i -> i.getString("menuid"), i -> i.getString("appid")));
    }

    public DynamicObjectCollection queryCurrentUserConf() {
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return QueryServiceHelper.query((String)"fmm_promonit_menuconf", (String)"menus.appid appid,menus.menuid menuid,menus.launchtype launchtype,menus.publish publish", (QFilter[])qFilter.toArray(), (String)"menus.seq");
    }

    public DynamicObject queryCurrentUserConfInfo() {
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return BusinessDataServiceHelper.loadSingle((String)"fmm_promonit_menuconf", (String)"menus.seq,menus.appid,menus.menuid,menus.launchtype,menus.publish", (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection querySysConf() {
        QFilter qFilter = new QFilter("sysconf", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.query((String)"fmm_promonit_menuconf", (String)"menus.appid appid,menus.menuid menuid,menus.launchtype launchtype,menus.publish publish", (QFilter[])qFilter.toArray(), (String)"menus.seq");
    }
}

