/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.formplugin.base.ProjectCardPlugin;

public class QueryCardPlugin
extends ProjectCardPlugin {
    protected static final String ENTITYKEY = "entitykey";
    protected static final String SHOWKEY = "showkey";
    protected static final String CAPTION = "caption";
    protected Map<String, Map<String, String>> QUERYSETTING = new LinkedHashMap<String, Map<String, String>>(16);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void initialize() {
        super.initialize();
        if (this.QUERYSETTING.isEmpty()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fmm_quercard_setting", (String)"id,entryentity.labelkey,entryentity.entitykey,entryentity.showkey,entryentity.caption", (QFilter[])new QFilter("number", "=", (Object)"DEFAULT").toArray());
            for (DynamicObject obj : query) {
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put(ENTITYKEY, obj.getString("entryentity.entitykey"));
                map.put(SHOWKEY, obj.getString("entryentity.showkey"));
                map.put(CAPTION, obj.getString("entryentity.caption"));
                this.QUERYSETTING.put(obj.getString("entryentity.labelkey"), map);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String key : this.QUERYSETTING.keySet()) {
            Label label = (Label)this.getControl(key);
            if (label == null) continue;
            label.addClickListener((ClickListener)this);
        }
        Vector setting = (Vector)this.getControl("setting");
        setting.addClickListener((ClickListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (source instanceof Label) {
            String key = source.getKey();
            this.showFilterForm(key);
        }
        if ("setting".equals(source.getKey())) {
            this.showEntitySelectForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        if (this.QUERYSETTING.containsKey(actionId)) {
            this.showListForm(actionId, (String)e.getReturnData());
        }
    }

    protected void showFilterForm(String labelKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fmm_query_filter");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("entity", (Object)this.QUERYSETTING.get(labelKey).get(ENTITYKEY));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, labelKey));
        this.getView().showForm(formShowParameter);
    }

    protected void showListForm(String labelKey, String filterStr) {
        String showKey = this.QUERYSETTING.get(labelKey).get(SHOWKEY);
        String entityKey = this.QUERYSETTING.get(labelKey).get(ENTITYKEY);
        String caption = this.QUERYSETTING.get(labelKey).get(CAPTION);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityKey);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
        fb.buildFilter(false);
        ListShowParameter listForm = ShowFormHelper.createShowListForm((String)showKey, (boolean)false, (int)0, (boolean)false);
        listForm.getListFilterParameter().getQFilters().addAll(fb.getQFilters());
        listForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listForm.setAppId("pmts");
        listForm.setCaption(caption);
        listForm.addCustPlugin("kd.pmc.pmpd.formplugin.base.HideFilterContainerApPlugin");
        listForm.setCustomParam("refresh", (Object)"1");
        listForm.setCustomParam("entity", (Object)entityKey);
        if (this.isPublish(entityKey)) {
            listForm.setPageId("publish_" + showKey);
            listForm.setCustomParam("publish", (Object)"1");
        } else {
            listForm.addCustPlugin("kd.pmc.pmpd.formplugin.base.HideToolBarPlugin");
            listForm.setPageId("unpublish_" + showKey);
            listForm.setCustomParam("publish", (Object)"0");
        }
        this.sendOperate(FormShowParameter.toJsonString((FormShowParameter)listForm), "fmm_dynamicboard_card", "inittab");
    }

    protected boolean isPublish(String entityKey) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        qFilter = qFilter.and(new QFilter("ispublish", "=", (Object)Boolean.TRUE));
        qFilter = qFilter.and(new QFilter("number", "=", (Object)entityKey));
        return QueryServiceHelper.exists((String)"fmm_querydesign", (QFilter[])qFilter.toArray());
    }

    protected void showEntitySelectForm() {
        FormShowParameter baseShowParameter = new FormShowParameter();
        baseShowParameter.setFormId("fmm_entityselect");
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(baseShowParameter);
    }
}

