/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.query.QueryEntityParseHelper;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public class QueryDesignPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BIZENTITY = "bizentity";
    private static final String QUERYFIELD = "queryfield";
    private static final String FIELDFLAG = "fieldflag";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit queryField = (TextEdit)this.getControl(QUERYFIELD);
        queryField.addClickListener((ClickListener)this);
        BasedataEdit bizEntity = (BasedataEdit)this.getControl(BIZENTITY);
        bizEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        if (BillOperationStatus.ADDNEW == baseShowParameter.getBillStatus()) {
            this.getModel().setValue("number", (Object)entity);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)QUERYFIELD, (CharSequence)name) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || StringUtils.isEmpty((CharSequence)newValue.toString()))) {
            this.getModel().setValue(FIELDFLAG, null, e.getChangeSet()[0].getRowIndex());
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        MainEntityType entityType;
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)QUERYFIELD, (CharSequence)key) && (entityType = this.getEntityType()) != null) {
            QueryEntityTreeBuildParameter parameter = new QueryEntityTreeBuildParameter(entityType);
            TreeNode srcBillNode = QueryEntityParseHelper.buildBillTreeNodes((QueryEntityTreeBuildParameter)parameter, (boolean)false, null);
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            this.showBillFieldForm(nodesJson, QUERYFIELD);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String returnData = (String)event.getReturnData();
        String actionId = event.getActionId();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (StringUtils.equals((CharSequence)QUERYFIELD, (CharSequence)actionId) && StringUtils.isNotEmpty((CharSequence)returnData) && returnData.contains(".")) {
            MainEntityType entityType;
            MainEntityType type = entityType = this.getEntityType();
            if (entityType == null) {
                return;
            }
            Map allEntities = entityType.getAllEntities();
            String fieldFlag = returnData.substring(entityType.getName().length() + 1);
            IDataEntityProperty property = entityType.findProperty(fieldFlag);
            if (fieldFlag.contains(".")) {
                String entryKey = fieldFlag.split("[.]")[0];
                EntityType entryType = (EntityType)allEntities.get(entryKey);
                if (entryType != null) {
                    fieldFlag = fieldFlag.substring(entryType.getName().length() + 1);
                    property = entryType.findProperty(fieldFlag);
                    type = entryType;
                } else {
                    fieldFlag = entryKey;
                    property = entityType.findProperty(fieldFlag);
                }
            }
            if (property != null) {
                this.getModel().setValue(QUERYFIELD, (Object)(type.getDisplayName() + "." + property.getDisplayName()), rowIndex);
                this.getModel().setValue(FIELDFLAG, (Object)fieldFlag, rowIndex);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int rowCount;
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String name = entryProp.getName();
        if (StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)name) && (rowCount = this.getModel().getEntryRowCount(ENTRYENTITY)) > 0) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            this.getModel().setItemValueByNumber(BIZENTITY, entity, rowCount - 1);
        }
    }

    private MainEntityType getEntityType() {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObject entity = (DynamicObject)this.getModel().getValue(BIZENTITY, row);
        if (entity != null) {
            Object entityPkValue = entity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityPkValue.toString());
            return dataEntityType;
        }
        return null;
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mpdm_billfieldselect");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)BIZENTITY, (CharSequence)name)) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            QFilter qFilter = new QFilter("number", "=", (Object)entity);
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }
}

