/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryFieldMappingPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected static final String MONITORAREA = "monitorarea";
    protected static final String PARAMENTITY = "paramentity";
    protected static final String QUERYENTITY = "queryentity";
    protected static final String PARAMFIELD = "paramfield";
    protected static final String QUERYFIELD = "queryfield";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)PARAMENTITY, (CharSequence)name) || StringUtils.equals((CharSequence)QUERYENTITY, (CharSequence)name)) {
            this.getModel().deleteEntryData("entryentity");
            this.initComboItems();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initComboItems();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setItemValueByNumber(PARAMENTITY, "pmpd_project");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUERYFIELD, PARAMFIELD});
        BasedataEdit queryEntity = (BasedataEdit)this.getControl(QUERYENTITY);
        queryEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)QUERYENTITY, (CharSequence)name)) {
            String area = (String)this.getModel().getValue(MONITORAREA);
            HashSet<String> entityNumbers = new HashSet<String>(8);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)area)) {
                DynamicObjectCollection querySettings = QueryServiceHelper.query((String)"fmm_quercard_setting", (String)"entryentity.entitykey", (QFilter[])new QFilter("number", "=", (Object)"DEFAULT").toArray());
                for (DynamicObject querySetting : querySettings) {
                    entityNumbers.add(querySetting.getString("entryentity.entitykey"));
                }
            } else if (StringUtils.equals((CharSequence)"B", (CharSequence)area)) {
                DynamicObjectCollection fmm_promonit_menuconf = QueryServiceHelper.query((String)"fmm_promonit_menuconf", (String)"menus.appid,menus.menuid", null);
                for (DynamicObject config : fmm_promonit_menuconf) {
                    AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)config.getString("menus.appid"), (String)config.getString("menus.menuid"));
                    if (appMenuInfo == null) continue;
                    String entityNumber = appMenuInfo.getEntityNumber();
                    entityNumbers.add(entityNumber);
                }
            }
            ListFilterParameter listFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter();
            listFilterParameter.getQFilters().add(new QFilter("number", "in", entityNumbers));
        }
    }

    private void initComboItems() {
        this.initParamComboItems();
        this.initQueryComboItems();
    }

    private void initParamComboItems() {
        DynamicObject paramEntity = (DynamicObject)this.getModel().getValue(PARAMENTITY);
        if (paramEntity == null) {
            return;
        }
        ComboEdit paramField = (ComboEdit)this.getControl(PARAMFIELD);
        paramField.setComboItems(this.getComboItemsByEntity(paramEntity.getString("number")));
    }

    private void initQueryComboItems() {
        DynamicObject queryEntity = (DynamicObject)this.getModel().getValue(QUERYENTITY);
        if (queryEntity == null) {
            return;
        }
        ComboEdit queryField = (ComboEdit)this.getControl(QUERYFIELD);
        queryField.setComboItems(this.getComboItemsByEntity(queryEntity.getString("number")));
    }

    private List<ComboItem> getComboItemsByEntity(String entityNumber) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (item instanceof MainEntity) continue;
            if (item instanceof EntryEntity) {
                EntryEntity entry = (EntryEntity)item;
                List entryItems = entry.getItems();
                for (EntityItem entryItem : entryItems) {
                    String key = entry.getKey() + "." + entryItem.getKey();
                    String name = entry.getName().getLocaleValue() + "." + entryItem.getName().getLocaleValue();
                    if (entryItem instanceof BasedataField) {
                        key = key + ".number";
                        name = String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"QueryFieldMappingPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), name);
                    }
                    comboItems.add(this.createComboItem(key, name));
                }
                continue;
            }
            if (item instanceof BasedataField) {
                comboItems.add(this.createComboItem(item.getKey() + ".number", String.format(ResManager.loadKDString((String)"%s.\u7f16\u7801", (String)"QueryFieldMappingPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), item.getName().getLocaleValue())));
                continue;
            }
            comboItems.add(this.createComboItem(item.getKey(), item.getName().getLocaleValue()));
        }
        return comboItems;
    }

    private ComboItem createComboItem(String key, String name) {
        ComboItem comboItem = new ComboItem();
        comboItem.setId(key);
        comboItem.setValue(key);
        comboItem.setCaption(new LocaleString(name));
        return comboItem;
    }
}

