/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.base;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class QueryFilterPlugin
extends AbstractFormPlugin {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String ENTITY = "entity";
    private static final String BTN_OK = "btn_ok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn_ok = (Button)this.getControl(BTN_OK);
        btn_ok.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entity = (String)parameter.getCustomParam(ENTITY);
        if (StringUtils.isNotEmpty((CharSequence)entity)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
            this.setFilterByDestBillType(entity);
        }
    }

    private void setFilterByDestBillType(String entity) {
        if (entity != null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            List<String> queryScheme = this.getQueryScheme(entity);
            ArrayList<Map> removeCols = new ArrayList<Map>();
            for (Map col : cols) {
                String key = (String)col.get("fieldName");
                if (key.contains(".")) {
                    key = key.split("[.]")[0];
                }
                if (queryScheme.contains(key)) continue;
                removeCols.add(col);
            }
            cols.removeAll(removeCols);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String srcCtrlKey = con.getKey().toLowerCase();
        if (BTN_OK.equals(srcCtrlKey)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
            this.getView().returnDataToParent((Object)filterString);
            this.getView().close();
        }
    }

    private List<String> getQueryScheme(String entity) {
        ArrayList<String> scheme = new ArrayList<String>(8);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        DynamicObject queryDesign = BusinessDataServiceHelper.loadSingle((String)"fmm_querydesign", (QFilter[])(qFilter = qFilter.and(new QFilter("number", "=", (Object)entity))).toArray());
        if (queryDesign != null) {
            DynamicObjectCollection entrys = queryDesign.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                String entityId;
                DynamicObject bizentity;
                String querytype = entry.getString("querytype");
                if (!StringUtils.equals((CharSequence)"A", (CharSequence)querytype) || (bizentity = entry.getDynamicObject("bizentity")) == null || !StringUtils.equals((CharSequence)entity, (CharSequence)(entityId = bizentity.getString("number")))) continue;
                scheme.add(entry.getString("fieldflag"));
            }
        }
        return scheme;
    }
}

