/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.util.EventObject;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BusinessProjectFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog((String)BusinessProjectFormPlugin.class.getName());
    public static final String BUS_PROJ_CODERULE_ID = "3YVA=Q9RUZXL";
    public static final String OP_CONTOFORMALPROJ = "contoformalproj";
    public static final String NEED_CONFIRM = "Yes_No_Confirm";
    public static final String NO_CONFIRM = "NO";
    public static final String OP_SAVE = "save";
    public static final String OP_SUBMIT = "submit";
    public static final String KEY_MEMORY_BUSIPROJ_NUMBER = "memory_busiproj_number";
    public static final String BUSINESS_PROJECTTYPE = "business";
    public static final String FORMAL_PROJECTTYPE = "formal";
    public static final String SYSTEM_TYPE = "mmc-fmm-formplugin";
    public static final String OP_AUDIT = "audit";

    public void afterBindData(EventObject e) {
        Boolean isBusiProj;
        super.afterBindData(e);
        if (this.isNewAdd() && (isBusiProj = (Boolean)this.getModel().getValue("isbusiproj")).booleanValue()) {
            this.fillBusiProjNumb();
        }
        this.controlBusiProjView();
    }

    private boolean isNewAdd() {
        Long pkValue;
        DynamicObject entity = this.getModel().getDataEntity();
        if (entity != null && (pkValue = (Long)entity.getPkValue()) != null && pkValue != 0L) {
            return !QueryServiceHelper.exists((String)"pmpd_project", (Object)pkValue);
        }
        return Boolean.TRUE;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("isbusiproj".equals(name)) {
            Boolean isBusiProj = (Boolean)newValue;
            String busiprojnumb = (String)this.getModel().getValue("busiprojnumb");
            if (isBusiProj.booleanValue() && StringUtils.isBlank((CharSequence)busiprojnumb)) {
                this.fillBusiProjNumb();
            } else if (!isBusiProj.booleanValue()) {
                this.clearBusiProjNumb();
            }
            this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String KEY_OP = source.getOperateKey();
        if (KEY_OP.equals(OP_CONTOFORMALPROJ)) {
            String needConfirm = this.getPageCache().get(NEED_CONFIRM);
            if (!NO_CONFIRM.equals(needConfirm)) {
                this.confirmToFormalProject(args, KEY_OP);
            }
            this.getPageCache().remove(OP_CONTOFORMALPROJ);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String message;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OP_SAVE.equals(operateKey) || OP_SUBMIT.equals(operateKey)) {
            this.controlBusiProjView();
        } else if (OP_CONTOFORMALPROJ.equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u8f6c\u4e3a\u6b63\u5f0f\u9879\u76ee\uff0c\u8bf7\u6ce8\u610f\u9879\u76ee\u53f7\u7684\u53d8\u66f4\u3002", (String)"BusinessProjectFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        } else if (OP_AUDIT.equals(operateKey) && StringUtils.isNotBlank((CharSequence)(message = afterDoOperationEventArgs.getOperationResult().getMessage()))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8WBS\u5b58\u5728\u5931\u8d25\uff1a%s", (String)"BusinessProjectFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), message));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (OP_CONTOFORMALPROJ.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put(NEED_CONFIRM, NO_CONFIRM);
            this.getView().invokeOperation(OP_CONTOFORMALPROJ);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.recycleBusiProjNumb();
    }

    private void confirmToFormalProject(BeforeDoOperationEventArgs args, String KEY_OP) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_OP, (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u60a8\u662f\u5426\u8f6c\u4e3a\u6b63\u5f0f\u9879\u76ee\uff1f", (String)"BusinessProjectFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        args.setCancel(true);
    }

    private void clearBusiProjNumb() {
        this.getModel().setValue("busiprojnumb", null);
        this.getModel().setValue("number", (Object)this.getMemoryProjNumber(FORMAL_PROJECTTYPE));
    }

    private void fillBusiProjNumb() {
        if (this.containOldBusiProjNumb()) {
            this.continueOldBusiProjNumb();
        } else {
            String busiProjNumb = this.getBusiProjNumb();
            if (StringUtils.isNotBlank((CharSequence)busiProjNumb)) {
                this.getModel().setValue("busiprojnumb", (Object)busiProjNumb);
                this.memoryProjNumber(BUSINESS_PROJECTTYPE, busiProjNumb);
                String formalProjectNumb = (String)this.getModel().getValue("number");
                this.memoryProjNumber(FORMAL_PROJECTTYPE, formalProjectNumb);
                this.getModel().setValue("number", (Object)busiProjNumb);
            }
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private String getMemoryProjNumber(String projectType) {
        return this.getView().getPageCache().get(projectType + KEY_MEMORY_BUSIPROJ_NUMBER);
    }

    private void memoryProjNumber(String projectType, String projNumber) {
        this.getView().getPageCache().put(projectType + KEY_MEMORY_BUSIPROJ_NUMBER, projNumber);
    }

    private void clearProjNumber(String projectType) {
        this.getView().getPageCache().remove(projectType + KEY_MEMORY_BUSIPROJ_NUMBER);
    }

    private void continueOldBusiProjNumb() {
        String formalProjectNumb = (String)this.getModel().getValue("number");
        this.memoryProjNumber(FORMAL_PROJECTTYPE, formalProjectNumb);
        String busiProjectNumb = this.getMemoryProjNumber(BUSINESS_PROJECTTYPE);
        this.getModel().setValue("busiprojnumb", (Object)busiProjectNumb);
        this.getModel().setValue("number", (Object)busiProjectNumb);
    }

    private boolean containOldBusiProjNumb() {
        Boolean result = Boolean.FALSE;
        String oldValue = this.getMemoryProjNumber(BUSINESS_PROJECTTYPE);
        if (StringUtils.isNotBlank((CharSequence)oldValue)) {
            result = Boolean.TRUE;
        }
        return result;
    }

    private String getBusiProjNumb() {
        String resultNumber = "";
        DynamicObject curEntityObj = this.getModel().getDataEntity();
        CodeRuleInfo codeRule = this.getBusProjCodeRuleInfo();
        if (codeRule != null) {
            resultNumber = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)curEntityObj);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f3a\u5931\u5546\u673a\u9879\u76ee\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BusinessProjectFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            logger.info((Object)"BusinessProjectFormPlugin#fillBusiProjNumb  \u7f3a\u5931\u5546\u673a\u9879\u76ee\u7f16\u7801\u89c4\u5219");
        }
        return resultNumber;
    }

    private CodeRuleInfo getBusProjCodeRuleInfo() {
        return CodeRuleCache.reloadCodeRuleById((String)BUS_PROJ_CODERULE_ID);
    }

    private void recycleBusiProjNumb() {
        DynamicObject entity = this.getModel().getDataEntity();
        if (!this.isNewAdd()) {
            Long id = entity.getLong("id");
            this.recycleSavedBusiProjNumb(id);
        } else {
            this.recycleHasNotSaveBusiProjNumb(entity);
        }
    }

    private void recycleSavedBusiProjNumb(Long id) {
        DynamicObject curProject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmpd_project");
        String busiProjNumb = curProject.getString("busiprojnumb");
        String busiProjNumbOld = this.getMemoryProjNumber(BUSINESS_PROJECTTYPE);
        if (StringUtils.isNotBlank((CharSequence)busiProjNumbOld) && StringUtils.isBlank((CharSequence)busiProjNumb)) {
            this.recycleBusiProjNumb(curProject, busiProjNumbOld);
            this.clearProjNumber(BUSINESS_PROJECTTYPE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curProject});
        }
    }

    private void recycleHasNotSaveBusiProjNumb(DynamicObject entity) {
        String busiprojnumbOld = this.getMemoryProjNumber(BUSINESS_PROJECTTYPE);
        if (StringUtils.isNotBlank((CharSequence)busiprojnumbOld)) {
            this.recycleBusiProjNumb(entity, busiprojnumbOld);
        }
    }

    private void recycleBusiProjNumb(DynamicObject obj, String busiProjNumbOld) {
        CodeRuleInfo busProjCodeRuleInfo = this.getBusProjCodeRuleInfo();
        if (busProjCodeRuleInfo != null) {
            CodeRuleServiceImp codeRuleServiceImp = new CodeRuleServiceImp();
            codeRuleServiceImp.recycleNumber(busProjCodeRuleInfo, obj, busiProjNumbOld);
        }
    }

    private void controlBusiProjView() {
        Long id = this.getCurEntityId();
        if (id != 0L) {
            DynamicObject projectObjSave = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"isbusiproj", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (projectObjSave != null && projectObjSave.getBoolean("isbusiproj")) {
                this.enableBusiProjView(Boolean.FALSE);
            } else {
                this.enableBusiProjView(Boolean.TRUE);
            }
        }
    }

    private void enableBusiProjView(Boolean boolen) {
        this.getView().setEnable(boolen, new String[]{"isbusiproj"});
    }

    private Long getCurEntityId() {
        Long projectId;
        DynamicObject entity = this.getModel().getDataEntity();
        if (entity != null && (projectId = Long.valueOf(entity.getLong("id"))) != null && projectId != 0L) {
            return projectId;
        }
        return 0L;
    }
}

