/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FixProjectEditPlugin
extends AbstractBillPlugIn {
    private static Log log = LogFactory.getLog(FixProjectEditPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showExePkgForm();
        this.showProjectPrinter();
        this.countProjectMroOrderNum();
    }

    public void showProjectPrinter() {
        DynamicObjectCollection sources = this.getModel().getEntryEntity("entryentity1");
        String resourcePlanPk = null;
        for (DynamicObject source : sources) {
            DynamicObject sourcebilltype = source.getDynamicObject("sourcebilltype");
            if (sourcebilltype == null) continue;
            String sourcebilltypePk = sourcebilltype.getString("id");
            String sourcebillid = source.getString("sourcebillid");
            if (!StringUtils.equals((CharSequence)sourcebilltypePk, (CharSequence)"pmpd_resourceplan") || !StringUtils.isNotEmpty((CharSequence)sourcebillid)) continue;
            resourcePlanPk = sourcebillid;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmpd_planroomprinter");
        showParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("printerflex");
        showParameter.setCustomParam("resourcePlanPks", resourcePlanPk);
        showParameter.setCustomParam("projectPk", (Object)String.valueOf(this.getModel().getValue("id")));
        this.getView().showForm(showParameter);
    }

    public void showExePkgForm() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            return;
        }
        Object projectId = this.getModel().getValue("id");
        QFilter qFilter = new QFilter("project", "=", projectId);
        DynamicObject pkg = QueryServiceHelper.queryOne((String)"pmpd_exec_workpack", (String)"manageid", (QFilter[])qFilter.toArray());
        if (pkg == null) {
            return;
        }
        BillShowParameter billShowParameter = new BillShowParameter();
        String formId = "pmpd_exeworkpkg_pkgview";
        String targetKey = "exepkg";
        billShowParameter.setFormId(formId);
        billShowParameter.setParentFormId(this.getView().getFormShowParameter().getFormId());
        billShowParameter.setPkId(pkg.get(0));
        billShowParameter.setCustomParam("showJobCardList", (Object)true);
        billShowParameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = billShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(targetKey);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void countProjectMroOrderNum() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            return;
        }
        Long projectId = (Long)this.getModel().getValue("id");
        HashSet<Long> set = new HashSet<Long>();
        set.add(projectId);
        try {
            Map countNum = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"IMroOrderQureyTypeService", (String)"countMroOrder", (Object[])new Object[]{set});
            if (countNum != null) {
                this.getModel().setValue("orderqty", countNum.get(projectId));
                this.getModel().setDataChanged(false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

