/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmts.business.workbench.MyToDoBusinessHelper;

public class MyToDoWorkBenchPlugin
extends AbstractFormPlugin {
    public static final String FLEXPANELRIGHT = "flexpanelright";
    public static final String USERNAME = "username";
    public static final String TRIGGERMODIF = "triggermodif";
    private static final String[] keys = new String[]{"clue_pending_allocation", "clue_pending_confirmation", "opportunity_pending_proce", "opportunity_pending_revie", "my_wbs", "task_not_started", "task_in_progress", "task_completed"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"clue_pending_allocation", "clue_pending_confirmation", "opportunity_pending_proce", "opportunity_pending_revie", "task_not_started", "task_in_progress", "task_completed", "my_wbs"});
    }

    public void afterCreateNewData(EventObject e) {
        String firstHasPermPage = this.verifyPerm();
        this.setSelectButton(firstHasPermPage);
        this.setNavigationData();
        if (StringUtils.isNotBlank((CharSequence)firstHasPermPage)) {
            this.openPage(firstHasPermPage);
        }
    }

    private String verifyPerm() {
        String appId = this.getAppId();
        Long currUserId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, Boolean> permissions = new LinkedHashMap<String, Boolean>();
        permissions.put("my_clue", PermissionServiceHelper.hasViewPermission((long)currUserId, (String)appId, (String)"pmps_clueget"));
        permissions.put("my_business", PermissionServiceHelper.hasViewPermission((long)currUserId, (String)appId, (String)"pmps_bismanage"));
        permissions.put("my_wbs", PermissionServiceHelper.hasViewPermission((long)currUserId, (String)appId, (String)"pmts_wbs"));
        permissions.put("my_task", PermissionServiceHelper.hasViewPermission((long)currUserId, (String)appId, (String)"pmts_mytask"));
        ArrayList notDispNodeList = new ArrayList();
        String firstDisp = "";
        for (Map.Entry entry : permissions.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) {
                notDispNodeList.add(entry.getKey());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)firstDisp)) continue;
            firstDisp = (String)entry.getKey();
        }
        this.getView().setVisible(Boolean.FALSE, notDispNodeList.toArray(new String[0]));
        switch (firstDisp) {
            case "my_clue": {
                return "clue_pending_allocation";
            }
            case "my_business": {
                return "opportunity_pending_revie";
            }
            case "my_wbs": {
                return "my_wbs";
            }
            case "my_task": {
                return "task_not_started";
            }
        }
        return "";
    }

    private String getAppId() {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        return appid;
    }

    private String getEntityNumber() {
        String entity = this.getView().getEntityId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (TRIGGERMODIF.equals(property.getName())) {
            this.setNavigationData();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setNavigationData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickButton = ((Control)evt.getSource()).getKey();
        this.openPage(clickButton);
        this.setSelectButton(clickButton);
        this.setNavigationData();
    }

    private void openPage(String itemKey) {
        List qFilterList = MyToDoBusinessHelper.getQFilterList((String)itemKey);
        Tuple<String, String> showNameTuple = this.getListShowParamName(itemKey);
        if (showNameTuple != null) {
            String listShowParamName = (String)showNameTuple.item1;
            if (!qFilterList.isEmpty() && listShowParamName != null) {
                ListShowParameter showParameter = this.getListShowParam(listShowParamName, qFilterList);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private Tuple<String, String> getListShowParamName(String itemKey) {
        switch (itemKey) {
            case "clue_pending_allocation": {
                return new Tuple((Object)"pmps_clue_tobealloc", (Object)"pmpd");
            }
            case "clue_pending_confirmation": {
                return new Tuple((Object)"pmps_clue_tobeconfirm", (Object)"pmpd");
            }
            case "opportunity_pending_proce": {
                return new Tuple((Object)"pmps_busmanag_maint", (Object)"pmpd");
            }
            case "opportunity_pending_revie": {
                return new Tuple((Object)"pmps_busmanag_needaudit", (Object)"pmpd");
            }
            case "my_wbs": {
                return new Tuple((Object)"pmts_mywbs_workbench", (Object)"fmm");
            }
            case "task_not_started": 
            case "task_in_progress": 
            case "task_completed": {
                return new Tuple((Object)"pmts_mytask_workbenchpc", (Object)"pmts");
            }
        }
        return null;
    }

    private Map<String, Integer> getPageNumber() {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>(16);
        for (String key : keys) {
            List qFilterList = MyToDoBusinessHelper.getQFilterList((String)key);
            DynamicObjectCollection results = QueryServiceHelper.query((String)MyToDoBusinessHelper.getQueryName((String)key), (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
            resultMap.put(key, results != null ? results.size() : 0);
        }
        resultMap.put("my_clue", resultMap.getOrDefault("clue_pending_allocation", 0) + resultMap.getOrDefault("clue_pending_confirmation", 0));
        resultMap.put("my_business", resultMap.getOrDefault("opportunity_pending_proce", 0) + resultMap.getOrDefault("opportunity_pending_revie", 0));
        resultMap.put("my_task", resultMap.getOrDefault("task_in_progress", 0) + resultMap.getOrDefault("task_completed", 0) + resultMap.getOrDefault("task_not_started", 0));
        return resultMap;
    }

    private ListShowParameter getListShowParam(String billFormId, List<QFilter> qFilterList) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.getOpenStyle().setTargetKey(FLEXPANELRIGHT);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getListFilterParameter().getQFilters().addAll(qFilterList);
        return showParameter;
    }

    private void setNavigationData() {
        Map<String, Integer> pageNumberMap = this.getPageNumber();
        String selectButton = this.getSelectButton();
        this.updateControlMetadataForKey("clue_pending_allocation", ResManager.loadKDString((String)"\u5f85\u5206\u914d", (String)"MyToDoWorkBenchPlugin_0", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("clue_pending_confirmation", ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"MyToDoWorkBenchPlugin_1", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("opportunity_pending_proce", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"MyToDoWorkBenchPlugin_2", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("opportunity_pending_revie", ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"MyToDoWorkBenchPlugin_3", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("task_not_started", ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"MyToDoWorkBenchPlugin_4", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("task_in_progress", ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d", (String)"MyToDoWorkBenchPlugin_5", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("task_completed", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"MyToDoWorkBenchPlugin_6", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, false, selectButton);
        this.updateControlMetadataForKey("my_wbs", ResManager.loadKDString((String)"\u6211\u7684WBS", (String)"MyToDoWorkBenchPlugin_7", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, true, selectButton);
        this.updateControlMetadataForKey("my_clue", ResManager.loadKDString((String)"\u6211\u7684\u7ebf\u7d22", (String)"MyToDoWorkBenchPlugin_8", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, true, selectButton);
        this.updateControlMetadataForKey("my_business", ResManager.loadKDString((String)"\u6211\u7684\u5546\u673a", (String)"MyToDoWorkBenchPlugin_9", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, true, selectButton);
        this.updateControlMetadataForKey("my_task", ResManager.loadKDString((String)"\u6211\u7684\u4efb\u52a1", (String)"MyToDoWorkBenchPlugin_10", (String)"mmc-pmts-formplugin", (Object[])new Object[0]), pageNumberMap, true, selectButton);
    }

    private void updateControlMetadataForKey(String key, String prefix, Map<String, Integer> pageNumberMap, Boolean isParent, String selectButton) {
        Integer pageNumber = pageNumberMap.get(key);
        if (pageNumber != null) {
            LocaleString localeString = new LocaleString(prefix + " (" + pageNumber + ")");
            Control control = this.getView().getControl(key);
            HashMap<String, String> map = new HashMap<String, String>(2);
            if (control instanceof Label) {
                Label label = (Label)control;
                label.setText(localeString.toString());
                if (key.equals(selectButton)) {
                    map.put("bc", "#EAEFFD");
                    map.put("fc", "#2A71F5");
                } else {
                    map.put("bc", "#ffffff");
                    map.put("fc", "#666666");
                }
            }
            map.put("text", (String)localeString);
            this.getView().updateControlMetadata(key, map);
        }
    }

    public String getSelectButton() {
        return this.getView().getPageCache().get("select_button");
    }

    private void setSelectButton(String selectButton) {
        this.getView().getPageCache().put("select_button", selectButton);
    }
}

