/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ProjectChangeLogListPlugin
extends AbstractFormPlugin {
    public static final String KEY_BILLLISTTAP = "billlistap";
    public static final String KEY_MAINBAR = "tbmain";
    public static final String PROJECT = "pmpd_project";
    public static final String PROJECTCHANGELIST = "tree_bos_list";
    public static final String PROJECTCHANGE = "pmpd_changeproject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_MAINBAR});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"changelog", (CharSequence)evt.getOperationKey())) {
            MainEntityType mainEntityType;
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            IFormView view = this.getView();
            String entityId = view.getEntityId();
            boolean validateOrgPermission = this.validateOrgPermission(listShowParameter, filters, entityId);
            if (!validateOrgPermission) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u65e0\"\u9879\u76ee\u53d8\u66f4\u65e5\u5fd7\"\u67e5\u770b\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProjectChangeLogListPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (view instanceof ListView) {
                BillList billList = (BillList)this.getControl(KEY_BILLLISTTAP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.size() < 1) {
                    return;
                }
                String[] projectNumbers = new String[selectedRows.size()];
                for (int i = 0; i < selectedRows.size(); ++i) {
                    ListSelectedRow listSelectedRow = selectedRows.get(i);
                    projectNumbers[i] = listSelectedRow.getNumber();
                }
                if (StringUtils.equals((CharSequence)((ListView)view).getEntityTypeId(), (CharSequence)PROJECTCHANGE)) {
                    filters.add(new QFilter("pcnumber", "in", (Object)projectNumbers));
                } else {
                    filters.add(new QFilter("pnumber", "in", (Object)projectNumbers));
                }
                listShowParameter.setFormId("bos_list");
                listShowParameter.setBillFormId("pmpd_pchangelog");
                view.showForm((FormShowParameter)listShowParameter);
            } else if (view instanceof BaseView && StringUtils.equals((CharSequence)(mainEntityType = this.getModel().getDataEntityType()).getName(), (CharSequence)PROJECTCHANGE)) {
                String pnumber = (String)this.getModel().getValue("number");
                filters.add(new QFilter("pcnumber", "=", (Object)pnumber));
                listShowParameter.setFormId("bos_list");
                listShowParameter.setBillFormId("pmpd_pchangelog");
                view.showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    private boolean validateOrgPermission(ListShowParameter listShowParameter, List<QFilter> filters, String entityId) {
        ArrayList<Long> entryOrgValues;
        if (this.getView() instanceof ListView) {
            BillList billList = (BillList)this.getControl(KEY_BILLLISTTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            entryOrgValues = new ArrayList<Long>();
            ArrayList<Long> entryKeyValues = new ArrayList<Long>();
            for (ListSelectedRow listSelectedRow : selectedRows) {
                Object entryPrimaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                long mainOrgId = listSelectedRow.getMainOrgId();
                if (!entryOrgValues.contains(mainOrgId)) {
                    entryOrgValues.add(mainOrgId);
                }
                PermissionServiceHelper.clearAllCache();
                Long userId = Long.parseLong(RequestContext.get().getUserId());
                String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
                String permItemId = "47150e89000000ac";
                Iterator iterator = entryOrgValues.iterator();
                while (iterator.hasNext()) {
                    Long produceOrgId = (Long)iterator.next();
                    List allPermissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)appId, (String)"pmpd_pchangelog", (String)permItemId);
                    if (allPermissionOrgs.contains(produceOrgId)) continue;
                    if (entryOrgValues.size() == 1) {
                        return false;
                    }
                    iterator.remove();
                }
                entryKeyValues.add(Long.parseLong(String.valueOf(entryPrimaryKeyValue)));
            }
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("useorg");
            if (org == null && (org = (DynamicObject)this.getModel().getValue("createorg")) == null) {
                return true;
            }
            Object orgPkValue = org.getPkValue();
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
            String permItemId = "47150e89000000ac";
            long produceOrgId = Long.parseLong(orgPkValue.toString());
            int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)produceOrgId, (String)appId, (String)"pmpd_pchangelog", (String)permItemId);
            if (checkPermission != 1) {
                return false;
            }
            ArrayList<String> orgPkValues = new ArrayList<String>();
            orgPkValues.add(orgPkValue.toString());
            listShowParameter.setCustomParam("useorgIdFilter", orgPkValues);
            return true;
        }
        listShowParameter.setCustomParam("useorgIdFilter", entryOrgValues);
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        BillList billList;
        ListSelectedRow lsr;
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("changelogdetail".equals(afterDoOperationEventArgs.getOperateKey()) && (lsr = (billList = (BillList)this.getView().getControl(KEY_BILLLISTTAP)).getCurrentSelectedRowInfo()) != null && lsr.getPrimaryKeyValue() != null) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(lsr.getPrimaryKeyValue());
            billShowParameter.setFormId("pmpd_pchangelog");
            billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

