/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ProjectInteractionPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit control = (TextEdit)this.getControl("archivefilter");
        control.addClickListener((ClickListener)this);
        BasedataEdit businessobj = (BasedataEdit)this.getControl("businessobj");
        businessobj.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit interactemodel = (TextEdit)this.getControl("interactemodel");
        interactemodel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        long userMainOrgId;
        super.afterCreateNewData(e);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        if (currentUserId > 0L && (userMainOrgId = UserServiceHelper.getUserMainOrgId((long)currentUserId)) > 0L) {
            this.getModel().setValue("createorg", (Object)userMainOrgId);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entity = (DynamicObject)this.getModel().getValue("businessobj", index);
        if ("archivefilter".equals(key)) {
            DynamicObjectCollection entitys = this.getModel().getEntryEntity("entryentity");
            String billfilter = ((DynamicObject)entitys.get(index)).getString("filterstorge_tag");
            this.openFilterWindow(billfilter, key, entity, entitys);
        } else if ("interactemodel".equals(key)) {
            String interacttype = (String)this.getModel().getValue("interacttype", index);
            this.openPrintWindow(entity, interacttype);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("businessobj".equals(name)) {
            ChangeData changeSet = e.getChangeSet()[0];
            Object oldValue = changeSet.getOldValue();
            int rowIndex = changeSet.getRowIndex();
            if (oldValue != null) {
                this.getModel().setValue("archivefilter", (Object)"", rowIndex);
                this.getModel().setValue("filterstorge_tag", (Object)"", rowIndex);
                this.getModel().setValue("interactemodel", (Object)"", rowIndex);
                this.getModel().setValue("manageprintid", (Object)0, rowIndex);
                this.getModel().setValue("earchiveobj", (Object)"", rowIndex);
                this.getModel().setValue("edirectory", (Object)"", rowIndex);
                this.getModel().setValue("interacttype", (Object)"", rowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData != null) {
            String actionId = evt.getActionId();
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            if ("archivefilter".equals(actionId)) {
                Map rData = (Map)returnData;
                String filterString = (String)rData.get("filterString");
                this.getModel().setValue("filterstorge_tag", (Object)filterString, index);
                String temp = this.transletString(filterString, (String)rData.get("number"));
                this.getModel().setValue("archivefilter", (Object)temp, index);
            } else if ("interactemodel".equals(actionId)) {
                ListSelectedRowCollection listRow = (ListSelectedRowCollection)returnData;
                Object[] primaryKeyValues = listRow.getPrimaryKeyValues();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_manageprinttpl", (String)"id,printtplid.*", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValues[0])});
                if (null != dynamicObject) {
                    this.getModel().setValue("interactemodel", (Object)dynamicObject.getString("printtplid.name"), index);
                    this.getModel().setValue("manageprintid", (Object)dynamicObject.getLong("id"), index);
                }
            }
        }
    }

    private void openPrintWindow(DynamicObject dyobj, String str) {
        if ("B".equals(str)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bos_manageprinttpl", (boolean)false);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("billformid", "=", dyobj.getPkValue()));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "interactemodel"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void openFilterWindow(String billfilterstr, String actionId, DynamicObject entity, DynamicObjectCollection entitys) {
        if (entity != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("mpdm_filters_condition");
            showParameter.setCaption(ResManager.loadKDString((String)"\u8fc7\u6ee4", (String)"ProjectInteractionPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("billfilterstr", (Object)billfilterstr);
            showParameter.setCustomParam("entityobj", entity.get("number"));
            showParameter.setPermissionEntityId(null);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private String transletString(String filters, String number) {
        if (!StringUtils.isBlank((CharSequence)filters) && !StringUtils.isBlank((CharSequence)number)) {
            FilterCondition filterConditions = (FilterCondition)SerializationUtils.fromJsonString((String)filters, FilterCondition.class);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)number);
            String result = this.converCondition(filterConditions, mainType);
            FilterBuilder fb = new FilterBuilder(mainType, filterConditions, false);
            fb.setUserService((IUserService)new UserService());
            fb.buildFilter(false);
            return result;
        }
        return null;
    }

    private String converCondition(FilterCondition filterConditions, MainEntityType mainType) {
        List simpleFilterRows = filterConditions.getFilterRow();
        Iterator simpleFilterRowIterator = simpleFilterRows.iterator();
        StringBuilder filterStr = new StringBuilder();
        ArrayList<SimpleFilterRow> filterRow = new ArrayList<SimpleFilterRow>(16);
        FilterCondition fc = new FilterCondition();
        int row = 1;
        int size = simpleFilterRows.size();
        while (simpleFilterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)simpleFilterRowIterator.next();
            String leftBracket = simpleFilterRow.getLeftBracket();
            String rightBracket = simpleFilterRow.getRightBracket();
            simpleFilterRow.setLeftBracket("");
            simpleFilterRow.setRightBracket("");
            String logicDesc = "";
            String logic = simpleFilterRow.getLogic();
            logicDesc = "1".equals(logic) ? ResManager.loadKDString((String)" \u6216\u8005", (String)"ProjectInteractionPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)" \u5e76\u4e14", (String)"ProjectInteractionPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
            String fieldName = simpleFilterRow.getFieldName();
            List filterValues = simpleFilterRow.getValue();
            UserService userService = new UserService();
            if (fieldName.endsWith("_mmc_formula") && filterValues != null && !filterValues.isEmpty()) {
                simpleFilterRow.setValue(new ArrayList(0));
            } else {
                filterRow.add(simpleFilterRow);
                fc.setFilterRow(filterRow);
                FilterBuilder fb = new FilterBuilder(mainType, fc, false);
                fb.setUserService((IUserService)userService);
                fb.buildFilter(false);
                filterRow.clear();
                if (size == row) {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(' ');
                } else {
                    filterStr.append(leftBracket).append(fb.getFilterString().trim()).append(rightBracket).append(logicDesc).append(' ');
                }
            }
            simpleFilterRow.setLeftBracket(leftBracket);
            simpleFilterRow.setRightBracket(rightBracket);
            ++row;
        }
        return filterStr.toString();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("businessobj".equals(name)) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
        }
    }
}

