/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.business.project.ProjectHelper;
import kd.pmc.pmpd.common.util.TimeUnitUtils;

public class ProjectListPlugin
extends StandardTreeListPlugin {
    private static final String BUTTON_CHANGE = "change";
    public static final String KEY_BILLLISTTAP = "billlistap";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "tblsync": {
                this.showBdProjectForm();
                break;
            }
            case "bar_edittime": {
                this.showEditTimeForm();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (StringUtils.equals((CharSequence)"pmpd_fixproject", (CharSequence)billFormId)) {
            e.addCustomQFilter(new QFilter("projecttype", "=", (Object)"B"));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (StringUtils.equals((CharSequence)"pmpd_fixproject", (CharSequence)billFormId)) {
            e.getParameter().setFormId("pmpd_fixproject");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (StringUtils.equals((CharSequence)key, (CharSequence)BUTTON_CHANGE)) {
            this.checkProjectChange(args);
        }
    }

    private void showEditTimeForm() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fmm_projecttime_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_edittime"));
        formShowParameter.setCustomParam("project", (Object)selectedRows.getPrimaryKeyValues());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void checkProjectChange(BeforeDoOperationEventArgs args) {
        HashSet<Object> primaryKeyValues;
        BillList billList = (BillList)this.getControl(KEY_BILLLISTTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() > 1 && (primaryKeyValues = new HashSet<Object>(Arrays.asList(selectedRows.getPrimaryKeyValues()))).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u53d8\u66f4\u9879\u76ee\u3002", (String)"ProjectListPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void showBdProjectForm() {
        ListShowParameter params = ShowFormHelper.createShowListForm((String)"bd_project", (boolean)true);
        params.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "tblsync");
        params.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)params);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    public void closedCallBack(ClosedCallBackEvent ce) {
        super.closedCallBack(ce);
        if (ce.getActionId().equals("tblsync") && Objects.nonNull(ce.getReturnData())) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)ce.getReturnData();
            Object[] pks = rows.getPrimaryKeyValues();
            HashSet<Object> ids = new HashSet<Object>(8);
            for (Object pk : pks) {
                ids.add(pk);
            }
            OperationResult result = ProjectHelper.syncSysProject(ids);
            if (result.getAllErrorInfo().isEmpty() && result.getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"ProjectListPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(result);
            }
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)"bar_edittime", (CharSequence)ce.getActionId()) && ce.getReturnData() != null) {
            this.handleTime((Map)ce.getReturnData());
        }
    }

    private void handleTime(Map<String, Object> returnData) {
        DynamicObject[] projects;
        Date beginDate = (Date)returnData.get("begindate");
        Date endDate = (Date)returnData.get("enddate");
        Object[] projectIds = this.getSelectedRows().getPrimaryKeyValues();
        for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id,timeunit,realstartdate,realfinshdate,realperiod", (QFilter[])new QFilter("id", "in", (Object)projectIds).toArray())) {
            project.set("realstartdate", (Object)beginDate);
            project.set("realfinshdate", (Object)endDate);
            DynamicObject timeunit = project.getDynamicObject("timeunit");
            if (timeunit == null) continue;
            BigDecimal period = TimeUnitUtils.calPeriod((String)timeunit.getString("number"), (Date)beginDate, (Date)endDate);
            project.set("realperiod", (Object)period.intValue());
        }
        SaveServiceHelper.save((DynamicObject[])projects);
        try {
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"IMroNrcDeleteService", (String)"deleteNrc", (Object[])new Object[]{new HashSet<Object>(Arrays.asList(projectIds))});
            if (result != null) {
                String msg;
                String string = msg = result.get("msg") == null ? "" : (String)result.get("msg");
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u671f\u8c03\u6574\u6210\u529f\u3002", (String)"ProjectListPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("invokeBizService", String.format(ResManager.loadKDString((String)"\u8c03\u7528[IMroNrcDeleteService]->deleteNrc\u65b9\u6cd5\u5931\u8d25\uff1a%s\u3002", (String)"ProjectListPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8c03\u6574\u6210\u529f\u3002", (String)"ProjectListPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
    }
}

