/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.util.DateTimeFieldUtils;
import kd.pmc.pmpd.common.util.TimeUnitUtils;

public class ProjectPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        String formId;
        super.afterCreateNewData(e);
        Object pjOrg = this.getModel().getValue("createorg");
        if (Objects.nonNull(pjOrg)) {
            DynamicObject orgObj = (DynamicObject)pjOrg;
            QFilter orgQF = new QFilter("createorg", "=", orgObj.getPkValue());
            QFilter isdfQF = new QFilter("isfault", "=", (Object)Boolean.TRUE);
            DynamicObject cldObj = QueryServiceHelper.queryOne((String)"pmbd_calendar", (String)"id", (QFilter[])new QFilter[]{orgQF, isdfQF});
            if (Objects.nonNull(cldObj)) {
                this.getModel().setValue("pjcale", (Object)cldObj.getLong("id"));
            }
        }
        if (StringUtils.equals((CharSequence)"pmpd_fixproject", (CharSequence)(formId = this.getView().getFormShowParameter().getFormId()))) {
            this.getModel().setValue("projecttype", (Object)"B");
        }
        this.setWorkTimeTab();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit saleconstractno = (TextEdit)this.getControl("saleconstractno");
        saleconstractno.addClickListener((ClickListener)this);
        TextEdit saleorderno = (TextEdit)this.getControl("saleorderno");
        saleorderno.addClickListener((ClickListener)this);
        BasedataEdit fileScheme = (BasedataEdit)this.getControl("filescheme");
        fileScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"saleconstractno", (CharSequence)key)) {
            this.showContractF7();
        } else if (StringUtils.equals((CharSequence)"saleorderno", (CharSequence)key)) {
            this.showSaleOrderF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (StringUtils.equals((CharSequence)"saleconstractno", (CharSequence)actionId)) {
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            this.getModel().setValue("saleconstract", listSelectedRow.getPrimaryKeyValue(), rowIndex);
            this.getModel().setValue("saleconstractno", (Object)listSelectedRow.getNumber(), rowIndex);
            this.getModel().setValue("saleconstractname", (Object)listSelectedRow.getName(), rowIndex);
        } else if (StringUtils.equals((CharSequence)"saleorderno", (CharSequence)actionId)) {
            if (returnData == null) {
                return;
            }
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            this.getModel().setValue("saleorder", listSelectedRow.getPrimaryKeyValue(), rowIndex);
            this.getModel().setValue("saleorderno", (Object)listSelectedRow.getNumber(), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.save(evt);
                break;
            }
            case "delete": {
                this.delete(evt);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("entryentity1");
    }

    public void afterBindData(EventObject e) {
        int entryentity_hour;
        super.afterBindData(e);
        this.calculatePeriod();
        this.getModel().setDataChanged(false);
        this.initDateTimeFields();
        Object sourcebilltype = this.getModel().getValue("sourcebilltype", 0);
        if (sourcebilltype != null) {
            DynamicObject billType = (DynamicObject)sourcebilltype;
            boolean isPlan = StringUtils.equals((CharSequence)"pmpd_resourceplan", (CharSequence)billType.getString("number"));
            this.getView().setEnable(Boolean.valueOf(!isPlan), new String[]{"createorg", "expstartdate", "expfinshdate", "timeunit", "estperiod"});
            this.getView().setEnable(Boolean.valueOf(!isPlan), 0, new String[]{"entrycustomer"});
        }
        if ((entryentity_hour = this.getModel().getEntryRowCount("entryentity_hour")) == 0) {
            this.setWorkTimeTab();
        }
        this.setSupEndDate();
        this.fillColor(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        FormOperate operate = (FormOperate)evt.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "delete": {
                if (!evt.getOperationResult().isSuccess()) break;
                this.getView().close();
                break;
            }
            case "save": 
            case "submit": {
                if (!evt.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void delete(BeforeDoOperationEventArgs evt) {
        this.updateUseOrg(evt, "createOrg");
    }

    private void save(BeforeDoOperationEventArgs evt) {
        this.updateUseOrg(evt, "useOrgID");
    }

    private void updateUseOrg(BeforeDoOperationEventArgs evt, String key) {
        FormOperate operate = (FormOperate)evt.getSource();
        OperateOption opt = operate.getOption();
        DynamicObject createOrgObj = (DynamicObject)this.getModel().getValue("createorg");
        String curUseOrgID = opt.getVariableValue("useOrgID", "");
        if (StringUtils.isNotBlank((Object)createOrgObj) && StringUtils.isEmpty((CharSequence)curUseOrgID)) {
            opt.setVariableValue(key, String.valueOf(createOrgObj.getPkValue()));
            operate.setOption(opt);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IDataModel dm = this.getModel();
        if (dm == null) {
            return;
        }
        int ordinal = dm.getProperty("fullname").getOrdinal();
        dm.getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        ordinal = dm.getProperty("longnumber").getOrdinal();
        dm.getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        ordinal = dm.getProperty("level").getOrdinal();
        dm.getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        DynamicObjectCollection entryentity_hour = dm.getDataEntity(true).getDynamicObjectCollection("entryentity_hour");
        ordinal = entryentity_hour.getDynamicObjectType().getProperty("hourtype").getOrdinal();
        for (DynamicObject entry : entryentity_hour) {
            entry.getDataEntityState().setBizChanged(ordinal, false);
        }
        DynamicObjectCollection entryentity = dm.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            ordinal = entryentity.getDynamicObjectType().getProperty("saleconstract").getOrdinal();
            entry.getDataEntityState().setBizChanged(ordinal, false);
            ordinal = entryentity.getDynamicObjectType().getProperty("saleorder").getOrdinal();
            entry.getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("createorg")) {
            QFilter isdfQF;
            DynamicObject orgObj;
            QFilter orgQF;
            DynamicObject cldObj;
            Object pjOrg = this.getModel().getValue("createorg");
            if (Objects.nonNull(pjOrg) && Objects.nonNull(cldObj = QueryServiceHelper.queryOne((String)"pmbd_calendar", (String)"id", (QFilter[])new QFilter[]{orgQF = new QFilter("createorg", "=", (orgObj = (DynamicObject)pjOrg).getPkValue()), isdfQF = new QFilter("isfault", "=", (Object)Boolean.TRUE)}))) {
                this.getModel().setValue("pjcale", (Object)cldObj.getLong("id"));
            }
        } else if (propertyName.equals("expstartdate") || propertyName.equals("expfinshdate") || propertyName.equals("planstartdate") || propertyName.equals("planfinshdate") || propertyName.equals("realstartdate") || propertyName.equals("realfinshdate") || propertyName.equals("timeunit")) {
            this.calculatePeriod();
        } else if (propertyName.equals("jobcodepreincre")) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            if (newValue == null) {
                this.getModel().setValue("jobcodepreincre", (Object)0);
            }
        } else if (StringUtils.equals((CharSequence)"difsupbegindate", (CharSequence)propertyName)) {
            this.setSupEndDate();
        } else if (StringUtils.equals((CharSequence)"difsupenddate", (CharSequence)propertyName)) {
            this.setSupEndDate();
        } else if (StringUtils.equals((CharSequence)"labelcolor", (CharSequence)propertyName)) {
            this.fillColor(false);
        }
    }

    private void setSupEndDate() {
        Date supbegindate = (Date)this.getModel().getValue("difsupbegindate");
        Date supenddate = (Date)this.getModel().getValue("difsupenddate");
        if (supbegindate != null && supenddate != null) {
            DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("difsupenddate");
            endDateEdit.setMinDate(supbegindate);
            DateTimeEdit beginDateEdit = (DateTimeEdit)this.getControl("difsupbegindate");
            beginDateEdit.setMaxDate(supenddate);
        } else if (supbegindate == null && supenddate != null) {
            DateTimeEdit beginDateEdit = (DateTimeEdit)this.getControl("difsupbegindate");
            beginDateEdit.setMaxDate(supenddate);
        } else if (supbegindate != null && supenddate == null) {
            DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("difsupenddate");
            endDateEdit.setMinDate(supbegindate);
        }
    }

    private void calculatePeriod() {
        Date expstartdate = (Date)this.getModel().getValue("expstartdate");
        Date expfinshdate = (Date)this.getModel().getValue("expfinshdate");
        Date planstartdate = (Date)this.getModel().getValue("planstartdate");
        Date planfinshdate = (Date)this.getModel().getValue("planfinshdate");
        Date realstartdate = (Date)this.getModel().getValue("realstartdate");
        Date realfinshdate = (Date)this.getModel().getValue("realfinshdate");
        if (expstartdate != null && expfinshdate != null) {
            BigDecimal estperiod = this.daysBetween(expstartdate, expfinshdate);
            this.getModel().setValue("estperiod", (Object)estperiod);
        } else {
            this.getModel().setValue("estperiod", (Object)BigDecimal.ZERO);
        }
        if (planstartdate != null && planfinshdate != null) {
            BigDecimal planperiod = this.daysBetween(planstartdate, planfinshdate);
            this.getModel().setValue("planperiod", (Object)planperiod);
        } else {
            this.getModel().setValue("planperiod", (Object)BigDecimal.ZERO);
        }
        if (realstartdate != null && realfinshdate != null) {
            BigDecimal realperiod = this.daysBetween(realstartdate, realfinshdate);
            this.getModel().setValue("realperiod", (Object)realperiod);
        } else {
            this.getModel().setValue("realperiod", (Object)BigDecimal.ZERO);
        }
    }

    private BigDecimal daysBetween(Date startdate, Date finshdate) {
        DynamicObject timeunit = (DynamicObject)this.getModel().getValue("timeunit");
        BigDecimal period = BigDecimal.ZERO;
        if (timeunit != null) {
            String timeUnitNo = timeunit.getString("number");
            period = TimeUnitUtils.calPeriod((String)timeUnitNo, (Date)startdate, (Date)finshdate, (int)1);
        }
        return period;
    }

    private void setWorkTimeTab() {
        ArrayList<String> hourTypeList = new ArrayList<String>(8);
        hourTypeList.add(ResManager.loadKDString((String)"\u9884\u4f30\u5de5\u65f6", (String)"ProjectPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        hourTypeList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u62a5\u949f\u5de5\u65f6", (String)"ProjectPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        hourTypeList.add(ResManager.loadKDString((String)"\u6709\u6548\u62a5\u949f\u5de5\u65f6", (String)"ProjectPlugin_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        hourTypeList.add(ResManager.loadKDString((String)"\u5408\u540c\u5de5\u65f6", (String)"ProjectPlugin_14", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        hourTypeList.add(ResManager.loadKDString((String)"\u989d\u5916\u5de5\u65f6", (String)"ProjectPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        hourTypeList.add(ResManager.loadKDString((String)"\u552e\u5356\u5de5\u65f6", (String)"ProjectPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        this.getModel().batchCreateNewEntryRow("entryentity_hour", hourTypeList.size());
        for (int i = 0; i < hourTypeList.size(); ++i) {
            this.getModel().setValue("hourtype", hourTypeList.get(i), i);
        }
    }

    private void showContractF7() {
        Object[] pkIds;
        DynamicObjectCollection entryEntity;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"conm_salcontractf7", (boolean)false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "saleconstractno"));
        QFilter filter = new QFilter("billstatus", "=", (Object)"C").and("validstatus", "=", (Object)"B");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(filter);
        DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
        if (customer != null) {
            filters.add(new QFilter("customer", "=", customer.getPkValue()));
        }
        if (!(entryEntity = this.getModel().getEntryEntity("entryentity")).isEmpty() && (pkIds = entryEntity.stream().filter(dynamicObject -> dynamicObject.getLong("saleconstract") != 0L).map(dynamicObject -> dynamicObject.get("saleconstract")).toArray()).length > 0) {
            filters.add(new QFilter("id", "not in", (Object)pkIds));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void showSaleOrderF7() {
        Object[] pkIds;
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"sm_salorder_f7", (boolean)false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "saleorderno"));
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        filters.add(filter);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!entryEntity.isEmpty() && (pkIds = entryEntity.stream().filter(dynamicObject -> dynamicObject.getLong("saleorder") != 0L).map(dynamicObject -> dynamicObject.get("saleorder")).toArray()).length > 0) {
            filters.add(new QFilter("id", "not in", (Object)pkIds));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void fillColor(boolean init) {
        DynamicObject labelColor = (DynamicObject)this.getModel().getValue("labelcolor");
        String color = null;
        if (labelColor == null) {
            if (init) {
                return;
            }
        } else {
            color = labelColor.getString("color");
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("bc", color);
        this.getView().updateControlMetadata("btn_color", params);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"filescheme", (CharSequence)name)) {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
            QFilter qFilter = new QFilter("customer", "is null", (Object)"");
            if (customer != null) {
                qFilter = new QFilter("customer", "=", customer.getPkValue());
            }
            listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    protected void initDateTimeFields() {
        IFormView formView = this.getView();
        ArrayList<String> startKeys = new ArrayList<String>(8);
        startKeys.add("expstartdate");
        startKeys.add("planstartdate");
        startKeys.add("realstartdate");
        startKeys.add("preschedate");
        DateTimeFieldUtils.setDefaultMinSelectedDate((IFormView)formView, startKeys);
        ArrayList<String> endKeys = new ArrayList<String>(8);
        endKeys.add("expfinshdate");
        endKeys.add("planfinshdate");
        endKeys.add("realfinshdate");
        DateTimeFieldUtils.setDefaultMinSelectedDate((IFormView)formView, endKeys);
    }
}

