/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.util.TimeUnitUtils;

public class ProjectTimePlugin
extends AbstractBillPlugIn {
    private static final String EDITTIME = "edittime";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)EDITTIME, (CharSequence)operateKey) && args.getOperationResult().isSuccess()) {
            this.showEditTimeForm();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTimeRange();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("expstartdate") || name.equals("expfinshdate") || name.equals("planstartdate") || name.equals("planfinshdate") || name.equals("realstartdate") || name.equals("realfinshdate")) {
            this.setTimeRange();
        }
    }

    private void setTimeRange() {
        Date minDate = new Date(1662631L);
        Date maxDate = new Date(4102379431000L);
        Date expStartDate = (Date)this.getModel().getValue("expstartdate");
        Date expFinishDate = (Date)this.getModel().getValue("expfinshdate");
        if (expStartDate == null) {
            ((DateTimeEdit)this.getControl("expfinshdate")).setMinDate(minDate);
        } else {
            ((DateTimeEdit)this.getControl("expfinshdate")).setMinDate(expStartDate);
        }
        if (expFinishDate == null) {
            ((DateTimeEdit)this.getControl("expstartdate")).setMaxDate(maxDate);
        } else {
            ((DateTimeEdit)this.getControl("expstartdate")).setMaxDate(expFinishDate);
        }
        Date planStartDate = (Date)this.getModel().getValue("planstartdate");
        Date planFinishDate = (Date)this.getModel().getValue("planfinshdate");
        if (planStartDate == null) {
            ((DateTimeEdit)this.getControl("planfinshdate")).setMinDate(minDate);
        } else {
            ((DateTimeEdit)this.getControl("planfinshdate")).setMinDate(planStartDate);
        }
        if (planFinishDate == null) {
            ((DateTimeEdit)this.getControl("planstartdate")).setMaxDate(maxDate);
        } else {
            ((DateTimeEdit)this.getControl("planstartdate")).setMaxDate(planFinishDate);
        }
        Date realStartDate = (Date)this.getModel().getValue("realstartdate");
        Date realFinishDate = (Date)this.getModel().getValue("realfinshdate");
        if (realStartDate == null) {
            ((DateTimeEdit)this.getControl("realfinshdate")).setMinDate(minDate);
        } else {
            ((DateTimeEdit)this.getControl("realfinshdate")).setMinDate(realStartDate);
        }
        if (realFinishDate == null) {
            ((DateTimeEdit)this.getControl("realfinshdate")).setMaxDate(maxDate);
        } else {
            ((DateTimeEdit)this.getControl("realfinshdate")).setMaxDate(realFinishDate);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (EDITTIME.equals(actionId) && event.getReturnData() != null) {
            this.handleTime((Map)event.getReturnData());
            this.getView().invokeOperation("refresh");
        }
    }

    private void showEditTimeForm() {
        Object[] pkValues = new Object[]{this.getModel().getDataEntity().getPkValue()};
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("fmm_projecttime_edit");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITTIME));
        formShowParameter.setCustomParam("project", (Object)pkValues);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void handleTime(Map<String, Object> returnData) {
        DynamicObject[] projects;
        Date beginDate = (Date)returnData.get("begindate");
        Date endDate = (Date)returnData.get("enddate");
        Object[] pkValues = new Object[]{this.getModel().getDataEntity().getPkValue()};
        for (DynamicObject project : projects = BusinessDataServiceHelper.load((String)"pmpd_project", (String)"id,timeunit,realstartdate,realfinshdate,realperiod", (QFilter[])new QFilter("id", "in", (Object)pkValues).toArray())) {
            project.set("realstartdate", (Object)beginDate);
            project.set("realfinshdate", (Object)endDate);
            DynamicObject timeunit = project.getDynamicObject("timeunit");
            if (timeunit == null) continue;
            BigDecimal period = TimeUnitUtils.calPeriod((String)timeunit.getString("number"), (Date)beginDate, (Date)endDate);
            project.set("realperiod", (Object)period.intValue());
        }
        SaveServiceHelper.save((DynamicObject[])projects);
        try {
            HashSet<Object> set = new HashSet<Object>();
            for (Object pkValue : pkValues) {
                set.add(pkValue);
            }
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"IMroNrcDeleteService", (String)"deleteNrc", (Object[])new Object[]{set});
            if (result != null) {
                String msg;
                String string = msg = result.get("msg") == null ? "" : (String)result.get("msg");
                if (StringUtils.isNotEmpty((CharSequence)msg)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u65e5\u671f\u8c03\u6574\u6210\u529f\u3002", (String)"ProjectTimePlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("invokeBizService", String.format(ResManager.loadKDString((String)"\u8c03\u7528[IMroNrcDeleteService]->deleteNrc\u65b9\u6cd5\u5931\u8d25\uff1a%s\u3002", (String)"ProjectTimePlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8c03\u6574\u6210\u529f\u3002", (String)"ProjectTimePlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
    }
}

