/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmpd.formplugin.rpt;

import com.alibaba.fastjson.JSONObject;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.swing.JLabel;
import kd.bd.mpdm.common.gantt.enums.GanttRowTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCellModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttColModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCrossModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttGlobalModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttHolidayModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherDateLineMoel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherHLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherLLineModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttOtherModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowNumModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttViewSchemModel;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmpd.common.model.TaskCompareModel;

public class ProjectPlanCompareRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final Map<String, String> COLS = new LinkedHashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit projectone = (BasedataEdit)this.getControl("projectone");
        projectone.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit projecttwo = (BasedataEdit)this.getControl("projecttwo");
        projecttwo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit projectorg = (BasedataEdit)this.getControl("projectorg");
        projectorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Set ids = this.getOrgIds();
        long orgId = RequestContext.get().getOrgId();
        if (!ids.isEmpty()) {
            if (ids.contains(orgId)) {
                this.getModel().setValue("projectorg", (Object)orgId);
            } else {
                this.getModel().setValue("projectorg", ids.iterator().next());
            }
        }
        CustomControl custCtl = (CustomControl)this.getView().getControl("ganttctl");
        JSONObject result = (JSONObject)JSONObject.toJSON((Object)new GanttGlobalModel());
        custCtl.setData((Object)result);
        this.getView().setVisible(Boolean.FALSE, new String[]{"ganttctl"});
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo projectorg = filter.getFilterItem("projectorg");
        if (projectorg.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectPlanCompareRptPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo projectone = filter.getFilterItem("projectone");
        if (projectone.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectPlanCompareRptPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo projecttwo = filter.getFilterItem("projecttwo");
        if (projecttwo.getValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectPlanCompareRptPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        List<QFilter> qFilters = this.getQFilters(queryParam);
        QFilter filter = new QFilter("version.id", "is null", null);
        filter.or("version.id", "=", (Object)0);
        qFilters.add(filter);
        qFilters.add(new QFilter("scheduletype", "!=", (Object)"3"));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "_QueryTask"), (String)"pmts_task", (String)this.getSelectProperty(), (QFilter[])qFilters.toArray(new QFilter[0]), (String)"projectnum.number,name");){
            List<TaskCompareModel> modelList = this.handleQueryDatas(dataSet);
            Map<String, List<TaskCompareModel>> mergeMap = this.mergeTaskByName(modelList);
            this.initGanttDatas(mergeMap);
        }
    }

    protected List<QFilter> getQFilters(ReportQueryParam queryParam) {
        Object professionValue;
        Object planareaValue;
        Object projectplanValue;
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo projectorg = filter.getFilterItem("projectorg");
        FilterItemInfo projectplan = filter.getFilterItem("projectplan");
        FilterItemInfo planarea = filter.getFilterItem("planarea");
        FilterItemInfo profession = filter.getFilterItem("profession");
        FilterItemInfo projectone = filter.getFilterItem("projectone");
        FilterItemInfo projecttwo = filter.getFilterItem("projecttwo");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        Object projectorgValue = projectorg.getValue();
        if (projectorgValue != null) {
            qFilters.add(new QFilter("createorg", "=", ((DynamicObject)projectorgValue).getPkValue()));
        }
        if ((projectplanValue = projectplan.getValue()) != null) {
            qFilters.add(new QFilter("plantype", "=", ((DynamicObject)projectplanValue).getPkValue()));
        }
        if ((planareaValue = planarea.getValue()) != null) {
            qFilters.add(new QFilter("planarea", "=", ((DynamicObject)planareaValue).getPkValue()));
        }
        if ((professionValue = profession.getValue()) != null) {
            qFilters.add(new QFilter("trade", "=", ((DynamicObject)professionValue).getPkValue()));
        }
        Object projectoneValue = projectone.getValue();
        Object projecttwoValue = projecttwo.getValue();
        if (projectoneValue != null && projecttwoValue != null) {
            Object[] projectIds = new Object[]{((DynamicObject)projectoneValue).getPkValue(), ((DynamicObject)projecttwoValue).getPkValue()};
            qFilters.add(new QFilter("projectnum", "in", (Object)projectIds));
        }
        return qFilters;
    }

    protected String getSelectProperty() {
        String selectProperty = "id,number,name,projectnum.id,projectnum.number,projectnum.name,projectnum.expstartdate,plantype.name,plantime,planstartdate,planenddate";
        return selectProperty;
    }

    protected List<TaskCompareModel> handleQueryDatas(DataSet dataSet) {
        ArrayList<TaskCompareModel> modelList = new ArrayList<TaskCompareModel>(8);
        long currentTime = new Date().getTime();
        Map<String, String> colorMap = this.getColorMap();
        Object projectOnePkValue = ((DynamicObject)this.getModel().getValue("projectone")).getPkValue();
        Object projectTwoPkValue = ((DynamicObject)this.getModel().getValue("projecttwo")).getPkValue();
        Map projectTaskMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getTaskDateIndex", (Object[])new Object[]{projectOnePkValue});
        Map projectTwoTaskMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getTaskDateIndex", (Object[])new Object[]{projectTwoPkValue});
        projectTaskMap.putAll(projectTwoTaskMap);
        HashMap<Object, Object> projectDayOneMap = new HashMap<Object, Object>(2);
        projectDayOneMap.put(projectOnePkValue, DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getProjectDayOne", (Object[])new Object[]{projectOnePkValue}));
        projectDayOneMap.put(projectTwoPkValue, DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getProjectDayOne", (Object[])new Object[]{projectTwoPkValue}));
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Date projectStartDate = (Date)projectDayOneMap.get(row.getLong("projectnum.id"));
            if (projectStartDate == null) continue;
            Date taskStartDate = row.getDate("planstartdate");
            Date taskEndDate = row.getDate("planenddate");
            if (taskStartDate == null || taskEndDate == null) continue;
            Map taskMap = (Map)projectTaskMap.get(row.getLong("id"));
            TaskCompareModel taskCompareModel = new TaskCompareModel();
            taskCompareModel.setTaskId(row.getString("id"));
            taskCompareModel.setTaskNumber(row.getString("number"));
            taskCompareModel.setTaskName(row.getString("name"));
            taskCompareModel.setProjectNumber(row.getString("projectnum.number"));
            taskCompareModel.setProjectPlanType(row.getString("plantype.name"));
            taskCompareModel.setPlanPeriod(row.getBigDecimal("plantime"));
            taskCompareModel.setPlanStartTime(taskStartDate);
            taskCompareModel.setPlanEndTime(taskEndDate);
            taskCompareModel.setStartIndex(((Integer)taskMap.get("start")).intValue());
            taskCompareModel.setEndIndex(((Integer)taskMap.get("end")).intValue());
            taskCompareModel.setColor(colorMap.get(row.getString("projectnum.number")));
            taskCompareModel.setStartCurrent(currentTime + (taskStartDate.getTime() - projectStartDate.getTime()));
            taskCompareModel.setEndCurrent(currentTime + (taskEndDate.getTime() - projectStartDate.getTime()));
            modelList.add(taskCompareModel);
        }
        return modelList;
    }

    protected Map<String, String> getColorMap() {
        DynamicObject projectTwo;
        HashMap<String, String> colorMap = new HashMap<String, String>(3);
        DynamicObject projectOne = (DynamicObject)this.getModel().getValue("projectone");
        if (projectOne != null) {
            colorMap.put(projectOne.getString("number"), "rgba(104,146,233,1)");
        }
        if ((projectTwo = (DynamicObject)this.getModel().getValue("projecttwo")) != null) {
            colorMap.put(projectTwo.getString("number"), "rgba(60,182,252,1)");
        }
        colorMap.put("Merge", "rgba(90,186,192,1)");
        QFilter qFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection settings = QueryServiceHelper.query((String)"fmm_plancompare_setting", (String)"id,entryentity.type,entryentity.colorvalue", (QFilter[])qFilter.toArray());
        if (settings.isEmpty()) {
            qFilter = new QFilter("number", "=", (Object)"DEFAULT");
            settings = QueryServiceHelper.query((String)"fmm_plancompare_setting", (String)"id,entryentity.type,entryentity.colorvalue", (QFilter[])qFilter.toArray());
        }
        for (DynamicObject setting : settings) {
            String type = setting.getString("entryentity.type");
            String colorValue = setting.getString("entryentity.colorvalue");
            if (StringUtils.isBlank((CharSequence)colorValue)) continue;
            if (StringUtils.equals((CharSequence)"A", (CharSequence)type) && projectOne != null) {
                colorMap.put(projectOne.getString("number"), colorValue);
                continue;
            }
            if (StringUtils.equals((CharSequence)"B", (CharSequence)type) && projectTwo != null) {
                colorMap.put(projectTwo.getString("number"), colorValue);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)type)) continue;
            colorMap.put("Merge", colorValue);
        }
        return colorMap;
    }

    protected Map<String, List<TaskCompareModel>> mergeTaskByName(List<TaskCompareModel> modelList) {
        LinkedHashMap mergeMap = new LinkedHashMap(16);
        Map<String, String> colorMap = this.getColorMap();
        for (TaskCompareModel taskCompareModel : modelList) {
            String taskName = taskCompareModel.getTaskName();
            ArrayList<TaskCompareModel> mergeList = (ArrayList<TaskCompareModel>)mergeMap.get(taskName);
            if (mergeList == null) {
                mergeList = new ArrayList<TaskCompareModel>();
            }
            boolean isMerge = false;
            for (TaskCompareModel model : mergeList) {
                String projectNumber = model.getProjectNumber();
                String taskNumber = model.getTaskNumber();
                if (StringUtils.equals((CharSequence)taskCompareModel.getProjectNumber(), (CharSequence)projectNumber) || !StringUtils.equals((CharSequence)taskCompareModel.getTaskName(), (CharSequence)model.getTaskName()) || taskCompareModel.getPlanPeriod().compareTo(model.getPlanPeriod()) != 0 || taskCompareModel.getStartIndex() != model.getStartIndex() || taskCompareModel.getEndIndex() != model.getEndIndex()) continue;
                isMerge = true;
                model.setProjectNumber(projectNumber + "/" + taskCompareModel.getProjectNumber());
                model.setTaskNumber(taskNumber + "/" + taskCompareModel.getTaskNumber());
                model.setColor(colorMap.get("Merge"));
                model.setMerge(true);
            }
            if (!isMerge) {
                mergeList.add(taskCompareModel);
            }
            mergeMap.put(taskName, mergeList);
        }
        LinkedHashMap<String, List<TaskCompareModel>> compareMap = new LinkedHashMap<String, List<TaskCompareModel>>();
        LinkedHashMap<String, List> onlyMergeMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> singleMap = new LinkedHashMap<String, List>();
        for (Map.Entry entry : mergeMap.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            if (value.size() > 1) {
                compareMap.put(key, value);
                continue;
            }
            TaskCompareModel taskCompareModel = (TaskCompareModel)value.get(0);
            if (taskCompareModel.isMerge()) {
                onlyMergeMap.put(key, value);
                continue;
            }
            singleMap.put(key, value);
        }
        compareMap.putAll(onlyMergeMap);
        compareMap.putAll(singleMap);
        return compareMap;
    }

    protected void initGanttDatas(Map<String, List<TaskCompareModel>> mergeMap) {
        GanttGlobalModel model = new GanttGlobalModel();
        model.setTodo(new HashMap());
        model.setSummary(new HashMap());
        model.setPageData(this.buildPageDatas(mergeMap));
        model.setColumns(this.buildColumns(model));
        model.setViewSchem(this.buildGanttViewSchemModel(model));
        model.setMethodName("gtRefreshIniControlGanttData");
        CustomControl custCtl = (CustomControl)this.getView().getControl("ganttctl");
        JSONObject result = (JSONObject)JSONObject.toJSON((Object)model);
        custCtl.setData((Object)result);
        this.getView().setVisible(Boolean.TRUE, new String[]{"ganttctl"});
    }

    protected List<GanttColModel> buildColumns(GanttGlobalModel model) {
        ArrayList<GanttColModel> colModels = new ArrayList<GanttColModel>(8);
        int colIndex = 0;
        Map pageData = model.getPageData();
        List dataList = (List)pageData.get("dataList");
        LinkedHashMap<Integer, Integer> colWidthMap = new LinkedHashMap<Integer, Integer>(8);
        for (GanttRowDataModel ganttRowDataModel : dataList) {
            List cellList = ganttRowDataModel.getCellList();
            for (GanttCellModel cellModel : cellList) {
                int index = cellModel.getColIndex();
                int pixelOfStr = this.getPixelOfStr(cellModel.getVal());
                Integer width = (Integer)colWidthMap.get(index);
                if (width == null) {
                    colWidthMap.put(index, pixelOfStr);
                    continue;
                }
                if (pixelOfStr <= width) continue;
                colWidthMap.put(index, pixelOfStr);
            }
        }
        for (Map.Entry entry : COLS.entrySet()) {
            int colWidth;
            String key = (String)entry.getKey();
            GanttColModel ganttColModel = new GanttColModel();
            ganttColModel.setId(UUID.randomUUID().toString());
            ganttColModel.setColIndex(colIndex);
            ganttColModel.setColName(key);
            ganttColModel.setColCaption((String)entry.getValue());
            ganttColModel.setVisible(Boolean.valueOf(true));
            ganttColModel.setColAlign("center");
            int pixelOfStr = this.getPixelOfStr((String)entry.getValue());
            int n = colWidth = colWidthMap.get(colIndex) == null ? 100 : (Integer)colWidthMap.get(colIndex);
            if (pixelOfStr > colWidth) {
                colWidth = pixelOfStr;
            }
            if ("planStartTime".equals(key) || "planEndTime".equals(key)) {
                colWidth = 170;
            } else if ("planPeriod".equals(key) || "startIndex".equals(key) || "endIndex".equals(key)) {
                colWidth = 100;
            } else if ("projectPlanType".equals(key)) {
                colWidth = 120;
            } else if ("taskName".equals(key)) {
                colWidth = colWidth < 100 ? 100 : colWidth;
            }
            ganttColModel.setColWidth(colWidth);
            ganttColModel.setFontSize(12);
            colModels.add(ganttColModel);
            ++colIndex;
        }
        return colModels;
    }

    protected Map<String, Object> buildPageDatas(Map<String, List<TaskCompareModel>> mergeMap) {
        LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
        ArrayList<GanttTaskModel> taskDataList = new ArrayList<GanttTaskModel>();
        ArrayList<GanttRowDataModel> dataList = new ArrayList<GanttRowDataModel>();
        String requestId = UUID.randomUUID().getMostSignificantBits() + "&";
        int requestIndex = 0;
        for (Map.Entry<String, List<TaskCompareModel>> entry : mergeMap.entrySet()) {
            List<TaskCompareModel> value = entry.getValue();
            for (TaskCompareModel taskCompareModel : value) {
                String rowModelId = requestId.concat(Integer.toString(requestIndex));
                dataList.add(this.createGanttRowDataModel(rowModelId, taskCompareModel));
                taskDataList.add(this.createGanttTaskModel(rowModelId, taskCompareModel));
                ++requestIndex;
            }
        }
        int size = dataList.size();
        if (size > 0 && size < 27) {
            for (int i = size; i < 27; ++i) {
                String addId = requestId.concat("add").concat(Integer.toString(i));
                GanttRowDataModel ganttRowDataModel = new GanttRowDataModel(addId, null, "", null, Boolean.TRUE, Boolean.TRUE, 0, new ArrayList(), null, null, "0", null);
                List<GanttCellModel> cells = this.getCells(new TaskCompareModel());
                for (GanttCellModel cell : cells) {
                    cell.setVal("");
                }
                ganttRowDataModel.setCellList(cells);
                ganttRowDataModel.setDropable(false);
                ganttRowDataModel.setRowType(GanttRowTypeEnum.NORMAL.getValue());
                ganttRowDataModel.setDataModelType("");
                ganttRowDataModel.setBorderBottom(Boolean.valueOf(true));
                ganttRowDataModel.setBorderRight(Boolean.valueOf(true));
                ganttRowDataModel.setRowCount(1);
                dataList.add(ganttRowDataModel);
            }
        }
        Map<String, Object> dataListMap = this.createDataListMap(dataList);
        model.put("dataList", dataList);
        model.put("dataListMap", dataListMap);
        model.put("taskDataList", taskDataList);
        model.put("yLines", new ArrayList());
        model.put("emptyBarsList", new ArrayList());
        model.put("height", "");
        return model;
    }

    protected GanttRowDataModel createGanttRowDataModel(String id, TaskCompareModel taskCompareModel) {
        GanttRowDataModel ganttRowDataModel = new GanttRowDataModel();
        ganttRowDataModel.setId(id);
        ganttRowDataModel.setDropable(false);
        ganttRowDataModel.setRowType(GanttRowTypeEnum.NORMAL.getValue());
        ganttRowDataModel.setDataModelType("");
        ganttRowDataModel.setCellList(this.getCells(taskCompareModel));
        ganttRowDataModel.setLevel(0);
        ganttRowDataModel.setColor(taskCompareModel.getColor());
        ganttRowDataModel.setName(taskCompareModel.getProjectNumber());
        ganttRowDataModel.setIsSealf(Boolean.valueOf(true));
        ganttRowDataModel.setBorderBottom(Boolean.valueOf(true));
        ganttRowDataModel.setBorderRight(Boolean.valueOf(true));
        return ganttRowDataModel;
    }

    protected GanttTaskModel createGanttTaskModel(String groupId, TaskCompareModel taskCompareModel) {
        GanttTaskModel ganttTaskModel = new GanttTaskModel();
        ganttTaskModel.setTaskId(taskCompareModel.getTaskId());
        ganttTaskModel.setGroupId(groupId);
        ganttTaskModel.setCrossId(taskCompareModel.getTaskId());
        ganttTaskModel.setCrossObjName("task");
        ganttTaskModel.setCrossHeightVal(20);
        ganttTaskModel.setPosition("left");
        ganttTaskModel.setStartDate(Long.valueOf(taskCompareModel.getStartCurrent()));
        ganttTaskModel.setDashedStartDate(Long.valueOf(taskCompareModel.getStartCurrent()));
        ganttTaskModel.setEndDate(Long.valueOf(taskCompareModel.getEndCurrent()));
        ganttTaskModel.setDashedEndDate(Long.valueOf(taskCompareModel.getEndCurrent()));
        ganttTaskModel.setBarColor(taskCompareModel.getColor());
        return ganttTaskModel;
    }

    protected Map<String, Object> createDataListMap(List<GanttRowDataModel> dataList) {
        HashMap<String, Object> dataListMap = new HashMap<String, Object>(dataList.size());
        dataListMap.put("totalRow", dataList.size());
        for (int i = 0; i < dataList.size(); ++i) {
            GanttRowDataModel rowDataModel = dataList.get(i);
            GanttRowNumModel ganttRowNumModel = new GanttRowNumModel();
            ganttRowNumModel.setRealRow(i);
            ganttRowNumModel.setStartRow(i + 1);
            ganttRowNumModel.setRowCount(1);
            ganttRowNumModel.setTaskStartIndex(i);
            ganttRowNumModel.setTaskEndIndex(i + 1);
            ganttRowNumModel.setName(rowDataModel.getName());
            dataListMap.put(rowDataModel.getId(), ganttRowNumModel);
        }
        return dataListMap;
    }

    protected List<GanttCellModel> getCells(TaskCompareModel taskCompareModel) {
        ArrayList<GanttCellModel> cellList = new ArrayList<GanttCellModel>(COLS.size());
        Map modelMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)taskCompareModel), Map.class);
        int colIndex = 0;
        for (Map.Entry<String, String> col : COLS.entrySet()) {
            String key = col.getKey();
            String value = modelMap.get(key) == null ? "" : modelMap.get(key);
            String val = value.toString();
            if ("planPeriod".equals(key) && value instanceof BigDecimal) {
                val = ((BigDecimal)((Object)value)).setScale(2, 4).toString();
            }
            GanttCellModel cellModel = new GanttCellModel();
            cellModel.setColIndex(colIndex);
            cellModel.setFieldFlag(col.getKey());
            cellModel.setVal(val);
            cellModel.setCellTag(val);
            cellModel.setEnable(true);
            cellModel.setDesc("");
            cellList.add(cellModel);
            ++colIndex;
        }
        return cellList;
    }

    protected GanttViewSchemModel buildGanttViewSchemModel(GanttGlobalModel model) {
        Map pageData = model.getPageData();
        List taskDataList = (List)pageData.get("taskDataList");
        LinkedHashMap<String, GanttCrossModel> corssSet = new LinkedHashMap<String, GanttCrossModel>();
        long start = new Date().getTime();
        long end = new Date().getTime();
        for (GanttTaskModel taskModel : taskDataList) {
            if (taskModel.getStartDate() < start) {
                start = taskModel.getStartDate();
            }
            if (taskModel.getEndDate() > end) {
                end = taskModel.getEndDate();
            }
            GanttCrossModel ganttCrossModel = new GanttCrossModel();
            ganttCrossModel.setCrossShap("3");
            ganttCrossModel.setCrossLevel(Integer.valueOf(4));
            ganttCrossModel.setPosition("left");
            ganttCrossModel.setCrossObjType("1");
            ganttCrossModel.setLimitvalue(0);
            ganttCrossModel.setCrossObj(taskModel.getCrossObj());
            ganttCrossModel.setCrossHeightVal(Integer.valueOf(20));
            ganttCrossModel.setCrossType("3");
            ganttCrossModel.setCrossId(taskModel.getCrossId());
            ganttCrossModel.setLabelisshow(Boolean.valueOf(true));
            ganttCrossModel.setIsline(Boolean.valueOf(false));
            ganttCrossModel.setCrossColorVal(taskModel.getBarColor());
            corssSet.put(taskModel.getCrossId(), ganttCrossModel);
        }
        GanttViewSchemModel viewSchemModel = new GanttViewSchemModel();
        viewSchemModel.setCellScale(new BigDecimal("1.4"));
        viewSchemModel.setCellUnitType("day");
        viewSchemModel.setCorssSet(corssSet);
        viewSchemModel.setDropTargetType(1);
        viewSchemModel.setEmptyBarsShow(Boolean.valueOf(false));
        viewSchemModel.setRankStart(Long.valueOf(new Date().getTime()));
        viewSchemModel.setStart(Long.valueOf(start));
        viewSchemModel.setEnd(Long.valueOf(end + 864000000L));
        viewSchemModel.setGanttName(ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"ProjectPlanCompareRptPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        viewSchemModel.setGanttNums(1);
        viewSchemModel.setHighlightColor("");
        viewSchemModel.setHoliday(new GanttHolidayModel());
        viewSchemModel.setInitTableWidthFlag("config");
        viewSchemModel.setIsBarContentShow(Boolean.valueOf(false));
        viewSchemModel.setIsIndexMode(Boolean.valueOf(true));
        viewSchemModel.setIsRankMode(Boolean.valueOf(false));
        viewSchemModel.setIsRowCheckBoxShow(Boolean.valueOf(false));
        viewSchemModel.setIsRowIconShow(Boolean.valueOf(false));
        viewSchemModel.setIsTaskBorderShow(Boolean.valueOf(false));
        viewSchemModel.setIsVerticalMode(Boolean.valueOf(false));
        viewSchemModel.setIsWeekCodeMode(Boolean.valueOf(false));
        viewSchemModel.setNoTaskBorderRadiusShow(Boolean.valueOf(false));
        viewSchemModel.setNormalBarsShow(Boolean.valueOf(true));
        GanttOtherModel ganttOtherModel = new GanttOtherModel();
        GanttOtherHLineModel ganttOtherHLineModel = new GanttOtherHLineModel();
        ganttOtherHLineModel.setOtherAssishlinetype("solid");
        ganttOtherHLineModel.setOtherInternalcol(1);
        ganttOtherHLineModel.setOtherShowhline(Boolean.valueOf(true));
        ganttOtherModel.setHline(ganttOtherHLineModel);
        GanttOtherLLineModel ganttOtherLLineModel = new GanttOtherLLineModel();
        ganttOtherLLineModel.setOtherAssislinetype("solid");
        ganttOtherLLineModel.setOtherInternalrow(1);
        ganttOtherLLineModel.setOtherShowlvlline(Boolean.valueOf(true));
        ganttOtherModel.setLline(ganttOtherLLineModel);
        ganttOtherModel.setDateline(new GanttOtherDateLineMoel());
        List dataList = (List)pageData.get("dataList");
        int treeWidth = 100;
        for (GanttRowDataModel dataModel : dataList) {
            String name = dataModel.getName();
            int pixelOfStr = this.getPixelOfStr(name);
            treeWidth = pixelOfStr > treeWidth ? pixelOfStr : treeWidth;
        }
        viewSchemModel.setTableWidth(treeWidth);
        viewSchemModel.setTreeWidth(treeWidth);
        List columns = model.getColumns();
        int initTableWidth = 800;
        if (columns.size() > 2) {
            initTableWidth = ((GanttColModel)columns.get(0)).getColWidth() + ((GanttColModel)columns.get(1)).getColWidth() + treeWidth;
        }
        viewSchemModel.setInitTableWidth(initTableWidth);
        viewSchemModel.setOtherSet(ganttOtherModel);
        viewSchemModel.setProjectTimeShow(Boolean.valueOf(false));
        viewSchemModel.setRankStart(Long.valueOf(new Date().getTime()));
        viewSchemModel.setShcemPlugin("");
        viewSchemModel.setShowIndex(Boolean.valueOf(false));
        viewSchemModel.setShowPercentValue(Boolean.valueOf(false));
        viewSchemModel.setShowRisk(false);
        viewSchemModel.setSummaryShow(Boolean.valueOf(false));
        viewSchemModel.setTaskFilter3(Boolean.valueOf(false));
        viewSchemModel.setTaskFilter6(Boolean.valueOf(false));
        viewSchemModel.setTimelineFillType(2);
        viewSchemModel.setTimelineRows(2);
        viewSchemModel.setTimelineShowRows(2);
        viewSchemModel.setTodoShow(Boolean.valueOf(false));
        viewSchemModel.setViewID("");
        viewSchemModel.setViewName("");
        viewSchemModel.setViewNumber("");
        viewSchemModel.setyLinesList(new ArrayList());
        return viewSchemModel;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        if (StringUtils.equals((CharSequence)"projectone", (CharSequence)name)) {
            DynamicObject projecttwo = (DynamicObject)this.getModel().getValue("projecttwo");
            if (projecttwo != null) {
                QFilter qFilter = new QFilter("id", "!=", projecttwo.getPkValue());
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
            }
        } else if (StringUtils.equals((CharSequence)"projecttwo", (CharSequence)name)) {
            DynamicObject projectone = (DynamicObject)this.getModel().getValue("projectone");
            if (projectone != null) {
                QFilter qFilter = new QFilter("id", "!=", projectone.getPkValue());
                ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
            }
        } else if (StringUtils.equals((CharSequence)"projectorg", (CharSequence)name)) {
            QFilter qFilter = new QFilter("id", "in", (Object)this.getOrgIds());
            ((ListShowParameter)event.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private Set getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet<Object> ids = new HashSet<Object>(structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            String appNumber = reportShowParameter.getAppId();
            String entityNumber = reportShowParameter.getFormId();
            HashSet<Long> orgIds = new HashSet<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)entityNumber, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet();
    }

    private int getPixelOfStr(String str) {
        Font f = new Font("Microsoft YaHei", 0, 12);
        JLabel j = new JLabel();
        FontMetrics fm = j.getFontMetrics(f);
        return fm.stringWidth(str) + 44;
    }

    private Date getProjectDayOne(DynamicObject project) {
        DynamicObject pmpd_project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id,planstartdate", (QFilter[])new QFilter("id", "=", project.getPkValue()).toArray());
        QFilter[] qFilters = new QFilter[]{new QFilter("projectnum", "=", project.getPkValue()), new QFilter("isdayone", "=", (Object)true)};
        DynamicObject dayOne = QueryServiceHelper.queryOne((String)"pmts_task", (String)"id,planstartdate", (QFilter[])qFilters);
        if (dayOne != null) {
            return dayOne.getDate("planstartdate");
        }
        return pmpd_project.getDate("planstartdate");
    }

    static {
        COLS.put("taskNumber", ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u7801", (String)"ProjectPlanCompareRptPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("taskName", ResManager.loadKDString((String)"\u4efb\u52a1\u540d\u79f0", (String)"ProjectPlanCompareRptPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("projectPlanType", ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u7c7b\u578b", (String)"ProjectPlanCompareRptPlugin_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("planPeriod", ResManager.loadKDString((String)"\u8ba1\u5212\u5de5\u671f", (String)"ProjectPlanCompareRptPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("startIndex", ResManager.loadKDString((String)"\u7b2c\u51e0\u5929\u5f00\u59cb", (String)"ProjectPlanCompareRptPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("endIndex", ResManager.loadKDString((String)"\u7b2c\u51e0\u5929\u5b8c\u6210", (String)"ProjectPlanCompareRptPlugin_9", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("planStartTime", ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", (String)"ProjectPlanCompareRptPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        COLS.put("planEndTime", ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4", (String)"ProjectPlanCompareRptPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
    }
}

