/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FieldTip;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmpd.common.util.TimeUnitUtils;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.common.enums.HsTypeEnum;
import kd.pmc.pmts.common.util.DateUtil;

public class PmtsTaskBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String PROJECTID = "projectnum.id";
    private static final String TASKPLANTYPEID = "plantype.id";
    private static final String BAR_CLOSE = "bar_close";
    private static final String DELIVERABLES = "delIds";
    private static final String PLANSTARTDATE = "planstartdate";
    private static final String PLANENDDATE = "planenddate";
    private static final long ONEDAY = 86400000L;
    private static final String TASKSPLIT = "tasksplit";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] datas = e.getChangeSet();
        ChangeData changeData = datas[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int line = changeData.getRowIndex();
        switch (e.getProperty().getName()) {
            case "number": {
                this.dealWithNumber();
                break;
            }
            case "attachment": {
                this.dealWithAttch(e.getChangeSet());
                break;
            }
            case "timeunit": {
                this.dealWithTimeUnit(e.getChangeSet());
                break;
            }
            case "nfirststartdate": {
                this.dealWithNFStartDate(e.getChangeSet());
                break;
            }
            case "nfirstenddate": {
                this.dealWithNFEndDate(e.getChangeSet());
                break;
            }
            case "nlaststartdate": {
                this.dealWithNLStartDate(e.getChangeSet());
                break;
            }
            case "nlastenddate": {
                this.dealWithNLEndDate(e.getChangeSet());
                break;
            }
            case "hstype": {
                this.changeHsType(oldValue, newValue, line);
                break;
            }
            case "hsplanabilitytime": 
            case "hsplanneedtime": {
                this.sumPlantime();
                break;
            }
            case "projectnum": {
                if (newValue != null) break;
                this.getModel().setValue("wbs", null);
                break;
            }
            case "finishpercent": {
                this.changeActualDate();
                break;
            }
            case "plantime": {
                this.changeActualDate();
                break;
            }
            case "scheduletype": {
                this.changePlanTime(newValue);
                break;
            }
            case "plantype": {
                this.getModel().deleteEntryData("prepositiontaskentry");
                this.getModel().deleteEntryData("postpositiontaskentry");
                break;
            }
        }
    }

    private void changePlanTime(Object newValue) {
        if (String.valueOf(newValue).equals("3") || String.valueOf(newValue).equals("4")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"plantime"});
            this.getModel().setValue("plantime", (Object)0);
        }
    }

    private void changeActualDate() {
        String executestatus = (String)this.getModel().getValue("executestatus");
        if (StringUtils.equals((CharSequence)"2", (CharSequence)executestatus)) {
            BigDecimal plantime = (BigDecimal)this.getModel().getValue("plantime");
            BigDecimal finishpercent = (BigDecimal)this.getModel().getValue("finishpercent");
            finishpercent = finishpercent.divide(new BigDecimal(100));
            if (plantime != null) {
                BigDecimal actualtime = plantime.multiply(finishpercent);
                Date actualStartDate = (Date)this.getModel().getValue("actualstartdate");
                Double seconds = actualtime.doubleValue() * 24.0 * 60.0 * 60.0;
                Date actualEndDate = DateUtil.addSecond((Date)actualStartDate, (long)seconds.longValue());
                this.getModel().setValue("actualdate", (Object)actualEndDate);
            }
        }
    }

    private void dealWithNLEndDate(ChangeData[] datas) {
        Date startDate;
        Date endDate;
        if (this.getModel().getValue("nlaststartdate") != null && datas[0].getNewValue() != null && (endDate = (Date)datas[0].getNewValue()).compareTo(startDate = (Date)this.getModel().getValue("nlaststartdate")) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5c1a\u9700\u6700\u665a\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u5c1a\u9700\u6700\u665a\u5f00\u59cb\u65e5\u671f\u3002", (String)"PmtsTaskBillPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("nlastenddate", datas[0].getOldValue());
        }
    }

    private void dealWithNLStartDate(ChangeData[] datas) {
        Date endDate;
        Date startDate;
        if (this.getModel().getValue("nlastenddate") != null && datas[0].getNewValue() != null && (startDate = (Date)datas[0].getNewValue()).compareTo(endDate = (Date)this.getModel().getValue("nlastenddate")) > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5c1a\u9700\u6700\u665a\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5c1a\u9700\u6700\u665a\u7ed3\u675f\u65e5\u671f\u3002", (String)"PmtsTaskBillPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("nlaststartdate", datas[0].getOldValue());
        }
    }

    private void dealWithNFEndDate(ChangeData[] datas) {
        Date startDate;
        Date endDate;
        if (this.getModel().getValue("nfirststartdate") != null && datas[0].getNewValue() != null && (endDate = (Date)datas[0].getNewValue()).compareTo(startDate = (Date)this.getModel().getValue("nfirststartdate")) < 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5c1a\u9700\u6700\u65e9\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u5c1a\u9700\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"PmtsTaskBillPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("nfirstenddate", datas[0].getOldValue());
        }
    }

    private void dealWithNFStartDate(ChangeData[] datas) {
        Date endDate;
        Date startDate;
        if (this.getModel().getValue("nfirstenddate") != null && datas[0].getNewValue() != null && (startDate = (Date)datas[0].getNewValue()).compareTo(endDate = (Date)this.getModel().getValue("nfirstenddate")) > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5c1a\u9700\u6700\u65e9\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u65e9\u4e8e\u5c1a\u9700\u6700\u65e9\u7ed3\u675f\u65e5\u671f\u3002", (String)"PmtsTaskBillPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("nfirststartdate", datas[0].getOldValue());
        }
    }

    private void dealWithTimeUnit(ChangeData[] datas) {
        if (Objects.nonNull(datas[0].getNewValue()) && Objects.nonNull(this.getModel().getValue("plantime"))) {
            String timeunit;
            DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
            long prostartDate = Objects.nonNull(project.get("planstarttime")) ? project.getDate("planstarttime").getTime() : project.getDate(PLANSTARTDATE).getTime();
            Calendar c = Calendar.getInstance();
            BigDecimal data = (BigDecimal)this.getModel().getValue("plantime");
            long lv = data.multiply(new BigDecimal(86400000L)).longValue();
            switch (timeunit = (String)datas[0].getNewValue()) {
                case "1": {
                    c.setTimeInMillis(prostartDate + lv);
                    break;
                }
                case "2": {
                    c.setTimeInMillis(prostartDate + lv * 7L);
                    break;
                }
            }
            this.getModel().setValue(PLANENDDATE, (Object)c.getTime());
        }
    }

    private void dealWithAttch(ChangeData[] datas) {
        if (Objects.nonNull(datas[0].getNewValue())) {
            DynamicObjectCollection attachs = (DynamicObjectCollection)datas[0].getNewValue();
            if (!attachs.isEmpty()) {
                this.getModel().setValue("uploaddate", (Object)Calendar.getInstance().getTime(), datas[0].getRowIndex());
                this.getModel().setValue("donestatus", (Object)"2", datas[0].getRowIndex());
                this.getModel().setItemValueByID("uploadperson", (Object)Long.parseLong(RequestContext.get().getUserId()), datas[0].getRowIndex());
            } else {
                this.getModel().setValue("uploaddate", null, datas[0].getRowIndex());
                this.getModel().setValue("uploadperson", null, datas[0].getRowIndex());
                this.getModel().setValue("donestatus", (Object)"1", datas[0].getRowIndex());
            }
        } else {
            this.getModel().setValue("uploaddate", null, datas[0].getRowIndex());
            this.getModel().setValue("uploadperson", null, datas[0].getRowIndex());
            this.getModel().setValue("donestatus", (Object)"1", datas[0].getRowIndex());
        }
    }

    private void dealWithNumber() {
        this.getModel().setValue("isautonumber", (Object)Boolean.FALSE);
    }

    private void sumPlantime() {
        DynamicObjectCollection hmReSourcesDynColl = this.getModel().getEntryEntity("hmresourcesentity");
        if (hmReSourcesDynColl != null) {
            BigDecimal plantime = new BigDecimal(0);
            for (DynamicObject dynamicObject : hmReSourcesDynColl) {
                plantime = plantime.add(dynamicObject.getBigDecimal("hsplanabilitytime"));
                plantime = plantime.add(dynamicObject.getBigDecimal("hsplanneedtime"));
            }
            this.getModel().setValue("planhours", (Object)plantime);
        }
    }

    private void changeHsType(Object oldValue, Object newValue, int line) {
        if (oldValue != null && newValue != null && oldValue.toString().equalsIgnoreCase(newValue.toString())) {
            return;
        }
        if (HsTypeEnum.ROLE.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.TRUE, line, new String[]{"hsrole"});
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hspicture", "hsuser"});
            this.getModel().setValue("hsuser", null, line);
        } else if (HsTypeEnum.USER.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hsrole"});
            this.getView().setEnable(Boolean.TRUE, line, new String[]{"hspicture", "hsuser"});
            this.getModel().setValue("hsrole", null, line);
        }
    }

    public void beforeBindData(EventObject e) {
        Long planstarttime;
        super.beforeBindData(e);
        String taskNumber = (String)this.getModel().getValue("number");
        if (taskNumber.contains("&")) {
            this.getModel().setValue("number", (Object)taskNumber.split("&")[0]);
        }
        if ((planstarttime = (Long)this.getView().getFormShowParameter().getCustomParam("startdate")) != null) {
            Long planendtime = (Long)this.getView().getFormShowParameter().getCustomParam("enddate");
            Date planstartdate = new Date(planstarttime);
            Date planenddate = new Date(planendtime);
            this.getModel().beginInit();
            this.getModel().setValue(PLANSTARTDATE, (Object)planstartdate);
            this.getModel().setValue(PLANENDDATE, (Object)planenddate);
            DynamicObject timeunit = (DynamicObject)this.getModel().getValue("durationunit");
            String timeUnitNo = timeunit.getString("number");
            this.getModel().setValue("plantime", (Object)TimeUnitUtils.calPeriod((String)timeUnitNo, (Date)planstartdate, (Date)planenddate));
            this.getModel().endInit();
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
        Optional.ofNullable(project).ifPresent(p -> {
            DynamicObject obj = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"workcenter.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)project.getLong("id"))});
            this.getModel().setItemValueByID("workcenter", (Object)obj.getLong("workcenter.id"));
        });
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection dynamicObjectCollection;
        DynamicObject object;
        ListView listView;
        super.afterBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("stoptask_entry");
        entrys.removeIf(entry -> Objects.isNull(entry.get("stoptime")));
        if (!entrys.isEmpty()) {
            entrys.sort((o1, o2) -> o1.getDate("stoptime").compareTo(o2.getDate("stoptime")));
        }
        if (this.getParentView() instanceof ListView && !StringUtils.equals((CharSequence)"pmts_task", (CharSequence)(listView = (ListView)this.getParentView()).getBillFormId()) && !StringUtils.equals((CharSequence)"pmts_task_gantt", (CharSequence)listView.getBillFormId()) && !StringUtils.equals((CharSequence)"pmts_milestone", (CharSequence)listView.getBillFormId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"plantype"});
        }
        this.getView().updateView("stoptask_entry");
        if (this.getModel().getValue("status").equals("B") || this.getModel().getValue("status").equals("C")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_doc"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_doc"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_prev"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_prev"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_next"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_next"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_doc"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_doc"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_prev"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_prev"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_next"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_next"});
        }
        DynamicObjectCollection dynColl = this.getModel().getEntryEntity("hmresourcesentity");
        if (dynColl != null) {
            int size = dynColl.size();
            for (int i = 0; i < size; ++i) {
                this.changeHsType("", this.getModel().getValue("hstype", i), i);
            }
        }
        if (this.getView().getFormShowParameter().getStatus().getValue() == OperationStatus.EDIT.getValue() && this.getModel().getValue("projectnum") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"projectnum"});
        }
        if ((object = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getModel().getValue("id"), (String)"pmts_task_subsection")) != null && !(dynamicObjectCollection = object.getDynamicObjectCollection("subsectionentry")).isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{PLANSTARTDATE, PLANENDDATE, "plantime"});
        }
        String scheduletype = (String)this.getModel().getValue("scheduletype");
        String releasestatus = (String)this.getModel().getValue("releasestatus");
        if (StringUtils.equals((CharSequence)scheduletype, (CharSequence)"3") || StringUtils.equals((CharSequence)releasestatus, (CharSequence)"1")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TASKSPLIT});
        }
    }

    private void setProjectAndPlanTypeBylFilter(ListView listView) {
        List taskPtfilterList;
        ControlFilters filters = listView.getControlFilters();
        List filterList = filters.getFilter(PROJECTID);
        if (filterList != null && filterList.size() > 0 && StringUtils.isNotEmpty((CharSequence)filterList.get(0).toString())) {
            long projectId = Long.parseLong(filterList.get(0).toString());
            this.getModel().setItemValueByID("projectnum", (Object)projectId);
            DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
            if (project != null) {
                this.getModel().setValue("scheduletype", (Object)project.getString("scheattr"));
                this.getModel().setValue("timetype", (Object)project.getString("workdaytype"));
                this.getModel().setValue("percenttype", (Object)project.getString("jobcomppertype"));
                this.getModel().setValue("priority", (Object)project.getInt("resballevel"));
            }
        }
        if ((taskPtfilterList = filters.getFilter(TASKPLANTYPEID)) != null && taskPtfilterList.size() > 0 && StringUtils.isNotEmpty((CharSequence)taskPtfilterList.get(0).toString())) {
            long taskplantypeId = Long.parseLong(taskPtfilterList.get(0).toString());
            this.getModel().setItemValueByID("plantype", (Object)taskplantypeId);
        }
    }

    private IFormView getParentView() {
        return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getParentView();
        if (parentView instanceof ListView) {
            ListView listView = (ListView)parentView;
            String filtersStr = (String)GanttBigObjectCache.get((String)listView.getPageId(), (String)"filterStr");
            if (StringUtils.isEmpty((CharSequence)filtersStr)) {
                this.setProjectAndPlanTypeBylFilter(listView);
            } else {
                PmtsTaskValueHelper.setFilterValueToGanttTask((IDataModel)this.getModel(), (IFormView)parentView);
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
            if (project != null) {
                this.getModel().setValue("scheduletype", (Object)project.getString("scheattr"));
                this.getModel().setValue("timetype", (Object)project.getString("workdaytype"));
                this.getModel().setValue("percenttype", (Object)project.getString("jobcomppertype"));
                this.getModel().setValue("priority", (Object)project.getInt("resballevel"));
                this.getModel().setValue("durationunit", project.get("timeunit"));
            }
            if (this.getView().getFormShowParameter().getCustomParam("wbs") != null) {
                DynamicObject pjObj;
                long wbsId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("wbs").toString());
                this.getModel().setValue("WBS", (Object)wbsId);
                DynamicObject wbsObj = (DynamicObject)this.getModel().getValue("WBS");
                if (wbsObj.get("responsorg") != null) {
                    this.getModel().setValue("responsorg", wbsObj.get("responsorg.id"));
                }
                if (wbsObj.get("responsperson") != null) {
                    this.getModel().setItemValueByID("responsperson", wbsObj.get("responsperson.id"));
                }
                if (Objects.nonNull((pjObj = (DynamicObject)this.getModel().getValue("projectnum")).get("pjcale"))) {
                    DynamicObject cId = pjObj.getDynamicObject("pjcale");
                    this.getModel().setValue("taskcalendar", cId.getPkValue());
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit ctlWBS;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BAR_CLOSE});
        BasedataEdit preTask = (BasedataEdit)this.getControl("prepositiontask");
        BasedataEdit postTask = (BasedataEdit)this.getControl("postpositiontask");
        BasedataEdit carlendar = (BasedataEdit)this.getControl("taskcalendar");
        if (preTask != null) {
            preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (postTask != null) {
            postTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (carlendar != null) {
            carlendar.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Tab tab = (Tab)this.getControl("tabap2");
        tab.addItemClickListener((ItemClickListener)this);
        BasedataEdit rpctl = (BasedataEdit)this.getControl("responsperson");
        if (rpctl != null) {
            rpctl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ctlWBS = (BasedataEdit)this.getControl("wbs")) != null) {
            ctlWBS.addBeforeF7SelectListener(arg -> {
                DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
                if (project == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmtsTaskBillPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    arg.setCancel(true);
                } else {
                    ListShowParameter showParam = (ListShowParameter)arg.getFormShowParameter();
                    showParam.setCustomParam("formTask", (Object)true);
                    arg.setFormShowParameter((FormShowParameter)showParam);
                    arg.addCustomQFilter(new QFilter(PROJECTID, "=", project.getPkValue()));
                    ((ListShowParameter)arg.getFormShowParameter()).setShowApproved(false);
                }
            });
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent paramBeforeF7SelectEvent) {
        if (Objects.isNull(this.getModel().getValue("projectnum"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmtsTaskBillPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            paramBeforeF7SelectEvent.setCancel(true);
            return;
        }
        DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filter = new QFilter(PROJECTID, "=", project.getPkValue());
        filters.add(filter);
        if ((Long)this.getModel().getValue("id") > 0L) {
            QFilter filter2 = new QFilter("id", "!=", this.getModel().getValue("id"));
            filters.add(filter2);
        }
        DynamicObject plantype = (DynamicObject)this.getModel().getValue("plantype");
        QFilter planTypeQFilter = null;
        if (plantype != null) {
            planTypeQFilter = new QFilter(TASKPLANTYPEID, "=", (Object)plantype.getLong("id"));
        }
        switch (paramBeforeF7SelectEvent.getProperty().getName()) {
            case "prepositiontask": {
                List<String> existNumberList = this.getExistNumberList("prepositiontaskentry", paramBeforeF7SelectEvent.getProperty().getName(), "postpositiontaskentry", "postpositiontask");
                if (existNumberList.size() > 0) {
                    QFilter qFilter = new QFilter("number", "not in", existNumberList);
                    filters.add(qFilter);
                }
                if (planTypeQFilter != null) {
                    filters.add(planTypeQFilter);
                }
                paramBeforeF7SelectEvent.setCustomQFilters(filters);
                break;
            }
            case "postpositiontask": {
                List<String> existNumberList = this.getExistNumberList("postpositiontaskentry", paramBeforeF7SelectEvent.getProperty().getName(), "prepositiontaskentry", "prepositiontask");
                if (existNumberList.size() > 0) {
                    QFilter qFilter = new QFilter("number", "not in", existNumberList);
                    filters.add(qFilter);
                }
                if (planTypeQFilter != null) {
                    filters.add(planTypeQFilter);
                }
                paramBeforeF7SelectEvent.setCustomQFilters(filters);
                break;
            }
            case "responsperson": {
                break;
            }
        }
    }

    private List<String> getExistNumberList(String entryName, String key, String otherEntryName, String otherKey) {
        DynamicObject entry;
        DynamicObject object;
        int i;
        int row = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryName);
        DynamicObjectCollection otherEntrys = this.getModel().getEntryEntity(otherEntryName);
        ArrayList<String> existNumberList = new ArrayList<String>();
        for (i = 0; i < entrys.size(); ++i) {
            if (i == row || !Objects.nonNull(object = (entry = (DynamicObject)entrys.get(i)).getDynamicObject(key))) continue;
            existNumberList.add(object.getString("number"));
        }
        for (i = 0; i < otherEntrys.size(); ++i) {
            entry = (DynamicObject)otherEntrys.get(i);
            object = entry.getDynamicObject(otherKey);
            if (!Objects.nonNull(object)) continue;
            existNumberList.add(object.getString("number"));
        }
        return existNumberList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)BAR_CLOSE)) {
            this.getView().returnDataToParent((Object)this.getPageCache().get("isRefresh"));
            this.getView().close();
        }
        if (StringUtils.equals((CharSequence)evt.getOperationKey(), (CharSequence)"import_doc")) {
            this.showProjectDocForm();
        }
    }

    private void showProjectDocForm() {
        ListShowParameter params = ShowFormHelper.createShowListForm((String)"pmpd_projectdeliverables", (boolean)true);
        DynamicObject project = (DynamicObject)this.getModel().getValue("projectnum");
        QFilter pjfilter = new QFilter(PROJECTID, "=", (Object)project.getLong("id"));
        QFilter issyofilter = new QFilter("issyototask", "=", (Object)Boolean.FALSE);
        QFilter statusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter typeQF = new QFilter("entryentity.deliverytype", "=", (Object)"B");
        params.getListFilterParameter().getQFilters().add(issyofilter);
        params.getListFilterParameter().getQFilters().add(pjfilter);
        params.getListFilterParameter().getQFilters().add(statusQF);
        params.getListFilterParameter().getQFilters().add(typeQF);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "importDevls");
        params.setCloseCallBack(callBack);
        this.getView().showForm((FormShowParameter)params);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof Save || args.getSource() instanceof Submit) {
            if (StringUtils.isNotEmpty((CharSequence)args.getOperationResult().getSponsor())) {
                this.getPageCache().put("isRefresh", "isRefresh");
            }
            this.getPageCache().put(DELIVERABLES, "");
        } else if (args.getSource() instanceof Delete) {
            this.getView().returnDataToParent((Object)"isRefresh");
        } else if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)TASKSPLIT) && args.getOperationResult().isSuccess()) {
            BigDecimal plantime = (BigDecimal)this.getModel().getValue("plantime");
            if (plantime.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5de5\u671f\u4efb\u52a1\u65e0\u9700\u62c6\u5206\u3002", (String)"PmtsTaskBillPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue(PLANSTARTDATE) == null || this.getModel().getValue(PLANENDDATE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u6216\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u62c6\u5206\u3002", (String)"PmtsTaskBillPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            BigDecimal finishpercent = (BigDecimal)this.getModel().getValue("finishpercent");
            if (finishpercent.compareTo(new BigDecimal(100)) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5b9e\u9645\u8fdb\u5ea6\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u62c6\u5206\u3002", (String)"PmtsTaskBillPlugin_13", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            String scheduletype = (String)this.getModel().getValue("scheduletype");
            if (StringUtils.equals((CharSequence)scheduletype, (CharSequence)"1")) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setFormId("pmts_task_subsection");
                showParameter.setPkId(this.getModel().getValue("id"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TASKSPLIT));
                this.getView().showForm((FormShowParameter)showParameter);
            } else if (StringUtils.equals((CharSequence)scheduletype, (CharSequence)"3")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cc\u7a0b\u7891\u65e0\u9700\u62c6\u5206\u3002", (String)"PmtsTaskBillPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (this.getModel().getValue("status").equals("B") || this.getModel().getValue("status").equals("C")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_doc"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_doc"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_prev"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_prev"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"addline_next"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"delline_next"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_doc"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_doc"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_prev"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_prev"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"addline_next"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"delline_next"});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().getEntryEntity("stoptask_entry").clear();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getOperationKey()) {
            case "addline_doc": {
                FieldTip tips = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.notNull, "number", ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7f16\u7801", (String)"PmtsTaskBillPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                if (!StringUtils.isNotBlank((Object)this.getModel().getValue("number"))) {
                    this.getView().showFieldTip(tips);
                    evt.setCancel(true);
                    break;
                }
                tips.setSuccess(true);
                this.getView().showFieldTip(tips);
                break;
            }
        }
        super.beforeItemClick(evt);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (e.getEntryProp().getName().equals("documententry") && e.getRowDataEntities().length > 0) {
            int rowindex = e.getRowDataEntities()[0].getRowIndex();
            String number = this.getDocNumber(rowindex);
            this.getModel().setValue("docnumber", (Object)number, rowindex);
        } else if (e.getEntryProp().getName().equals("hmresourcesentity") && e.getRowDataEntities().length > 0) {
            int rowindex = e.getRowDataEntities()[0].getRowIndex();
            this.changeHsType("", this.getModel().getValue("hstype", rowindex), rowindex);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("hmresourcesentity")) {
            this.sumPlantime();
        }
    }

    private String getDocNumber(int rowindex) {
        String number = "";
        StringBuilder docnumber = new StringBuilder();
        docnumber.append(StringUtils.upperCase((String)this.getModel().getValue("number").toString())).append("-WD-").append(String.format("%06d", rowindex + 1));
        number = docnumber.toString();
        int size = this.getModel().getEntryEntity("documententry").size();
        ArrayList<String> ls = new ArrayList<String>(10);
        for (int i = 0; i < size; ++i) {
            ls.add(this.getModel().getValue("docnumber", i).toString());
        }
        if (!ls.isEmpty() && ls.contains(docnumber.toString())) {
            number = this.getDocNumber(++rowindex);
        }
        return number;
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (e.getEntryProp().getName().endsWith("documententry")) {
            HashSet<Long> dvlIds = new HashSet<Long>();
            for (int index : e.getRowIndexs()) {
                long dvlId = (Long)this.getModel().getValue("deliverablesid", index);
                if (dvlId <= 0L) continue;
                dvlIds.add(dvlId);
            }
            if (!dvlIds.isEmpty()) {
                this.getPageCache().put(DELIVERABLES, SerializationUtils.toJsonString(dvlIds));
            } else {
                this.getPageCache().put(DELIVERABLES, "");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(DELIVERABLES))) {
                DefaultEntityOperate op = (DefaultEntityOperate)e.getSource();
                op.getOption().setVariableValue(DELIVERABLES, this.getPageCache().get(DELIVERABLES));
            }
            formOperate.getOption().setVariableValue("pageId", this.getParentView().getPageId());
            Boolean iscopy = (Boolean)formOperate.getView().getFormShowParameter().getCustomParam("iscopy");
            if (iscopy != null && iscopy.booleanValue()) {
                this.getModel().setValue("orderno", (Object)0);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent ce) {
        super.closedCallBack(ce);
        if (ce.getActionId().equals("importDevls") && Objects.nonNull(ce.getReturnData())) {
            DynamicObject[] dys;
            ORM orm = ORM.create();
            ListSelectedRowCollection rows = (ListSelectedRowCollection)ce.getReturnData();
            Object[] pks = rows.getPrimaryKeyValues();
            ArrayList<String> addDelsIds = new ArrayList<String>(8);
            for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"pmpd_projectdeliverables", (String)"issyototask,task,entryentity,entryentity.attachment,entryentity.filename,entryentity.deliverytype", (QFilter[])new QFilter("id", "in", (Object)pks).toArray())) {
                DynamicObjectCollection entrys = dy.getDynamicObjectCollection("entryentity");
                if (!entrys.isEmpty()) {
                    addDelsIds.add(dy.getString("id"));
                }
                for (DynamicObject entry : entrys) {
                    boolean typeB = entry.getString("deliverytype").equals("B");
                    if (!typeB) continue;
                    DynamicObjectCollection atts = (DynamicObjectCollection)entry.get("attachment");
                    Map<String, DynamicObjectType> type = this.getTaskAttachMentType();
                    int index = this.getModel().createNewEntryRow("documententry");
                    this.getModel().setValue("docname", entry.get("filename"), index);
                    this.getModel().setValue("isfrompd", (Object)Boolean.TRUE, index);
                    this.getModel().setValue("deliverablesid", dy.getPkValue(), index);
                    this.getModel().setValue("uploaddate", (Object)new Date(), index);
                    this.getModel().setValue("uploadperson", (Object)RequestContext.get().getCurrUserId(), index);
                    MulBasedataDynamicObjectCollection docatts = (MulBasedataDynamicObjectCollection)this.getModel().getValue("attachment", index);
                    atts.forEach(att -> {
                        DynamicObject taskAtt = this.newDynamicObject((DynamicObjectType)type.get("attachment"));
                        taskAtt.set("FPKID", (Object)this.genLongId((DynamicObjectType)type.get("attachment")));
                        taskAtt.set("fbasedataid", att.get("fbasedataid"));
                        taskAtt.set("fbasedataid_id", att.get("fbasedataid_id"));
                        docatts.add(taskAtt);
                    });
                    this.getView().updateView("attachment", index);
                }
            }
            if (!addDelsIds.isEmpty()) {
                this.getPageCache().put("addIds", SerializationUtils.toJsonString(addDelsIds));
            }
        } else if (ce.getActionId().equals(TASKSPLIT) && Objects.nonNull(ce.getReturnData())) {
            this.getView().setEnable(StringUtils.equals((CharSequence)ce.getReturnData().toString(), (CharSequence)"empty") ? Boolean.TRUE : Boolean.FALSE, new String[]{PLANSTARTDATE, PLANENDDATE, "plantime"});
        }
    }

    private DynamicObject newDynamicObject(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(type);
    }

    private long genLongId(DynamicObjectType type) {
        ORM orm = ORM.create();
        return orm.genLongId((IDataEntityType)type);
    }

    private Map<String, DynamicObjectType> getTaskAttachMentType() {
        HashMap<String, DynamicObjectType> typeMap = new HashMap<String, DynamicObjectType>();
        MainEntityType pmtsType = MetadataServiceHelper.getDataEntityType((String)"pmts_task");
        DynamicObjectType attType = null;
        for (IDataEntityProperty prop : pmtsType.getProperties()) {
            if (!prop.getName().equals("documententry")) continue;
            EntryProp docentry = (EntryProp)prop;
            DynamicObjectType docType = docentry.getDynamicCollectionItemPropertyType();
            typeMap.put("documententry", docType);
            for (IDataEntityProperty subprop : docType.getProperties()) {
                if (!subprop.getName().equals("attachment")) continue;
                AttachmentProp attprop = (AttachmentProp)subprop;
                attType = attprop.getDynamicCollectionItemPropertyType();
                typeMap.put("attachment", attType);
            }
        }
        return typeMap;
    }
}

