/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;

public class ProjectPlanCompareSettingPlugin
extends AbstractBillPlugIn {
    private static final String ENTRYENTITY = "entryentity";
    private static final String TYPE = "type";
    private static final String COLORVALUE = "colorvalue";
    private static final String COLOR = "color";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{COLORVALUE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initColorEntrys();
        this.showColor();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showColor();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)COLORVALUE, (CharSequence)actionId) && returnData != null) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            if (rowIndex < 0) {
                return;
            }
            this.getModel().setValue(COLORVALUE, returnData);
            this.showColor();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)COLORVALUE, (CharSequence)key)) {
            this.showColorSelectForm();
        }
    }

    protected void initColorEntrys() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, 3);
        this.getModel().setValue(TYPE, (Object)"A", 0);
        this.getModel().setValue(COLORVALUE, (Object)"rgba(104,146,233,1)", 0);
        this.getModel().setValue(TYPE, (Object)"B", 1);
        this.getModel().setValue(COLORVALUE, (Object)"rgba(60,182,252,1)", 1);
        this.getModel().setValue(TYPE, (Object)"C", 2);
        this.getModel().setValue(COLORVALUE, (Object)"rgba(90,186,192,1)", 2);
    }

    protected void showColorSelectForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mpdm_color_selector");
        formShowParameter.setShowClose(false);
        formShowParameter.setShowTitle(false);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COLORVALUE));
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (rowIndex < 0) {
            return;
        }
        String colorValue = (String)this.getModel().getValue(COLORVALUE, rowIndex);
        if (StringUtils.isNotBlank((CharSequence)colorValue)) {
            formShowParameter.setCustomParam(COLOR, (Object)colorValue);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    protected void showColor() {
        int rowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String colorValue = (String)this.getModel().getValue(COLORVALUE, i);
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(COLOR);
            cellStyle.setBackColor(colorValue);
            cellStyleList.add(cellStyle);
        }
        entry.setCellStyle(cellStyleList);
    }
}

