/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;

public class ResetRelationPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String PREDELAYED = "predelayed";
    private static final String POSTDELAYED = "postdelayed";
    private static final String PROJECTID = "projectnum.id";
    private static final String TASKIDS = "taskId";
    private static final String POSTPOSITIONTASKENTRY = "postpositiontaskentry";
    private static final String POSTPOSITIONTASK = "postpositiontask";
    private static final String PREPOSITIONTASKENTRY = "prepositiontaskentry";
    private static final String PREPOSITIONTASK = "prepositiontask";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previoustask", "nexttask", BTNOK, BTNCANCEL});
        BasedataEdit preTask = (BasedataEdit)this.getControl(PREPOSITIONTASK);
        if (preTask != null) {
            preTask.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String projectIdStr = this.getPageCache().get(PROJECTID);
        QFilter filter = new QFilter(PROJECTID, "=", (Object)Long.parseLong(projectIdStr));
        filters.add(filter);
        DynamicObject taskDyn = (DynamicObject)this.getModel().getValue("task");
        QFilter filter2 = new QFilter("id", "!=", taskDyn.getPkValue());
        filters.add(filter2);
        List<String> existNumberList = this.getExistNumberList(PREPOSITIONTASKENTRY, PREPOSITIONTASK, POSTPOSITIONTASKENTRY, POSTPOSITIONTASK);
        if (existNumberList.size() > 0) {
            QFilter qFilter = new QFilter("number", "not in", existNumberList);
            filters.add(qFilter);
        }
        beforeF7SelectEvent.setCustomQFilters(filters);
    }

    private List<String> getExistNumberList(String entryName, String key, String otherEntryName, String otherKey) {
        DynamicObject entry;
        DynamicObject object;
        int i;
        int row = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(entryName);
        DynamicObjectCollection otherEntrys = this.getModel().getEntryEntity(otherEntryName);
        ArrayList<String> existNumberList = new ArrayList<String>();
        for (i = 0; i < entrys.size(); ++i) {
            if (i == row || !Objects.nonNull(object = (entry = (DynamicObject)entrys.get(i)).getDynamicObject(key))) continue;
            existNumberList.add(object.getString("number"));
        }
        for (i = 0; i < otherEntrys.size(); ++i) {
            entry = (DynamicObject)otherEntrys.get(i);
            object = entry.getDynamicObject(otherKey);
            if (!Objects.nonNull(object)) continue;
            existNumberList.add(object.getString("number"));
        }
        return existNumberList;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object taskId = this.getView().getFormShowParameter().getCustomParam(TASKIDS);
        if (taskId == null) {
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)taskId, (String)"pmts_task");
        this.getPageCache().put(PROJECTID, taskObj.getString(PROJECTID));
        this.initData(taskId);
        this.initColIndex(taskId);
    }

    private void initColIndex(Object curtaskid) {
        List ids = null;
        String idJson = this.getPageCache().get(TASKIDS);
        String projectid = this.getPageCache().get(PROJECTID);
        if (StringUtils.isEmpty((CharSequence)projectid)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
        } else {
            ids = this.getAllTask();
            if (ids == null || ids.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u65e0\u4efb\u52a1\u3002", (String)"ResetRelationPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            idJson = JSONObject.toJSONString((Object)ids);
            this.getPageCache().put(TASKIDS, idJson);
        }
        int colindex = ids.indexOf(curtaskid);
        if (colindex == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nexttask", "previoustaskbak"});
        } else if (colindex == ids.size() - 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttask", "previoustaskbak"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttask"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttaskbak", "previoustaskbak"});
        }
        this.getModel().setValue("colindex", (Object)colindex);
    }

    private List<Long> getAllTask() {
        ListView listView = (ListView)this.getView().getParentView();
        List ganttTaskModels = (List)GanttBigObjectCache.get((String)listView.getPageId(), (String)"dataList");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (GanttRowDataModel ganttModel : ganttTaskModels) {
            if (!ganttModel.getEntityFlag().contains("pmts_task")) continue;
            ids.add(Long.parseLong(ganttModel.getObjId()));
        }
        return ids;
    }

    private void initData(Object taskId) {
        this.getModel().deleteEntryData(PREPOSITIONTASKENTRY);
        this.getModel().deleteEntryData(POSTPOSITIONTASKENTRY);
        this.getModel().setValue("task", taskId);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmts_task");
        DynamicObjectCollection taskPreposition = task.getDynamicObjectCollection(PREPOSITIONTASKENTRY);
        DynamicObjectCollection taskPostposition = task.getDynamicObjectCollection(POSTPOSITIONTASKENTRY);
        if (!taskPreposition.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(PREPOSITIONTASKENTRY, taskPreposition.size());
            for (int i = 0; i < taskPreposition.size(); ++i) {
                DynamicObject taskPrep = (DynamicObject)taskPreposition.get(i);
                if (taskPrep.getDynamicObject(PREPOSITIONTASK) == null) continue;
                this.getModel().setValue(PREPOSITIONTASK, (Object)taskPrep.getDynamicObject(PREPOSITIONTASK), i);
                this.getModel().setValue("taskrelation", (Object)taskPrep.getString("taskrelation"), i);
                this.getModel().setValue(PREDELAYED, (Object)taskPrep.getBigDecimal(PREDELAYED), i);
            }
        }
        if (!taskPostposition.isEmpty()) {
            this.getModel().batchCreateNewEntryRow(POSTPOSITIONTASKENTRY, taskPostposition.size());
            for (int j = 0; j < taskPostposition.size(); ++j) {
                DynamicObject taskPost = (DynamicObject)taskPostposition.get(j);
                if (taskPost.getDynamicObject(POSTPOSITIONTASK) == null) continue;
                this.getModel().setValue(POSTPOSITIONTASK, (Object)taskPost.getDynamicObject(POSTPOSITIONTASK), j);
                this.getModel().setValue("taskrelationtwo", (Object)taskPost.getString("taskrelationtwo"), j);
                this.getModel().setValue(POSTDELAYED, (Object)taskPost.getBigDecimal(POSTDELAYED), j);
            }
        }
        if (this.getView().getParentView() instanceof ListView) {
            ListView listView = (ListView)this.getView().getParentView();
            Object project = GanttUtils.getFilterValue((String)PROJECTID, (String)listView.getPageId());
            long projectId = Objects.nonNull(project) ? (Long)project : 0L;
            BasedataEdit ctlprevtask = (BasedataEdit)this.getControl(PREPOSITIONTASK);
            BasedataEdit ctlposttask = (BasedataEdit)this.getControl(POSTPOSITIONTASK);
            QFilter proFilter = new QFilter(PROJECTID, "=", (Object)projectId);
            QFilter idFilter = new QFilter("id", "!=", taskId);
            ArrayList<QFilter> fs = new ArrayList<QFilter>();
            fs.add(proFilter);
            fs.add(idFilter);
            ctlprevtask.setQFilters(fs);
            ctlposttask.setQFilters(fs);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            switch (btn.getKey()) {
                case "btnok": {
                    this.saveRelation();
                    break;
                }
                case "previoustask": {
                    this.previousTask();
                    break;
                }
                case "nexttask": {
                    this.nextTask();
                    break;
                }
            }
        }
    }

    private void previousTask() {
        String idJson = this.getPageCache().get(TASKIDS);
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue("colindex").toString());
            if (colindex != 0) {
                Long taskid = (Long)ids.get(--colindex);
                this.initColIndex(taskid);
                this.initData(taskid);
            }
        }
    }

    private void nextTask() {
        String idJson = this.getPageCache().get(TASKIDS);
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue("colindex").toString());
            if (colindex != ids.size() - 1) {
                Long taskid = (Long)ids.get(++colindex);
                this.initColIndex(taskid);
                this.initData(taskid);
            }
        }
    }

    private void saveRelation() {
        DynamicObject entry;
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>();
        DynamicObject pageValue = this.getModel().getDataEntity(true);
        DynamicObject taskObj = (DynamicObject)this.getModel().getValue("task");
        DynamicObjectCollection resPreposition = pageValue.getDynamicObjectCollection(PREPOSITIONTASKENTRY);
        DynamicObjectCollection resPostposition = pageValue.getDynamicObjectCollection(POSTPOSITIONTASKENTRY);
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskObj.getPkValue(), (String)"pmts_task");
        DynamicObjectCollection taskPreposition = task.getDynamicObjectCollection(PREPOSITIONTASKENTRY);
        taskPreposition.clear();
        DynamicObjectCollection taskPostposition = task.getDynamicObjectCollection(POSTPOSITIONTASKENTRY);
        taskPostposition.clear();
        for (DynamicObject resPrep : resPreposition) {
            if (resPrep.getDynamicObject(PREPOSITIONTASK) == null) continue;
            entry = new DynamicObject(taskPreposition.getDynamicObjectType());
            entry.set(PREPOSITIONTASK, (Object)resPrep.getDynamicObject(PREPOSITIONTASK));
            entry.set("taskrelation", (Object)resPrep.getString("taskrelation"));
            entry.set(PREDELAYED, (Object)resPrep.getBigDecimal(PREDELAYED));
            taskPreposition.add((Object)entry);
        }
        for (DynamicObject resPost : resPostposition) {
            if (resPost.getDynamicObject(POSTPOSITIONTASK) == null) continue;
            entry = new DynamicObject(taskPostposition.getDynamicObjectType());
            entry.set(POSTPOSITIONTASK, (Object)resPost.getDynamicObject(POSTPOSITIONTASK));
            entry.set("taskrelationtwo", (Object)resPost.getString("taskrelationtwo"));
            entry.set(POSTDELAYED, (Object)resPost.getBigDecimal(POSTDELAYED));
            taskPostposition.add((Object)entry);
        }
        values.add(task);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("pageId", this.getView().getParentView().getPageId());
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmts_task", (DynamicObject[])values.toArray(new DynamicObject[values.size()]), (OperateOption)operateOption);
        if (operationResult.getAllErrorOrValidateInfo().isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5faa\u73af\u5f15\u7528\uff0c\u5f15\u7528\u8def\u5f84\u4e3a", (String)"ResetRelationPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) && operationResult.getMessage().contains(errorMsg)) {
                this.getView().showErrorNotification(operationResult.getMessage());
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ResetRelationPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            ProjectPlanTypeHelper.projectPlanTypeTaskEdit((List)operationResult.getSuccessPkIds());
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }
}

