/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StandardTaskPlugin
extends AbstractBillPlugIn {
    private static final String WORKCARD = "workcard";
    private static final String PROGROUP = "progroup";
    private static final String PROFESSION = "profession";
    private static final String CARDID = "cardid";
    private static final String CARDENTRYID = "cardentryid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit card = (TextEdit)this.getControl(WORKCARD);
        card.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)WORKCARD, (CharSequence)name) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || StringUtils.isEmpty((CharSequence)newValue.toString()))) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue(PROGROUP, null, rowIndex);
            this.getModel().setValue(PROFESSION, null, rowIndex);
            this.getModel().setValue(CARDID, (Object)0, rowIndex);
            this.getModel().setValue(CARDENTRYID, (Object)0, rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            this.deleteNullDatas();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)WORKCARD, (CharSequence)key)) {
            this.showWorkCardF7();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int ordinal1 = entryentity.getDynamicObjectType().getProperty(CARDID).getOrdinal();
        int ordinal2 = entryentity.getDynamicObjectType().getProperty(CARDENTRYID).getOrdinal();
        for (DynamicObject entry : entryentity) {
            entry.getDataEntityState().setBizChanged(ordinal1, false);
            entry.getDataEntityState().setBizChanged(ordinal2, false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)WORKCARD, (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            this.fillDatas(returnData);
        }
    }

    private void showWorkCardF7() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"mpdm_mrocardroute", (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, WORKCARD));
        QFilter filter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        listShowParameter.getListFilterParameter().getQFilters().add(filter);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void fillDatas(ListSelectedRowCollection returnData) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        for (int i = 0; i < returnData.size(); ++i) {
            ListSelectedRow selectedRow = returnData.get(i);
            long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
            Object entryPrimaryKeyValue = selectedRow.getEntryPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", (Object)primaryKeyValue);
            if (entryPrimaryKeyValue != null && (Long)entryPrimaryKeyValue != 0L) {
                qFilter = new QFilter("processentry.id", "=", entryPrimaryKeyValue);
            }
            String selectFields = "id,number,processentry.id,processentry.processgroup,processentry.professiona";
            DynamicObject mrocardroute = QueryServiceHelper.queryOne((String)"mpdm_mrocardroute", (String)selectFields, (QFilter[])qFilter.toArray());
            if (i == 0) {
                this.getModel().setValue(WORKCARD, mrocardroute.get("number"), rowIndex);
                this.getModel().setValue(PROGROUP, mrocardroute.get("processentry.processgroup"), rowIndex);
                this.getModel().setValue(PROFESSION, mrocardroute.get("processentry.professiona"), rowIndex);
                this.getModel().setValue(CARDID, mrocardroute.get("id"), rowIndex);
                this.getModel().setValue(CARDENTRYID, mrocardroute.get("processentry.id"), rowIndex);
                continue;
            }
            int[] entryentities = this.getModel().batchCreateNewEntryRow("entryentity", 1);
            this.getModel().setValue(WORKCARD, mrocardroute.get("number"), entryentities[0]);
            this.getModel().setValue(PROGROUP, mrocardroute.get("processentry.processgroup"), entryentities[0]);
            this.getModel().setValue(PROFESSION, mrocardroute.get("processentry.professiona"), entryentities[0]);
            this.getModel().setValue(CARDID, mrocardroute.get("id"), entryentities[0]);
            this.getModel().setValue(CARDENTRYID, mrocardroute.get("processentry.id"), entryentities[0]);
        }
    }

    private void deleteNullDatas() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        ArrayList<Integer> deletes = new ArrayList<Integer>(8);
        for (int i = 0; i < rowCount; ++i) {
            String workCard = (String)this.getModel().getValue(WORKCARD, i);
            if (!StringUtils.isBlank((CharSequence)workCard)) continue;
            deletes.add(i);
        }
        int[] deleteRows = new int[deletes.size()];
        for (int i = 0; i < deletes.size(); ++i) {
            deleteRows[i] = (Integer)deletes.get(i);
        }
        if (!deletes.isEmpty()) {
            this.getModel().deleteEntryRows("entryentity", deleteRows);
        }
    }
}

