/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.pmc.pmpd.common.util.TimeUnitUtils;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.common.util.DateUtil;

public class TaskCalTimePlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"projectnum", (CharSequence)name)) {
            this.setTimeUnit();
        } else if (StringUtils.equals((CharSequence)"firststartdate", (CharSequence)name) || StringUtils.equals((CharSequence)"firstenddate", (CharSequence)name) || StringUtils.equals((CharSequence)"laststartdate", (CharSequence)name) || StringUtils.equals((CharSequence)"lastenddate", (CharSequence)name)) {
            this.calTotalFloatTime();
        } else if (StringUtils.equals((CharSequence)"postpositiontask", (CharSequence)name)) {
            this.calFreeFloatTime();
        } else if (StringUtils.equals((CharSequence)"firstenddate", (CharSequence)name)) {
            this.calTotalFloatTime();
            this.calFreeFloatTime();
        } else if (StringUtils.equals((CharSequence)"planstartdate", (CharSequence)name)) {
            this.calTimeByPlanTime();
            this.changeDelayed(e.getProperty().getName());
            Date planStartDate = (Date)this.getModel().getValue("planstartdate");
            if (planStartDate != null) {
                DateTimeEdit planEndDate = (DateTimeEdit)this.getControl("planenddate");
                planEndDate.setMinDate(planStartDate);
            } else {
                Date minxDate = new Date(1662631L);
                DateTimeEdit planEndDate = (DateTimeEdit)this.getControl("planenddate");
                planEndDate.setMinDate(minxDate);
                Date maxDate = new Date(4102379431000L);
                DateTimeEdit planStartDateEdit = (DateTimeEdit)this.getControl("planstartdate");
                planStartDateEdit.setMaxDate(maxDate);
            }
        } else if (StringUtils.equals((CharSequence)"planenddate", (CharSequence)name)) {
            this.calPlanTime();
            this.changeDelayed(e.getProperty().getName());
            Date planEndDate = (Date)this.getModel().getValue("planenddate");
            if (planEndDate != null) {
                DateTimeEdit planStartDate = (DateTimeEdit)this.getControl("planstartdate");
                planStartDate.setMaxDate(planEndDate);
            } else {
                Date maxDate = new Date(4102379431000L);
                DateTimeEdit planStartDate = (DateTimeEdit)this.getControl("planstartdate");
                planStartDate.setMaxDate(maxDate);
            }
        } else if (StringUtils.equals((CharSequence)"plantime", (CharSequence)name)) {
            this.calTimeByPlanTime();
        } else if (StringUtils.equals((CharSequence)"finishpercent", (CharSequence)name)) {
            BigDecimal finishpercent = (BigDecimal)this.getModel().getValue("finishpercent");
            String bizType = (String)this.getModel().getValue("biztype");
            if ("B".equals(bizType) && finishpercent != null && BigDecimal.ZERO.compareTo(finishpercent) != 0 && finishpercent.compareTo(new BigDecimal(100)) != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210\u767e\u5206\u6bd4\u53ea\u80fd\u4e3a0\u6216100\u3002", (String)"TaskCalTimePlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("finishpercent", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW == status) {
            this.calPlanTime();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Date minxDate = new Date(1662631L);
        Date maxDate = new Date(4102379431000L);
        DateTimeEdit planStartDate = (DateTimeEdit)this.getControl("planstartdate");
        DateTimeEdit planEndDate = (DateTimeEdit)this.getControl("planenddate");
        planStartDate.setMinDate(minxDate);
        planEndDate.setMinDate(minxDate);
        planStartDate.setMaxDate(maxDate);
        planEndDate.setMaxDate(maxDate);
    }

    private void changeDelayed(String properName) {
        Map dateMap;
        Date planstartdate = (Date)this.getModel().getValue("planstartdate");
        Date planenddate = (Date)this.getModel().getValue("planenddate");
        BigDecimal plantime = (BigDecimal)this.getModel().getValue("plantime");
        DynamicObject durationunit = (DynamicObject)this.getModel().getValue("durationunit");
        BigDecimal unit = PmtsTaskValueHelper.getUnit((DynamicObject)durationunit);
        if (unit == null) {
            return;
        }
        long seconds = plantime.multiply(unit).divide(new BigDecimal(1000)).longValue();
        if (properName.equals("planstartdate")) {
            if (Objects.nonNull(planstartdate)) {
                planenddate = DateUtil.addSecond((Date)planstartdate, (long)seconds);
            }
        } else if (Objects.nonNull(planenddate)) {
            planstartdate = DateUtil.reduceSecond((Date)planenddate, (long)seconds);
        }
        if ((dateMap = PmtsTaskValueHelper.getStartEndDate((Date)planstartdate, (Date)planenddate, (long)seconds)).isEmpty()) {
            return;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("prepositiontaskentry");
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String relation = dynamicObject.getString("taskrelation");
            DynamicObject positiontask = dynamicObject.getDynamicObject("prepositiontask");
            if (Objects.isNull(positiontask) || StringUtils.isBlank((CharSequence)relation)) continue;
            BigDecimal postplantime = positiontask.getBigDecimal("plantime");
            seconds = postplantime.multiply(unit).divide(new BigDecimal(1000)).longValue();
            Map pdateMap = PmtsTaskValueHelper.getStartEndDate((Date)positiontask.getDate("planstartdate"), (Date)positiontask.getDate("planenddate"), (long)seconds);
            if (pdateMap.isEmpty()) continue;
            Long timestamp = 0L;
            switch (relation) {
                case "1": {
                    timestamp = ((Date)dateMap.get("planstartdate")).getTime() - ((Date)pdateMap.get("planenddate")).getTime();
                    break;
                }
                case "2": {
                    timestamp = ((Date)dateMap.get("planenddate")).getTime() - ((Date)pdateMap.get("planenddate")).getTime();
                    break;
                }
                case "3": {
                    timestamp = ((Date)dateMap.get("planstartdate")).getTime() - ((Date)pdateMap.get("planstartdate")).getTime();
                    break;
                }
                case "4": {
                    timestamp = ((Date)dateMap.get("planenddate")).getTime() - ((Date)pdateMap.get("planstartdate")).getTime();
                    break;
                }
            }
            this.getModel().beginInit();
            BigDecimal delayed = new BigDecimal(timestamp).divide(unit, 2, 4);
            this.getModel().setValue("predelayed", (Object)delayed, index);
            this.getModel().endInit();
            ++index;
        }
        this.getView().updateView("prepositiontaskentry");
    }

    private void setTimeUnit() {
        DynamicObject projectnum = (DynamicObject)this.getModel().getValue("projectnum");
        if (projectnum != null) {
            this.getModel().setValue("durationunit", projectnum.get("timeunit"));
            this.calPlanTime();
        }
    }

    protected void calPlanTime() {
        Date planStartDate = (Date)this.getModel().getValue("planstartdate");
        Date planEndDate = (Date)this.getModel().getValue("planenddate");
        this.getModel().beginInit();
        if (planStartDate != null && planEndDate != null) {
            BigDecimal planTime = this.calPeriond(planStartDate, planEndDate);
            this.getModel().setValue("plantime", (Object)planTime);
            this.getModel().setValue("needtime", (Object)planTime);
        }
        this.getModel().endInit();
        this.getView().updateView("plantime");
        this.getView().updateView("needtime");
    }

    protected void calTimeByPlanTime() {
        Date planStartDate = (Date)this.getModel().getValue("planstartdate");
        BigDecimal planTime = (BigDecimal)this.getModel().getValue("plantime");
        this.getModel().beginInit();
        this.getModel().setValue("planenddate", (Object)this.calPlanEndTime(planStartDate, planTime));
        this.getModel().endInit();
        this.getView().updateView("planenddate");
    }

    protected Date calPlanEndTime(Date planStartDate, BigDecimal planTime) {
        DynamicObject timeunit;
        Date planEndTime = null;
        if (planStartDate != null && planTime != null && (timeunit = (DynamicObject)this.getModel().getValue("durationunit")) != null) {
            planEndTime = TimeUnitUtils.calEndDate((String)timeunit.getString("number"), (Date)planStartDate, (BigDecimal)planTime);
        }
        return planEndTime;
    }

    protected void calTotalFloatTime() {
        Date firstStartDate = (Date)this.getModel().getValue("firststartdate");
        Date lastStartDate = (Date)this.getModel().getValue("laststartdate");
        Date firstEndDate = (Date)this.getModel().getValue("firstenddate");
        Date lastEndDate = (Date)this.getModel().getValue("lastenddate");
        BigDecimal totalfloattime = BigDecimal.ZERO;
        if (firstStartDate != null && lastStartDate != null) {
            totalfloattime = this.calPeriond(firstStartDate, lastStartDate);
        }
        if (firstEndDate != null && lastEndDate != null) {
            totalfloattime = this.calPeriond(firstEndDate, lastEndDate);
        }
        this.getModel().setValue("totalfloattime", (Object)totalfloattime);
    }

    protected void calFreeFloatTime() {
        Date firstenddate = (Date)this.getModel().getValue("firstenddate");
        if (firstenddate == null) {
            return;
        }
        Date postFirstBeginDate = null;
        int rowCount = this.getModel().getEntryRowCount("postpositiontaskentry");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject postPositionTask = (DynamicObject)this.getModel().getValue("postpositiontask", i);
            Date taskBeginDate = (Date)postPositionTask.get("firststartdate");
            if (postFirstBeginDate == null && taskBeginDate != null) {
                postFirstBeginDate = taskBeginDate;
                continue;
            }
            if (postFirstBeginDate == null || taskBeginDate == null || taskBeginDate.compareTo(postFirstBeginDate) >= 0) continue;
            postFirstBeginDate = taskBeginDate;
        }
        if (postFirstBeginDate == null) {
            return;
        }
        this.getModel().setValue("totalfloattime", (Object)BigDecimal.valueOf(this.daysBetween(postFirstBeginDate, firstenddate)));
    }

    private BigDecimal calPeriond(Date startdate, Date finshdate) {
        DynamicObject timeunit = (DynamicObject)this.getModel().getValue("durationunit");
        BigDecimal period = BigDecimal.ZERO;
        if (timeunit != null) {
            String timeUnitNo = timeunit.getString("number");
            period = TimeUnitUtils.calPeriod((String)timeUnitNo, (Date)startdate, (Date)finshdate);
        }
        return period;
    }

    private int daysBetween(Date startdate, Date finshdate) {
        return 0;
    }
}

