/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.model.TaskDocumentModel;

public class TaskDocEditPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String ADDLINE = "addline";
    private static final String DELLINE = "delline";
    private static final String COLINDEX = "colindex";
    private static final String ENTRYID = "entryid";
    private static final String TASKIDS = "taskId";
    private static final String PROJECTID = "projectnum.id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL, "previoustask", "nexttask"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection attachs;
        super.propertyChanged(e);
        ChangeData[] datas = e.getChangeSet();
        if (Objects.equals(e.getProperty().getName(), "attachment") && Objects.nonNull(datas[0].getNewValue()) && !(attachs = (DynamicObjectCollection)datas[0].getNewValue()).isEmpty()) {
            this.getModel().setValue("donestatus", (Object)"2", datas[0].getRowIndex());
            this.getModel().setValue("uploaddate", (Object)Calendar.getInstance().getTime(), datas[0].getRowIndex());
            this.getModel().setItemValueByID("uploadperson", (Object)Long.parseLong(RequestContext.get().getUserId()), datas[0].getRowIndex());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().beginInit();
        Object taskId = this.getView().getFormShowParameter().getCustomParam(TASKIDS);
        if (taskId == null) {
            return;
        }
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmts_task");
        this.getPageCache().put(PROJECTID, taskObj.getString(PROJECTID));
        this.initData(taskId);
        this.initColIndex(taskId);
    }

    private void initColIndex(Object curtaskid) {
        List ids = null;
        String idJson = this.getPageCache().get(TASKIDS);
        String projectid = this.getPageCache().get(PROJECTID);
        if (StringUtils.isEmpty((CharSequence)projectid)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
        } else {
            ids = this.getAllTask(projectid);
            if (ids == null || ids.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u65e0\u4efb\u52a1\u3002", (String)"TaskDocEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            idJson = JSONObject.toJSONString((Object)ids);
            this.getPageCache().put(TASKIDS, idJson);
        }
        int colindex = ids.indexOf(Long.parseLong(curtaskid.toString()));
        DynamicObject currTask = BusinessDataServiceHelper.loadSingle((Object)curtaskid, (String)"pmts_task");
        if (currTask.getString("executestatus").equals("4")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADDLINE});
            this.getView().setEnable(Boolean.FALSE, new String[]{DELLINE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"documententry"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{ADDLINE});
            this.getView().setEnable(Boolean.TRUE, new String[]{DELLINE});
            this.getView().setEnable(Boolean.TRUE, new String[]{"documententry"});
        }
        if (colindex <= 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nexttask", "previoustaskbak"});
        } else if (colindex == ids.size() - 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttask", "previoustaskbak"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttask"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttaskbak", "previoustaskbak"});
        }
        this.getModel().setValue(COLINDEX, (Object)colindex);
    }

    private List<Long> getAllTask(String projectid) {
        ListView listView = (ListView)this.getView().getParentView();
        List ganttTaskModels = (List)GanttBigObjectCache.get((String)listView.getPageId(), (String)"dataList");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (GanttRowDataModel ganttModel : ganttTaskModels) {
            if (!ganttModel.getEntityFlag().contains("pmts_task")) continue;
            ids.add(Long.parseLong(ganttModel.getObjId()));
        }
        return ids;
    }

    private void initData(Object taskId) {
        this.getModel().deleteEntryData("documententry");
        DynamicObject currTask = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"pmts_task");
        if (currTask.getString("executestatus").equals("4")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ADDLINE});
            this.getView().setEnable(Boolean.FALSE, new String[]{DELLINE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"documententry"});
        }
        DynamicObjectCollection currDocentrys = currTask.getDynamicObjectCollection("documententry");
        this.getModel().setValue("number", taskId);
        if (!currDocentrys.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("documententry", currDocentrys.size());
            DynamicObject data = this.getModel().getDataEntity();
            for (int i = 0; i < currDocentrys.size(); ++i) {
                DynamicObject docentry = (DynamicObject)currDocentrys.get(i);
                ((DynamicObject)data.getDynamicObjectCollection("documententry").get(i)).set("attachment", (Object)docentry.getDynamicObjectCollection("attachment"));
                this.getModel().setValue("docnumber", (Object)docentry.getString("docnumber"), i);
                this.getModel().setValue("docname", (Object)docentry.getString("docname"), i);
                this.getModel().setValue("doctype", (Object)docentry.getString("doctype"), i);
                this.getModel().setValue("docplandate", (Object)docentry.getDate("docplandate"), i);
                this.getModel().setValue("donestatus", (Object)docentry.getString("donestatus"), i);
                this.getModel().setValue("uploadperson", (Object)docentry.getDynamicObject("uploadperson"), i);
                this.getModel().setValue(ENTRYID, (Object)docentry.getPkValue().toString(), i);
                this.getView().updateView("attachment", i);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (Objects.equals(((Button)evt.getSource()).getKey(), BTNOK)) {
            this.checkDatas(evt);
        }
    }

    private void checkDatas(BeforeClickEvent evt) {
        int rowindex = ((EntryGrid)this.getControl("documententry")).getEntryData().getEndIndex();
        DynamicObject taskObj = (DynamicObject)this.getModel().getValue("number");
        for (int i = 0; i < rowindex; ++i) {
            if (StringUtils.isBlank((Object)this.getModel().getValue("docnumber", i))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6587\u6863\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskDocEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1));
                evt.setCancel(true);
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue("docname", i))) {
                String autoName = taskObj.getString("name") + "_" + i;
                this.getModel().setValue("docname", (Object)autoName, i);
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue("doctype", i))) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6587\u6863\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskDocEditPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1));
                evt.setCancel(true);
            }
            if (!StringUtils.isBlank((Object)this.getModel().getValue("docplandate", i)) || !Objects.nonNull(taskObj.get("planenddate"))) continue;
            Date pendDate = taskObj.getDate("planenddate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(pendDate);
            calendar.add(5, -1);
            this.getModel().setValue("docplandate", (Object)calendar.getTime(), i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            switch (btn.getKey()) {
                case "btnok": {
                    this.saveDocument();
                    break;
                }
                case "previoustask": {
                    this.previousTask();
                    break;
                }
                case "nexttask": {
                    this.nextTask();
                    break;
                }
            }
        }
    }

    private void saveDocument() {
        int rowindex = ((EntryGrid)this.getControl("documententry")).getEntryData().getEndIndex();
        DynamicObject taskObj = (DynamicObject)this.getModel().getValue("number");
        DynamicObject task = BusinessDataServiceHelper.loadSingle((Object)taskObj.getPkValue(), (String)"pmts_task");
        DynamicObjectCollection taskdocs = task.getDynamicObjectCollection("documententry");
        ArrayList<String> docnumbers = new ArrayList<String>();
        if (rowindex > 0) {
            for (int i = 0; i < rowindex; ++i) {
                docnumbers.add(this.getModel().getValue(ENTRYID, i).toString());
                String entryid = this.getModel().getValue(ENTRYID, i).toString();
                String docnumber = (String)this.getModel().getValue("docnumber", i);
                String docname = (String)this.getModel().getValue("docname", i);
                String doctype = (String)this.getModel().getValue("doctype", i);
                String donestatus = (String)this.getModel().getValue("donestatus", i);
                Date docplandate = (Date)this.getModel().getValue("docplandate", i);
                Date uploaddate = (Date)this.getModel().getValue("uploaddate", i);
                TaskDocumentModel docmodel = new TaskDocumentModel();
                docmodel.setId(entryid);
                docmodel.setDocnumber(docnumber);
                docmodel.setDocname(docname);
                docmodel.setDoctype(doctype);
                docmodel.setDonestatus(donestatus);
                docmodel.setDocplandate(docplandate);
                docmodel.setUploaddate(uploaddate);
                docmodel.setAttachment(this.getModel().getValue("attachment", i));
                TaskDocConsumer docs = new TaskDocConsumer(docmodel);
                taskdocs.forEach((Consumer)docs);
                if (docs.iscontinue) continue;
                DynamicObject taskdoc = taskdocs.addNew();
                taskdoc.set("docnumber", this.getModel().getValue("docnumber", i));
                taskdoc.set("docname", this.getModel().getValue("docname", i));
                taskdoc.set("donestatus", this.getModel().getValue("donestatus", i));
                taskdoc.set("doctype", this.getModel().getValue("doctype", i));
                taskdoc.set("docplandate", this.getModel().getValue("docplandate", i));
                taskdoc.set("uploaddate", this.getModel().getValue("uploaddate", i));
                taskdoc.set("uploadperson", this.getModel().getValue("uploadperson", i));
                taskdoc.set("attachment", this.getModel().getValue("attachment", i));
            }
            if (!docnumbers.isEmpty()) {
                taskdocs.removeIf((Predicate)new TaskDocPredicate(docnumbers));
            }
        } else {
            taskdocs.clear();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{task});
        this.initData(taskObj.getPkValue());
        this.initColIndex(taskObj.getPkValue());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskDocEditPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
    }

    private void previousTask() {
        String idJson = this.getPageCache().get(TASKIDS);
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue(COLINDEX).toString());
            if (colindex != 0) {
                Long taskid = (Long)ids.get(--colindex);
                this.initColIndex(taskid);
                this.initData(taskid);
            }
        }
    }

    private void nextTask() {
        String idJson = this.getPageCache().get(TASKIDS);
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue(COLINDEX).toString());
            if (colindex != ids.size() - 1) {
                Long taskid = (Long)ids.get(++colindex);
                this.initColIndex(taskid);
                this.initData(taskid);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (e.getRowDataEntities().length > 0) {
            int rowindex = e.getRowDataEntities()[0].getRowIndex();
            String number = this.getDocNumber(rowindex);
            this.getModel().setValue("docnumber", (Object)number, rowindex);
        }
    }

    private String getDocNumber(int rowindex) {
        String number = "";
        StringBuilder docnumber = new StringBuilder();
        DynamicObject taskObj = (DynamicObject)this.getModel().getValue("number");
        docnumber.append(StringUtils.upperCase((String)taskObj.getString("number"))).append("-WD-").append(String.format("%06d", rowindex + 1));
        number = docnumber.toString();
        int size = this.getModel().getEntryEntity("documententry").size();
        ArrayList<String> ls = new ArrayList<String>(10);
        for (int i = 0; i < size; ++i) {
            ls.add(this.getModel().getValue("docnumber", i).toString());
        }
        if (!ls.isEmpty() && ls.contains(docnumber.toString())) {
            number = this.getDocNumber(++rowindex);
        }
        return number;
    }

    static class TaskDocPredicate
    implements Predicate<DynamicObject> {
        private List list;

        TaskDocPredicate(List list) {
            this.list = list;
        }

        @Override
        public boolean test(DynamicObject t) {
            if (t.getString("id").equals("0")) {
                return false;
            }
            return !this.list.contains(t.getString("id"));
        }
    }

    static class TaskDocConsumer
    implements Consumer<DynamicObject> {
        private TaskDocumentModel docmodel;
        private boolean iscontinue;

        TaskDocConsumer(TaskDocumentModel docmodel) {
            this.docmodel = docmodel;
        }

        @Override
        public void accept(DynamicObject t) {
            if (t.getString("id").equals(this.docmodel.getId())) {
                t.set("attachment", this.docmodel.getAttachment());
                t.set("docnumber", (Object)this.docmodel.getDocnumber());
                t.set("donestatus", (Object)this.docmodel.getDonestatus());
                t.set("docname", (Object)this.docmodel.getDocname());
                t.set("doctype", (Object)this.docmodel.getDoctype());
                t.set("docplandate", (Object)this.docmodel.getDocplandate());
                t.set("uploaddate", (Object)this.docmodel.getUploaddate());
                this.setIscontinue(true);
            }
        }

        public boolean isIscontinue() {
            return this.iscontinue;
        }

        public void setIscontinue(boolean iscontinue) {
            this.iscontinue = iscontinue;
        }
    }
}

