/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.enums.HsTypeEnum;

public class TaskRsAllocationEditPlugin
extends AbstractFormPlugin {
    private static ORM orm = ORM.create();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String taskid = (String)this.getView().getFormShowParameter().getCustomParam("curtaskid");
        Long projectid = (Long)this.getView().getFormShowParameter().getCustomParam("projectid");
        if (taskid == null || projectid == null) {
            return;
        }
        long curtaskid = Long.parseLong(taskid);
        this.getModel().setValue("projectid", (Object)projectid);
        this.initData(curtaskid);
        this.initColIndex(projectid, curtaskid);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previoustask", "nexttask", "btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object obj = evt.getSource();
        String btnKey = "";
        if (obj instanceof Button) {
            btnKey = ((Button)obj).getKey();
        }
        switch (btnKey) {
            case "previoustask": {
                this.previousTask();
                break;
            }
            case "nexttask": {
                this.nextTask();
                break;
            }
            case "btnok": {
                this.save();
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (e.getEntryProp().getName().equals("entryentity") && e.getRowDataEntities().length > 0) {
            int rowindex = e.getRowDataEntities()[0].getRowIndex();
            this.changeHsType("", this.getModel().getValue("hstype", rowindex), rowindex);
        }
    }

    private void save() {
        Long taskid = Long.parseLong(this.getModel().getValue("taskid").toString());
        DynamicObjectCollection entryEntityColl = this.getModel().getEntryEntity("entryentity");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"pmts_task");
        DynamicObject currTask = BusinessDataServiceHelper.loadSingle((Object)taskid, (DynamicObjectType)type);
        if (currTask != null) {
            DynamicObjectCollection dynColl = currTask.getDynamicObjectCollection("hmresourcesentity");
            dynColl.clear();
            DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType("pmts_task.hmresourcesentity");
            if (entryEntityColl != null) {
                BigDecimal bg = new BigDecimal(0);
                for (int i = 0; i < entryEntityColl.size(); ++i) {
                    DynamicObject dyn = new DynamicObject(entityType);
                    dyn.set("hsmain", (Object)((DynamicObject)entryEntityColl.get(i)).getString("hsmain"));
                    dyn.set("hsplanabilitytime", (Object)((DynamicObject)entryEntityColl.get(i)).getBigDecimal("hsplanabilitytime"));
                    dyn.set("hsplanneedtime", (Object)((DynamicObject)entryEntityColl.get(i)).getBigDecimal("hsplanneedtime"));
                    bg = bg.add(((DynamicObject)entryEntityColl.get(i)).getBigDecimal("hsplanabilitytime"));
                    bg = bg.add(((DynamicObject)entryEntityColl.get(i)).getBigDecimal("hsplanneedtime"));
                    dyn.set("hsrole", (Object)((DynamicObject)entryEntityColl.get(i)).getString("hsrole.id"));
                    dyn.set("hstype", (Object)((DynamicObject)entryEntityColl.get(i)).getString("hstype"));
                    dyn.set("hsuser", (Object)((DynamicObject)entryEntityColl.get(i)).getLong("hsuser.id"));
                    dynColl.add((Object)dyn);
                }
                currTask.set("planhours", (Object)bg);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currTask});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4eba\u529b\u8d44\u6e90\u5206\u914d\u6210\u529f\u3002", (String)"TaskRsAllocationEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void nextTask() {
        String idJson = this.getPageCache().get("taskids");
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue("colindex").toString());
            if (colindex != ids.size() - 1) {
                Long taskid = (Long)ids.get(++colindex);
                Long projectid = Long.parseLong(this.getModel().getValue("projectid").toString());
                this.initColIndex(projectid, taskid);
                this.initData(taskid);
            }
        }
    }

    private void previousTask() {
        String idJson = this.getPageCache().get("taskids");
        List ids = null;
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
            int colindex = Integer.parseInt(this.getModel().getValue("colindex").toString());
            if (colindex != 0) {
                Long taskid = (Long)ids.get(--colindex);
                Long projectid = Long.parseLong(this.getModel().getValue("projectid").toString());
                this.initColIndex(projectid, taskid);
                this.initData(taskid);
            }
        }
    }

    private void initColIndex(long projectid, long curtaskid) {
        List ids = null;
        String idJson = this.getPageCache().get("taskids");
        if (StringUtils.isNotEmpty((CharSequence)idJson)) {
            ids = (List)JSONObject.parseObject((String)idJson, List.class);
        } else {
            ids = this.getAllTask();
            if (ids == null || ids.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u65e0\u4efb\u52a1\u3002", (String)"TaskRsAllocationEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            idJson = JSONObject.toJSONString((Object)ids);
            this.getPageCache().put("taskids", idJson);
        }
        int colindex = ids.indexOf(curtaskid);
        if (colindex == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nexttask", "previoustaskbak"});
        } else if (colindex == ids.size() - 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttaskbak"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttask", "previoustaskbak"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"previoustask", "nexttask"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nexttaskbak", "previoustaskbak"});
        }
        this.getModel().setValue("colindex", (Object)colindex);
    }

    private List<Long> getAllTask() {
        ListView listView = (ListView)this.getView().getParentView();
        List ganttTaskModels = (List)GanttBigObjectCache.get((String)listView.getPageId(), (String)"dataList");
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (GanttRowDataModel ganttModel : ganttTaskModels) {
            if (!ganttModel.getEntityFlag().contains("pmts_task")) continue;
            ids.add(Long.parseLong(ganttModel.getObjId()));
        }
        return ids;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int line = changeData.getRowIndex();
        switch (e.getProperty().getName()) {
            case "hstype": {
                this.changeHsType(oldValue, newValue, line);
                break;
            }
            case "hsrole": {
                this.changeRole(oldValue, newValue, line);
                break;
            }
            case "hsuser": {
                this.changeUser(oldValue, newValue, line);
                break;
            }
        }
    }

    private void changeUser(Object oldValue, Object newValue, int line) {
        if (newValue != null) {
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hsrole"});
            this.getModel().setValue("hstype", (Object)"A", line);
        }
    }

    private void changeRole(Object oldValue, Object newValue, int line) {
        if (newValue != null) {
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hsuser"});
            this.getModel().setValue("hstype", (Object)"B", line);
        }
    }

    private void changeHsType(Object oldValue, Object newValue, int line) {
        if (oldValue != null && newValue != null && oldValue.toString().equalsIgnoreCase(newValue.toString())) {
            return;
        }
        if (HsTypeEnum.ROLE.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.TRUE, line, new String[]{"hsrole"});
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hspicture", "hsuser"});
            this.getModel().setValue("hsuser", null, line);
        } else if (HsTypeEnum.USER.getValue().equals(newValue)) {
            this.getView().setEnable(Boolean.FALSE, line, new String[]{"hsrole"});
            this.getView().setEnable(Boolean.TRUE, line, new String[]{"hspicture", "hsuser"});
            this.getModel().setValue("hsrole", null, line);
        }
    }

    private void initData(long curtaskid) {
        this.getModel().setValue("taskid", (Object)curtaskid);
        DynamicObjectCollection taskDynColl = this.getTask(curtaskid);
        if (!taskDynColl.isEmpty()) {
            this.getModel().setValue("tasknumber", (Object)((DynamicObject)taskDynColl.get(0)).getString("number"));
            this.getModel().setValue("taskname", (Object)((DynamicObject)taskDynColl.get(0)).getString("name"));
            this.getModel().setValue("planstarttime", (Object)((DynamicObject)taskDynColl.get(0)).getDate("planstartdate"));
            this.getModel().setValue("planendtime", (Object)((DynamicObject)taskDynColl.get(0)).getDate("planenddate"));
            this.deleteEntryAllRow("entryentity");
            if (((DynamicObject)taskDynColl.get(0)).getString("hmresourcesentity.hstype") == null) {
                return;
            }
            this.getModel().batchCreateNewEntryRow("entryentity", taskDynColl.size());
            int size = taskDynColl.size();
            for (int i = 0; i < size; ++i) {
                this.getModel().setValue("hsmain", (Object)((DynamicObject)taskDynColl.get(i)).getString("hmresourcesentity.hsmain"), i);
                this.getModel().setValue("hsplanabilitytime", (Object)((DynamicObject)taskDynColl.get(i)).getBigDecimal("hmresourcesentity.hsplanabilitytime"), i);
                this.getModel().setValue("hsplanneedtime", (Object)((DynamicObject)taskDynColl.get(i)).getBigDecimal("hmresourcesentity.hsplanneedtime"), i);
                this.getModel().setValue("hsrole", (Object)((DynamicObject)taskDynColl.get(i)).getString("hmresourcesentity.hsrole"), i);
                this.getModel().setValue("hstype", (Object)((DynamicObject)taskDynColl.get(i)).getString("hmresourcesentity.hstype"), i);
                this.changeHsType("", ((DynamicObject)taskDynColl.get(i)).getString("hmresourcesentity.hstype"), i);
                this.getModel().setValue("hsuser", (Object)((DynamicObject)taskDynColl.get(i)).getLong("hmresourcesentity.hsuser"), i);
            }
        }
    }

    private void deleteEntryAllRow(String entryEntity) {
        int size = this.getModel().getEntryRowCount(entryEntity);
        if (size == 0) {
            return;
        }
        int[] line = new int[size];
        for (int i = 0; i < size; ++i) {
            line[i] = i;
        }
        this.getModel().deleteEntryRows(entryEntity, line);
    }

    private DynamicObjectCollection getTask(Long taskid) {
        String selectFields = TaskRsAllocationEditPlugin.getSelects("number", "name", "planstartdate", "planenddate", "hmresourcesentity", "hmresourcesentity.hsmain", "hmresourcesentity.hsplanabilitytime", "hmresourcesentity.hsplanneedtime", "hmresourcesentity.hsrole", "hmresourcesentity.hstype", "hmresourcesentity.hsuser");
        QFilter idsQFilter = new QFilter("id", "=", (Object)taskid);
        DynamicObjectCollection task = QueryServiceHelper.query((String)"pmts_task", (String)selectFields, (QFilter[])new QFilter[]{idsQFilter});
        return task;
    }

    private static String getSelects(String ... vals) {
        if (vals != null && vals.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                sb.append(vals[i]);
                sb.append(',');
            }
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }
}

