/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.TimeZone;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillView;
import kd.pmc.pmpd.common.util.TimeUnitUtils;
import kd.pmc.pmts.business.helper.DateTimeHelper;
import kd.pmc.pmts.common.consts.TaskSubsectionConst;
import org.apache.commons.lang3.time.DateUtils;

public class TaskSubsectionEditPlugin
extends AbstractBillPlugIn {
    private static final String ADD_FLAG = "addFlag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate formOperate = (FormOperate)e.getSource();
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            String pageId = this.getView().getParentView().getPageId();
            IFormView view = this.getView().getParentView();
            if (view instanceof BillView) {
                pageId = this.getView().getParentView().getFormShowParameter().getParentPageId();
            }
            formOperate.getOption().setVariableValue("pageId", pageId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("newentry".equals(operateKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("subsectionentry");
            if (rowIndex == 0) {
                this.getPageCache().put(ADD_FLAG, "true");
                this.getModel().setValue("subplanstartdate", this.getModel().getValue("planstartdate"), rowIndex);
                this.getModel().setValue("subfinishpercent", (Object)100, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"subfinishpercent"});
            } else {
                Date sectionStartTime = (Date)this.getModel().getValue("subplanstartdate", rowIndex - 1);
                Date sectionEndTime = (Date)this.getModel().getValue("subsubplanenddate", rowIndex - 1);
                BigDecimal subfinishpercent = (BigDecimal)this.getModel().getValue("subfinishpercent", rowIndex - 1);
                if (subfinishpercent.compareTo(BigDecimal.ZERO) == 0 && sectionStartTime != null && sectionEndTime != null) {
                    this.getPageCache().put(ADD_FLAG, "true");
                    this.getModel().setValue("subfinishpercent", (Object)100, rowIndex - 1);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex - 1, new String[]{"subfinishpercent"});
                }
                Date result = null;
                if (sectionEndTime != null) {
                    this.getPageCache().put(ADD_FLAG, "true");
                    result = DateUtils.addMinutes((Date)sectionEndTime, (int)1);
                    this.getModel().setValue("subplanstartdate", (Object)result, rowIndex);
                }
                BigDecimal subplanTime = (BigDecimal)this.getModel().getValue("plantime");
                for (int k = rowIndex - 1; k >= 0; --k) {
                    subplanTime = subplanTime.subtract((BigDecimal)this.getModel().getValue("subplantime", k));
                }
                if (subplanTime.doubleValue() > 0.0) {
                    this.getPageCache().put(ADD_FLAG, "true");
                    this.getModel().setValue("subplantime", (Object)subplanTime, rowIndex);
                    this.getPageCache().put(ADD_FLAG, "true");
                    this.getModel().setValue("subsubplanenddate", (Object)this.calPlanEndTime(result, subplanTime), rowIndex);
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initEntryDateRange();
        this.disableSort();
        this.getModel().setDataChanged(false);
        BigDecimal finishpercent = (BigDecimal)this.getModel().getValue("finishpercent");
        DynamicObjectCollection subsectionentry = this.getModel().getEntryEntity("subsectionentry");
        if (finishpercent.doubleValue() > 0.0 && subsectionentry.size() == 0) {
            DynamicObject newRow = subsectionentry.addNew();
            Date planStartDate = (Date)this.getModel().getValue("planstartdate");
            BigDecimal planTime = (BigDecimal)this.getModel().getValue("plantime");
            newRow.set("subplanstartdate", (Object)planStartDate);
            DynamicObject timeunit = (DynamicObject)this.getModel().getValue("durationunit");
            if (timeunit != null) {
                BigDecimal subplantime = planTime.multiply(finishpercent).divide(new BigDecimal(100)).setScale(2, 5);
                Date planEndTime = TimeUnitUtils.calEndDate((String)timeunit.getString("number"), (Date)planStartDate, (BigDecimal)subplantime);
                newRow.set("subsubplanenddate", (Object)planEndTime);
                newRow.set("subplantime", (Object)subplantime);
                newRow.set("subfinishpercent", (Object)100);
                this.getView().updateView("subsectionentry");
            }
        }
    }

    protected void disableSort() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("subsectionentry");
        List controls = entryGrid.getControls();
        for (Control control : controls) {
            entryGrid.setColumnProperty(control.getKey(), "sort", (Object)Boolean.FALSE);
        }
    }

    protected void initEntryDateRange() {
        Date startDateTime = (Date)this.getModel().getValue("planstartdate");
        DateTimeEdit startDateTimeEdit = (DateTimeEdit)this.getControl("subplanstartdate");
        DateTimeEdit endDateTimeEdit = (DateTimeEdit)this.getControl("subsubplanenddate");
        if (startDateTime != null) {
            startDateTimeEdit.setMinDate(startDateTime);
            endDateTimeEdit.setMinDate(startDateTime);
        }
    }

    protected void initDefaultSelectedDate() {
        TimeZone timeZone = DateTimeHelper.getTimeZone((IFormView)this.getView(), (String)"planstartdate");
        String minFormatString = DateTimeHelper.getMinFormatString((TimeZone)timeZone);
        String maxFormatString = DateTimeHelper.getMaxFormatString((TimeZone)timeZone);
        DateTimeHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"subsectionentry", (String)minFormatString, (List)TaskSubsectionConst.ENTRY_STARTDATETIME_KEYS);
        DateTimeHelper.setDefaultSelectedDate((IFormView)this.getView(), (String)"subsectionentry", (String)maxFormatString, (List)TaskSubsectionConst.ENTRY_ENDDATETIME_KEYS);
    }

    private String subsectionDateTimeChanged(Date changedDateTime, int rowIndex, boolean isStartDateTimeChanged, String name) {
        int entryRowCount;
        DynamicObjectCollection entryEntity;
        Date endDateTime;
        Date startDateTime;
        if (changedDateTime == null) {
            return "";
        }
        ArrayList<String> msgList = new ArrayList<String>();
        if (isStartDateTimeChanged) {
            startDateTime = changedDateTime;
            endDateTime = (Date)this.getModel().getValue("subsubplanenddate", rowIndex);
        } else {
            startDateTime = (Date)this.getModel().getValue("subplanstartdate", rowIndex);
            endDateTime = changedDateTime;
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"subsubplanenddate") && startDateTime != null && endDateTime != null && startDateTime.compareTo(endDateTime) >= 0) {
            msgList.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7684\u201c\u5206\u6bb5\u65f6\u95f4\u201d\u5e94\u65e9\u4e8e\u201c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u201d\u3002", (String)"TaskSubsectionEditPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), rowIndex + 1));
        }
        if (!(entryEntity = this.getModel().getEntryEntity("subsectionentry")).isEmpty()) {
            String prefix = ResManager.loadKDString((String)"\u5206\u6bb5\u8ba1\u5212\u65f6\u95f4\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"TaskSubsectionEditPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder(prefix);
            int size = entryEntity.size();
            for (int i = 0; i < size; ++i) {
                if (i == rowIndex) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                Date sectionStartTime = dynamicObject.getDate("subplanstartdate");
                Date sectionEndTime = dynamicObject.getDate("subsubplanenddate");
                if (sectionStartTime == null || sectionEndTime == null || changedDateTime.compareTo(sectionStartTime) < 0 || changedDateTime.compareTo(sectionEndTime) > 0) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"TaskSubsectionEditPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1)).append('\uff0c');
            }
            int strLength = sb.length();
            if (strLength > prefix.length()) {
                sb.setCharAt(strLength - 1, '\u3002');
                msgList.add(sb.toString());
            }
        }
        if (!msgList.isEmpty()) {
            if (msgList.size() == 1) {
                this.getView().showErrorNotification((String)msgList.get(0));
                return (String)msgList.get(0);
            }
            String msg = String.join((CharSequence)"\n", msgList);
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u751f\u9519\u8bef", (String)"TaskSubsectionEditPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
            return msg;
        }
        if (!isStartDateTimeChanged && (entryRowCount = this.getModel().getEntryRowCount("subsectionentry")) != rowIndex + 1) {
            this.getModel().setValue("subplanstartdate", (Object)DateUtils.addMinutes((Date)changedDateTime, (int)1), rowIndex + 1);
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get(ADD_FLAG))) {
            this.getPageCache().remove(ADD_FLAG);
            return;
        }
        if (StringUtils.equals((CharSequence)"subplanstartdate", (CharSequence)name)) {
            String errMsg = this.subsectionDateTimeChanged((Date)newValue, changeSet.getRowIndex(), true, name);
            if (errMsg == null) {
                this.calTimeByPlanTime(changeSet);
            }
        } else if (StringUtils.equals((CharSequence)"subsubplanenddate", (CharSequence)name)) {
            String errMsg = this.subsectionDateTimeChanged((Date)newValue, changeSet.getRowIndex(), false, name);
            if (errMsg == null) {
                this.calPlanTime(changeSet);
            }
        } else if (StringUtils.equals((CharSequence)"subplantime", (CharSequence)name)) {
            this.calTimeByPlanTime(changeSet);
            this.subsectionDateTimeChanged((Date)this.getModel().getValue("subsubplanenddate", changeSet.getRowIndex()), changeSet.getRowIndex(), false, name);
            DynamicObjectCollection subsectionentry = this.getModel().getEntryEntity("subsectionentry");
            if (subsectionentry.size() >= 2 && changeSet.getRowIndex() == subsectionentry.size() - 2) {
                BigDecimal subplanTime = (BigDecimal)this.getModel().getValue("plantime");
                for (int i = 0; i <= changeSet.getRowIndex(); ++i) {
                    subplanTime = subplanTime.subtract((BigDecimal)this.getModel().getValue("subplantime", i));
                }
                if (subplanTime.doubleValue() > 0.0) {
                    this.getModel().setValue("subplantime", (Object)subplanTime, changeSet.getRowIndex() + 1);
                }
            }
        }
    }

    protected void calPlanTime(ChangeData changeSet) {
        DynamicObject rowObject = changeSet.getDataEntity();
        Date planStartDate = rowObject.getDate("subplanstartdate");
        Date planEndDate = rowObject.getDate("subsubplanenddate");
        this.getModel().beginInit();
        if (planStartDate != null && planEndDate != null) {
            BigDecimal planTime = this.calPeriond(planStartDate, planEndDate);
            this.getModel().setValue("subplantime", (Object)planTime, changeSet.getRowIndex());
        }
        this.getModel().endInit();
        this.getView().updateView("subsectionentry");
    }

    protected void calTimeByPlanTime(ChangeData changeSet) {
        DynamicObject rowObject = changeSet.getDataEntity();
        Date planStartDate = rowObject.getDate("subplanstartdate");
        BigDecimal planTime = rowObject.getBigDecimal("subplantime");
        this.getModel().beginInit();
        this.getModel().setValue("subsubplanenddate", (Object)this.calPlanEndTime(planStartDate, planTime), changeSet.getRowIndex());
        this.getModel().endInit();
        this.getView().updateView("subsectionentry");
    }

    protected Date calPlanEndTime(Date planStartDate, BigDecimal planTime) {
        DynamicObject timeunit;
        Date planEndTime = null;
        if (planStartDate != null && planTime.compareTo(BigDecimal.ZERO) > 0 && (timeunit = (DynamicObject)this.getModel().getValue("durationunit")) != null) {
            planEndTime = TimeUnitUtils.calEndDate((String)timeunit.getString("number"), (Date)planStartDate, (BigDecimal)planTime);
        }
        return planEndTime;
    }

    private BigDecimal calPeriond(Date startdate, Date finshdate) {
        DynamicObject timeunit = (DynamicObject)this.getModel().getValue("durationunit");
        BigDecimal period = BigDecimal.ZERO;
        if (timeunit != null) {
            String timeUnitNo = timeunit.getString("number");
            period = TimeUnitUtils.calPeriod((String)timeUnitNo, (Date)startdate, (Date)finshdate);
        }
        return period;
    }

    public void click(EventObject evt) {
        Control con = (Control)evt.getSource();
        String srcCtrlKey = con.getKey().toLowerCase();
        if ("btncancel".equals(srcCtrlKey)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("subsectionentry");
            this.getView().returnDataToParent((Object)(dynamicObjects.isEmpty() ? "empty" : "notEmpty"));
            this.getView().close();
        }
    }
}

