/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.bill;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmc.pmbd.common.util.TimeUtils;

public class ToUpdateBaseInfoPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter filter = new QFilter("id", "=", (Object)currUserId);
        DynamicObject tmp = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        if (tmp != null) {
            QFilter filter2 = new QFilter("number", "=", tmp.get("number"));
            DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"pmbd_enterprise_hm_res_po", (String)"id,number,name", (QFilter[])new QFilter[]{filter2});
            if (user != null) {
                this.getModel().setValue("applicant", (Object)user);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount > 1) {
            this.setEnable();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if ("tb_del".equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int index = selectRows[i];
                int temp1 = -1;
                int temp2 = -1;
                if (index % 2 == 1) {
                    temp1 = index - 1;
                    temp2 = index;
                } else {
                    temp1 = index;
                    temp2 = index + 1;
                }
                if (temp1 <= rowCount - 1 && temp2 <= rowCount - 1) {
                    this.getModel().deleteEntryRow("entryentity", temp2);
                    this.getModel().deleteEntryRow("entryentity", temp1);
                    if (i <= 0 || selectRows[i - 1] != temp1) continue;
                    --i;
                    continue;
                }
                this.getModel().deleteEntryRow("entryentity", index);
            }
            evt.setCancel(true);
        } else if ("tb_new".equals(itemKey)) {
            String val = (String)this.getModel().getValue("tasknumber", rowCount - 1);
            if (rowCount != 0 && val == null || "".equals(val)) {
                evt.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        int rowInex = changeSet.getRowIndex();
        Object newValue = changeSet.getNewValue();
        if ("pronumber".equals(name)) {
            int rowCount;
            Object oldValue = changeSet.getOldValue();
            if (oldValue != null && (rowCount = this.getModel().getEntryRowCount("entryentity")) > 1) {
                this.getModel().deleteEntryData("entryentity");
            }
        } else if (StringUtils.equals((CharSequence)"starttime", (CharSequence)name)) {
            this.calTimeByPlanTime(rowInex);
            this.setEnable();
            if (newValue != null) {
                DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("finnishtime");
                endDateEdit.setMinDate((Date)newValue);
            }
        } else if (StringUtils.equals((CharSequence)"finnishtime", (CharSequence)name)) {
            this.calPlanTime(rowInex);
            this.setEnable();
            if (newValue != null) {
                DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("starttime");
                endDateEdit.setMaxDate((Date)newValue);
            }
        } else if (StringUtils.equals((CharSequence)"plainingtime", (CharSequence)name)) {
            this.calTimeByPlanTime(rowInex);
            this.setEnable();
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().deleteEntryData("entryentity");
    }

    protected void calTimeByPlanTime(int rowInex) {
        Date planStartDate = (Date)this.getModel().getValue("starttime", rowInex);
        BigDecimal planTime = (BigDecimal)this.getModel().getValue("plainingtime", rowInex);
        this.getModel().beginInit();
        this.getModel().setValue("finnishtime", (Object)this.calPlanEndTime(planStartDate, planTime));
        this.getModel().endInit();
        this.getView().updateView("entryentity", rowInex);
    }

    protected void calPlanTime(int rowInex) {
        Date planStartDate = (Date)this.getModel().getValue("starttime", rowInex);
        Date planEndDate = (Date)this.getModel().getValue("finnishtime", rowInex);
        this.getModel().beginInit();
        if (planStartDate != null && planEndDate != null) {
            long temp = planEndDate.getTime() - planStartDate.getTime();
            BigDecimal planTime = BigDecimal.valueOf(temp /= 86400000L);
            this.getModel().setValue("plainingtime", (Object)planTime, rowInex);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity", rowInex);
    }

    protected Date calPlanEndTime(Date planStartDate, BigDecimal planTime) {
        Date planEndTime = null;
        if (planStartDate != null && planTime != null) {
            long planStartDateTime = planStartDate.getTime();
            planEndTime = new Date(planStartDateTime + planTime.multiply(new BigDecimal(86400000)).longValue());
        }
        return planEndTime;
    }

    private int daysBetween(Date startdate, Date finshdate) {
        int between = 0;
        if (null == startdate || null == finshdate) {
            return between;
        }
        Calendar expstartdateCdr = Calendar.getInstance();
        Calendar expfinshdateCdr = Calendar.getInstance();
        expstartdateCdr.set(1, startdate.getYear());
        expstartdateCdr.set(2, startdate.getMonth());
        expstartdateCdr.set(5, startdate.getDate());
        expfinshdateCdr.set(1, finshdate.getYear());
        expfinshdateCdr.set(2, finshdate.getMonth());
        expfinshdateCdr.set(5, finshdate.getDate());
        between = TimeUtils.daysBetween((Calendar)expstartdateCdr, (Calendar)expfinshdateCdr);
        return between;
    }

    private void setEnable() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; i += 2) {
            if (i + 1 >= rowCount) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"taskname", "scheduletype", "plainingtime", "planingarea", "timeunit", "starttime", "finnishtime", "changesource", "changereason", "remarks"});
            this.getView().setEnable(Boolean.valueOf(false), i + 1, new String[]{"tasknumber", "scheduletype", "timeunit"});
        }
    }
}

