/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.util.TimeUnitUtils;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;
import kd.pmc.pmts.business.helper.TaskSaveStageServiceHelper;
import kd.pmc.pmts.common.model.BindOrderModel;
import kd.pmc.pmts.common.util.BindOrderUtils;

public class BindOrderPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String SOURCEBILLTYPE = "sfc_mromanuftech";
    private static ORM orm = ORM.create();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button ok = (Button)this.getControl("btn_ok");
        ok.addClickListener((ClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("wbs");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initForm();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        Object newValue = cd.getNewValue();
        int rowInex = cd.getRowIndex();
        if (StringUtils.equals((CharSequence)"planbegindate", (CharSequence)name)) {
            this.calTimeByPlanTime(rowInex);
            if (newValue != null) {
                DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("planenddate");
                endDateEdit.setMinDate((Date)newValue);
            }
        } else if (StringUtils.equals((CharSequence)"planenddate", (CharSequence)name)) {
            this.calPlanTime(rowInex);
            if (newValue != null) {
                DateTimeEdit endDateEdit = (DateTimeEdit)this.getControl("planbegindate");
                endDateEdit.setMaxDate((Date)newValue);
            }
        } else if (StringUtils.equals((CharSequence)"planperiod", (CharSequence)name)) {
            this.calTimeByPlanTime(rowInex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String errMsg;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey) && StringUtils.isNotBlank((CharSequence)(errMsg = this.validateDatas()))) {
            this.getView().showTipNotification(errMsg);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey)) {
            this.checkProjectStage();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        int taskRowCount = this.getModel().getEntryRowCount("entryentity_task");
        int orderRowCount = this.getModel().getEntryRowCount("entryentity_order");
        String bindType = this.getBinderType();
        if (!(StringUtils.equals((CharSequence)"add_notask", (CharSequence)bindType) || StringUtils.equals((CharSequence)"auto", (CharSequence)bindType) || StringUtils.equals((CharSequence)"split", (CharSequence)bindType) || StringUtils.equals((CharSequence)"group", (CharSequence)bindType) || StringUtils.equals((CharSequence)"collect", (CharSequence)bindType))) {
            return;
        }
        if (StringUtils.equals((CharSequence)"collect", (CharSequence)bindType)) {
            this.calCollectHours();
        } else {
            BigDecimal planTime = this.hourToPeriod(this.calWorkHours(), this.getTimeUnit(), this.getProjectClass());
            if (taskRowCount == 1) {
                this.getModel().setValue("planperiod", (Object)planTime, 0);
                this.getModel().setValue("needtime", (Object)planTime, 0);
            }
            if (orderRowCount == 1) {
                for (int i = 0; i < taskRowCount; ++i) {
                    this.getModel().setValue("planperiod", (Object)planTime, i);
                    this.getModel().setValue("needtime", (Object)planTime, i);
                }
            }
        }
    }

    public void initForm() {
        String type = this.getBinderType();
        if (type == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"add_task", (CharSequence)type) || StringUtils.equals((CharSequence)"add_notask", (CharSequence)type)) {
            this.initAddForm();
        } else if (StringUtils.equals((CharSequence)"replace", (CharSequence)type)) {
            this.initReplaceForm();
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)type)) {
            this.initDeleteForm();
        } else if (StringUtils.equals((CharSequence)"auto", (CharSequence)type)) {
            this.initAutoForm();
        } else if (StringUtils.equals((CharSequence)"collect", (CharSequence)type)) {
            this.initCollectForm();
        } else if (StringUtils.equals((CharSequence)"split", (CharSequence)type)) {
            this.initSplitForm();
        } else if (StringUtils.equals((CharSequence)"group", (CharSequence)type)) {
            this.initGroupForm();
        }
    }

    public void dealDatas() {
        String type = this.getBinderType();
        if (type == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)"add_task", (CharSequence)type) || StringUtils.equals((CharSequence)"add_notask", (CharSequence)type)) {
            this.handleAddDatas();
        } else if (StringUtils.equals((CharSequence)"replace", (CharSequence)type)) {
            this.handleReplaceDatas();
        } else if (StringUtils.equals((CharSequence)"delete", (CharSequence)type)) {
            this.handleDeleteDatas();
        } else if (StringUtils.equals((CharSequence)"auto", (CharSequence)type)) {
            this.handleAutoDatas();
        } else if (StringUtils.equals((CharSequence)"collect", (CharSequence)type)) {
            this.handleCollectDatas();
        } else if (StringUtils.equals((CharSequence)"split", (CharSequence)type)) {
            this.handleSplitDatas();
        } else if (StringUtils.equals((CharSequence)"group", (CharSequence)type)) {
            this.handleGroupDatas();
        }
        this.getView().returnDataToParent((Object)"success");
        this.getView().close();
    }

    public void initAddForm() {
        this.createOrderEntry();
        String type = this.getBinderType();
        Set<Long> selectTaskIds = this.getSelectTaskIds();
        if (StringUtils.equals((CharSequence)"add_notask", (CharSequence)type)) {
            this.createNewTaskEntry();
        } else {
            this.createSelectTaskEntry(selectTaskIds);
            this.lockFields();
        }
    }

    public void initReplaceForm() {
        this.createOrderEntry();
        this.createSelectTaskEntry(this.getSelectTaskIds());
        this.lockFields();
    }

    public void initDeleteForm() {
        this.createSelectTaskEntry(this.getSelectTaskIds());
        this.lockFields();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
    }

    public void initAutoForm() {
        this.createOrderEntry();
        this.createNewTaskEntry();
    }

    public void initCollectForm() {
        this.createOrderEntry();
        this.createCollectTaskEntry();
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2"});
    }

    public void initSplitForm() {
        this.createOrderEntry();
        this.createSplitGroupOrderEntry();
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2"});
    }

    public void initGroupForm() {
        this.createOrderEntry();
        this.createSplitGroupOrderEntry();
        this.getView().setVisible(Boolean.FALSE, new String[]{"advconbaritemap2"});
    }

    public void handleAddDatas() {
        List<BindOrderModel> bindOrderModels = this.getBindOrderModels();
        if (!bindOrderModels.isEmpty()) {
            DynamicObject[] tasks;
            String binderType = this.getBinderType();
            Set<Long> taskIds = this.getSelectTaskIds();
            if (StringUtils.equals((CharSequence)"add_notask", (CharSequence)binderType)) {
                for (DynamicObject task : tasks = this.saveTask()) {
                    taskIds.add(task.getLong("id"));
                }
                ProjectPlanTypeHelper.projectPlanTypeTaskAdd(Arrays.asList(taskIds.toArray()));
            }
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            tasks = BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
            BindOrderUtils.updateSpecialTask((DynamicObject[])tasks);
            BindOrderUtils.updateTaskBindStauts(this.longToString(new ArrayList<Long>(taskIds)));
            BindOrderUtils.updateRelatedOrderQtys(this.longToString(new ArrayList<Long>(taskIds)));
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(Arrays.asList(taskIds.toArray()));
        }
    }

    public void handleReplaceDatas() {
        List<BindOrderModel> bindOrderModels = this.getBindOrderModels();
        if (!bindOrderModels.isEmpty()) {
            List<String> taskIds = this.longToString(new ArrayList<Long>(this.getSelectTaskIds()));
            BindOrderUtils.deleteTargetBillRelations(taskIds, (String)SOURCEBILLTYPE);
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            BindOrderUtils.updateSpecialTask((DynamicObject[])BusinessDataServiceHelper.load((Object[])this.getSelectTaskIds().toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task")));
            BindOrderUtils.updateTaskBindStauts(taskIds);
            BindOrderUtils.updateRelatedOrderQtys(taskIds);
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(new ArrayList<Long>(this.getSelectTaskIds()));
        }
    }

    public void handleDeleteDatas() {
        int taskCount = this.getModel().getEntryRowCount("entryentity_task");
        ArrayList<String> taskIds = new ArrayList<String>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid", i);
            taskIds.add(taskId);
        }
        BindOrderUtils.deleteTargetBillRelations(taskIds, (String)SOURCEBILLTYPE);
        BindOrderUtils.updateSpecialTask((DynamicObject[])BusinessDataServiceHelper.load((Object[])BindOrderUtils.stringToLong(taskIds).toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task")));
        BindOrderUtils.updateTaskBindStauts(taskIds);
        BindOrderUtils.updateRelatedOrderQtys(taskIds);
        ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(new ArrayList(BindOrderUtils.stringToLong(taskIds)));
    }

    public void handleAutoDatas() {
        List<BindOrderModel> bindOrderModels = this.getBindOrderModels();
        if (!bindOrderModels.isEmpty()) {
            DynamicObject[] tasks = this.saveTask();
            HashSet<Long> taskIds = new HashSet<Long>(8);
            for (DynamicObject task : tasks) {
                taskIds.add(task.getLong("id"));
            }
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            BindOrderUtils.updateSpecialTask((DynamicObject[])BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task")));
            BindOrderUtils.updateTaskBindStauts(this.longToString(new ArrayList<Long>(taskIds)));
            BindOrderUtils.updateRelatedOrderQtys(this.longToString(new ArrayList<Long>(taskIds)));
            ProjectPlanTypeHelper.projectPlanTypeTaskAdd(Arrays.asList(taskIds.toArray()));
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(Arrays.asList(taskIds.toArray()));
        }
    }

    public void handleCollectDatas() {
        List<BindOrderModel> bindOrderModels = this.getCollectBindOrderModels();
        if (!bindOrderModels.isEmpty()) {
            DynamicObject[] tasks = this.saveTask();
            HashSet<Long> taskIds = new HashSet<Long>(8);
            for (DynamicObject task : tasks) {
                taskIds.add(task.getLong("id"));
            }
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            BindOrderUtils.updateSpecialTask((DynamicObject[])BusinessDataServiceHelper.load((Object[])taskIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task")));
            BindOrderUtils.updateTaskBindStauts(this.longToString(new ArrayList<Long>(taskIds)));
            BindOrderUtils.updateRelatedOrderQtys(this.longToString(new ArrayList<Long>(taskIds)));
            ProjectPlanTypeHelper.projectPlanTypeTaskAdd(Arrays.asList(taskIds.toArray()));
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(Arrays.asList(taskIds.toArray()));
        }
    }

    public void handleSplitDatas() {
        List<BindOrderModel> bindOrderModels = this.getBindOrderModels();
        Object[] newTask = this.saveTask();
        HashSet<Long> updateTaskIds = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : newTask) {
            updateTaskIds.add(dynamicObject.getLong("id"));
        }
        if (!bindOrderModels.isEmpty()) {
            Set<Long> selectTaskIds = this.getSelectTaskIds();
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            Object[] tasks = BusinessDataServiceHelper.load((Object[])selectTaskIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
            BindOrderUtils.updateSpecialTask((DynamicObject[])((DynamicObject[])ArrayUtils.addAll((Object[])newTask, (Object[])tasks)));
            updateTaskIds.addAll(selectTaskIds);
            BindOrderUtils.updateTaskBindStauts(this.longToString(new ArrayList<Long>(updateTaskIds)));
            BindOrderUtils.updateRelatedOrderQtys(this.longToString(new ArrayList<Long>(updateTaskIds)));
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(Arrays.asList(updateTaskIds.toArray()));
        }
    }

    public void handleGroupDatas() {
        List<BindOrderModel> bindOrderModels = this.getBindOrderModels();
        Object[] newTask = this.saveTask();
        HashSet<Long> updateTaskIds = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : newTask) {
            updateTaskIds.add(dynamicObject.getLong("id"));
        }
        if (!bindOrderModels.isEmpty()) {
            Set<Long> selectTaskIds = this.getSelectTaskIds();
            BindOrderUtils.saveBindOrderModel((BindOrderModel[])bindOrderModels.toArray(new BindOrderModel[0]));
            Set<Long> deleteEntryIds = this.getDeleteEntryIds();
            BindOrderUtils.longToString(new ArrayList<Long>(selectTaskIds)).forEach(targetId -> BindOrderUtils.deleteRelations((String)targetId, (String)SOURCEBILLTYPE, (List)BindOrderUtils.longToString(new ArrayList(deleteEntryIds))));
            Object[] tasks = BusinessDataServiceHelper.load((Object[])selectTaskIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"pmts_task"));
            BindOrderUtils.updateSpecialTask((DynamicObject[])((DynamicObject[])ArrayUtils.addAll((Object[])newTask, (Object[])tasks)));
            updateTaskIds.addAll(selectTaskIds);
            BindOrderUtils.updateTaskBindStauts(this.longToString(new ArrayList<Long>(updateTaskIds)));
            BindOrderUtils.updateRelatedOrderQtys(this.longToString(new ArrayList<Long>(updateTaskIds)));
            ProjectPlanTypeHelper.projectPlanTypeTaskAdd(Arrays.asList(updateTaskIds.toArray()));
            ProjectPlanTypeHelper.projectPlanTypeTaskBindCard(Arrays.asList(updateTaskIds.toArray()));
        }
    }

    public void lockFields() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"entryentity_task"});
    }

    public String getBinderType() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            return "add_notask";
        }
        return type;
    }

    public long getTimeUnit() {
        long projectId = this.getProjectId();
        DynamicObject project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id,timeunit", (QFilter[])new QFilter("id", "=", (Object)projectId).toArray());
        if (project != null) {
            return project.getLong("timeunit");
        }
        return 0L;
    }

    public BigDecimal getProjectClass() {
        String classString;
        BigDecimal projectClass = BigDecimal.ONE;
        DynamicObject project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id,projectclass", (QFilter[])new QFilter("id", "=", (Object)this.getProjectId()).toArray());
        if (project != null && StringUtils.isNotEmpty((CharSequence)(classString = project.getString("projectclass")))) {
            projectClass = new BigDecimal(classString);
        }
        return projectClass;
    }

    public long getProjectId() {
        Object project = this.getView().getFormShowParameter().getCustomParam("project");
        if (project == null) {
            return 0L;
        }
        long projectId = (Long)project;
        return projectId;
    }

    public long getPlanTypeId() {
        long planTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("planType");
        return planTypeId;
    }

    public void createOrderEntry() {
        TableValueSetter vs = this.getTableValueSetter("entryentity_order");
        Set<Long> selectOrders = this.getSelectOrders();
        HashMap<String, Set<Long>> queryMap = new HashMap<String, Set<Long>>(16);
        queryMap.put("entryIDSet", selectOrders);
        Map returnMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MroManufTechQueryService", (String)"queryMroManufTechData", (Object[])new Object[]{queryMap});
        if (!returnMap.isEmpty()) {
            for (Map.Entry maps : returnMap.entrySet()) {
                Map dataMap = (Map)maps.getValue();
                Long entryID = Long.valueOf((String)maps.getKey());
                vs.addRow(new Object[]{dataMap.get("headbillno"), dataMap.get("oprprocessgroupid"), dataMap.get("oprprofessionaid"), dataMap.get("headbillid"), entryID, dataMap.get("workcardname"), dataMap.get("oprworkhours")});
            }
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_order", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity_order");
    }

    public void createNewTaskEntry() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity_order");
        String[] taskNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)entryRowCount);
        if (taskNumbers.length == 0) {
            taskNumbers = ID.genStringIds((int)entryRowCount);
        }
        long[] ids = ID.genLongIds((int)entryRowCount);
        long timeUnit = this.getTimeUnit();
        BigDecimal projectClass = this.getProjectClass();
        TableValueSetter vs = this.getTableValueSetter("entryentity_task");
        Map<Long, Long> projectStage = this.getProjectStage();
        for (int i = 0; i < entryRowCount; ++i) {
            String taskName = (String)this.getModel().getValue("cardname", i);
            BigDecimal oprworkhours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
            long projectStageId = projectStage.get(this.getModel().getValue("progroup_id", i)) == null ? 0L : projectStage.get(this.getModel().getValue("progroup_id", i));
            HashSet<Long> projectStageIds = new HashSet<Long>(1);
            projectStageIds.add(projectStageId);
            MulBasedataDynamicObjectCollection projectStageCollection = this.createProjectStageCollection(projectStageIds);
            BigDecimal period = this.hourToPeriod(oprworkhours, timeUnit, projectClass);
            vs.addRow(new Object[]{taskNumbers[i], taskName, 0, projectStageCollection, period, null, null, ids[i], period, timeUnit});
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_task", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity_task");
    }

    public void createSelectTaskEntry(Set<Long> selectTaskIds) {
        String selectProperties = "id,number,name,wbs,projectstage,plantime,planstartdate,planenddate,durationunit,trade,workshift,responsorg,responsperson,planner,workspace,isspecial,actualtime,needtime,finishtime,finishpercent,taskcalendar,tasktype,tasklevel,priority,timetype,percenttype,ismaxpath,iscrux,limitone,limitonedate,limittwo,limittwodate,relatedorderqty";
        QFilter qFilter = new QFilter("id", "in", selectTaskIds);
        DynamicObject[] selectTasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)selectProperties, (QFilter[])qFilter.toArray());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < selectTasks.length; ++i) {
            DynamicObject task = selectTasks[i];
            vs.set("taskno", task.get("number"), i);
            vs.set("taskname", task.get("name"), i);
            vs.set("wbs", task.get("wbs_id"), i);
            vs.set("projectstage", task.get("projectstage"), i);
            vs.set("planperiod", task.get("plantime"), i);
            vs.set("planbegindate", task.get("planstartdate"), i);
            vs.set("planenddate", task.get("planenddate"), i);
            vs.set("taskid", task.get("id"), i);
            vs.set("durationunit", task.get("durationunit_id"), i);
            vs.set("trade", task.get("trade_id"), i);
            vs.set("workshift", task.get("workshift"), i);
            vs.set("responsorg", task.get("responsorg_id"), i);
            vs.set("responsperson", task.get("responsperson_id"), i);
            vs.set("planner", task.get("planner_id"), i);
            vs.set("workspace", task.get("workspace"), i);
            vs.set("isspecial", task.get("isspecial"), i);
            vs.set("actualtime", task.get("actualtime"), i);
            vs.set("needtime", task.get("needtime"), i);
            vs.set("finishtime", task.get("finishtime"), i);
            vs.set("finishpercent", task.get("finishpercent"), i);
            vs.set("taskcalendar", task.get("taskcalendar_id"), i);
            vs.set("tasktype", task.get("tasktype_id"), i);
            vs.set("tasklevel", task.get("tasklevel"), i);
            vs.set("priority", task.get("priority"), i);
            vs.set("timetype", task.get("timetype"), i);
            vs.set("ismaxpath", task.get("ismaxpath"), i);
            vs.set("iscrux", task.get("iscrux"), i);
            vs.set("limitone", task.get("limitone"), i);
            vs.set("limitonedate", task.get("limitonedate"), i);
            vs.set("limittwo", task.get("limittwo"), i);
            vs.set("limittwodate", task.get("limittwodate"), i);
            vs.set("relatedorderqty", task.get("relatedorderqty"), i);
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_task", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity_task");
    }

    public void createCollectTaskEntry() {
        Map<Long, ProGroupRow> proGroupRowMap = this.getProGroupRow();
        int taskRowCount = proGroupRowMap.size();
        String[] taskNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)taskRowCount);
        if (taskNumbers.length == 0) {
            taskNumbers = ID.genStringIds((int)taskRowCount);
        }
        long[] ids = ID.genLongIds((int)taskRowCount);
        HashMap<String, String> proGroupToTask = new HashMap<String, String>(8);
        TableValueSetter vs = this.getTableValueSetter("entryentity_task");
        Map<Long, Long> projectStage = this.getProjectStage();
        long timeUnit = this.getTimeUnit();
        BigDecimal projectClass = this.getProjectClass();
        int i = 0;
        for (Map.Entry<Long, ProGroupRow> entry : proGroupRowMap.entrySet()) {
            ProGroupRow row = entry.getValue();
            long projectStageId = projectStage.get(row.getId()) == null ? 0L : projectStage.get(row.getId());
            HashSet<Long> projectStageIds = new HashSet<Long>(1);
            projectStageIds.add(projectStageId);
            MulBasedataDynamicObjectCollection projectStageCollection = this.createProjectStageCollection(projectStageIds);
            BigDecimal period = this.hourToPeriod(row.getHours(), timeUnit, projectClass);
            vs.addRow(new Object[]{taskNumbers[i], row.getName(), 0, projectStageCollection, period, null, null, ids[i], period, timeUnit});
            proGroupToTask.put(String.valueOf(entry.getKey()), String.valueOf(ids[i]));
            ++i;
        }
        this.getPageCache().put("proGroupToTask", SerializationUtils.toJsonString(proGroupToTask));
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_task", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity_task");
    }

    public void createSplitGroupOrderEntry() {
        int taskRowCount = 1;
        String[] taskNumbers = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(RequestContext.get().getOrgId()), (int)taskRowCount);
        if (taskNumbers.length == 0) {
            taskNumbers = ID.genStringIds((int)taskRowCount);
        }
        long[] ids = ID.genLongIds((int)taskRowCount);
        TableValueSetter vs = this.getTableValueSetter("entryentity_task");
        Map<Long, Long> projectStage = this.getProjectStage();
        HashSet<Long> projectStageIds = new HashSet<Long>(8);
        for (Map.Entry<Long, Long> entry : projectStage.entrySet()) {
            projectStageIds.add(entry.getValue());
        }
        Map<String, Date> planDate = this.getPlanDate();
        MulBasedataDynamicObjectCollection projectStageCollection = this.createProjectStageCollection(projectStageIds);
        BigDecimal period = this.hourToPeriod(this.calWorkHours(), this.getTimeUnit(), this.getProjectClass());
        vs.addRow(new Object[]{taskNumbers[0], null, 0, projectStageCollection, period, planDate.get("planbegindate"), planDate.get("planenddate"), ids[0], period, this.getTimeUnit()});
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.batchCreateNewEntryRow("entryentity_task", vs);
        dataModel.endInit();
        this.getView().updateView("entryentity_task");
        this.calPlanTime(0);
    }

    public Map<Long, ProGroupRow> getProGroupRow() {
        String collecttype = this.getCollectType();
        int orderRowCount = this.getModel().getEntryRowCount("entryentity_order");
        LinkedHashMap<Long, ProGroupRow> proGroupRowMap = new LinkedHashMap<Long, ProGroupRow>(8);
        for (int i = 0; i < orderRowCount; ++i) {
            ProGroupRow proGroupRow;
            if (StringUtils.equals((CharSequence)"A", (CharSequence)collecttype) || StringUtils.equals((CharSequence)"D", (CharSequence)collecttype)) {
                BigDecimal oprWorkHours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
                long proGroupId = 0L;
                ProGroupRow proGroupRow2 = (ProGroupRow)proGroupRowMap.get(proGroupId);
                if (proGroupRow2 == null) {
                    proGroupRow2 = new ProGroupRow();
                }
                proGroupRow2.setId(proGroupId);
                proGroupRow2.setName(ResManager.loadKDString((String)"\u68c0\u4fee\u751f\u4ea7\u4efb\u52a1", (String)"BindOrderPlugin_10", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                if (StringUtils.equals((CharSequence)"D", (CharSequence)collecttype)) {
                    proGroupRow2.setName(ResManager.loadKDString((String)"\u975e\u4f8b\u884c\u68c0\u4fee\u4efb\u52a1", (String)"BindOrderPlugin_11", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                }
                proGroupRow2.setHours(proGroupRow2.getHours().add(oprWorkHours));
                proGroupRowMap.put(proGroupId, proGroupRow2);
                continue;
            }
            if (StringUtils.equals((CharSequence)"B", (CharSequence)collecttype)) {
                DynamicObject proGroup = (DynamicObject)this.getModel().getValue("progroup", i);
                BigDecimal oprWorkHours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
                long proGroupId = proGroup == null ? 0L : proGroup.getLong("id");
                proGroupRow = (ProGroupRow)proGroupRowMap.get(proGroupId);
                if (proGroupRow == null) {
                    proGroupRow = new ProGroupRow();
                }
                proGroupRow.setId(proGroupId);
                proGroupRow.setName(proGroup == null ? null : proGroup.getString("name"));
                proGroupRow.setHours(proGroupRow.getHours().add(oprWorkHours));
                proGroupRowMap.put(proGroupId, proGroupRow);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"C", (CharSequence)collecttype)) continue;
            DynamicObject profession = (DynamicObject)this.getModel().getValue("profession", i);
            BigDecimal oprWorkHours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
            long professionId = profession == null ? 0L : profession.getLong("id");
            proGroupRow = (ProGroupRow)proGroupRowMap.get(professionId);
            if (proGroupRow == null) {
                proGroupRow = new ProGroupRow();
            }
            proGroupRow.setId(professionId);
            proGroupRow.setName(profession == null ? null : profession.getString("name"));
            proGroupRow.setHours(proGroupRow.getHours().add(oprWorkHours));
            proGroupRowMap.put(professionId, proGroupRow);
        }
        return proGroupRowMap;
    }

    public String validateDatas() {
        String type = this.getBinderType();
        if (StringUtils.equals((CharSequence)"add_task", (CharSequence)type) || StringUtils.equals((CharSequence)"add_notask", (CharSequence)type)) {
            return this.validateAddDatas();
        }
        if (StringUtils.equals((CharSequence)"replace", (CharSequence)type)) {
            return this.validateReplaceDatas();
        }
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)type)) {
            return this.validateDeleteDatas();
        }
        if (StringUtils.equals((CharSequence)"split", (CharSequence)type) || StringUtils.equals((CharSequence)"group", (CharSequence)type) || StringUtils.equals((CharSequence)"auto", (CharSequence)type) || StringUtils.equals((CharSequence)"collect", (CharSequence)type)) {
            return this.validateTaskDatas();
        }
        return null;
    }

    public String validateAddDatas() {
        int orderCounts = this.getModel().getEntryRowCount("entryentity_order");
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        if (orderCounts == 0 || taskCounts == 0) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u6216\u4efb\u52a1\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ed1\u5b9a\u3002", (String)"BindOrderPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        if (orderCounts > 1 && taskCounts > 1 && orderCounts != taskCounts) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u6570\u91cf\u4e0e\u4efb\u52a1\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u3002", (String)"BindOrderPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        String errMsg = this.validateTaskDatas();
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return errMsg;
        }
        return null;
    }

    public String validateTaskDatas() {
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        ArrayList<String> errMsg = new ArrayList<String>(8);
        for (int i = 0; i < taskCounts; ++i) {
            String taskNo = (String)this.getModel().getValue("taskno", i);
            String taskName = (String)this.getModel().getValue("taskname", i);
            if (StringUtils.isEmpty((CharSequence)taskNo)) {
                errMsg.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4efb\u52a1\u7f16\u7801\u3002", (String)"BindOrderPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (!StringUtils.isEmpty((CharSequence)taskName)) continue;
            errMsg.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BindOrderPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), i + 1));
        }
        if (StringUtils.isNotBlank(errMsg)) {
            return ((Object)errMsg).toString().replace("[", "").replace("]", "");
        }
        return null;
    }

    public String validateReplaceDatas() {
        int orderCounts = this.getModel().getEntryRowCount("entryentity_order");
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        if (orderCounts == 0 || taskCounts == 0) {
            return ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u6216\u4efb\u52a1\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ed1\u5b9a\u3002", (String)"BindOrderPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        if (taskCounts > 1) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u65e0\u6cd5\u6279\u91cf\u66ff\u6362\u3002", (String)"BindOrderPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    public String validateDeleteDatas() {
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        if (taskCounts == 0) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u7ed1\u5b9a\u3002", (String)"BindOrderPlugin_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private TableValueSetter getTableValueSetter(String flag) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if (StringUtils.equals((CharSequence)"entryentity_order", (CharSequence)flag)) {
            vs.addField("orderno", new Object[0]);
            vs.addField("progroup", new Object[0]);
            vs.addField("profession", new Object[0]);
            vs.addField("orderid", new Object[0]);
            vs.addField("orderentryid", new Object[0]);
            vs.addField("cardname", new Object[0]);
            vs.addField("oprworkhours", new Object[0]);
        } else if (StringUtils.equals((CharSequence)"entryentity_task", (CharSequence)flag)) {
            vs.addField("taskno", new Object[0]);
            vs.addField("taskname", new Object[0]);
            vs.addField("wbs", new Object[0]);
            vs.addField("projectstage", new Object[0]);
            vs.addField("planperiod", new Object[0]);
            vs.addField("planbegindate", new Object[0]);
            vs.addField("planenddate", new Object[0]);
            vs.addField("taskid", new Object[0]);
            vs.addField("needtime", new Object[0]);
            vs.addField("durationunit", new Object[0]);
        }
        return vs;
    }

    public DynamicObject[] saveTask() {
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        DynamicObject[] tasks = new DynamicObject[taskCounts];
        long createOrg = this.getCreateOrgId();
        for (int i = 0; i < taskCounts; ++i) {
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"pmts_task");
            String taskId = (String)this.getModel().getValue("taskid", i);
            task.set("id", (Object)Long.parseLong(taskId));
            task.set("number", this.getModel().getValue("taskno", i));
            task.set("name", this.getModel().getValue("taskname", i));
            task.set("wbs", this.getModel().getValue("wbs", i));
            task.set("projectstage", this.getModel().getValue("projectstage", i));
            task.set("plantime", this.getModel().getValue("planperiod", i));
            task.set("planstartdate", this.getModel().getValue("planbegindate", i));
            task.set("planenddate", this.getModel().getValue("planenddate", i));
            task.set("durationunit", this.getModel().getValue("durationunit", i));
            task.set("trade", this.getModel().getValue("trade", i));
            task.set("workshift", this.getModel().getValue("workshift", i));
            task.set("responsorg", this.getModel().getValue("responsorg", i));
            task.set("responsperson", this.getModel().getValue("responsperson", i));
            task.set("planner", this.getModel().getValue("planner", i));
            task.set("workspace", this.getModel().getValue("workspace", i));
            task.set("isspecial", this.getModel().getValue("isspecial", i));
            task.set("actualtime", this.getModel().getValue("actualtime", i));
            task.set("needtime", this.getModel().getValue("needtime", i));
            task.set("finishtime", this.getModel().getValue("finishtime", i));
            task.set("finishpercent", this.getModel().getValue("finishpercent", i));
            task.set("taskcalendar", this.getModel().getValue("taskcalendar", i));
            task.set("tasktype", this.getModel().getValue("tasktype", i));
            task.set("tasklevel", this.getModel().getValue("tasklevel", i));
            task.set("priority", this.getModel().getValue("priority", i));
            task.set("timetype", this.getModel().getValue("timetype", i));
            task.set("percenttype", this.getModel().getValue("percenttype", i));
            task.set("ismaxpath", this.getModel().getValue("ismaxpath", i));
            task.set("iscrux", this.getModel().getValue("iscrux", i));
            task.set("limitone", this.getModel().getValue("limitone", i));
            task.set("limitonedate", this.getModel().getValue("limitonedate", i));
            task.set("limittwo", this.getModel().getValue("limittwo", i));
            task.set("limittwodate", this.getModel().getValue("limittwodate", i));
            task.set("abnormal", this.getModel().getValue("abnormal", i));
            task.set("projectnum", (Object)this.getProjectId());
            task.set("plantype", (Object)this.getPlanTypeId());
            task.set("status", (Object)"A");
            task.set("enable", (Object)"1");
            task.set("ctrlstrategy", (Object)"5");
            task.set("createorg", (Object)createOrg);
            task.set("creator", (Object)RequestContext.get().getCurrUserId());
            task.set("createtime", (Object)new Date());
            task.set("executestatus", (Object)"1");
            task.set("workloadunit", (Object)"1");
            task.set("scheduletype", (Object)"1");
            task.set("timetype", (Object)"1");
            task.set("percenttype", (Object)"1");
            task.set("taskstatus", (Object)"1");
            PmtsTaskValueHelper.setFilterValueToGanttTask((DynamicObject)task, (IFormView)this.getView().getParentView());
            tasks[i] = task;
        }
        SaveServiceHelper.save((DynamicObject[])tasks);
        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])tasks);
        PmtsTaskValueHelper.setTaskOrderNo(Arrays.asList(tasks));
        return tasks;
    }

    protected List<String> longToString(List<Long> datas) {
        ArrayList<String> list = new ArrayList<String>(datas.size());
        for (long data : datas) {
            list.add(Long.toString(data));
        }
        return list;
    }

    public long getCreateOrgId() {
        String createOrg = (String)this.getView().getFormShowParameter().getCustomParam("createOrg");
        if (StringUtils.isEmpty((CharSequence)createOrg)) {
            return 0L;
        }
        return Long.parseLong(createOrg);
    }

    public Set<Long> getSelectOrders() {
        LinkedHashSet<Long> selectOrders = new LinkedHashSet<Long>(8);
        JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("order");
        if (jsonArray == null) {
            return selectOrders;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            selectOrders.add(jsonArray.getLong(i));
        }
        return selectOrders;
    }

    public Set<Long> getSelectTaskIds() {
        List selectTaskIds = (List)this.getView().getFormShowParameter().getCustomParam("task");
        if (selectTaskIds == null || selectTaskIds.isEmpty()) {
            return new HashSet<Long>();
        }
        LinkedHashSet<Long> selectIds = new LinkedHashSet<Long>(8);
        for (String taksId : selectTaskIds) {
            selectIds.add(Long.parseLong(taksId));
        }
        return selectIds;
    }

    public List<BindOrderModel> getBindOrderModels() {
        int orderCounts = this.getModel().getEntryRowCount("entryentity_order");
        int taskCounts = this.getModel().getEntryRowCount("entryentity_task");
        String targetBillType = "pmts_task";
        ArrayList<BindOrderModel> list = new ArrayList<BindOrderModel>(8);
        if (orderCounts == taskCounts) {
            for (int i = 0; i < orderCounts; ++i) {
                String orderId = (String)this.getModel().getValue("orderid", i);
                String orderEntryId = (String)this.getModel().getValue("orderentryid", i);
                String taskId = (String)this.getModel().getValue("taskid", i);
                BindOrderModel BindOrderModel2 = new BindOrderModel();
                BindOrderModel2.setSourceBillType(SOURCEBILLTYPE);
                BindOrderModel2.setSourceBillId(orderId);
                BindOrderModel2.setSourceBillEntryId(orderEntryId);
                BindOrderModel2.setTargetBillType(targetBillType);
                BindOrderModel2.setTargetBillId(taskId);
                BindOrderModel2.setTargetBillEntryId("");
                list.add(BindOrderModel2);
            }
        } else {
            for (int i = 0; i < taskCounts; ++i) {
                String taskId = (String)this.getModel().getValue("taskid", i);
                for (int j = 0; j < orderCounts; ++j) {
                    String orderId = (String)this.getModel().getValue("orderid", j);
                    String orderEntryId = (String)this.getModel().getValue("orderentryid", j);
                    BindOrderModel BindOrderModel3 = new BindOrderModel();
                    BindOrderModel3.setSourceBillType(SOURCEBILLTYPE);
                    BindOrderModel3.setSourceBillId(orderId);
                    BindOrderModel3.setSourceBillEntryId(orderEntryId);
                    BindOrderModel3.setTargetBillType(targetBillType);
                    BindOrderModel3.setTargetBillId(taskId);
                    BindOrderModel3.setTargetBillEntryId("");
                    list.add(BindOrderModel3);
                }
            }
        }
        return list;
    }

    public List<BindOrderModel> getCollectBindOrderModels() {
        int orderCounts = this.getModel().getEntryRowCount("entryentity_order");
        String targetBillType = "pmts_task";
        ArrayList<BindOrderModel> list = new ArrayList<BindOrderModel>(8);
        String proGroupToTaskStr = this.getPageCache().get("proGroupToTask");
        if (StringUtils.isEmpty((CharSequence)proGroupToTaskStr)) {
            return list;
        }
        String collectType = this.getCollectType();
        Map proGroupToTaskMap = (Map)SerializationUtils.fromJsonString((String)proGroupToTaskStr, Map.class);
        for (int i = 0; i < orderCounts; ++i) {
            String orderId = (String)this.getModel().getValue("orderid", i);
            String orderEntryId = (String)this.getModel().getValue("orderentryid", i);
            DynamicObject proGroup = (DynamicObject)this.getModel().getValue("progroup", i);
            DynamicObject profession = (DynamicObject)this.getModel().getValue("profession", i);
            String proGroupId = proGroup == null ? "0" : proGroup.getString("id");
            String professionId = profession == null ? "0" : profession.getString("id");
            String taskId = (String)proGroupToTaskMap.get("0");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)collectType)) {
                taskId = (String)proGroupToTaskMap.get(proGroupId);
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)collectType)) {
                taskId = (String)proGroupToTaskMap.get(professionId);
            }
            BindOrderModel BindOrderModel2 = new BindOrderModel();
            BindOrderModel2.setSourceBillType(SOURCEBILLTYPE);
            BindOrderModel2.setSourceBillId(orderId);
            BindOrderModel2.setSourceBillEntryId(orderEntryId);
            BindOrderModel2.setTargetBillType(targetBillType);
            BindOrderModel2.setTargetBillId(taskId);
            BindOrderModel2.setTargetBillEntryId("");
            list.add(BindOrderModel2);
        }
        return list;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = ((Control)event.getSource()).getKey();
        if (StringUtils.equals((CharSequence)"wbs", (CharSequence)key)) {
            long projectId = this.getProjectId();
            QFilter qFilter = new QFilter("projectnum.id", "=", (Object)projectId);
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.setShowApproved(false);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private String getCollectType() {
        String collecttype = (String)this.getView().getFormShowParameter().getCustomParam("collecttype");
        return collecttype;
    }

    private BigDecimal calWorkHours() {
        int orderRowCount = this.getModel().getEntryRowCount("entryentity_order");
        BigDecimal planTime = BigDecimal.ZERO;
        for (int i = 0; i < orderRowCount; ++i) {
            BigDecimal opworkhours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
            if (opworkhours == null) continue;
            planTime = planTime.add(opworkhours);
        }
        return planTime;
    }

    private void calCollectHours() {
        String proGroupToTaskStr = this.getPageCache().get("proGroupToTask");
        if (StringUtils.isEmpty((CharSequence)proGroupToTaskStr)) {
            return;
        }
        String collectType = this.getCollectType();
        Map proGroupToTaskMap = (Map)SerializationUtils.fromJsonString((String)proGroupToTaskStr, Map.class);
        int orderRowCount = this.getModel().getEntryRowCount("entryentity_order");
        HashMap<String, BigDecimal> taskHours = new HashMap<String, BigDecimal>(orderRowCount);
        for (int i = 0; i < orderRowCount; ++i) {
            DynamicObject proGroup = (DynamicObject)this.getModel().getValue("progroup", i);
            DynamicObject profession = (DynamicObject)this.getModel().getValue("profession", i);
            String proGroupId = proGroup == null ? "0" : proGroup.getString("id");
            String professionId = profession == null ? "0" : profession.getString("id");
            BigDecimal opworkhours = (BigDecimal)this.getModel().getValue("oprworkhours", i);
            String taskId = (String)proGroupToTaskMap.get("0");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)collectType)) {
                taskId = (String)proGroupToTaskMap.get(proGroupId);
            } else if (StringUtils.equals((CharSequence)"C", (CharSequence)collectType)) {
                taskId = (String)proGroupToTaskMap.get(professionId);
            }
            BigDecimal totalHours = (BigDecimal)taskHours.get(taskId);
            if (totalHours == null) {
                totalHours = BigDecimal.ZERO;
            }
            totalHours = totalHours.add(opworkhours);
            taskHours.put(taskId, totalHours);
        }
        int taskRowCount = this.getModel().getEntryRowCount("entryentity_task");
        for (int i = 0; i < taskRowCount; ++i) {
            String taskId = (String)this.getModel().getValue("taskid");
            BigDecimal totalHours = taskHours.get(taskId) == null ? BigDecimal.ZERO : (BigDecimal)taskHours.get(taskId);
            BigDecimal planTime = this.hourToPeriod(totalHours, this.getTimeUnit(), this.getProjectClass());
            this.getModel().setValue("planperiod", (Object)planTime, i);
            this.getModel().setValue("planperiod", (Object)planTime, i);
        }
    }

    private Set<Long> getDeleteEntryIds() {
        HashSet<Long> existsIds = new HashSet<Long>(8);
        int orderCount = this.getModel().getEntryRowCount("entryentity_order");
        for (int i = 0; i < orderCount; ++i) {
            String orderEntryId = (String)this.getModel().getValue("orderentryid", i);
            if (!StringUtils.isNotEmpty((CharSequence)orderEntryId)) continue;
            existsIds.add(Long.parseLong(orderEntryId));
        }
        Set<Long> deleteOrders = this.getSelectOrders();
        if (deleteOrders.size() != existsIds.size()) {
            return existsIds;
        }
        return deleteOrders;
    }

    protected void calTimeByPlanTime(int rowInex) {
        Date planStartDate = (Date)this.getModel().getValue("planbegindate", rowInex);
        BigDecimal planTime = (BigDecimal)this.getModel().getValue("planperiod", rowInex);
        this.getModel().beginInit();
        this.getModel().setValue("planenddate", (Object)this.calPlanEndTime(planStartDate, planTime));
        this.getModel().endInit();
        this.getView().updateView("entryentity_task");
    }

    protected void calPlanTime(int rowInex) {
        Date planStartDate = (Date)this.getModel().getValue("planbegindate", rowInex);
        Date planEndDate = (Date)this.getModel().getValue("planenddate", rowInex);
        this.getModel().beginInit();
        if (planStartDate != null && planEndDate != null) {
            BigDecimal planTime = this.daysBetween(planStartDate, planEndDate);
            this.getModel().setValue("planperiod", (Object)planTime, rowInex);
            this.getModel().setValue("needtime", (Object)planTime, rowInex);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity_task");
    }

    protected Date calPlanEndTime(Date planStartDate, BigDecimal planTime) {
        DynamicObject timeunit;
        Date planEndTime = null;
        if (planStartDate != null && planTime != null && (timeunit = (DynamicObject)this.getModel().getValue("durationunit", 0)) != null) {
            planEndTime = TimeUnitUtils.calEndDate((String)timeunit.getString("number"), (Date)planStartDate, (BigDecimal)planTime);
        }
        return planEndTime;
    }

    private BigDecimal daysBetween(Date startdate, Date finshdate) {
        DynamicObject timeunit = (DynamicObject)this.getModel().getValue("durationunit", 0);
        BigDecimal period = BigDecimal.ZERO;
        if (timeunit != null) {
            String timeUnitNo = timeunit.getString("number");
            period = TimeUnitUtils.calPeriod((String)timeUnitNo, (Date)startdate, (Date)finshdate);
        }
        return period;
    }

    private BigDecimal hourToPeriod(BigDecimal hour, long timeUnit, BigDecimal projectClass) {
        BigDecimal period = hour.multiply(new BigDecimal("0.125")).divide(projectClass, 2, 4);
        if (timeUnit == 1394029404463565824L) {
            period = hour;
        }
        return period;
    }

    private Map<Long, Long> getProjectStage() {
        LinkedHashMap<Long, Long> map = new LinkedHashMap<Long, Long>(8);
        int orderCount = this.getModel().getEntryRowCount("entryentity_order");
        HashSet<Long> proGroupIds = new HashSet<Long>(8);
        for (int i = 0; i < orderCount; ++i) {
            proGroupIds.add((Long)this.getModel().getValue("progroup_id", i));
        }
        QFilter qFilter = new QFilter("entryentity.processgroup", "in", proGroupIds);
        qFilter = qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter = qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"fmm_propggroup", (String)"id,entryentity.processgroup,projectphase", (QFilter[])qFilter.toArray());
        for (DynamicObject relation : relations) {
            map.put(relation.getLong("entryentity.processgroup"), relation.getLong("projectphase"));
        }
        return map;
    }

    private MulBasedataDynamicObjectCollection createProjectStageCollection(Set<Long> projectStageIds) {
        IDataEntityType dataEntityType = orm.getDataEntityType("fmm_bindorder_form.entryentity_task.projectstage");
        MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection((DynamicObjectType)dataEntityType, null);
        for (long projectStageId : projectStageIds) {
            DynamicObject object = collection.addNew();
            object.set("fbasedataid_id", (Object)projectStageId);
        }
        return collection;
    }

    private void checkProjectStage() {
        ArrayList taskList = new ArrayList(1);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity_task");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObjectCollection col = (DynamicObjectCollection)this.getModel().getValue("projectstage", i);
            if (col.isEmpty()) continue;
            Date planStartDate = (Date)this.getModel().getValue("planbegindate", i);
            Date date = (Date)this.getModel().getValue("planenddate", i);
            HashSet projectStageIds = new HashSet(8);
            col.forEach(obj -> projectStageIds.add(obj.getLong("fbasedataid_id")));
            long id = i;
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("id", id);
            task.put("projectstage", projectStageIds);
            task.put("planstartdate", planStartDate);
            task.put("planenddate", date);
            taskList.add(task);
        }
        Map result = TaskSaveStageServiceHelper.getTaskProjectStageMsg((Long)this.getProjectId(), taskList);
        StringBuilder checkStr = new StringBuilder();
        for (Map.Entry entry : result.entrySet()) {
            checkStr.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"BindOrderPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), (Long)entry.getKey() + 1L)).append((String)entry.getValue()).append('\n');
        }
        if (StringUtils.isNotEmpty((CharSequence)checkStr)) {
            this.setTaskAbnormal(result.keySet());
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("check", (IFormPlugin)this);
            this.getView().showConfirm(null, checkStr.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack);
        } else {
            this.dealDatas();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult resultValue;
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)"check", (CharSequence)callBackId) && MessageBoxResult.Yes == (resultValue = event.getResult())) {
            this.dealDatas();
        }
    }

    private void setTaskAbnormal(Set<Long> resultSeq) {
        HashSet<Integer> seqSet = new HashSet<Integer>(8);
        for (Long seq : resultSeq) {
            seqSet.add(seq.intValue());
        }
        int taskCount = this.getModel().getEntryRowCount("entryentity_task");
        for (int i = 0; i < taskCount; ++i) {
            if (seqSet.contains(i)) {
                this.getModel().setValue("abnormal", (Object)true, i);
                continue;
            }
            this.getModel().setValue("abnormal", (Object)false, i);
        }
    }

    private Map<String, Date> getPlanDate() {
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        Set<Long> taskIds = this.getSelectTaskIds();
        if (!taskIds.isEmpty()) {
            QFilter[] qfilters = new QFilter[]{new QFilter("id", "in", taskIds), new QFilter("planstartdate", "is not null", (Object)"")};
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"pmts_task", (String)"id,planstartdate", (QFilter[])qfilters, (String)"planstartdate", (int)1);
            if (!tasks.isEmpty()) {
                map.put("planbegindate", ((DynamicObject)tasks.get(0)).getDate("planstartdate"));
            } else {
                map.put("planbegindate", null);
            }
            qfilters[1] = new QFilter("planenddate", "is not null", (Object)"");
            tasks = QueryServiceHelper.query((String)"pmts_task", (String)"id,planenddate", (QFilter[])qfilters, (String)"planenddate desc", (int)1);
            if (!tasks.isEmpty()) {
                map.put("planenddate", ((DynamicObject)tasks.get(0)).getDate("planenddate"));
            } else {
                map.put("planenddate", null);
            }
        }
        return map;
    }

    static class ProGroupRow {
        private long id;
        private String name;
        private BigDecimal hours = BigDecimal.ZERO;

        ProGroupRow() {
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public BigDecimal getHours() {
            return this.hours;
        }

        public void setHours(BigDecimal hours) {
            this.hours = hours;
        }
    }
}

