/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GanttVersionRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private Stack<String> st = new Stack();

    public void registerListener(EventObject e) {
        BasedataEdit mainOrgField;
        BasedataEdit versiontwo;
        BasedataEdit versionone;
        BasedataEdit versiontype;
        BasedataEdit plantype;
        BasedataEdit projectnum = (BasedataEdit)this.getControl("pprojectnum");
        if (projectnum != null) {
            projectnum.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            projectnum.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((plantype = (BasedataEdit)this.getControl("pplantype")) != null) {
            plantype.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((versiontype = (BasedataEdit)this.getControl("versiontype")) != null) {
            versiontype.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((versionone = (BasedataEdit)this.getControl("versionone")) != null) {
            versionone.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((versiontwo = (BasedataEdit)this.getControl("versiontwo")) != null) {
            versiontwo.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((mainOrgField = (BasedataEdit)this.getControl("org")) != null) {
            mainOrgField.addAfterF7SelectListener((AfterF7SelectListener)this);
            mainOrgField.addBeforeF7SelectListener(beforeF7SelectEvent -> beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)this.getOrgIds())));
        }
    }

    private Set getOrgIds() {
        QFilter[] filters = new QFilter[]{new QFilter("org.enable", "=", (Object)Boolean.TRUE), new QFilter("isctrlunit", "=", (Object)Boolean.TRUE), new QFilter("isfreeze", "=", (Object)Boolean.FALSE), new QFilter("view.number", "=", (Object)"ProjectManageSchemeDefault")};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (!structureMap.isEmpty()) {
            HashSet<Object> ids = new HashSet<Object>(structureMap.size());
            for (Map.Entry entry : structureMap.entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).get("org_id"));
            }
            ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
            String appNumber = reportShowParameter.getAppId();
            String entityNumber = reportShowParameter.getFormId();
            HashSet<Long> orgIds = new HashSet<Long>(8);
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)entityNumber, (String)"47150e89000000ac");
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                Iterator iterator = hasPermOrgResult.getHasPermOrgs().iterator();
                while (iterator.hasNext()) {
                    long orgId = (Long)iterator.next();
                    if (!ids.contains(orgId)) continue;
                    orgIds.add(orgId);
                }
                if (orgIds.isEmpty()) {
                    return ids;
                }
                return orgIds;
            }
            return ids;
        }
        return new HashSet();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u7ec4\u7ec7\u3002", (String)"GanttVersionRptPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject projectnum = (DynamicObject)this.getModel().getValue("pprojectnum");
        if (projectnum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9879\u76ee\u53f7\u3002", (String)"GanttVersionRptPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject versionone = (DynamicObject)this.getModel().getValue("versionone");
        if (versionone == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7248\u672c\u53f7\uff1a1\u3002", (String)"GanttVersionRptPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarap"});
        return true;
    }

    public void beforeBindData(EventObject e) {
        Set ids = this.getOrgIds();
        long orgId = RequestContext.get().getOrgId();
        if (!ids.isEmpty()) {
            if (ids.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
            } else {
                this.getModel().setValue("org", ids.iterator().next());
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
    }

    public void initialize() {
        super.initialize();
    }

    public void setMergeColums(List<String> columns) {
        columns.add("projectnum");
        columns.add("plantype");
        columns.add("scheduletype");
        columns.add("wbsno");
        columns.add("wbsname");
        columns.add("ismilestone");
        columns.add("taskno");
        columns.add("taskname");
        columns.add("projectstage");
        columns.add("planarea");
        columns.add("trade");
        columns.add("planstartdate");
        columns.add("planenddate");
        columns.add("responsorg");
        super.setMergeColums(columns);
    }

    public void packageData(PackageDataEvent pe) {
        super.packageData(pe);
        DynamicObject rowData = pe.getRowData();
        ReportColumn column = (ReportColumn)pe.getSource();
        ColumnStyle columnStyle = new ColumnStyle();
        column.setStyle(columnStyle);
        ArrayList<String> ls = new ArrayList<String>(2);
        ls.add("projectnum");
        ls.add("plantype");
        ls.add("scheduletype");
        ls.add("wbsno");
        ls.add("wbsname");
        ls.add("ismilestone");
        ls.add("taskno");
        ls.add("taskname");
        ls.add("projectstage");
        ls.add("planarea");
        ls.add("trade");
        ls.add("planstartdate");
        ls.add("planenddate");
        ls.add("responsorg");
        if (this.st.isEmpty()) {
            pe.setNoMergeKey(ls);
            this.st.push(rowData.getString("taskno"));
        } else if (!this.st.peek().equals(rowData.getString("taskno"))) {
            pe.setNoMergeKey(ls);
            this.st.push(rowData.getString("taskno"));
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        super.setCellStyleRules(cellStyleRules);
        ReportList ls = (ReportList)this.getControl("reportlistap");
        List columns = ls.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            ReportColumn col = (ReportColumn)columns.get(i);
            String fieldKey = col.getFieldKey();
            CellStyleRule cellStyleRule = new CellStyleRule();
            cellStyleRule.setFieldKey(fieldKey);
            cellStyleRule.setCondition(fieldKey + "> 0");
            cellStyleRules.add(cellStyleRule);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceID = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"versionone", (CharSequence)sourceID)) {
            showParameter.setCustomParam("openByF7", (Object)true);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c", (String)"GanttVersionRptPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().setQFilters(this.getQFilterList("versiontwo"));
        } else if (StringUtils.equals((CharSequence)"versiontwo", (CharSequence)sourceID)) {
            showParameter.setCustomParam("openByF7", (Object)true);
            showParameter.setCaption(ResManager.loadKDString((String)"\u7248\u672c", (String)"GanttVersionRptPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().setQFilters(this.getQFilterList("versionone"));
        }
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        DynamicObject versiontype;
        BasedataEdit source = (BasedataEdit)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"org")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            this.setVersionFilter(org, "createorg");
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"pprojectnum")) {
            DynamicObject projectnum = (DynamicObject)this.getModel().getValue("pprojectnum");
            this.setVersionFilter(projectnum, "projectnum");
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"pplantype")) {
            DynamicObject plantype = (DynamicObject)this.getModel().getValue("pplantype");
            if (plantype != null) {
                this.setVersionFilter(plantype.getString("number"));
            }
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"versiontype") && (versiontype = (DynamicObject)this.getModel().getValue("versiontype")) != null) {
            this.setVersionFilter(versiontype, "versiontype");
        }
    }

    private void setVersionFilter(DynamicObject object, String name) {
        if (object == null) {
            return;
        }
        DynamicObject versiontwo = (DynamicObject)this.getModel().getValue("versiontwo");
        DynamicObject versionone = (DynamicObject)this.getModel().getValue("versionone");
        if (Objects.nonNull(versionone)) {
            if (versionone.getDynamicObject(name) == null) {
                return;
            }
            if (!StringUtils.equals((CharSequence)object.getString("id"), (CharSequence)versionone.getDynamicObject(name).getString("id"))) {
                this.getModel().setValue("versionone", null);
            }
        }
        if (Objects.nonNull(versiontwo)) {
            if (versiontwo.getDynamicObject(name) == null) {
                return;
            }
            if (!StringUtils.equals((CharSequence)object.getString("id"), (CharSequence)versiontwo.getDynamicObject(name).getString("id"))) {
                this.getModel().setValue("versiontwo", null);
            }
        }
    }

    private void setVersionFilter(String plantypeNumber) {
        DynamicObject versiontwo = (DynamicObject)this.getModel().getValue("versiontwo");
        DynamicObject versionone = (DynamicObject)this.getModel().getValue("versionone");
        String taskplanType = this.getTaskplanType(plantypeNumber);
        if (versionone != null && !StringUtils.equals((CharSequence)taskplanType, (CharSequence)versionone.getString("taskplantype"))) {
            this.getModel().setValue("versionone", null);
        }
        if (versiontwo != null && !StringUtils.equals((CharSequence)taskplanType, (CharSequence)versiontwo.getString("taskplantype"))) {
            this.getModel().setValue("versiontwo", null);
        }
    }

    private List<QFilter> getQFilterList(String otherVersionFlag) {
        DynamicObject otherVersion = (DynamicObject)this.getModel().getValue(otherVersionFlag);
        DynamicObject org = null;
        DynamicObject projectnum = null;
        String plantype = null;
        DynamicObject versiontype = null;
        Long versionId = null;
        if (otherVersion != null) {
            org = otherVersion.getDynamicObject("createorg");
            projectnum = otherVersion.getDynamicObject("projectnum");
            plantype = otherVersion.getString("taskplantype");
            versiontype = otherVersion.getDynamicObject("versiontype");
            versionId = otherVersion.getLong("id");
        } else {
            org = (DynamicObject)this.getModel().getValue("org");
            projectnum = (DynamicObject)this.getModel().getValue("pprojectnum");
            DynamicObject plantypeObject = (DynamicObject)this.getModel().getValue("pplantype");
            if (plantypeObject != null) {
                plantype = this.getTaskplanType(plantypeObject.getString("number"));
            }
            versiontype = (DynamicObject)this.getModel().getValue("versiontype");
        }
        return this.getQFilterList(org, projectnum, plantype, versiontype, versionId);
    }

    private List<QFilter> getQFilterList(DynamicObject org, DynamicObject projectnum, String plantype, DynamicObject versiontype, Long versionId) {
        QFilter versiontypeQfilter;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (org != null) {
            QFilter orgQfilter = new QFilter("createorg.id", "=", org.get("id"));
            qFilterList.add(orgQfilter);
        }
        if (projectnum != null) {
            QFilter projectnumQfilter = new QFilter("projectnum.id", "=", projectnum.get("id"));
            qFilterList.add(projectnumQfilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)plantype)) {
            QFilter plantypeQfilter = new QFilter("taskplantype", "=", (Object)plantype);
            qFilterList.add(plantypeQfilter);
        }
        if (versiontype != null) {
            versiontypeQfilter = new QFilter("versiontype.id", "=", versiontype.get("id"));
            qFilterList.add(versiontypeQfilter);
        } else {
            qFilterList.add(this.getVersionQFilter());
        }
        if (versionId != null) {
            versiontypeQfilter = new QFilter("id", "!=", (Object)versionId);
            qFilterList.add(versiontypeQfilter);
        }
        return qFilterList;
    }

    private QFilter getVersionQFilter() {
        ArrayList<String> versionTypeNumberList = new ArrayList<String>();
        versionTypeNumberList.add("baseline");
        versionTypeNumberList.add("task_history_version");
        versionTypeNumberList.add("industryplan_baseline");
        versionTypeNumberList.add("industryplan_history");
        versionTypeNumberList.add("masterplan_baseline");
        versionTypeNumberList.add("masterplan_history");
        versionTypeNumberList.add("regionplan_baseline");
        versionTypeNumberList.add("regionplan_history");
        QFilter versiontypeQfilter = new QFilter("number", "in", (Object)versionTypeNumberList.toArray());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])versiontypeQfilter.toArray());
        ArrayList versionTypeIdList = new ArrayList();
        dynamicObjects.forEach(object -> versionTypeIdList.add(object.getLong("id")));
        return new QFilter("versiontype", "in", (Object)versionTypeIdList.toArray());
    }

    private String getTaskplanType(String number) {
        String taskplantype = "";
        switch (number) {
            case "MASTERPLAN_S": {
                taskplantype = "pmts_task_masterplan";
                break;
            }
            case "REGIONPLAN_S": {
                taskplantype = "pmts_task_regionplan";
                break;
            }
            case "TREDEPLAN_S": {
                taskplantype = "pmts_task_industryplan";
                break;
            }
        }
        return taskplantype;
    }
}

