/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmtsGanttBaseLineVersionPlugin
extends AbstractListPlugin {
    private final List<String> numberListOne = Arrays.asList("masterplan_baseline", "regionplan_baseline", "industryplan_baseline");
    private final List<String> numberListTwo = Collections.singletonList("baseline");
    private final List<String> columsKeys = Arrays.asList("trade.name", "planarea.name", "areas.name");
    private static final Log logger = LogFactory.getLog(PmtsGanttBaseLineVersionPlugin.class);

    public void beforeBindData(EventObject e) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String showFlag = (String)param.getCustomParam("showFlag");
        if (StringUtils.equals((CharSequence)showFlag, (CharSequence)"projectPlan")) {
            BillList billList = (BillList)this.getControl("billlistap");
            List columns = billList.getShowListColumns();
            for (IListColumn column : columns) {
                if (!this.columsKeys.contains(column.getListFieldKey())) continue;
                column.setVisible(10);
                column.setVisible(9);
                column.setVisible(0);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        List<Object> numberList = new ArrayList(4);
        String showFlag = (String)param.getCustomParam("showFlag");
        if (StringUtils.equals((CharSequence)showFlag, (CharSequence)"projectPlan")) {
            numberList = this.numberListTwo;
        } else if (StringUtils.equals((CharSequence)showFlag, (CharSequence)"overhaulPlan")) {
            numberList = this.numberListOne;
        }
        QFilter typeQFilter = new QFilter("number", "in", numberList);
        DynamicObjectCollection ganttVersionTypes = QueryServiceHelper.query((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])new QFilter[]{typeQFilter});
        final ArrayList idList = new ArrayList();
        ganttVersionTypes.forEach((Consumer)new Consumer<DynamicObject>(){

            @Override
            public void accept(DynamicObject dynamicObject) {
                idList.add(dynamicObject.getLong("id"));
            }
        });
        QFilter qFilter = new QFilter("versiontype.id", "in", idList);
        e.getQFilters().add(qFilter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object openByF7 = this.getView().getFormShowParameter().getCustomParam("openByF7");
        if (Objects.nonNull(openByF7)) {
            return;
        }
        BillList rowData = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currSelectRow = rowData.getCurrentSelectedRowInfo();
        Long versionId = (Long)currSelectRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mpdm_gantt_version", (String)"id , versionType.versionpage.number page", (QFilter[])new QFilter("id", "=", (Object)versionId).toArray());
        if (dynamicObject == null) {
            return;
        }
        String versionPage = dynamicObject.getString("page");
        if (StringUtils.isBlank((CharSequence)versionPage)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5728\u7248\u672c\u7c7b\u578b\u914d\u7f6e\u4e2d\u914d\u7f6e\u201c\u9875\u9762\u201d\u3002", (String)"PmtsGanttBaseLineVersionPlugin_5", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)versionPage, (boolean)false, (int)0, (boolean)false);
        showParameter.setCustomParam("versionId", (Object)Long.toString(versionId));
        String title = ResManager.loadKDString((String)"\u9879\u76ee\u8ba1\u5212\u57fa\u7ebf\u7248\u672c", (String)"PmtsGanttBaseLineVersionPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)versionPage, (CharSequence)"pmts_task_mp_history")) {
            title = ResManager.loadKDString((String)"\u4e3b\u8ba1\u5212\u57fa\u7ebf\u7248\u672c", (String)"PmtsGanttBaseLineVersionPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)versionPage, (CharSequence)"pmts_task_qy_history")) {
            title = ResManager.loadKDString((String)"\u533a\u57df\u8ba1\u5212\u57fa\u7ebf\u7248\u672c", (String)"PmtsGanttBaseLineVersionPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)versionPage, (CharSequence)"pmts_task_ip_history")) {
            title = ResManager.loadKDString((String)"\u884c\u4e1a\u8ba1\u5212\u57fa\u7ebf\u7248\u672c", (String)"PmtsGanttBaseLineVersionPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
        }
        showParameter.setCaption(title);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        BillList grid = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if ("delversion".equals(operateKey)) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            String versionNumber = listSelectedRow.getNumber();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deleteVersionConfirm");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664 %s \u7248\u672c\u7684\u6570\u636e\uff1f", (String)"PmtsGanttBaseLineVersionPlugin_6", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), versionNumber), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("deleteVersionConfirm".equals(callBackId) && result == MessageBoxResult.Yes) {
            logger.info("\u57fa\u7ebf\u7248\u672c\u5220\u9664\u5f00\u59cb..........");
            this.getView().invokeOperation("deleteversion");
            this.getView().invokeOperation("refresh");
            logger.info("\u57fa\u7ebf\u7248\u672c\u5220\u9664\u7ed3\u675f..........");
        }
    }
}

