/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttVersionServiceEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.service.GanttVersionCreateService;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bd.mpdm.common.gantt.util.GanttVersionUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmc.pmpd.common.util.ProjectUtils;
import kd.pmc.pmts.common.util.FiledSetUtil;
import org.apache.commons.lang3.time.DateUtils;

public class PmtsGanttVersionPlugin
extends AbstractListPlugin {
    private static final String CLOSE_SAVEVERSION = "saveVersion";
    private static final String CLOSE_SELECTVERSION = "selectVersion";
    private static final String MPDM_GANTT_VERSION_TASK = "mpdm_gantt_version_task";
    private static final String PROJECTNUM_ID = "projectnum.id";
    private static final String PLANTYPE_ID = "plantype.id";
    private static final String PLANAREA_ID = "planarea.id";
    private static final String TRADE_ID = "trade.id";
    private static final String AREAS_ID = "areas.fbasedataid.id";
    private static final String BAR_SENDALL = "sendall";
    private static final String BAR_SENDPART = "sendpart";
    private static final String BAR_SAVEVERSION = "saveversion";
    private static final String BAR_CHANGE = "change";
    private static final String BAR_UPDATEPROGRESS = "updateprogress";
    private static final String BAR_PUBLISH = "publish";
    private static final String VERSIONTYPE = "versiontype";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PAGE_PMTS_TASK_GANTT = "pmts_task_gantt";
    private static final List<String> pageList = Arrays.asList("pmts_task_release", "pmts_task_mplan_release", "pmts_task_qy_release", "pmts_task_ip_release", "pmts_task_ip_release_v", "pmts_task_mplan_release_v", "pmts_task_qy_release_v", "pmts_task_release_version");

    public void afterBindData(EventObject e) {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (pageList.contains(billFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbldel"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        boolean hasPermiss;
        String itemKey = evt.getItemKey();
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        String appNumber = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isBlank((CharSequence)appNumber)) {
            appNumber = "fmm";
        }
        if (BAR_SAVEVERSION.equals(itemKey) && !(hasPermiss = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)MPDM_GANTT_VERSION_TASK, (String)"2YP0JGOXD6RU"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4efb\u52a1\u7248\u672c\"\u5386\u53f2\u7248\u672c\"\u6743\u9650\u3002", (String)"PmtsGanttVersionPlugin_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ((BAR_SENDALL.equals(itemKey) || BAR_SENDPART.equals(itemKey)) && !(hasPermiss = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appNumber, (String)"mpdm_gantt_version_tbase", (String)"2YP0O8W+HR2K"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4efb\u52a1\u57fa\u7ebf\u7248\u672c\"\u57fa\u7ebf\u7248\u672c\"\u6743\u9650\u3002", (String)"PmtsGanttVersionPlugin_4", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().getPageCache().remove("versionflag");
        if (BAR_SAVEVERSION.equals(itemKey) || BAR_SENDALL.equals(itemKey)) {
            String taskEntityVersionField = (String)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"taskEntityVersionField");
            if (StringUtils.isBlank((CharSequence)taskEntityVersionField)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u6e90\u4e2d\u672a\u8bbe\u7f6e\u7248\u672c\u5b58\u50a8\u5b57\u6bb5\u3002", (String)"PmtsGanttVersionPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean haveEntity = false;
            List ganttRowDataModelList = (List)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"dataList");
            for (GanttRowDataModel ganttRowDataModel : ganttRowDataModelList) {
                if (!StringUtils.equals((CharSequence)ganttRowDataModel.getEntityFlag(), (CharSequence)"pmts_task") && !StringUtils.equals((CharSequence)ganttRowDataModel.getEntityFlag(), (CharSequence)"pmts_wbs")) continue;
                haveEntity = true;
                break;
            }
            if (!haveEntity) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u65e0\u6570\u636e\u3002", (String)"PmtsGanttVersionPlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (BAR_SAVEVERSION.equals(itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fmm_gantt_version_name");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
            if (BAR_PUBLISH.equals(itemKey)) {
                // empty if block
            }
            this.getView().showForm(showParameter);
        } else if ("viewversion".equals(itemKey)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)MPDM_GANTT_VERSION_TASK, (boolean)false);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            String showFlag = StringUtils.equals((CharSequence)billFormId, (CharSequence)PAGE_PMTS_TASK_GANTT) ? "projectPlan" : "overhaulPlan";
            showParameter.setCustomParam("showFlag", (Object)showFlag);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_SELECTVERSION));
            showParameter.setCustomParam("openByF7", (Object)true);
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            String versiontype = this.getVersionType(billFormId, "version");
            QFilter typeQFilter = new QFilter("number", "=", (Object)versiontype);
            DynamicObjectCollection ganttVersionTypes = QueryServiceHelper.query((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])new QFilter[]{typeQFilter});
            final ArrayList idList = new ArrayList();
            ganttVersionTypes.forEach((Consumer)new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    idList.add(dynamicObject.getLong("id"));
                }
            });
            QFilter qFilter = new QFilter("versiontype.id", "in", idList);
            qFilters.add(qFilter);
            Object projectObject = GanttUtils.getFilterValue((String)PROJECTNUM_ID, (String)this.getView().getPageId());
            if (projectObject != null) {
                Long projectnumId = Long.parseLong(projectObject.toString());
                qFilters.add(new QFilter(PROJECTNUM_ID, "=", (Object)projectnumId));
            }
            showParameter.setHasRight(false);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (BAR_SENDALL.equals(itemKey)) {
            Object projectObject = GanttUtils.getFilterValue((String)PROJECTNUM_ID, (String)this.getView().getPageId());
            if (projectObject != null) {
                String versiontype = this.getVersionType(billFormId, "baseline");
                boolean isExist = this.isExistBaseLine(versiontype, projectObject);
                GanttBigObjectCache.put((String)this.getView().getPageId(), (String)"isExist", (Object)isExist);
                Map<String, Object> returnData = this.getParamMap(billFormId, this.getVersionTypeObject(versiontype), "0");
                if (isExist) {
                    GanttBigObjectCache.put((String)this.getView().getPageId(), (String)"returnData", (Object)returnData);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CLOSE_SAVEVERSION, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5df2\u7ecf\u5b58\u5728\u57fa\u7ebf\u7248\u672c\uff0c\u662f\u5426\u91cd\u65b0\u8bbe\u7f6e\u57fa\u7ebf\uff1f", (String)"PmtsGanttVersionPlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
                } else {
                    this.setVersionData(returnData);
                }
            }
        } else if (BAR_SENDPART.equals(itemKey)) {
            Object projectObject = GanttUtils.getFilterValue((String)PROJECTNUM_ID, (String)this.getView().getPageId());
            if (projectObject == null) {
                return;
            }
            List ganttRowDataModelList = (List)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"dataList");
            boolean isSelectTask = false;
            for (GanttRowDataModel ganttRowDataModel : ganttRowDataModelList) {
                if (!ganttRowDataModel.getIsSelect().booleanValue() || !ganttRowDataModel.getEntityFlag().equals("pmts_task") && !ganttRowDataModel.getEntityFlag().equals("pmts_wbs")) continue;
                isSelectTask = true;
                break;
            }
            if (!isSelectTask) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9WBS\u6216\u4efb\u52a1\u8fdb\u884c\u53d1\u5e03\u3002", (String)"PmtsGanttVersionPlugin_8", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long projectnumId = Long.parseLong(projectObject.toString());
            String versiontype = this.getVersionType(billFormId, "baseline");
            boolean isExist = this.isExistBaseLine(versiontype, projectObject);
            GanttBigObjectCache.put((String)this.getView().getPageId(), (String)"isExist", (Object)isExist);
            this.getView().getPageCache().put("versionflag", itemKey);
            if (isExist) {
                QFilter qFilter = new QFilter("projectnum", "=", (Object)projectnumId);
                QFilter numberQFilter = new QFilter("number", "=", (Object)versiontype);
                DynamicObject qversiontype = QueryServiceHelper.queryOne((String)"mpdm_gantt_versiontype", (String)"id,name", (QFilter[])numberQFilter.toArray());
                QFilter versiontypeFilter = new QFilter(VERSIONTYPE, "=", (Object)qversiontype.getLong("id"));
                DynamicObject idObject = QueryServiceHelper.queryOne((String)MPDM_GANTT_VERSION_TASK, (String)"id", (QFilter[])new QFilter[]{qFilter, versiontypeFilter});
                DynamicObject version = BusinessDataServiceHelper.loadSingle((Object)idObject.getLong("id"), (String)MPDM_GANTT_VERSION_TASK);
                try {
                    this.setVersionDataByPart(version, billFormId);
                }
                catch (Throwable e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PmtsGanttVersionPlugin_17", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                Map<String, Object> returnData = this.getParamMap(billFormId, this.getVersionTypeObject(versiontype), "0");
                this.setVersionData(returnData);
            }
        } else if (BAR_CHANGE.equals(itemKey)) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)BAR_UPDATEPROGRESS) && args.getOperationResult().isSuccess()) {
            List taskModels = (List)GanttCacheUtils.getCacheBigObject((String)this.getView().getPageCache().getPageId(), (String)"dataList");
            List<Object> ids = new ArrayList(16);
            if (!CollectionUtils.isEmpty((Collection)taskModels)) {
                ids = taskModels.stream().map(p -> Long.parseLong(p.getObjId())).collect(Collectors.toList());
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fmm_update_task_progress");
            showParameter.setCustomParam("taskids", ids);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAR_UPDATEPROGRESS));
            this.getView().showForm(showParameter);
        }
    }

    private void taskPlanChange(String billFormId) {
    }

    private void showTaskChangeForm(String billFormId, QFilter qFilter, QFilter currentpublishFilter) {
    }

    private String isRelease(String billFormId) {
        return null;
    }

    private DynamicObject getVersionTypeObject(String versiontype) {
        QFilter nQFilter = new QFilter("number", "=", (Object)versiontype);
        return BusinessDataServiceHelper.loadSingle((String)"mpdm_gantt_versiontype", (String)FiledSetUtil.queryAllFileds((String)"mpdm_gantt_versiontype", null), (QFilter[])new QFilter[]{nQFilter});
    }

    private boolean isExistBaseLine(String versiontype, Object projectObject) {
        boolean isExist = false;
        if (versiontype.contains("baseline")) {
            Long projectnumId = Long.parseLong(projectObject.toString());
            QFilter qFilter = new QFilter("projectnum", "=", (Object)projectnumId);
            QFilter numberQFilter = new QFilter("number", "=", (Object)versiontype);
            DynamicObject qversiontype = QueryServiceHelper.queryOne((String)"mpdm_gantt_versiontype", (String)"id,name", (QFilter[])numberQFilter.toArray());
            QFilter versiontypeFilter = new QFilter(VERSIONTYPE, "=", (Object)qversiontype.getLong("id"));
            isExist = QueryServiceHelper.exists((String)MPDM_GANTT_VERSION_TASK, (QFilter[])new QFilter[]{qFilter, versiontypeFilter});
        }
        return isExist;
    }

    private String getVersionReleaseType(String billFormId) {
        String versionType = "";
        switch (billFormId) {
            case "pmts_task_gantt": {
                versionType = "task_release";
                break;
            }
            case "pmts_task_masterplan": {
                versionType = "masterplan_release";
                break;
            }
            case "pmts_task_regionplan": {
                versionType = "regionplan_release";
                break;
            }
            case "pmts_task_industryplan": {
                versionType = "industryplan_release";
                break;
            }
        }
        return versionType;
    }

    private String getVersionType(String billFormId, String flag) {
        String taskplantype = "";
        switch (billFormId) {
            case "pmts_task_gantt": {
                taskplantype = StringUtils.equals((CharSequence)flag, (CharSequence)"version") ? "task_history_version" : "baseline";
                break;
            }
            case "pmts_task_masterplan": {
                taskplantype = StringUtils.equals((CharSequence)flag, (CharSequence)"version") ? "masterplan_history" : "masterplan_baseline";
                break;
            }
            case "pmts_task_regionplan": {
                taskplantype = StringUtils.equals((CharSequence)flag, (CharSequence)"version") ? "regionplan_history" : "regionplan_baseline";
                break;
            }
            case "pmts_task_industryplan": {
                taskplantype = StringUtils.equals((CharSequence)flag, (CharSequence)"version") ? "industryplan_history" : "industryplan_baseline";
                break;
            }
        }
        return taskplantype;
    }

    private String getPageByBillFormId(String billFormId) {
        String page = "";
        switch (billFormId) {
            case "pmts_task_gantt": {
                page = "pmts_task_gantt_history";
                break;
            }
            case "pmts_task_masterplan": {
                page = "pmts_task_mp_history";
                break;
            }
            case "pmts_task_regionplan": {
                page = "pmts_task_qy_history";
                break;
            }
            case "pmts_task_industryplan": {
                page = "pmts_task_ip_history";
                break;
            }
        }
        return page;
    }

    private Map<String, Object> getParamMap(String billFormId, DynamicObject object, String isDefault) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(16);
        QFilter[] qfilter = new QFilter[]{new QFilter("default", "=", (Object)isDefault), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C"), new QFilter("orgpage.number", "=", (Object)billFormId)};
        DynamicObject[] dy = BusinessDataServiceHelper.load((String)"mpdm_gantt_versiontype", (String)"id", (QFilter[])qfilter);
        if (dy.length > 0 && Objects.nonNull(dy[0])) {
            DynamicObject version = BusinessDataServiceHelper.newDynamicObject((String)"mpdm_gantt_version");
            version.set(VERSIONTYPE, (Object)dy[0]);
            String number = GanttVersionUtils.getVersionNumber((DynamicObject)version);
            returnMap.put("number", number);
            returnMap.put("name", number);
            returnMap.put(VERSIONTYPE, object);
            String filterStr = (String)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"filterStr");
            returnMap.put("filterstr_tag", filterStr);
        }
        return returnMap;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        if (StringUtils.equals((CharSequence)CLOSE_SELECTVERSION, (CharSequence)actionId)) {
            ListSelectedRowCollection rd = (ListSelectedRowCollection)returnData;
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)this.getPageByBillFormId(billFormId), (boolean)false, (int)0, (boolean)false);
            showParameter.setCustomParam("versionId", (Object)rd.get(0).getPrimaryKeyValue().toString());
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (StringUtils.equals((CharSequence)BAR_SAVEVERSION, (CharSequence)actionId) || StringUtils.equals((CharSequence)BAR_PUBLISH, (CharSequence)actionId)) {
            Map result = (Map)returnData;
            String versiontype = "";
            versiontype = StringUtils.equals((CharSequence)BAR_PUBLISH, (CharSequence)actionId) ? this.getVersionReleaseType(billFormId) : this.getVersionType(billFormId, "version");
            QFilter nQFilter = new QFilter("number", "=", (Object)versiontype);
            DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"mpdm_gantt_versiontype", (String)FiledSetUtil.queryAllFileds((String)"mpdm_gantt_versiontype", null), (QFilter[])nQFilter.toArray());
            Map<String, Object> returnMapData = this.getParamMap(billFormId, object, "1");
            GanttBigObjectCache.put((String)this.getView().getPageId(), (String)"isExist", (Object)false);
            returnMapData.put("name", result.get("name"));
            returnMapData.put(BAR_PUBLISH, result.get(BAR_PUBLISH));
            this.setVersionData(returnMapData);
        } else if (StringUtils.equals((CharSequence)BAR_UPDATEPROGRESS, (CharSequence)actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)BAR_CHANGE, (CharSequence)actionId)) {
            DynamicObject[] versions;
            ListSelectedRowCollection rd = (ListSelectedRowCollection)returnData;
            List idlist = rd.stream().map(x -> Long.parseLong(x.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            QFilter versionfilter = new QFilter("version.id", "in", idlist);
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])new QFilter[]{versionfilter});
            DynamicObject[] wbss = BusinessDataServiceHelper.load((String)"pmts_wbs", (String)FiledSetUtil.queryAllFileds((String)"pmts_wbs", null), (QFilter[])new QFilter[]{versionfilter});
            HashMap<String, DynamicObject[]> resourcePlanMap = new HashMap<String, DynamicObject[]>();
            resourcePlanMap.put("pmts_task", tasks);
            resourcePlanMap.put("pmts_wbs", wbss);
            this.setReleaseData(tasks, null, "0");
            this.setReleaseData(wbss, null, "0");
            QFilter idfilter = new QFilter("id", "in", idlist);
            for (DynamicObject version : versions = BusinessDataServiceHelper.load((String)MPDM_GANTT_VERSION_TASK, (String)"id,ischange", (QFilter[])new QFilter[]{idfilter})) {
                version.set("ischange", (Object)true);
            }
            SaveServiceHelper.update((DynamicObject[])versions);
            GanttVersionCreateService createService = (GanttVersionCreateService)TypesContainer.getOrRegisterSingletonInstance((String)GanttVersionServiceEnum.getService((String)GanttVersionServiceEnum.TASK.getType()));
            Map objectMap = BusinessDataServiceHelper.loadFromCache((Object[])idlist.toArray(), (String)MPDM_GANTT_VERSION_TASK);
            objectMap.forEach((k, v) -> createService.setVersionPlans(resourcePlanMap, this.getView(), v));
            ProjectUtils.updateProjectRelease((long)this.getObjetId(PROJECTNUM_ID), (long)this.getObjetId(PLANTYPE_ID), (boolean)false);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\u3002", (String)"PmtsGanttVersionPlugin_12", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    private Long getObjetId(String flag) {
        Object obj = GanttUtils.getFilterValue((String)flag, (String)this.getView().getPageId());
        if (obj == null) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            Map returnData = (Map)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"returnData");
            this.setVersionData(returnData);
            GanttBigObjectCache.remove((String)this.getView().getPageId(), (String[])new String[]{"returnData"});
        }
    }

    private void setVersionDataByPart(DynamicObject version, String billFormId) throws Throwable {
        try (TXHandle h0 = TX.required((String)"setVersionData");){
            try {
                ListView listView = (ListView)this.getView();
                DynamicObject projectnum = this.getBaseData("pmpd_project", PROJECTNUM_ID);
                MulBasedataDynamicObjectCollection planareas = this.getMuBaseData("fmm_planningarea", PLANAREA_ID, "planarea", version);
                MulBasedataDynamicObjectCollection trades = this.getMuBaseData("mpdm_professiona", TRADE_ID, "trade", version);
                MulBasedataDynamicObjectCollection areas = this.getMuBaseData("mpdm_areaproperty", AREAS_ID, "areas", version);
                version.set("projectnum", (Object)projectnum);
                version.set("taskplantype", (Object)listView.getBillFormId());
                if (!StringUtils.equals((CharSequence)billFormId, (CharSequence)PAGE_PMTS_TASK_GANTT)) {
                    DynamicObject plantype = this.getBaseData("fmm_plantype", PLANTYPE_ID);
                    version.set("plantype", (Object)plantype);
                    version.set("planarea", (Object)planareas);
                    version.set("trade", (Object)trades);
                    if (StringUtils.equals((CharSequence)billFormId, (CharSequence)"pmts_task_regionplan")) {
                        version.set("areas", (Object)areas);
                    }
                }
                version.set("modifier", (Object)RequestContext.get().getCurrUserId());
                version.set("modifytime", (Object)System.currentTimeMillis());
                version.set("auditor", (Object)RequestContext.get().getCurrUserId());
                version.set("audittime", (Object)System.currentTimeMillis());
                String filterStr = (String)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"filterStr");
                Map oldGtFilterMap = (Map)JSONObject.parseObject((String)version.getString("filterstr_tag"), Map.class);
                Map newGtFilterMap = (Map)JSONObject.parseObject((String)filterStr, Map.class);
                List<String> keyList = Arrays.asList("ganttentity.id", "viewscheme.id", "useorg.id", PROJECTNUM_ID, !StringUtils.equals((CharSequence)billFormId, (CharSequence)PAGE_PMTS_TASK_GANTT) ? PLANTYPE_ID : "");
                Iterator newIter = newGtFilterMap.entrySet().iterator();
                while (newIter.hasNext()) {
                    Map.Entry entry1 = newIter.next();
                    if (keyList.contains(entry1.getKey())) continue;
                    if (((String)entry1.getKey()).equals("planstartdate")) {
                        JSONObject newvalue = (JSONObject)entry1.getValue();
                        JSONObject oldvalue = (JSONObject)oldGtFilterMap.get(entry1.getKey());
                        JSONArray oldvalues = oldvalue.getJSONArray("value");
                        JSONArray newvalues = newvalue.getJSONArray("value");
                        JSONArray values = new JSONArray(2);
                        if (!oldvalues.isEmpty() && !newvalues.isEmpty() && oldvalues.size() == newvalues.size() && oldvalues.size() == 2) {
                            Date oldStartDate = DateUtils.parseDate((String)oldvalues.getString(0), (String[])new String[]{DATE_FORMAT});
                            Date newStartDate = DateUtils.parseDate((String)newvalues.getString(0), (String[])new String[]{DATE_FORMAT});
                            Date oldEndDate = DateUtils.parseDate((String)oldvalues.getString(1), (String[])new String[]{DATE_FORMAT});
                            Date newEndDate = DateUtils.parseDate((String)newvalues.getString(1), (String[])new String[]{DATE_FORMAT});
                            if (newStartDate.before(oldStartDate)) {
                                values.add((Object)newvalues.getString(0));
                            } else {
                                values.add((Object)oldvalues.getString(0));
                            }
                            if (newEndDate.after(oldEndDate)) {
                                values.add((Object)newvalues.getString(1));
                            } else {
                                values.add((Object)oldvalues.getString(1));
                            }
                        }
                        newvalue.put("value", (Object)values);
                        continue;
                    }
                    newIter.remove();
                }
                version.set("filterstr_tag", (Object)JSONObject.toJSONString((Object)newGtFilterMap));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{version});
                GanttVersionCreateService createService = (GanttVersionCreateService)TypesContainer.getOrRegisterSingletonInstance((String)GanttVersionServiceEnum.getService((String)GanttVersionServiceEnum.TASK.getType()));
                createService.createVersion(version, this.getView());
                DynamicObject versiontype = (DynamicObject)version.get(VERSIONTYPE);
                if (StringUtils.contains((CharSequence)versiontype.getString("number"), (CharSequence)"baseline")) {
                    OperationServiceHelper.executeOperate((String)BAR_SAVEVERSION, (String)MPDM_GANTT_VERSION_TASK, (DynamicObject[])new DynamicObject[]{version}, (OperateOption)OperateOption.create());
                }
                GanttBigObjectCache.remove((String)this.getView().getPageId(), (String[])new String[]{"isExist"});
            }
            catch (Throwable e) {
                h0.markRollback();
                throw e;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PmtsGanttVersionPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    private void setVersionData(Map<String, Object> returnData) {
        if (returnData == null || returnData.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        try (TXHandle h0 = TX.required((String)"setVersionData");){
            ListView listView = (ListView)this.getView();
            DynamicObject version = BusinessDataServiceHelper.newDynamicObject((String)MPDM_GANTT_VERSION_TASK);
            DynamicObject projectnum = this.getBaseData("pmpd_project", PROJECTNUM_ID);
            DynamicObject plantype = this.getBaseData("fmm_plantype", PLANTYPE_ID);
            MulBasedataDynamicObjectCollection planareas = this.getMuBaseData("fmm_planningarea", PLANAREA_ID, "planarea", version);
            MulBasedataDynamicObjectCollection trades = this.getMuBaseData("mpdm_professiona", TRADE_ID, "trade", version);
            MulBasedataDynamicObjectCollection areas = this.getMuBaseData("mpdm_areaproperty", AREAS_ID, "areas", version);
            version.set("projectnum", (Object)projectnum);
            version.set("taskplantype", (Object)listView.getBillFormId());
            version.set("planarea", (Object)planareas);
            version.set("plantype", (Object)plantype);
            version.set("trade", (Object)trades);
            version.set("areas", (Object)areas);
            version.set("sourcetype", (Object)"1");
            if (returnData.containsKey("name")) {
                version.set("name", returnData.get("name"));
            }
            Boolean publish = returnData.get(BAR_PUBLISH) == null ? Boolean.FALSE : (Boolean)returnData.get(BAR_PUBLISH);
            version.set("currentpublish", (Object)publish);
            if (publish.booleanValue()) {
                ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                List ganttRowDataModelList = (List)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"dataList");
                List wbsSelectList = ganttRowDataModelList.stream().filter(x -> x.getIsSelect()).collect(Collectors.toList());
                String billFormId = formShowParameter.getBillFormId();
                String publishtype = "";
                publishtype = wbsSelectList.isEmpty() ? (billFormId.equals(PAGE_PMTS_TASK_GANTT) ? "1" : "3") : (billFormId.equals(PAGE_PMTS_TASK_GANTT) ? "2" : "4");
                version.set("publishtype", (Object)publishtype);
                version.set("id", (Object)ID.genLongId());
                this.updateHistoryVersionPublish(version);
                GanttVersionCreateService.setVersion(returnData, (DynamicObject)version);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"PmtsGanttVersionPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
                ProjectUtils.updateProjectRelease((long)(projectnum == null ? 0L : projectnum.getLong("id")), (long)(plantype == null ? 0L : plantype.getLong("id")), (boolean)true);
                this.getView().invokeOperation("refresh");
                return;
            }
            try {
                GanttVersionCreateService.setVersion(returnData, (DynamicObject)version);
                GanttVersionCreateService createService = (GanttVersionCreateService)TypesContainer.getOrRegisterSingletonInstance((String)GanttVersionServiceEnum.getService((String)GanttVersionServiceEnum.TASK.getType()));
                createService.createVersion(version, this.getView());
                DynamicObject versiontype = (DynamicObject)version.get(VERSIONTYPE);
                if (StringUtils.contains((CharSequence)versiontype.getString("number"), (CharSequence)"baseline")) {
                    OperationServiceHelper.executeOperate((String)BAR_SAVEVERSION, (String)MPDM_GANTT_VERSION_TASK, (DynamicObject[])new DynamicObject[]{version}, (OperateOption)OperateOption.create());
                }
                GanttBigObjectCache.remove((String)this.getView().getPageId(), (String[])new String[]{"isExist"});
            }
            catch (Throwable throwable2) {
                h0.markRollback();
                throw throwable2;
            }
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PmtsGanttVersionPlugin_7", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    public void updateHistoryVersionPublish(DynamicObject newVersion) {
        Object obj = GanttUtils.getFilterValue((String)PROJECTNUM_ID, (String)this.getView().getPageId());
        if (Objects.nonNull(obj)) {
            Long projectnumId = Long.parseLong(obj.toString());
            ArrayList<QFilter> taskFilters = new ArrayList<QFilter>(4);
            ArrayList<QFilter> wbsFilters = new ArrayList<QFilter>(4);
            ArrayList<QFilter> versionFilters = new ArrayList<QFilter>(4);
            QFilter qFilter = new QFilter("projectnum", "=", (Object)projectnumId);
            QFilter vfilter = new QFilter("version.id", "is null", null);
            vfilter.or("version.id", "=", (Object)0);
            taskFilters.add(qFilter);
            taskFilters.add(vfilter);
            versionFilters.add(qFilter);
            if (newVersion.getDynamicObject("plantype") != null) {
                QFilter plantypeFilter = new QFilter(PLANTYPE_ID, "=", (Object)newVersion.getDynamicObject("plantype").getLong("id"));
                taskFilters.add(plantypeFilter);
                versionFilters.add(plantypeFilter);
            }
            wbsFilters.addAll(taskFilters);
            QFilter isphchangeFilter = new QFilter("ischange", "=", (Object)"1");
            QFilter currentpublishFilter = new QFilter("currentpublish", "=", (Object)"1");
            versionFilters.add(isphchangeFilter);
            versionFilters.add(currentpublishFilter);
            List ganttRowDataModelList = (List)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"dataList");
            List selectWbsList = ganttRowDataModelList.stream().filter(x -> x.getIsSelect()).collect(Collectors.toList());
            ArrayList<Long> versionIds = new ArrayList<Long>();
            DynamicObjectCollection versionTasks = QueryServiceHelper.query((String)MPDM_GANTT_VERSION_TASK, (String)"id", (QFilter[])taskFilters.toArray(new QFilter[versionFilters.size()]));
            for (DynamicObject versionTask : versionTasks) {
                versionIds.add(versionTask.getLong("id"));
            }
            if (!selectWbsList.isEmpty()) {
                List<GanttRowDataModel> wbsList = ganttRowDataModelList.stream().filter(x -> StringUtils.equals((CharSequence)x.getEntityFlag(), (CharSequence)"pmts_wbs")).collect(Collectors.toList());
                HashSet<Long> wbsIdSet = new HashSet<Long>(selectWbsList.size());
                for (GanttRowDataModel ganttRowDataModel : selectWbsList) {
                    wbsIdSet.add(Long.parseLong(ganttRowDataModel.getObjId()));
                    this.findParentWbsId(ganttRowDataModel.getObjId(), wbsList, wbsIdSet);
                    this.findChildWbsId(ganttRowDataModel.getObjId(), wbsList, wbsIdSet);
                }
                taskFilters.add(new QFilter("wbs.id", "in", (Object)wbsIdSet.toArray()));
                QFilter wbsQilter = new QFilter("id", "in", (Object)wbsIdSet.toArray());
                wbsFilters.add(wbsQilter);
                QFilter vwbsQilter = new QFilter("version.id", "in", (Object)versionIds.toArray());
                DynamicObjectCollection wbsCollection = QueryServiceHelper.query((String)"pmts_wbs", (String)"number", (QFilter[])wbsQilter.toArray());
                DynamicObjectCollection vwbsCollection = QueryServiceHelper.query((String)"pmts_wbs", (String)"number,version.id", (QFilter[])vwbsQilter.toArray());
                versionIds.clear();
                block2: for (DynamicObject wbs : wbsCollection) {
                    String number = wbs.getString("number");
                    for (DynamicObject vwbs : vwbsCollection) {
                        String vnumber = vwbs.getString("number");
                        if (!vnumber.contains("&") || !vnumber.contains(number)) continue;
                        versionIds.add(vwbs.getLong("version.id"));
                        break block2;
                    }
                }
            }
            QFilter vidQfilter = new QFilter("id", "in", (Object)versionIds.toArray());
            QFilter versonidQfilter = new QFilter("version.id", "in", (Object)versionIds.toArray());
            DeleteServiceHelper.delete((String)MPDM_GANTT_VERSION_TASK, (QFilter[])vidQfilter.toArray());
            DeleteServiceHelper.delete((String)"pmts_wbs", (QFilter[])versonidQfilter.toArray());
            DeleteServiceHelper.delete((String)"pmts_task", (QFilter[])versonidQfilter.toArray());
            DynamicObject[] wbss = BusinessDataServiceHelper.load((String)"pmts_wbs", (String)FiledSetUtil.queryAllFileds((String)"pmts_wbs", null), (QFilter[])wbsFilters.toArray(new QFilter[wbsFilters.size()]));
            DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)FiledSetUtil.queryAllFileds((String)"pmts_task", null), (QFilter[])taskFilters.toArray(new QFilter[taskFilters.size()]));
            this.setReleaseData(wbss, newVersion, "1");
            if (tasks != null && tasks.length > 0) {
                DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmts", (String)"ICalSysPrecentService", (String)"calSysPrecent", (Object[])new Object[]{new HashSet(Arrays.stream(tasks).map(x -> x.getLong("id")).collect(Collectors.toList()))});
                this.setReleaseData(tasks, newVersion, "1");
            }
        }
    }

    private void findParentWbsId(String selfId, List<GanttRowDataModel> wbsRowDataModelList, Set<Long> wbsIdSet) {
        String id = "";
        block0: for (GanttRowDataModel ganttRowDataModel : wbsRowDataModelList) {
            List childNodes = ganttRowDataModel.getChildNodes();
            if (ganttRowDataModel.getEntityFlag().equals("pmpd_project")) continue;
            for (GanttRowDataModel childNode : childNodes) {
                if (!StringUtils.equals((CharSequence)childNode.getObjId(), (CharSequence)selfId)) continue;
                wbsIdSet.add(Long.parseLong(ganttRowDataModel.getObjId()));
                id = ganttRowDataModel.getObjId();
                childNodes.forEach(obj -> wbsIdSet.add(Long.parseLong(obj.getObjId())));
                break block0;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            this.findParentWbsId(id, wbsRowDataModelList, wbsIdSet);
        }
    }

    private void findChildWbsId(String selfId, List<GanttRowDataModel> wbsRowDataModelList, Set<Long> wbsIdSet) {
        ArrayList<String> idlist = new ArrayList<String>(16);
        for (GanttRowDataModel ganttRowDataModel : wbsRowDataModelList) {
            if (!StringUtils.equals((CharSequence)ganttRowDataModel.getParentObjId(), (CharSequence)selfId)) continue;
            wbsIdSet.add(Long.parseLong(ganttRowDataModel.getObjId()));
            idlist.add(ganttRowDataModel.getObjId());
        }
        if (!idlist.isEmpty()) {
            idlist.forEach(id -> this.findChildWbsId((String)id, wbsRowDataModelList, wbsIdSet));
        }
    }

    private void setReleaseData(DynamicObject[] datas, DynamicObject newVersion, String releasestatus) {
        Date releasetime = new Date();
        for (DynamicObject data : datas) {
            data.set("releasestatus", (Object)releasestatus);
            data.set("version", (Object)newVersion);
            data.set("status", (Object)("1".equals(releasestatus) ? "C" : "A"));
            if (!data.getDataEntityType().getName().equals("pmts_task") || data.getDate("releasetime") != null) continue;
            data.set("releasetime", (Object)releasetime);
        }
        SaveServiceHelper.update((DynamicObject[])datas);
    }

    private DynamicObject getBaseData(String entityName, String key) {
        DynamicObject object = null;
        Object obj = GanttUtils.getFilterValue((String)key, (String)this.getView().getPageId());
        if (Objects.nonNull(obj)) {
            long pid = Long.parseLong(obj.toString());
            object = BusinessDataServiceHelper.loadSingle((Object)pid, (String)entityName);
        }
        return object;
    }

    private MulBasedataDynamicObjectCollection getMuBaseData(String entityName, String key, String filed, DynamicObject version) {
        Object value = GanttUtils.getFilterValue((String)key, (String)this.getView().getPageId());
        if (value == null) {
            return null;
        }
        MulBasedataDynamicObjectCollection objects = (MulBasedataDynamicObjectCollection)version.get(filed);
        if (value instanceof List) {
            List idlist = (List)GanttUtils.getFilterValue((String)key, (String)this.getView().getPageId());
            if (!CollectionUtils.isEmpty((Collection)idlist)) {
                long[] longs = DB.genGlobalLongIds((int)idlist.size());
                int i = 0;
                for (Long id : idlist) {
                    DynamicObject object2;
                    boolean flag = false;
                    for (DynamicObject object2 : objects) {
                        if (object2.getDynamicObject("fbasedataid").getLong("id") != id.longValue()) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    DynamicObject dynamicObject = objects.addNew();
                    object2 = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
                    dynamicObject.set("pkid", (Object)longs[i]);
                    dynamicObject.set("fbasedataid", (Object)object2);
                    dynamicObject.set("fbasedataid_id", dynamicObject.get("fbasedataid_id"));
                    ++i;
                }
            }
        } else if (value instanceof Long) {
            Long id = (Long)value;
            boolean flag = false;
            for (DynamicObject object : objects) {
                if (object.getDynamicObject("fbasedataid").getLong("id") != id.longValue()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                long pkid = DB.genGlobalLongId();
                DynamicObject dynamicObject = objects.addNew();
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
                dynamicObject.set("pkid", (Object)pkid);
                dynamicObject.set("fbasedataid", (Object)object);
                dynamicObject.set("fbasedataid_id", dynamicObject.get("fbasedataid_id"));
            }
        }
        return objects;
    }
}

