/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmtsTaskListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = e.getQFilters();
        qFilters.removeIf(x -> StringUtils.equals((CharSequence)x.getProperty(), (CharSequence)"ctrlstrategy"));
        String versionId = (String)param.getCustomParam("versionId");
        if (StringUtils.isBlank((CharSequence)versionId)) {
            QFilter vfilter = new QFilter("version.id", "is null", null);
            vfilter.or("version.id", "=", (Object)0);
            qFilters.add(vfilter);
        } else {
            qFilters.removeIf(x -> x.getProperty().contains("version"));
            QFilter filter = new QFilter("version.id", "=", (Object)Long.parseLong(versionId));
            qFilters.add(filter);
        }
        if (param.isLookUp()) {
            List nqFilters = qFilters.stream().filter(qFilter -> StringUtils.equals((CharSequence)qFilter.getProperty(), (CharSequence)"status") || StringUtils.equals((CharSequence)qFilter.getProperty(), (CharSequence)"enable")).collect(Collectors.toList());
            qFilters.removeAll(nqFilters);
        }
        e.setOrderBy("modifytime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        HashMap idToName = new HashMap(8);
        DynamicObjectCollection pmpd_project = QueryServiceHelper.query((String)"pmpd_project", (String)"id,name", null);
        pmpd_project.forEach(project -> idToName.put(project.getString("id"), new LocaleString(project.getString("name"))));
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.contains("projectnum.number")) continue;
            String defprojectid = this.getPageCache().get("defprojectid");
            if (StringUtils.isNotEmpty((CharSequence)defprojectid)) {
                filterColumn.setDefaultValue(defprojectid);
            }
            CommonBaseDataFilterColumn baseDataFilterColumn = (CommonBaseDataFilterColumn)filterColumn;
            List comboItems = baseDataFilterColumn.getComboItems();
            comboItems.forEach(comboItem -> comboItem.setCaption((LocaleString)idToName.get(comboItem.getValue())));
            break;
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DealNumberProvider());
    }

    static class DealNumberProvider
    extends ListDataProvider {
        DealNumberProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (data.isEmpty()) {
                return data;
            }
            DataEntityPropertyCollection properties = ((DynamicObject)data.get(0)).getDataEntityType().getProperties();
            boolean hasNumber = properties.containsKey((Object)"number");
            if (hasNumber) {
                for (DynamicObject obj : data) {
                    obj.set("number", (Object)obj.getString("number").split("&")[0]);
                }
            }
            return data;
        }
    }
}

