/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttRowDataModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.pmc.pmpd.common.util.ProjectUtils;
import kd.pmc.pmts.business.helper.ProjectPlanReleaseHelper;
import kd.pmc.pmts.common.util.SingleProjectBenchLockUtils;

public class ProjectPlanReleasePlugin
extends AbstractListPlugin {
    private static final String RELEASE = "releaseplan";
    private static final String UNRELEASE = "unreleaseplan";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Boolean lock;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)RELEASE, (CharSequence)operateKey) && (lock = SingleProjectBenchLockUtils.judgeProjectIsLock((Long)this.getProjectId())).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u8ba1\u5212\u6b63\u5728\u3010\u9879\u76ee\u5de5\u4f5c\u53f0\u3011\u4e2d\u7f16\u5236\uff0c\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ProjectPlanReleasePlugin_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)RELEASE, (CharSequence)operateKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fmm_gantt_version_name");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            showParameter.setCustomParam("publish", (Object)Boolean.TRUE);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)UNRELEASE, (CharSequence)operateKey)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_gantt_version_task", (boolean)false);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("projectnum", "=", (Object)this.getProjectId()));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("plantype", "=", (Object)this.getPlanTypeId()));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("versiontype", "in", ProjectPlanReleaseHelper.PLANTYPE_VERSIONTYPE.values()));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (returnData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)RELEASE, (CharSequence)actionId)) {
            try {
                ProjectPlanReleaseHelper.release((Map)((Map)returnData), (Object)this.getProjectId(), (Object)this.getPlanTypeId(), this.getDataIds(), (String)((String)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"filterStr")));
                ProjectUtils.updateProjectRelease((long)this.getProjectId(), (long)this.getProjectId(), (boolean)true);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"ProjectPlanReleasePlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
            finally {
                this.getView().invokeOperation("refresh");
            }
        }
        if (StringUtils.equals((CharSequence)UNRELEASE, (CharSequence)actionId)) {
            try {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
                ProjectPlanReleaseHelper.unRelease((Object)selectedRows.getPrimaryKeyValues()[0]);
                ProjectUtils.updateProjectRelease((long)this.getProjectId(), (long)this.getProjectId(), (boolean)false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f\u3002", (String)"ProjectPlanReleasePlugin_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
            finally {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private long getPlanTypeId() {
        long planTypeId = 0L;
        String pageId = this.getView().getPageId();
        Object filterValue = GanttUtils.getFilterValue((String)"plantype.id", (String)pageId);
        if (filterValue instanceof Long) {
            planTypeId = (Long)filterValue;
        }
        return planTypeId;
    }

    private long getProjectId() {
        long projectId = 0L;
        String pageId = this.getView().getPageId();
        Object filterValue = GanttUtils.getFilterValue((String)"projectnum.id", (String)pageId);
        if (filterValue instanceof Long) {
            projectId = (Long)filterValue;
        }
        return projectId;
    }

    private Set<Long> getDataIds() {
        HashSet<Long> dataIds = new HashSet<Long>();
        List allDatas = (List)GanttBigObjectCache.get((String)this.getView().getPageId(), (String)"dataList");
        HashSet<GanttRowDataModel> selectDatas = new HashSet<GanttRowDataModel>();
        LinkedHashMap<String, GanttRowDataModel> allDatasMap = new LinkedHashMap<String, GanttRowDataModel>(16);
        boolean isAllDatas = false;
        for (GanttRowDataModel ganttRowDataModel : allDatas) {
            allDatasMap.put(ganttRowDataModel.getObjId(), ganttRowDataModel);
            if (!ganttRowDataModel.getIsSelect().booleanValue()) continue;
            selectDatas.add(ganttRowDataModel);
            if (!StringUtils.equals((CharSequence)Long.toString(this.getProjectId()), (CharSequence)ganttRowDataModel.getObjId())) continue;
            isAllDatas = true;
        }
        if (selectDatas.isEmpty()) {
            isAllDatas = true;
        }
        HashSet topDatas = isAllDatas ? new HashSet(allDatas) : new HashSet();
        selectDatas.forEach(selectData -> this.findTopDataId((GanttRowDataModel)selectData, (Map<String, GanttRowDataModel>)allDatasMap, topDatas));
        topDatas.forEach(topData -> this.findAllChildren((GanttRowDataModel)topData, (Set<Long>)dataIds));
        return dataIds;
    }

    private void findTopDataId(GanttRowDataModel selectData, Map<String, GanttRowDataModel> allDatas, Set<GanttRowDataModel> topDatas) {
        if (selectData == null) {
            return;
        }
        for (GanttRowDataModel ganttRowDataModel : allDatas.values()) {
            String parentObjId = ganttRowDataModel.getParentObjId();
            String objId = ganttRowDataModel.getObjId();
            if (!StringUtils.equals((CharSequence)selectData.getObjId(), (CharSequence)objId)) continue;
            if (StringUtils.equals((CharSequence)parentObjId, (CharSequence)Long.toString(this.getProjectId()))) {
                topDatas.add(ganttRowDataModel);
                continue;
            }
            this.findTopDataId(allDatas.get(parentObjId), allDatas, topDatas);
        }
    }

    private void findAllChildren(GanttRowDataModel topData, Set<Long> allDatasId) {
        allDatasId.add(Long.parseLong(topData.getObjId()));
        List childNodes = topData.getChildNodes();
        if (childNodes.isEmpty()) {
            return;
        }
        for (GanttRowDataModel chidNode : childNodes) {
            allDatasId.add(Long.parseLong(chidNode.getObjId()));
            this.findAllChildren(chidNode, allDatasId);
        }
    }
}

