/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bd.mpdm.common.gantt.util.GanttCacheUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.util.DateUtil;

public class TaskProgressUpdatePlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"finishpercent")) {
            ChangeData[] changeDatas = e.getChangeSet();
            this.getModel().setValue("ischangepercent", (Object)true, changeDatas[0].getRowIndex());
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map<Long, Long> relations = this.getInitIdToVersionDataId();
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pmts", (String)"ICalSysPrecentService", (String)"calSystemPercent", (Object[])new Object[]{new ArrayList<Long>(relations.keySet())});
        this.updateVersionTasks(relations);
        this.initDatas(relations.keySet());
    }

    private void initDatas(Set<Long> taskIds) {
        DynamicObjectCollection taskdata = QueryServiceHelper.query((String)"pmts_task", (String)"id,name,number,finishpercent,sysactualper,ischangepercent", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)}, (String)this.getSortField());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tablevs = this.getTableSetter();
        BigDecimal hundred = new BigDecimal(100);
        for (DynamicObject taskdatum : taskdata) {
            Object finishpercent = !taskdatum.getBoolean("ischangepercent") ? taskdatum.getBigDecimal("sysactualper").multiply(hundred) : taskdatum.get("finishpercent");
            tablevs.addRow(new Object[]{taskdatum.get("id"), taskdatum.get("number"), taskdatum.get("name"), finishpercent, taskdatum.get("sysactualper"), taskdatum.get("ischangepercent")});
        }
        model.batchCreateNewEntryRow("entryentity", tablevs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private TableValueSetter getTableSetter() {
        TableValueSetter tablevs = new TableValueSetter(new String[0]);
        tablevs.addField("id", new Object[0]);
        tablevs.addField("number", new Object[0]);
        tablevs.addField("name", new Object[0]);
        tablevs.addField("finishpercent", new Object[0]);
        tablevs.addField("sysactualper", new Object[0]);
        tablevs.addField("ischangepercent", new Object[0]);
        return tablevs;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String srcCtrlKey = con.getKey().toLowerCase();
        if (BTNOK.equals(srcCtrlKey)) {
            this.clickBtnOK();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TaskProgressUpdatePlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().close();
        }
    }

    private String getSortField() {
        DynamicObject dataSource = (DynamicObject)GanttCacheUtils.getCacheBigObject((String)this.getView().getParentView().getPageId(), (String)"datasource");
        DynamicObjectCollection entityselects = dataSource.getDynamicObjectCollection("entityselect");
        String sortField = "";
        block0: for (DynamicObject entityselect : entityselects) {
            DynamicObjectCollection entityCondition = entityselect.getDynamicObjectCollection("entitycondition");
            for (DynamicObject condition : entityCondition) {
                DynamicObject centity = condition.getDynamicObject("centity");
                if (!"pmts_task".equals(centity.getString("number"))) continue;
                sortField = condition.getString("fieldsortflag");
                break block0;
            }
        }
        return sortField;
    }

    private void clickBtnOK() {
        Map<Long, Long> relations = this.getInitIdToVersionDataId();
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,finishpercent,plantime,actualstartdate,actualdate,ischangepercent", (QFilter[])new QFilter[]{new QFilter("id", "in", relations.keySet())});
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        block0: for (DynamicObject task : tasks) {
            for (DynamicObject object : entryentity) {
                if (task.getLong("id") != object.getLong("id")) continue;
                task.set("finishpercent", object.get("finishpercent"));
                task.set("ischangepercent", object.get("ischangepercent"));
                BigDecimal plantime = task.getBigDecimal("plantime");
                BigDecimal finishpercent = object.getBigDecimal("finishpercent");
                finishpercent = finishpercent.divide(new BigDecimal(100));
                Date actualstartdate = task.getDate("actualstartdate");
                if (!Objects.nonNull(plantime) || !Objects.nonNull(finishpercent) || finishpercent.compareTo(BigDecimal.ZERO) <= 0 || actualstartdate == null) continue block0;
                BigDecimal actualtime = plantime.multiply(finishpercent);
                Double seconds = actualtime.doubleValue() * 24.0 * 60.0 * 60.0;
                Date actualEndDate = DateUtil.addSecond((Date)actualstartdate, (long)seconds.longValue());
                task.set("actualdate", (Object)actualEndDate);
                continue block0;
            }
        }
        SaveServiceHelper.update((DynamicObject[])tasks);
        this.updateVersionTasks(relations);
    }

    private void updateVersionTasks(Map<Long, Long> relations) {
        DynamicObject[] versionTasks;
        DynamicObjectCollection tasks = QueryServiceHelper.query((String)"pmts_task", (String)"id,finishpercent,sysactualper,ischangepercent", (QFilter[])new QFilter("id", "in", relations.keySet()).toArray());
        LinkedHashMap<Long, DynamicObject> taskMap = new LinkedHashMap<Long, DynamicObject>(16);
        for (DynamicObject task : tasks) {
            taskMap.put(task.getLong("id"), task);
        }
        for (DynamicObject versionTask : versionTasks = BusinessDataServiceHelper.load((String)"pmts_task", (String)"id,initid,finishpercent,sysactualper,ischangepercent", (QFilter[])new QFilter("id", "in", relations.values()).toArray())) {
            long initid = versionTask.getLong("initid");
            DynamicObject task = (DynamicObject)taskMap.get(initid);
            if (task == null) continue;
            versionTask.set("finishpercent", task.get("finishpercent"));
            versionTask.set("sysactualper", task.get("sysactualper"));
            versionTask.set("ischangepercent", task.get("ischangepercent"));
        }
        SaveServiceHelper.save((DynamicObject[])versionTasks);
    }

    private Map<Long, Long> getInitIdToVersionDataId() {
        LinkedHashMap<Long, Long> relations = new LinkedHashMap<Long, Long>(16);
        Object taskids = this.getView().getFormShowParameter().getCustomParam("taskids");
        if (taskids == null) {
            return relations;
        }
        DynamicObjectCollection versionTasks = QueryServiceHelper.query((String)"pmts_task", (String)"id,initid", (QFilter[])new QFilter[]{new QFilter("id", "in", taskids)});
        for (DynamicObject versionTask : versionTasks) {
            relations.put(versionTask.getLong("initid"), versionTask.getLong("id"));
        }
        return relations;
    }
}

