/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttDataSource;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttLinkTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.util.GanttBigObjectCache;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;
import kd.pmc.pmts.business.helper.SimpleTaskCaculateHelper;
import kd.pmc.pmts.common.helper.TaskScheduleHelper;

public class CrosslineCommand
extends AbstractGanttCommand {
    private static final String TASKRELATION_ONE = "1";
    private static final String TASKRELATION_TWO = "2";
    private static final String TASKRELATION_THREE = "3";
    private static final String TASKRELATION_FOUR = "4";

    public void execute(GanttCommandContext ctx) {
        GanttDataSource ganttDataSource = TaskScheduleHelper.getDataSourceIntoCache();
        GanttLinkTaskModel ganttLinkTaskModel = GanttUtils.getGanttLinkTaskModel((String)ctx.getFilterArg().getFilterDataJson());
        List ganttTaskModels = (List)GanttBigObjectCache.get((String)ctx.getView().getPageId(), (String)"taskDataList");
        boolean isLeftline = true;
        boolean isRightline = true;
        String taskrelation = GanttUtils.convertRelationsToValue((String)ganttLinkTaskModel.getStartLinePosType(), (String)ganttLinkTaskModel.getEndLinePosType());
        for (GanttTaskModel ganttTaskModel : ganttTaskModels) {
            if (!ganttTaskModel.isSubcross()) continue;
            if (StringUtils.equals((CharSequence)ganttTaskModel.getTaskId(), (CharSequence)ganttLinkTaskModel.getTaskId())) {
                if (!ganttTaskModel.isLeftLine() && (StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_THREE) || StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_FOUR))) {
                    isLeftline = false;
                }
                if (!ganttTaskModel.isRightLine() && (StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_ONE) || StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_TWO))) {
                    isRightline = false;
                }
            }
            if (StringUtils.equals((CharSequence)ganttTaskModel.getTaskId(), (CharSequence)ganttLinkTaskModel.getTaskLinkId())) {
                if (!ganttTaskModel.isLeftLine() && (StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_ONE) || StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_THREE))) {
                    isLeftline = false;
                }
                if (!ganttTaskModel.isRightLine() && (StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_TWO) || StringUtils.equals((CharSequence)taskrelation, (CharSequence)TASKRELATION_FOUR))) {
                    isRightline = false;
                }
            }
            if (isLeftline && isRightline) continue;
            break;
        }
        if (isLeftline && isRightline) {
            this.crossLine(ganttLinkTaskModel, ganttDataSource, ctx.getPageCache().getPageId());
            GanttUtils.ganttRefresh((IFormView)ctx.getView());
        } else {
            if (!isLeftline) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6bb5\u6a2a\u9053\u5de6\u4fa7\u4e0d\u53ef\u8fde\u7ebf\u3002", (String)"CrosslineCommand_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
            if (!isRightline) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u6bb5\u6a2a\u9053\u53f3\u4fa7\u4e0d\u53ef\u8fde\u7ebf\u3002", (String)"CrosslineCommand_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void crossLine(GanttLinkTaskModel ganttLinkTaskModel, GanttDataSource ganttDataSource, String pageId) {
        List<Object> idList = null;
        try (TXHandle h0 = TX.required((String)"crossLine");){
            try {
                String taskId = ganttLinkTaskModel.getTaskId().split("_")[2];
                String taskLinkId = ganttLinkTaskModel.getTaskLinkId().split("_")[2];
                DynamicObject selfObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)ganttDataSource.getEntityFlag());
                boolean isBaseDataEntityType = false;
                if (selfObj.getDataEntityType() instanceof BasedataEntityType) {
                    isBaseDataEntityType = true;
                }
                DynamicObject connectObj = BusinessDataServiceHelper.loadSingle((Object)taskLinkId, (String)ganttDataSource.getEntityFlag());
                String posttaskrelation = GanttUtils.convertRelationsToValue((String)ganttLinkTaskModel.getStartLinePosType(), (String)ganttLinkTaskModel.getEndLinePosType());
                Map entityTypeMap = MetadataServiceHelper.getDataEntityType((String)ganttDataSource.getEntityFlag()).getAllEntities();
                String postTableName = ((EntityType)entityTypeMap.get(ganttDataSource.getPostRalationFlag())).getAlias();
                Map<String, String> paramMap = this.getParamMap(ganttDataSource.getPostentity(), ganttDataSource.getPostRalation(), ganttDataSource.getPostRalationFlag(), postTableName);
                this.savePositiontask(taskLinkId, posttaskrelation, connectObj, selfObj, paramMap, isBaseDataEntityType);
                String pretTableName = ((EntityType)entityTypeMap.get(ganttDataSource.getPreralationFlag())).getAlias();
                paramMap = this.getParamMap(ganttDataSource.getPreentity(), ganttDataSource.getPreralation(), ganttDataSource.getPreralationFlag(), pretTableName);
                this.savePositiontask(taskId, posttaskrelation, selfObj, connectObj, paramMap, isBaseDataEntityType);
                SimpleTaskCaculateHelper.caculateTask((DynamicObject[])new DynamicObject[]{connectObj}, (String)pageId);
                idList = Arrays.asList(Long.parseLong(taskId), Long.parseLong(taskLinkId));
            }
            catch (Throwable throwable) {
                h0.markRollback();
                throw throwable;
            }
        }
        if (idList != null) {
            ProjectPlanTypeHelper.projectPlanTypeTaskEdit(idList);
        }
    }

    private Map<String, String> getParamMap(String positiontaskname, String taskrelation, String positiontaskentry, String tablename) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("positiontaskname", positiontaskname);
        paramMap.put("taskrelation", taskrelation);
        paramMap.put("positiontaskentry", positiontaskentry);
        paramMap.put("tablename", tablename);
        return paramMap;
    }

    private void savePositiontask(String taskLinkId, String taskrelation, DynamicObject connectObj, DynamicObject selfObj, Map<String, String> paramMap, boolean isBaseDataEntityType) {
        DynamicObjectCollection selfTaskentrys = selfObj.getDynamicObjectCollection(paramMap.get("positiontaskentry"));
        this.deleteEntryData(selfTaskentrys, paramMap.get("positiontaskname"), taskLinkId, null, isBaseDataEntityType);
        DynamicObjectType objType = selfTaskentrys.getDynamicObjectType();
        DynamicObject postentry = new DynamicObject(objType);
        if (isBaseDataEntityType) {
            postentry.set(paramMap.get("positiontaskname"), (Object)connectObj);
        } else {
            postentry.set(paramMap.get("positiontaskname"), (Object)taskLinkId);
        }
        postentry.set(paramMap.get("taskrelation"), (Object)taskrelation);
        selfTaskentrys.add((Object)postentry);
        selfObj.set(paramMap.get("positiontaskentry"), (Object)selfTaskentrys);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{selfObj});
        DynamicObjectCollection connectTaskentrys = connectObj.getDynamicObjectCollection(paramMap.get("positiontaskentry"));
        this.deleteEntryData(connectTaskentrys, paramMap.get("positiontaskname"), selfObj.getString("id"), paramMap.get("tablename"), isBaseDataEntityType);
    }

    private void deleteEntryData(DynamicObjectCollection taskentrys, String positiontaskname, String id, String tableName, boolean isBaseDataEntityType) {
        Iterator iterator = taskentrys.iterator();
        while (iterator.hasNext()) {
            DynamicObject object = (DynamicObject)iterator.next();
            boolean idEqual = false;
            if (isBaseDataEntityType) {
                DynamicObject positiontask = object.getDynamicObject(positiontaskname);
                if (positiontask != null) {
                    idEqual = StringUtils.equals((CharSequence)positiontask.getString("id"), (CharSequence)id);
                }
            } else {
                idEqual = StringUtils.equals((CharSequence)object.getString("id"), (CharSequence)id);
            }
            if (!idEqual) continue;
            if (StringUtils.isBlank((CharSequence)tableName)) {
                iterator.remove();
                break;
            }
            this.executeDelete(object, tableName);
            break;
        }
    }

    private void executeDelete(DynamicObject object, String tableName) {
        DBRoute dbRoute = DBRoute.of((String)object.getDataEntityType().getDBRouteKey());
        String sql = String.format("delete from %s  where fentryid=?", tableName);
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{object.get(0)});
    }

    public String getCommondName() {
        return ResManager.loadKDString((String)"\u7518\u7279\u56fe\u6a2a\u9053\u8fde\u63a5\u89e6\u53d1", (String)"CrosslineCommand_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
    }

    public String getCommondNumber() {
        return "crossline";
    }
}

