/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt.command;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bd.mpdm.common.gantt.ganttevent.itf.AbstractGanttCommand;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttCommandContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttDataSource;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.business.helper.PmtsTaskValueHelper;
import kd.pmc.pmts.business.helper.ProjectPlanTypeHelper;
import org.apache.commons.lang3.time.DateUtils;

public class CrosslinedeleteCommand
extends AbstractGanttCommand
implements IConfirmCallBack {
    public void execute(GanttCommandContext ctx) {
        String taskId = ctx.getFilterArg().getFilterDataJson().split("_")[2];
        GanttDataSource ganttDataSource = this.getDataSourceIntoCache();
        DynamicObject selfObj = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)ganttDataSource.getEntityFlag());
        DynamicObjectCollection postTaskentrys = selfObj.getDynamicObjectCollection(ganttDataSource.getPostRalationFlag());
        DynamicObjectCollection preTaskentrys = selfObj.getDynamicObjectCollection(ganttDataSource.getPreralationFlag());
        if (postTaskentrys.isEmpty() && preTaskentrys.isEmpty()) {
            ctx.getView().showTipNotification(ResManager.loadKDString((String)"\u6a2a\u9053\u65e0\u8fde\u7ebf\u5173\u7cfb\uff0c\u53ef\u5220\u9664\u3002", (String)"CrosslinedeleteCommand_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
        } else {
            HashSet<Long> set = new HashSet<Long>(10);
            set.add(Long.parseLong(taskId));
            this.getIds(postTaskentrys, "postpositiontask", set);
            this.getIds(preTaskentrys, "prepositiontask", set);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("crosslinedelete", (IConfirmCallBack)this);
            ctx.getPageCache().put("crosslinedelete", taskId);
            ctx.getPageCache().put("dataSource", JSON.toJSONString((Object)ganttDataSource));
            ctx.getPageCache().put("sets", JSON.toJSONString(set));
            HashSet<Long> idSet = new HashSet<Long>(10);
            if (!preTaskentrys.isEmpty()) {
                idSet.add(Long.parseLong(taskId));
            }
            if (!postTaskentrys.isEmpty()) {
                this.getIds(postTaskentrys, "postpositiontask", idSet);
            }
            ctx.getPageCache().put("idSet", JSON.toJSONString(idSet));
            ctx.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u5f53\u524d\u4efb\u52a1\u7684\u524d\u540e\u7f6e\u5173\u7cfb\uff1f\uff08\u5bf9\u5e94\u6309\u94ae\uff1a\u662f/\u5426\uff09", (String)"CrosslinedeleteCommand_1", (String)"mmc-fmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    private void getIds(DynamicObjectCollection taskentrys, String name, Set<Long> set) {
        for (DynamicObject taskentry : taskentrys) {
            if (taskentry.getDynamicObject(name) == null) continue;
            set.add(taskentry.getDynamicObject(name).getLong("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            ListView listview = (ListView)event.getSource();
            GanttDataSource ganttDataSource = (GanttDataSource)JSONObject.parseObject((String)listview.getPageCache().get("dataSource"), (TypeReference)new TypeReference<GanttDataSource>(){}, (Feature[])new Feature[0]);
            DynamicObject selfObj = BusinessDataServiceHelper.newDynamicObject((String)ganttDataSource.getEntityFlag());
            Long taskId = Long.parseLong(listview.getPageCache().get("crosslinedelete"));
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)ganttDataSource.getEntityFlag());
            String postTable = ((EntityType)mainEntityType.getAllEntities().get(ganttDataSource.getPostRalationFlag())).getAlias();
            String preTable = ((EntityType)mainEntityType.getAllEntities().get(ganttDataSource.getPreralationFlag())).getAlias();
            String postFid = ((IDataEntityProperty)((EntityType)mainEntityType.getAllEntities().get(ganttDataSource.getPostRalationFlag())).getFields().get(ganttDataSource.getPostentity())).getAlias();
            String preFid = ((IDataEntityProperty)((EntityType)mainEntityType.getAllEntities().get(ganttDataSource.getPreralationFlag())).getFields().get(ganttDataSource.getPreentity())).getAlias();
            this.executeDeleteById(selfObj, postTable, "fid", taskId);
            this.executeDeleteById(selfObj, postTable, postFid, taskId);
            this.executeDeleteById(selfObj, preTable, "fid", taskId);
            this.executeDeleteById(selfObj, preTable, preFid, taskId);
            Set set = (Set)JSONObject.parseObject((String)listview.getPageCache().get("sets"), (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            ProjectPlanTypeHelper.projectPlanTypeTaskEdit(new ArrayList(set));
            Set idSet = (Set)JSONObject.parseObject((String)listview.getPageCache().get("idSet"), (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            if (!CollectionUtils.isEmpty((Collection)idSet)) {
                for (Long id : idSet) {
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pmts_task");
                    DynamicObjectCollection prepositiontaskentry = object.getDynamicObjectCollection("prepositiontaskentry");
                    if (!prepositiontaskentry.isEmpty()) continue;
                    DynamicObject project = object.getDynamicObject("projectnum");
                    Date planstartdate = project.getDate("expstartdate");
                    Date dayOne = PmtsTaskValueHelper.queryDayOneDate((Long)project.getLong("id"), (Long)0L);
                    if (dayOne != null) {
                        planstartdate = dayOne;
                    }
                    BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
                    Date planenddate = DateUtils.addMilliseconds((Date)planstartdate, (int)object.getBigDecimal("plantime").multiply(unit).intValue());
                    object.set("planstartdate", (Object)planstartdate);
                    object.set("planenddate", (Object)planenddate);
                    this.setSubTaskDataToDayOne(object, planstartdate);
                    PmtsTaskValueHelper.startCalTaskDateDalayed((DynamicObject)object, (String)listview.getPageCache().getPageId());
                    SaveServiceHelper.update((DynamicObject)object);
                }
            }
            listview.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CrosslinedeleteCommand_2", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            GanttUtils.ganttRefresh((IFormView)listview);
        }
    }

    private void setSubTaskDataToDayOne(DynamicObject dynamicObject, Date planstartdate) {
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("subsectionentry");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        Date newplanstartdate = null;
        Date newplanenddate = null;
        Long intervalTime = 0L;
        BigDecimal unit = PmtsTaskValueHelper.getUnit(null);
        int size = dynamicObjects.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject subObject = (DynamicObject)dynamicObjects.get(i);
            if (i == 0) {
                if (planstartdate != null) {
                    newplanstartdate = planstartdate;
                    newplanenddate = DateUtils.addMilliseconds((Date)newplanstartdate, (int)subObject.getBigDecimal("subplantime").multiply(unit).intValue());
                    intervalTime = newplanstartdate.getTime() - subObject.getDate("subplanstartdate").getTime();
                }
            } else {
                newplanstartdate = DateUtils.addMilliseconds((Date)subObject.getDate("subplanstartdate"), (int)intervalTime.intValue());
                newplanenddate = DateUtils.addMilliseconds((Date)subObject.getDate("subsubplanenddate"), (int)intervalTime.intValue());
            }
            subObject.set("subplanstartdate", (Object)newplanstartdate);
            subObject.set("subsubplanenddate", newplanenddate);
        }
    }

    private GanttDataSource getDataSourceIntoCache() {
        String entityFlag = "pmts_task";
        String preralationFlag = "prepositiontaskentry";
        String preentity = "prepositiontask";
        String preralation = "taskrelation";
        String postRalationFlag = "postpositiontaskentry";
        String postentity = "postpositiontask";
        String postRalation = "taskrelationtwo";
        return new GanttDataSource(entityFlag, preralationFlag, preentity, preralation, postRalationFlag, postentity, postRalation);
    }

    private void executeDeleteById(DynamicObject object, String tableName, String filed, Long id) {
        DBRoute dbRoute = DBRoute.of((String)object.getDataEntityType().getDBRouteKey());
        String sql = String.format("delete from %s  where %s=?", tableName, filed);
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{id});
    }

    public String getCommondName() {
        return ResManager.loadKDString((String)"\u7518\u7279\u56fe\u6a2a\u9053\u8fde\u7ebf\u5220\u9664\u89e6\u53d1\u6761\u4ef6\uff1a\u5f53\u60a8\u9700\u8981\u5220\u9664\u7518\u7279\u56fe\u4e2d\u7684\u6a2a\u9053\u8fde\u7ebf\u65f6\uff0c\u8bf7\u786e\u4fdd\u8be5\u8fde\u7ebf\u5df2\u7ecf\u5b8c\u6210\u6240\u6709\u7684\u524d\u7f6e\u4efb\u52a1\uff0c\u5426\u5219\u65e0\u6cd5\u5220\u9664\u3002", (String)"CrosslinedeleteCommand_3", (String)"mmc-fmm-formplugin", (Object[])new Object[0]);
    }

    public String getCommondNumber() {
        return "crosslinedelete";
    }
}

