/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.gantt.decorator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.gantt.enums.GanttContentLocationEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossObjectEnum;
import kd.bd.mpdm.common.gantt.enums.GanttCrossTypeEnum;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttBuildContext;
import kd.bd.mpdm.common.gantt.ganttmodel.GanttTaskModel;
import kd.bd.mpdm.common.gantt.ganttmodel.composite.AbstractGanttComponent;
import kd.bd.mpdm.common.gantt.util.GanttDataUtils;
import kd.bd.mpdm.common.gantt.util.GanttDealDataUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.pmc.pmpd.common.util.TimeUnitUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class TaskSubCrossDecorator {
    private AbstractGanttComponent component = null;

    public void setGanttDecorator(AbstractGanttComponent mComponent) {
        this.component = mComponent;
    }

    public AbstractGanttComponent getComponent() {
        return this.component;
    }

    public abstract void decoratorSubTask(GanttTaskModel var1, List<GanttTaskModel> var2);

    public void setGanttLabel(GanttTaskModel ganttTaskModel) {
        String up = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.UP.getValue());
        String down = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.DOWN.getValue());
        String left = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.LEFT.getValue());
        String right = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.RIGHT.getValue());
        String innerDesc = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.CENTRE.getValue());
        String title = GanttDealDataUtils.getDescDynamicObject((DynamicObject)this.component.getDynobj(), (GanttBuildContext)this.component.getContext(), (String)ganttTaskModel.getCrossObj(), (String)ganttTaskModel.getCrossType(), (String)GanttContentLocationEnum.TIP.getValue());
        ganttTaskModel.setDesc(up);
        ganttTaskModel.setInnerDesc(innerDesc);
        ganttTaskModel.setBotDesc(down);
        ganttTaskModel.setRightDesc(right);
        ganttTaskModel.setLeftDesc(left);
        ganttTaskModel.setTitle(title);
    }

    public void setCrossLableToNull(GanttTaskModel ganttTaskModel) {
        ganttTaskModel.setDesc("");
        ganttTaskModel.setInnerDesc("");
        ganttTaskModel.setBotDesc("");
        ganttTaskModel.setRightDesc("");
        ganttTaskModel.setLeftDesc("");
        ganttTaskModel.setTitle("");
    }

    public void getTaskSubsectionCross(GanttTaskModel ganttTaskModel, List<GanttTaskModel> subsectionTasks) {
        DynamicObjectCollection subsectionEntrys = this.component.getDynobj().getDynamicObjectCollection("subsectionentry");
        if (GanttCrossObjectEnum.TASK.getValue().equals(ganttTaskModel.getCrossObj()) && (GanttCrossTypeEnum.PLAN.getValue().equals(ganttTaskModel.getCrossType()) || GanttCrossTypeEnum.PERCENT.getValue().equals(ganttTaskModel.getCrossType()))) {
            GanttBuildContext context = this.getComponent().getContext();
            String requestId = context.getRequestId();
            DynamicObject object = this.getComponent().getDynobj();
            String id = object.get("id").toString();
            int size = subsectionEntrys.size();
            BigDecimal hundred = new BigDecimal(100);
            for (int i = 0; i < size; ++i) {
                DynamicObject subsectionEntry = (DynamicObject)subsectionEntrys.get(i);
                GanttTaskModel subTaskModel = new GanttTaskModel();
                GanttDataUtils.copyProperties((Object)subTaskModel, (Object)ganttTaskModel);
                subTaskModel.setTaskSubEntryId(subsectionEntry.getString("id"));
                Long starttime = subsectionEntry.getDate("subplanstartdate").getTime();
                Long endtime = subsectionEntry.getDate("subsubplanenddate").getTime();
                subTaskModel.setAdjustable(false);
                subTaskModel.setIsLine(false);
                subTaskModel.setDraggable(false);
                subTaskModel.setLeftLine(false);
                subTaskModel.setRightLine(false);
                this.setCrossLableToNull(subTaskModel);
                if (StringUtils.equals((CharSequence)GanttCrossTypeEnum.PERCENT.getValue(), (CharSequence)ganttTaskModel.getCrossType())) {
                    DynamicObject timeunit = object.getDynamicObject("durationunit");
                    BigDecimal subplantime = subsectionEntry.getBigDecimal("subplantime");
                    BigDecimal subfinishpercent = subsectionEntry.getBigDecimal("subfinishpercent").setScale(2, 4).stripTrailingZeros();
                    if (timeunit != null && subfinishpercent.compareTo(BigDecimal.ZERO) > 0) {
                        Date planEndTime = TimeUnitUtils.calEndDate((String)timeunit.getString("number"), (Date)subsectionEntry.getDate("subplanstartdate"), (BigDecimal)subplantime.multiply(subfinishpercent.divide(hundred)));
                        endtime = planEndTime.getTime();
                        if (StringUtils.isNotBlank((CharSequence)ganttTaskModel.getInnerDesc())) {
                            subTaskModel.setInnerDesc(subfinishpercent.toPlainString().concat("%"));
                        }
                    } else if (subfinishpercent.compareTo(BigDecimal.ZERO) == 0) continue;
                }
                if (StringUtils.equals((CharSequence)GanttCrossTypeEnum.PLAN.getValue(), (CharSequence)ganttTaskModel.getCrossType())) {
                    if (i == 0 || i == size - 1) {
                        subTaskModel.setIsLine(true);
                        subTaskModel.setLeftLine(i == 0);
                        subTaskModel.setRightLine(i == size - 1);
                    }
                    subTaskModel.setDraggable(true);
                    subTaskModel.setAdjustable(true);
                }
                if (i == size - 1) {
                    this.setGanttLabel(subTaskModel);
                } else {
                    List menus = ganttTaskModel.getMenus();
                    subTaskModel.setMenus(menus.stream().filter(x -> !x.getCbNumber().equals("labelContentSet")).collect(Collectors.toList()));
                }
                String entryId = subsectionEntry.getString("id");
                String taskId = requestId.concat(ganttTaskModel.getCrossObj().concat("_").concat(ganttTaskModel.getCrossType()).concat("_").concat(id).concat("_").concat(entryId));
                subTaskModel.setTaskId(taskId);
                subTaskModel.setStartDate(starttime);
                subTaskModel.setEndDate(endtime);
                subTaskModel.setSubcross(true);
                subsectionTasks.add(subTaskModel);
            }
        }
    }
}

