/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmpd.common.util.WbsUtils;
import kd.pmc.pmts.common.util.BindOrderUtils;

public class CreateProfessionWBSPlugin
extends AbstractListPlugin {
    public static final String CREATEPROWBS = "createprowbs";
    public static final String PMTS_TASK_INDUSTRYPLAN = "pmts_task_industryplan";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (!StringUtils.equals((CharSequence)PMTS_TASK_INDUSTRYPLAN, (CharSequence)billFormId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CREATEPROWBS});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)CREATEPROWBS, (CharSequence)itemKey)) {
            this.saveWBS();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u884c\u4e1a\u8ba1\u5212WBS\u751f\u6210\u6210\u529f\u3002", (String)"CreateProfessionWBSPlugin_0", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    protected void saveWBS() {
        DynamicObject[] wbs = this.createWBSByProfession(BindOrderUtils.getProjectId((IFormView)this.getView()));
        SaveServiceHelper.save((DynamicObject[])wbs);
        BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])wbs);
    }

    protected DynamicObject[] createWBSByProfession(long projectId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection professions = QueryServiceHelper.query((String)"mpdm_professiona", (String)"id,name,parent", (QFilter[])qFilters);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"pmpd_project");
        int professionsSize = professions.size();
        String[] wbsNumbers = WbsUtils.createWbsNumbers((int)professionsSize);
        ArrayList<DynamicObject> wbsList = new ArrayList<DynamicObject>(professionsSize);
        long planTypeId = BindOrderUtils.getPlanTypeId((IFormView)this.getView());
        long[] ids = ID.genLongIds((int)professionsSize);
        Map<Long, Long> relations = this.getRelations(professions, ids);
        for (int i = 0; i < professionsSize; ++i) {
            DynamicObject profession = (DynamicObject)professions.get(i);
            DynamicObject wbs = WbsUtils.createWBSByProject((DynamicObject)project);
            long parent = 0L;
            long parentProfession = profession.getLong("parent");
            if (parentProfession != 0L) {
                parent = relations.get(parentProfession);
            }
            wbs.set("id", (Object)ids[i]);
            wbs.set("name", profession.get("name"));
            wbs.set("number", (Object)wbsNumbers[i]);
            wbs.set("parent", (Object)parent);
            wbs.set("plantype", (Object)planTypeId);
            wbsList.add(wbs);
        }
        return wbsList.toArray(new DynamicObject[0]);
    }

    protected Map<Long, Long> getRelations(DynamicObjectCollection professions, long[] wbsIds) {
        int size = professions.size();
        HashMap<Long, Long> relations = new HashMap<Long, Long>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject profession = (DynamicObject)professions.get(i);
            relations.put(profession.getLong("id"), wbsIds[i]);
        }
        return relations;
    }
}

