/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.list;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.gantt.util.GanttUtils;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmc.pmts.common.helper.ProjectToSimilarProjectHelper;

public class TaskToSimilarProjectPlugin
extends AbstractListPlugin {
    private static final String TBL_SIMILARPROJECT = "similarproject";
    private static final String ENTITY_PMPD_CALCSIMILARPROJ = "pmpd_calcsimilarproj";
    private static final String TBL_GENERATEBYPROJECT = "generatebyproject";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap1"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!StringUtils.equals((CharSequence)args.getOperateKey(), (CharSequence)"refresh") && args.getOperationResult().isSuccess()) {
            if (StringUtils.equals((CharSequence)TBL_SIMILARPROJECT, (CharSequence)args.getOperateKey())) {
                this.showBillFrom(ENTITY_PMPD_CALCSIMILARPROJ);
            } else if (StringUtils.equals((CharSequence)TBL_GENERATEBYPROJECT, (CharSequence)args.getOperateKey())) {
                this.showBillList(ENTITY_PMPD_CALCSIMILARPROJ);
            }
        }
    }

    private void showBillList(String entityPmpdCalcsimilarproj) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("pmpd_project_f7");
        showParameter.setBillFormId("pmpd_project");
        showParameter.setMultiSelect(false);
        showParameter.setShowTitle(false);
        showParameter.setShowFrequent(true);
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("500");
        styleCss.setWidth("1000");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setF7Style(1);
        showParameter.setLookUp(true);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TBL_GENERATEBYPROJECT));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showBillFrom(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return;
        }
        String orgId = this.getOrgId();
        Object project = GanttUtils.getFilterValue((String)"projectnum.id", (String)this.getView().getPageId());
        if (project == null) {
            return;
        }
        String projectId = project.toString();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("projectorg", (Object)orgId);
        showParameter.setCustomParam("entitynumber", (Object)"pmpd_project");
        showParameter.setCustomParam("sourceid", (Object)projectId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TBL_SIMILARPROJECT));
        this.getView().showForm(showParameter);
    }

    private String getOrgId() {
        ControlFilters filters = ((IListView)this.getView()).getControlFilters();
        List createOrg = filters.getFilter("useorg.id");
        String orgId = this.getPageCache().get("verifyOrg");
        if (createOrg != null && !createOrg.isEmpty()) {
            orgId = (String)createOrg.get(0);
        }
        return orgId;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (StringUtils.equals((CharSequence)TBL_SIMILARPROJECT, (CharSequence)e.getActionId())) {
            Map result = (Map)e.getReturnData();
            if (result == null) {
                return;
            }
            String similarProject = (String)result.get("similarProject");
            this.similarProjectToProject(similarProject);
        } else if (StringUtils.equals((CharSequence)TBL_GENERATEBYPROJECT, (CharSequence)e.getActionId())) {
            ListSelectedRowCollection result = (ListSelectedRowCollection)e.getReturnData();
            if (result == null) {
                return;
            }
            this.resourceplanByProject(Long.parseLong(result.getPrimaryKeyValues()[0].toString()));
        }
    }

    private void resourceplanByProject(long project) {
        this.generateByProject(project);
    }

    public Set<Long> getResourcePlan(long project) {
        HashSet<Long> projects = new HashSet<Long>(8);
        return projects;
    }

    private void generateByProject(long project) {
        DynamicObject[] wbsDyns;
        Object projecto = GanttUtils.getFilterValue((String)"projectnum.id", (String)this.getView().getPageId());
        if (projecto == null) {
            return;
        }
        String newProjectId = projecto.toString();
        DynamicObject projectDyn = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(newProjectId), (String)"pmpd_project");
        HashMap<Long, DynamicObject> wbsOldNew = new HashMap<Long, DynamicObject>(8);
        HashMap<Long, Long> taskOldNew = new HashMap<Long, Long>(8);
        DynamicObject[] newWbsDyns = null;
        DynamicObject[] newTaskDyns = null;
        Map<Object, Object> taskRelations = new HashMap(8);
        QFilter qFilterVersion = new QFilter("version", "=", (Object)0L);
        QFilter qFilterProjectNum = new QFilter("projectnum", "=", (Object)project);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        Object plantypes = GanttUtils.getFilterValue((String)"plantype.id", (String)this.getView().getPageId());
        if (!StringUtils.equals((CharSequence)"pmts_task_gantt", (CharSequence)billFormId) && plantypes != null) {
            QFilter qFilterPlanType = new QFilter("plantype", "=", plantypes);
            qFilterProjectNum.and(qFilterPlanType);
        }
        if ((wbsDyns = ProjectToSimilarProjectHelper.getWbs((Long)project, (QFilter[])new QFilter[]{qFilterVersion, qFilterProjectNum})).length > 0) {
            for (DynamicObject wbs : newWbsDyns = this.updateWbs(wbsDyns, projectDyn, wbsOldNew)) {
                if (wbs.getLong("parent.id") == 0L) continue;
                wbs.set("parent", wbsOldNew.get(wbs.get("parent.id")));
            }
        }
        qFilterVersion = new QFilter("version", "=", (Object)0L);
        qFilterProjectNum = new QFilter("projectnum", "=", (Object)project);
        if (!StringUtils.equals((CharSequence)"pmts_task_gantt", (CharSequence)billFormId) && plantypes != null) {
            QFilter qFilterPlanType = new QFilter("plantype", "=", plantypes);
            qFilterProjectNum.and(qFilterPlanType);
        }
        DynamicObject[] taskDyns = ProjectToSimilarProjectHelper.getTask((Long)project, (QFilter[])new QFilter[]{qFilterVersion, qFilterProjectNum});
        if (!StringUtils.equals((CharSequence)"pmts_task_gantt", (CharSequence)billFormId) && plantypes != null) {
            taskRelations = this.getTaskMromanuftech(project, Long.parseLong(newProjectId), taskDyns);
            newTaskDyns = taskDyns.length > 0 ? taskDyns : new DynamicObject[]{};
        } else {
            newTaskDyns = taskDyns;
        }
        if (newTaskDyns.length > 0) {
            newTaskDyns = this.updateTask(newTaskDyns, projectDyn, wbsOldNew, taskOldNew);
            DynamicObject oldProjectDyn = BusinessDataServiceHelper.loadSingle((Object)project, (String)"pmpd_project");
            this.updateTaskTime(newTaskDyns, taskOldNew, projectDyn, oldProjectDyn);
            this.updatePrepositionPostpositionTask(newTaskDyns, taskOldNew, "prepositiontaskentry", "prepositiontask");
            this.updatePrepositionPostpositionTask(newTaskDyns, taskOldNew, "postpositiontaskentry", "postpositiontask");
        }
        if (!StringUtils.equals((CharSequence)"pmts_task_gantt", (CharSequence)billFormId) && plantypes != null && !taskRelations.isEmpty()) {
            this.saveBindOrderModel(taskRelations, taskOldNew);
        }
        if (newWbsDyns != null && newWbsDyns.length > 0) {
            SaveServiceHelper.save((DynamicObject[])newWbsDyns);
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])newWbsDyns);
        }
        if (newTaskDyns != null && newTaskDyns.length > 0) {
            SaveServiceHelper.save((DynamicObject[])newTaskDyns);
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject[])newTaskDyns);
        }
        this.getView().invokeOperation("refresh");
    }

    private void updateTaskTime(DynamicObject[] newTaskDyns, Map<Long, Long> taskOldNew, DynamicObject projectDyn, DynamicObject oldProjectDyn) {
        Map projectTaskMap = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getTaskDateIndex", (Object[])new Object[]{oldProjectDyn.getPkValue()});
        Date projectDayOne = (Date)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"ProjectService", (String)"getProjectDayOne", (Object[])new Object[]{projectDyn.getPkValue()});
        long dayOneTime = projectDayOne.getTime();
        for (DynamicObject task : newTaskDyns) {
            for (Map.Entry<Long, Long> oldNewEntry : taskOldNew.entrySet()) {
                if (projectDayOne == null || task.getLong("id") != oldNewEntry.getValue().longValue()) continue;
                Map taskMap = (Map)projectTaskMap.get(oldNewEntry.getKey());
                Integer start = (Integer)taskMap.get("start");
                Integer end = (Integer)taskMap.get("end");
                if (start != null) {
                    long newPlanStartDate = start > 0 ? dayOneTime + (long)((start - 1) * 1000 * 60 * 60 * 24) : dayOneTime + (long)(start * 1000 * 60 * 60 * 24);
                    this.setTaskTime(task, "planstartdate", newPlanStartDate);
                }
                if (end == null) continue;
                long newPlanEndDate = end > 0 ? dayOneTime + (long)((end - 1) * 1000 * 60 * 60 * 24) : dayOneTime + (long)(end * 1000 * 60 * 60 * 24);
                this.setTaskTime(task, "planenddate", newPlanEndDate);
            }
        }
    }

    private void setTaskTime(DynamicObject task, String planstartdate, long newPlanStartDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String s = sdf.format(new Date(newPlanStartDate));
        try {
            Date date = sdf.parse(s);
            task.set(planstartdate, (Object)date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void updatePrepositionPostpositionTask(DynamicObject[] newTaskDyns, Map<Long, Long> taskOldNew, String entry, String filed) {
        for (DynamicObject task : newTaskDyns) {
            DynamicObjectCollection prepositiontaskentry = task.getDynamicObjectCollection(entry);
            if (prepositiontaskentry == null || prepositiontaskentry.isEmpty()) continue;
            for (DynamicObject prepositiontask : prepositiontaskentry) {
                DynamicObject pretask = prepositiontask.getDynamicObject(filed);
                if (pretask == null) continue;
                for (DynamicObject newTask : newTaskDyns) {
                    if (taskOldNew.get(pretask.getLong("id")) == null || newTask.getLong("id") != taskOldNew.get(pretask.getLong("id")).longValue()) continue;
                    prepositiontask.set(filed, (Object)newTask);
                }
            }
        }
    }

    private void similarProjectToProject(String similarProject) {
        Map similarProject1 = (Map)SerializationUtils.fromJsonString((String)similarProject, Map.class);
        for (Map.Entry stringSetEntry : similarProject1.entrySet()) {
            List projectIds = (List)stringSetEntry.getValue();
            if (projectIds == null || projectIds.isEmpty()) continue;
            this.resourceplanByProject(Long.parseLong((String)projectIds.get(0)));
        }
    }

    private void saveBindOrderModel(Map<Long, List<Map<String, Object>>> taskRelations, Map<Long, Long> taskOldNew) {
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>(taskRelations.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entrySet : taskRelations.entrySet()) {
            List<Map<String, Object>> list = entrySet.getValue();
            for (Map<String, Object> map : list) {
                DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"fmm_task_relations");
                relation.set("sourcebilltype", (Object)"sfc_mromanuftech");
                relation.set("sourcebillid", map.get("id"));
                relation.set("sourcebillentryid", map.get("oprentryentity"));
                relation.set("targetbilltype", (Object)"pmts_task");
                relation.set("targetbillid", (Object)taskOldNew.get(entrySet.getKey()));
                relation.set("targetbillentryid", null);
                relations.add(relation);
            }
        }
        if (!relations.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[relations.size()]));
        }
    }

    private DynamicObject[] excludeTask(DynamicObject[] taskDyns, Map<Long, List<Map<String, Object>>> taskRelations) {
        ArrayList<DynamicObject> newTaskDyns = new ArrayList<DynamicObject>(taskDyns.length);
        for (DynamicObject task : taskDyns) {
            if (taskRelations.get(task.getLong("id")) == null) continue;
            newTaskDyns.add(task);
        }
        return newTaskDyns.toArray(new DynamicObject[newTaskDyns.size()]);
    }

    private Map<Long, List<Map<String, Object>>> getTaskMromanuftech(Long project, long newProject, DynamicObject[] tasks) {
        if (tasks.length == 0) {
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        HashSet<String> taskIds = new HashSet<String>(tasks.length);
        for (DynamicObject dyn : tasks) {
            taskIds.add(String.valueOf(dyn.getLong("id")));
        }
        Map mromanuftechEntityIdMap = ProjectToSimilarProjectHelper.getMromanuftechEntityIdForTask(taskIds);
        List oldmromanuftechIds = ProjectToSimilarProjectHelper.getMromanuftech(mromanuftechEntityIdMap.keySet());
        List mromanuftechIds = ProjectToSimilarProjectHelper.getMromanuftech((Long)newProject);
        Map<Long, List<Map<String, Object>>> taskRelations = this.compareMromanuftech(oldmromanuftechIds, mromanuftechIds, mromanuftechEntityIdMap);
        return taskRelations;
    }

    private Map<Long, List<Map<String, Object>>> compareMromanuftech(List<Map<String, Object>> oldmromanuftechs, List<Map<String, Object>> mromanuftechs, Map<Long, Long> mromanuftechEntityIdMap) {
        HashMap<Long, List<Map<String, Object>>> taskRelations = new HashMap<Long, List<Map<String, Object>>>(8);
        for (Map<String, Object> oldmromanuftech : oldmromanuftechs) {
            for (Map<String, Object> mromanuftech : mromanuftechs) {
                List<Map<String, Object>> list;
                if (!oldmromanuftech.get("workcard").equals(mromanuftech.get("workcard")) || !oldmromanuftech.get("oprprocessgroup").equals(mromanuftech.get("oprprocessgroup"))) continue;
                Long oprentryentity = (Long)oldmromanuftech.get("oprentryentity");
                if (taskRelations.get(mromanuftechEntityIdMap.get(oprentryentity)) == null) {
                    list = new ArrayList<Map<String, Object>>(1);
                    list.add(mromanuftech);
                    taskRelations.put(mromanuftechEntityIdMap.get(oldmromanuftech.get("oprentryentity")), list);
                    continue;
                }
                list = (List)taskRelations.get(mromanuftechEntityIdMap.get(oprentryentity));
                list.add(mromanuftech);
            }
        }
        return taskRelations;
    }

    private void updateTaskMilestone(DynamicObject[] newTaskDyns, DynamicObject projectDyn, DynamicObject oldProjectDyn) {
        Date oldProjectPlanStartDate = oldProjectDyn.getDate("planstartdate");
        Date oldProjectPlanEndDate = oldProjectDyn.getDate("planfinshdate");
        Long oldProjectTime = oldProjectPlanEndDate.getTime() - oldProjectPlanStartDate.getTime();
        Date projectPlanStartDate = projectDyn.getDate("planstartdate");
        Date projectPlanEndDate = projectDyn.getDate("planfinshdate");
        Long projectTime = projectPlanEndDate.getTime() - projectPlanStartDate.getTime();
        for (DynamicObject taskDyn : newTaskDyns) {
            Date planEndDate;
            Date planStartDate = taskDyn.getDate("planstartdate");
            if (planStartDate != null && oldProjectTime != 0L) {
                BigDecimal oldProjectoldProjectTime = new BigDecimal(planStartDate.getTime()).subtract(new BigDecimal(oldProjectPlanStartDate.getTime())).divide(new BigDecimal(oldProjectTime), 10, RoundingMode.HALF_UP);
                Long newPlanStartDate = oldProjectoldProjectTime.multiply(new BigDecimal(projectTime)).add(new BigDecimal(projectPlanStartDate.getTime())).longValue();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String s = sdf.format(new Date(newPlanStartDate));
                try {
                    Date date = sdf.parse(s);
                    taskDyn.set("planstartdate", (Object)date);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((planEndDate = taskDyn.getDate("planenddate")) == null || oldProjectTime == 0L) continue;
            BigDecimal planTime = taskDyn.getBigDecimal("plantime");
            Date newPlanStartDate = taskDyn.getDate("planstartdate");
            long newPlanEndDate = newPlanStartDate.getTime() + planTime.multiply(new BigDecimal(86400000)).longValue();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String s = sdf.format(new Date(newPlanEndDate));
            try {
                Date date = sdf.parse(s);
                taskDyn.set("planenddate", (Object)date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private DynamicObject[] updateTask(DynamicObject[] oldTaskDyns, DynamicObject project, Map<Long, DynamicObject> wbsOldNew, Map<Long, Long> taskOldNew) {
        CloneUtils cloneUtils = new CloneUtils(true, true);
        DynamicObject[] newTaskDyns = new DynamicObject[oldTaskDyns.length];
        Long orgId = Long.parseLong(this.getOrgId());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        long[] ids = ID.genLongIds((int)oldTaskDyns.length);
        String[] code = CodeRuleServiceHelper.getBatchNumber((String)"pmts_task", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_task")), (String)String.valueOf(orgId), (int)oldTaskDyns.length);
        Date date = new Date();
        for (int i = 0; i < oldTaskDyns.length; ++i) {
            DynamicObject task = oldTaskDyns[i];
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)task);
            if (code.length == 0) {
                clone.set("number", (Object)ID.genStringId());
            } else {
                clone.set("number", (Object)code[i]);
            }
            clone.set("projectnum", (Object)project);
            clone.set("createtime", (Object)date);
            clone.set("creator", (Object)user);
            clone.set("status", (Object)Character.valueOf('A'));
            clone.set("createorg", (Object)org);
            clone.set("releasestatus", (Object)"0");
            clone.set("taskstatus", (Object)"1");
            clone.set("executestatus", (Object)"1");
            clone.set("version", null);
            if (clone.getLong("wbs.id") != 0L) {
                clone.set("wbs", (Object)wbsOldNew.get(clone.getLong("wbs.id")));
            }
            clone.set("id", (Object)ids[i]);
            clone.set("masterid", (Object)ids[i]);
            taskOldNew.put(task.getLong("id"), ids[i]);
            newTaskDyns[i] = clone;
        }
        return newTaskDyns;
    }

    private DynamicObject[] updateWbs(DynamicObject[] oldWbsDyns, DynamicObject project, Map<Long, DynamicObject> wbsOldNew) {
        CloneUtils cloneUtils = new CloneUtils(false, true);
        DynamicObject[] newWbsDyns = new DynamicObject[oldWbsDyns.length];
        long[] ids = ID.genLongIds((int)oldWbsDyns.length);
        Date date = new Date();
        Long orgId = Long.parseLong(this.getOrgId());
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        String[] code = CodeRuleServiceHelper.getBatchNumber((String)"pmts_wbs", (DynamicObject)new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmts_wbs")), (String)String.valueOf(orgId), (int)oldWbsDyns.length);
        for (int i = 0; i < oldWbsDyns.length; ++i) {
            DynamicObject wbs = oldWbsDyns[i];
            DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)wbs);
            if (code.length == 0) {
                clone.set("number", (Object)ID.genStringId());
            } else {
                clone.set("number", (Object)code[i]);
            }
            clone.set("projectnum", (Object)project);
            clone.get("createtime");
            clone.set("createtime", (Object)date);
            clone.set("creator", (Object)user);
            clone.set("status", (Object)Character.valueOf('A'));
            clone.set("createorg", (Object)org);
            clone.set("businessstate", (Object)Character.valueOf('A'));
            clone.set("checkpurchase", (Object)true);
            clone.set("checkoutsource", (Object)true);
            clone.set("checkproduct", (Object)true);
            clone.set("checkregister", (Object)true);
            clone.set("id", (Object)ids[i]);
            clone.set("masterid", (Object)ids[i]);
            wbsOldNew.put(wbs.getLong("id"), clone);
            newWbsDyns[i] = clone;
        }
        return newWbsDyns;
    }
}

