/*
 * Decompiled with CFR 0.152.
 */
package kd.pmc.pmts.formplugin.list;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class WbsListPlugin
extends StandardTreeListPlugin
implements ListRowClickListener {
    private static final Set<String> OPERATIONS = new HashSet<String>(8);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"upgrade"});
        this.addItemClickListeners(new String[]{"demotion"});
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String formId = this.getView().getFormShowParameter().getFormId();
        if (StringUtils.equals((CharSequence)"bos_templatetreelist", (CharSequence)formId)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            HashMap idToName = new HashMap(8);
            DynamicObjectCollection pmpd_project = QueryServiceHelper.query((String)"pmpd_project", (String)"id,number", null);
            pmpd_project.forEach(project -> idToName.put(project.getString("id"), new LocaleString(project.getString("number"))));
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!"projectnum.name".equals(fieldName)) continue;
                String defprojectid = this.getPageCache().get("defprojectid");
                if (StringUtils.isNotEmpty((CharSequence)defprojectid)) {
                    filterColumn.setDefaultValue(defprojectid);
                }
                CommonBaseDataFilterColumn baseDataFilterColumn = (CommonBaseDataFilterColumn)filterColumn;
                List comboItems = baseDataFilterColumn.getComboItems();
                comboItems.forEach(comboItem -> comboItem.setCaption((LocaleString)idToName.get(comboItem.getValue())));
                break;
            }
            for (FilterColumn filterColumn : commonFilterColumns) {
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                if (!commonFilterColumn.getFieldName().contains("projectnum.name")) continue;
                SchemeFilterColumn schemeFilterColumn = new SchemeFilterColumn();
                schemeFilterColumn.setEntityType(commonFilterColumn.getEntityType());
                schemeFilterColumn.setFieldName(commonFilterColumn.getFieldName());
                schemeFilterColumn.setKey(commonFilterColumn.getKey());
                schemeFilterColumn.setCaption(commonFilterColumn.getCaption());
                schemeFilterColumn.setType(commonFilterColumn.getType());
                List compareTypes = schemeFilterColumn.getFilterField().getCompareTypes();
                compareTypes.removeIf(x -> !StringUtils.equals((CharSequence)"67", (CharSequence)x.getId()));
                args.addFilterColumn((FilterColumn)schemeFilterColumn);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        List schemefilters = (List)args.getFilterValues().get("schemefilter");
        if (schemefilters != null) {
            boolean existsProject = false;
            for (Map schemefilter : schemefilters) {
                List fieldName = (List)schemefilter.get("FieldName");
                if (!StringUtils.equals((CharSequence)fieldName.get(0).toString(), (CharSequence)"projectnum.name")) continue;
                existsProject = true;
                List value = (List)schemefilter.get("Value");
                String projectNum = value.get(0).toString();
                if (!StringUtils.isEmpty((CharSequence)projectNum)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u67e5\u8be2\u9879\u76ee\u8fc7\u6ee4\u6761\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WbsListPlugin_15", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
            if (!existsProject) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9879\u76ee\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"WbsListPlugin_16", (String)"mmc-fmm-formplugin", (Object[])new Object[0]));
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow != null && StringUtils.equals((CharSequence)"C", (CharSequence)currentListSelectedRow.getBillStatus())) {
            this.getPageCache().put("selectrow", currentListSelectedRow.getPrimaryKeyValue().toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (OPERATIONS.contains(operateKey)) {
            this.refesh();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (e.getParameter().getStatus() == OperationStatus.ADDNEW) {
            ControlFilters controlFilters = this.getControlFilters();
            String projectIdStr = this.getPageCache().get("defprojectid");
            if (controlFilters != null) {
                List filters = controlFilters.getFilter("projectnum.id");
                if (CollectionUtils.isNotEmpty((Collection)filters)) {
                    projectIdStr = filters.get(0).toString();
                } else {
                    DynamicObject dynamicObject;
                    List nameFilter = controlFilters.getFilter("projectnum.name");
                    if (CollectionUtils.isNotEmpty((Collection)nameFilter) && (dynamicObject = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)nameFilter.get(0).toString())})) != null) {
                        projectIdStr = dynamicObject.getString("id");
                    }
                }
            }
            if (!StringUtils.isEmpty((CharSequence)projectIdStr)) {
                e.getParameter().setCustomParam("project", (Object)Long.parseLong(projectIdStr));
            }
        }
    }

    private void refesh() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        list.refresh();
    }

    public void refreshNode(RefreshNodeEvent e) {
        TreeListModel treemodel = (TreeListModel)this.getTreeListView().getTreeModel();
        treemodel.getQueryParas().put("order", "createtime asc");
        super.refreshNode(e);
        long projectId = this.getSelectProjectId();
        if (projectId == 0L) {
            return;
        }
        QFilter qFilter = new QFilter("projectnum.id", "=", (Object)projectId);
        String versionId = (String)this.getView().getFormShowParameter().getCustomParam("versionId");
        QFilter vfilter = new QFilter("version.id", "=", (Object)(StringUtils.isBlank((CharSequence)versionId) ? 0L : Long.parseLong(versionId)));
        treemodel.getTreeFilter().add(qFilter);
        treemodel.getTreeFilter().add(vfilter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long projectId = this.getSelectProjectId();
        if (projectId != 0L) {
            DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectId, (String)"pmpd_project", (String)"number,name");
            this.getTreeModel().getRoot().setText(project.getString("name") + '(' + project.getString("number") + ')');
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        qFilters.removeIf(x -> StringUtils.equals((CharSequence)x.getProperty(), (CharSequence)"ctrlstrategy"));
        String versionId = (String)param.getCustomParam("versionId");
        if (StringUtils.isBlank((CharSequence)versionId)) {
            QFilter vfilter = new QFilter("version.id", "is null", null);
            vfilter.or("version.id", "=", (Object)0);
            qFilters.add(vfilter);
        } else {
            qFilters.removeIf(x -> x.getProperty().contains("version"));
            QFilter filter = new QFilter("version.id", "=", (Object)Long.parseLong(versionId));
            qFilters.add(filter);
        }
        if (Objects.nonNull(param.getCustomParam("formTask"))) {
            List nqFilters = qFilters.stream().filter(qFilter -> StringUtils.equals((CharSequence)qFilter.getProperty(), (CharSequence)"status")).collect(Collectors.toList());
            qFilters.removeAll(nqFilters);
        }
        e.setOrderBy("createtime");
    }

    public void initializeTree(EventObject e) {
        this.cacheDefProject();
        super.initializeTree(e);
    }

    private void cacheDefProject() {
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmpd_project", (String)"id", (QFilter[])qFilters, (String)"number", (int)1);
        if (!query.isEmpty()) {
            String id = ((DynamicObject)query.get(0)).getString("id");
            this.getPageCache().put("defprojectid", id);
        }
    }

    private long getSelectProjectId() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        for (QFilter qFilter : qFilters) {
            Object value;
            if (!StringUtils.equals((CharSequence)"projectnum.id", (CharSequence)qFilter.getProperty()) || !((value = qFilter.getValue()) instanceof Long)) continue;
            return Long.parseLong(qFilter.getValue().toString());
        }
        if (!qFilters.isEmpty()) {
            return 0L;
        }
        ControlFilters controlFilters = this.getControlFilters();
        String projectIdStr = this.getPageCache().get("defprojectid");
        if (controlFilters != null) {
            List filters = controlFilters.getFilter("projectnum.id");
            if (filters == null || filters.isEmpty()) {
                filters = controlFilters.getFilter("projectnum.name");
                if (filters == null || filters.isEmpty()) {
                    return 0L;
                }
                String projectName = filters.get(0).toString();
                QFilter qFilter = new QFilter("name", "=", (Object)projectName);
                DynamicObject project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"id", (QFilter[])qFilter.toArray());
                if (project != null) {
                    projectIdStr = project.getString("id");
                }
            } else {
                projectIdStr = filters.get(0).toString();
            }
        }
        if (StringUtils.isEmpty((CharSequence)projectIdStr)) {
            return 0L;
        }
        return Long.parseLong(projectIdStr);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DealNumberProvider());
    }

    static {
        OPERATIONS.add("sure");
        OPERATIONS.add("unsure");
        OPERATIONS.add("publish");
        OPERATIONS.add("issued");
        OPERATIONS.add("unissued");
        OPERATIONS.add("complete");
        OPERATIONS.add("uncomplete");
        OPERATIONS.add("demotion");
        OPERATIONS.add("upgrade");
    }

    static class DealNumberProvider
    extends ListDataProvider {
        DealNumberProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (data.isEmpty()) {
                return data;
            }
            DataEntityPropertyCollection properties = ((DynamicObject)data.get(0)).getDataEntityType().getProperties();
            boolean hasNumber = properties.containsKey((Object)"number");
            if (hasNumber) {
                for (DynamicObject obj : data) {
                    obj.set("number", (Object)obj.getString("number").split("&")[0]);
                }
            }
            return data;
        }
    }
}

